/*
 * Decompiled with CFR 0.152.
 */
package com.apporiented.algorithm.clustering;

import com.apporiented.algorithm.clustering.Cluster;
import com.apporiented.algorithm.clustering.ClusterPair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;

public class DistanceMap {
    private Map<String, Item> pairHash;
    private PriorityQueue<Item> data = new PriorityQueue();

    public DistanceMap() {
        this.pairHash = new HashMap<String, Item>();
    }

    public List<ClusterPair> list() {
        ArrayList<ClusterPair> arrayList = new ArrayList<ClusterPair>();
        for (Item item : this.data) {
            arrayList.add(item.pair);
        }
        return arrayList;
    }

    public ClusterPair findByCodePair(Cluster cluster, Cluster cluster2) {
        String string = this.hashCodePair(cluster, cluster2);
        return this.pairHash.get((Object)string).pair;
    }

    public ClusterPair removeFirst() {
        Item item = this.data.poll();
        while (item != null && item.removed) {
            item = this.data.poll();
        }
        if (item == null) {
            return null;
        }
        ClusterPair clusterPair = item.pair;
        this.pairHash.remove(item.hash);
        return clusterPair;
    }

    public boolean remove(ClusterPair clusterPair) {
        Item item = this.pairHash.remove(this.hashCodePair(clusterPair));
        if (item == null) {
            return false;
        }
        item.removed = true;
        return true;
    }

    public boolean add(ClusterPair clusterPair) {
        Item item = new Item(clusterPair);
        Item item2 = this.pairHash.get(item.hash);
        if (item2 != null) {
            System.err.println("hashCode = " + item2.hash + " adding redundant link:" + clusterPair + " (exist:" + item2 + ")");
            return false;
        }
        this.pairHash.put(item.hash, item);
        this.data.add(item);
        return true;
    }

    String hashCodePair(ClusterPair clusterPair) {
        return this.hashCodePair(clusterPair.getlCluster(), clusterPair.getrCluster());
    }

    String hashCodePair(Cluster cluster, Cluster cluster2) {
        return this.hashCodePairNames(cluster.getName(), cluster2.getName());
    }

    String hashCodePairNames(String string, String string2) {
        if (string.compareTo(string2) < 0) {
            return string + "~~~" + string2;
        }
        return string2 + "~~~" + string;
    }

    public String toString() {
        return this.data.toString();
    }

    private class Item
    implements Comparable<Item> {
        final ClusterPair pair;
        final String hash;
        boolean removed = false;

        Item(ClusterPair clusterPair) {
            this.pair = clusterPair;
            this.hash = DistanceMap.this.hashCodePair(clusterPair);
        }

        @Override
        public int compareTo(Item item) {
            return this.pair.compareTo(item.pair);
        }

        public String toString() {
            return this.hash;
        }
    }
}

