/*
 * Decompiled with CFR 0.152.
 */
package alma.valuetypes;

import alma.entity.xmlbinding.valuetypes.SpeedT;
import alma.obsprep.util.TextUtils;
import alma.valuetypes.Frequency;
import alma.valuetypes.data.SpeedData;

public class Speed
extends SpeedData<Speed> {
    public static final Speed LIGHT_SPEED_C = Speed.createSpeed((double)299792.458, (String)UNIT_KM_S);
    private static final double LIGHT_SPEED_C_DEF_UNITS = LIGHT_SPEED_C.getContentInDefaultUnits();

    public Speed(SpeedT speedT) {
        super(speedT);
    }

    protected void initAsNew() {
        super.initAsNew();
        this.setUnit(UNIT_KM_S);
        if (this.getUnit() == null) {
            this.setUnit(this.defaultUnit());
        }
        this.setContent(0.0);
    }

    public static String[] getKnownUnitList() {
        String[] stringArray = SpeedData.getKnownUnitList();
        stringArray = TextUtils.removeFromArray(stringArray, UNIT_KM_H);
        return stringArray;
    }

    public String defaultUnit() {
        return UNIT_KM_S;
    }

    public static Speed getSpeedResolution(Frequency frequency, Frequency frequency2) {
        if (frequency == null || frequency2 == null) {
            throw new IllegalArgumentException("Resolution and sky frequency must not be null.");
        }
        double d = frequency.getContentInDefaultUnits() / frequency2.getContentInDefaultUnits();
        return (Speed)LIGHT_SPEED_C.multiply(d, true);
    }

    public static Frequency getFrequencyResolution(Speed speed, Frequency frequency) {
        if (speed == null || frequency == null) {
            throw new IllegalArgumentException("Resolution and sky frequency must not be null.");
        }
        double d = speed.getContentInDefaultUnits() / LIGHT_SPEED_C_DEF_UNITS;
        return (Frequency)frequency.multiply(d, true);
    }
}

