/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.util;

import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.obsprep.util.Range;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.IllegalFormatException;
import java.util.List;
import java.util.Optional;

public class VupRange<E extends ValueUnitPair>
implements Range<E> {
    protected E maximum;
    protected E minimum;

    public VupRange(E e, E e2) {
        this.setMin(e);
        this.setMax(e2);
    }

    public VupRange(Range<E> range) {
        this.setMin((ValueUnitPair)range.min());
        this.setMax((ValueUnitPair)range.max());
    }

    public void setMin(E e) {
        this.minimum = e;
    }

    public void setMax(E e) {
        this.maximum = e;
    }

    @Override
    public E max() {
        return this.maximum;
    }

    @Override
    public E min() {
        return this.minimum;
    }

    @Override
    public E mid() {
        return (E)this.minimum.plus(this.maximum).half();
    }

    @Override
    public E range() {
        return (E)this.maximum.minus(this.minimum);
    }

    public VupRange minus(E e) {
        VupRange<ValueUnitPair> vupRange = new VupRange<ValueUnitPair>(this.minimum.minus(e), this.maximum.minus(e));
        return vupRange;
    }

    public VupRange plus(E e) {
        VupRange<ValueUnitPair> vupRange = new VupRange<ValueUnitPair>(this.minimum.plus(e), this.maximum.plus(e));
        return vupRange;
    }

    public boolean inRange(E e) {
        return !e.isLessThan(this.minimum) && !e.isGreaterThan(this.maximum);
    }

    public E clip(E e) {
        E e2 = e;
        if (e.isLessThan(this.min())) {
            e2 = this.min();
        }
        if (e.isGreaterThan(this.max())) {
            e2 = this.max();
        }
        return e2;
    }

    public boolean intersects(Range<E> range) {
        if (this.max().isLessThan((ValueUnitPair)range.min())) {
            return false;
        }
        return !((ValueUnitPair)range.max()).isLessThan(this.min());
    }

    public boolean contains(Range<E> range) {
        if (this.max().isLessThan((ValueUnitPair)range.max())) {
            return false;
        }
        return !this.min().isGreaterThan((ValueUnitPair)range.min());
    }

    public static List<VupRange> aggregate(List<VupRange> list) {
        ArrayList<VupRange> arrayList = new ArrayList<VupRange>();
        if (list.size() == 0) {
            return arrayList;
        }
        Comparator<VupRange> comparator = new Comparator<VupRange>(){

            @Override
            public int compare(VupRange vupRange, VupRange vupRange2) {
                if (!vupRange.min().equals(vupRange2.min())) {
                    return vupRange.min().compareTo(vupRange2.min());
                }
                return vupRange.max().compareTo(vupRange2.max());
            }
        };
        VupRange[] vupRangeArray = list.toArray(new VupRange[list.size()]);
        Arrays.sort(vupRangeArray, comparator);
        VupRange vupRange = vupRangeArray[0];
        arrayList.add(vupRange);
        for (int i = 1; i < vupRangeArray.length; ++i) {
            VupRange vupRange2 = vupRangeArray[i];
            if (vupRange2.intersects(vupRange)) {
                Object e = vupRange2.min().isLessThan(vupRange.min()) ? vupRange2.min() : vupRange.min();
                Object e2 = vupRange2.max().isGreaterThan(vupRange.max()) ? vupRange2.max() : vupRange.max();
                vupRange.setMin(e);
                vupRange.setMax(e2);
                continue;
            }
            vupRange = vupRange2;
            arrayList.add(vupRange);
        }
        return arrayList;
    }

    public VupRange<E> expand(E e) {
        if (e.isLessThan(this.min())) {
            return new VupRange<E>(e, this.max());
        }
        if (e.isGreaterThan(this.max())) {
            return new VupRange<E>(this.min(), e);
        }
        return new VupRange<E>(this.min(), this.max());
    }

    public VupRange<E> expand(Range<E> range) {
        Object object = this.min();
        Object object2 = this.max();
        if (((ValueUnitPair)range.min()).isLessThan(object)) {
            object = (ValueUnitPair)range.min();
        }
        if (((ValueUnitPair)range.max()).isGreaterThan(object2)) {
            object2 = (ValueUnitPair)range.max();
        }
        return new VupRange<E>(object, object2);
    }

    public VupRange overlap(Range<E> range) {
        if (!this.intersects(range)) {
            return null;
        }
        Object object = this.min();
        Object object2 = this.max();
        if (((ValueUnitPair)range.min()).isGreaterThan(object)) {
            object = (ValueUnitPair)range.min();
        }
        if (((ValueUnitPair)range.max()).isLessThan(object2)) {
            object2 = (ValueUnitPair)range.max();
        }
        return new VupRange<E>(object, object2);
    }

    public static VupRange wholeRange(Range[] rangeArray) {
        if (rangeArray.length == 0) {
            return null;
        }
        VupRange vupRange = new VupRange(rangeArray[0]);
        for (Range range : rangeArray) {
            vupRange = vupRange.expand(range);
        }
        return vupRange;
    }

    public static <E extends ValueUnitPair> VupRange<E> createRange(ValueUnitPair<E> ... valueUnitPairArray) {
        return VupRange.wholeRange(valueUnitPairArray);
    }

    public static VupRange wholeRange(ValueUnitPair[] valueUnitPairArray) {
        if (valueUnitPairArray.length == 0) {
            return null;
        }
        ValueUnitPair valueUnitPair = valueUnitPairArray[0];
        VupRange<ValueUnitPair> vupRange = new VupRange<ValueUnitPair>(valueUnitPair, valueUnitPair);
        for (ValueUnitPair valueUnitPair2 : valueUnitPairArray) {
            vupRange = vupRange.expand(valueUnitPair2);
        }
        return vupRange;
    }

    public static VupRange centerRange(Range[] rangeArray) {
        if (rangeArray.length == 0) {
            return null;
        }
        ValueUnitPair valueUnitPair = (ValueUnitPair)rangeArray[0].mid();
        VupRange<ValueUnitPair> vupRange = new VupRange<ValueUnitPair>(valueUnitPair, valueUnitPair);
        for (Range range : rangeArray) {
            vupRange = vupRange.expand((ValueUnitPair)range.mid());
        }
        return vupRange;
    }

    public String toString() {
        String string = "[" + this.minimum + ", " + this.maximum + "]";
        return string;
    }

    public String format(String string) {
        String string2;
        try {
            string2 = String.format(string, this.minimum.getContent(), this.minimum.getUnit(), this.maximum.getContent(), this.maximum.getUnit());
        }
        catch (IllegalFormatException illegalFormatException) {
            string2 = this.toString();
        }
        return string2;
    }

    public Optional<ValueUnitPair<E>> separation(Range<E> range) {
        if (range == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: targetRange");
        }
        if (this.intersects(range)) {
            return Optional.empty();
        }
        ValueUnitPair valueUnitPair = ((ValueUnitPair)range.max()).isLessThan(this.min()) ? this.min().minus((ValueUnitPair)range.max()) : ((ValueUnitPair)range.min()).minus(this.max());
        return Optional.of(valueUnitPair);
    }

    public static boolean contains(double[] dArray, double[] dArray2) {
        if (dArray2.length != 2) {
            throw new IllegalArgumentException("Illegal argument: containedRange.length (" + dArray2.length + ") did not pass the test: containedRange.length != 2");
        }
        if (dArray.length != 2) {
            throw new IllegalArgumentException("Illegal argument: containingRange.length (" + dArray.length + ") did not pass the test: containingRange.length != 2");
        }
        return dArray2[0] > dArray[0] && dArray2[1] < dArray[1];
    }
}

