/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.util;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.Entity;
import alma.hla.runtime.obsprep.bo.EntityPart;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.ot.gui.toplevel.GuiFactory;
import alma.obsprep.ot.gui.toplevel.ObservingToolController;
import alma.obsprep.ot.gui.toplevel.ObservingToolGui;
import alma.obsprep.ot.persistence.ImpexFactory;
import alma.obsprep.util.FileUtilities;
import java.awt.Font;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.Vector;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.prefs.Preferences;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.swing.JSplitPane;
import lombok.NonNull;
import org.apache.commons.jcs.engine.control.CompositeCacheManager;
import org.apache.commons.lang3.StringUtils;

public class MiscUtils {
    private static Vector<Font> italicizedFonts = new Vector();
    private static Boolean isParallelismToBeUsed = null;
    private static Boolean isSpectralLinesToBeAddedToSB = null;
    private static Boolean isDeveloperUIFeaturesEnabled = null;
    protected static final boolean dbg = false;
    static Map<String, ArrayList<String>> reportForFindResource = new HashMap<String, ArrayList<String>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Font italicize(Font font) {
        Vector<Font> vector = italicizedFonts;
        synchronized (vector) {
            for (int i = 0; i < italicizedFonts.size(); i += 2) {
                if (italicizedFonts.get(i) != font) continue;
                return italicizedFonts.get(i + 1);
            }
            Font font2 = font.deriveFont(2);
            italicizedFonts.add(font);
            italicizedFonts.add(font2);
            return font2;
        }
    }

    public static Object[] unique(Object[] objectArray, Comparator<Object> comparator) {
        Object[] objectArray2 = new Object[objectArray.length];
        objectArray2[0] = objectArray[0];
        int n = 1;
        for (int i = 1; i < objectArray.length; ++i) {
            int n2 = comparator.compare(objectArray[i - 1], objectArray[i]);
            if (n2 == 0) continue;
            objectArray2[n] = objectArray[i];
            ++n;
        }
        Object[] objectArray3 = new Object[n - 1];
        System.arraycopy(objectArray2, 0, objectArray3, 0, objectArray3.length);
        return objectArray2;
    }

    public static int[] computeAlignment(Object[] objectArray, Object[] objectArray2, Comparator<Object> comparator) {
        int[] nArray = new int[objectArray.length];
        int n = 0;
        int n2 = 0;
        while (n2 != objectArray.length) {
            if (n == objectArray2.length) {
                Arrays.fill(nArray, n2, nArray.length, -1);
                break;
            }
            int n3 = comparator.compare(objectArray[n2], objectArray2[n]);
            if (n3 < 0) {
                nArray[n2] = -1;
                ++n2;
                continue;
            }
            if (n3 == 0) {
                nArray[n2] = n;
                ++n2;
                continue;
            }
            if (n3 <= 0) continue;
            ++n;
        }
        return nArray;
    }

    public static File getBaseDirectory() {
        File file;
        for (File file2 = file = new File(System.getProperty("user.dir")); file2 != null; file2 = file2.getParentFile()) {
            if (!new File(file2, ".classpath").exists()) continue;
            return file2;
        }
        return null;
    }

    public static URL findResource(String string) {
        URL uRL = MiscUtils.findResource(null, string);
        if (uRL != null) {
            return uRL;
        }
        File file = MiscUtils.getBaseDirectory();
        if (file == null) {
            return null;
        }
        File file2 = new File(System.getProperty("user.dir"));
        if (file2.compareTo(file) == 0) {
            return null;
        }
        return MiscUtils.findResource(file, string);
    }

    public static boolean isDeveloperUIFeaturesEnabled() {
        if (isDeveloperUIFeaturesEnabled != null) {
            return isDeveloperUIFeaturesEnabled;
        }
        isDeveloperUIFeaturesEnabled = StringUtils.equals((CharSequence)System.getProperty("alma.obsprep.devfeatures", "false"), (CharSequence)"true");
        return isDeveloperUIFeaturesEnabled;
    }

    public static boolean isParallelismToBeUsed() {
        if (isParallelismToBeUsed != null) {
            return isParallelismToBeUsed;
        }
        isParallelismToBeUsed = StringUtils.equals((CharSequence)System.getProperty("alma.obsprep.useparallelism", "true"), (CharSequence)"true");
        return isParallelismToBeUsed;
    }

    public static boolean isSpectralLinesToBeAddedToSBs() {
        if (isSpectralLinesToBeAddedToSB != null) {
            return isSpectralLinesToBeAddedToSB;
        }
        isSpectralLinesToBeAddedToSB = StringUtils.equals((CharSequence)System.getProperty("alma.obsprep.addlinestosb", "true"), (CharSequence)"true");
        return isSpectralLinesToBeAddedToSB;
    }

    public static boolean isConfigurationsToBeDisplayed() {
        return StringUtils.equals((CharSequence)System.getProperty("alma.obsprep.displayconfigurations", "false"), (CharSequence)"true");
    }

    public static boolean isMacOS() {
        String string = System.getProperty("os.name");
        if (StringUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        return string.toLowerCase().indexOf("mac") >= 0;
    }

    public static boolean isConfirmationsDisabled() {
        String string = System.getProperty("alma.obsprep.noconfirmations", "false");
        return string.toLowerCase().indexOf("true") >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static URL findResource(File var0, String var1_1) {
        block29: {
            block25: {
                block23: {
                    block28: {
                        block24: {
                            block21: {
                                block27: {
                                    block22: {
                                        block19: {
                                            block26: {
                                                block20: {
                                                    var2_2 = null;
                                                    var3_3 = null;
                                                    var4_4 = null;
                                                    var5_5 = null;
                                                    try {
                                                        if (var0 == null) {
                                                            var3_3 = var1_1;
                                                        } else {
                                                            var6_6 = var0.getPath();
                                                            if (!var6_6.endsWith(File.separator)) {
                                                                var6_6 = (String)var6_6 + File.separator;
                                                            }
                                                            var3_3 = (String)var6_6 + var1_1;
                                                        }
                                                        var6_6 = var3_3.replace('\\', '/');
                                                        var4_4 = "classpath (ContextClassLoader)";
                                                        var7_7 = Thread.currentThread().getContextClassLoader();
                                                        var2_2 = var7_7.getResource((String)var6_6);
                                                        if (var2_2 == null) break block19;
                                                        var8_8 = var2_2;
                                                        if (var2_2 == null) break block20;
                                                    }
                                                    catch (Throwable var14_30) {
                                                        if (var2_2 != null) {
                                                            var15_31 = "from " + var4_4 + ": " + var2_2;
                                                            var16_32 = var15_31.lastIndexOf("/");
                                                            var17_33 = var15_31.substring(0, var16_32);
                                                            var18_34 = var15_31.substring(var16_32 + 1);
                                                            MiscUtils.reportForFindResourceAppend(var17_33, var18_34);
                                                        } else {
                                                            if (var5_5 == null) {
                                                                var5_5 = "not found anywhere in classpath or filesystem";
                                                            }
                                                            MiscUtils.reportForFindResourceAppend(var5_5, (String)var3_3);
                                                        }
                                                        throw var14_30;
                                                    }
                                                    var9_11 = "from " + var4_4 + ": " + var2_2;
                                                    var10_16 = var9_11.lastIndexOf("/");
                                                    var11_20 = var9_11.substring(0, var10_16);
                                                    var12_24 = var9_11.substring(var10_16 + 1);
                                                    MiscUtils.reportForFindResourceAppend(var11_20, var12_24);
                                                    break block26;
                                                }
                                                if (var5_5 == null) {
                                                    var5_5 = "not found anywhere in classpath or filesystem";
                                                }
                                                MiscUtils.reportForFindResourceAppend(var5_5, (String)var3_3);
                                            }
                                            return var8_8;
                                        }
                                        var4_4 = "classpath (SystemClassLoader)";
                                        var7_7 = MiscUtils.class.getClassLoader();
                                        var2_2 = var7_7.getResource((String)var6_6);
                                        if (var2_2 == null) break block21;
                                        var8_9 = var2_2;
                                        if (var2_2 == null) break block22;
                                        var9_12 = "from " + var4_4 + ": " + var2_2;
                                        var10_17 = var9_12.lastIndexOf("/");
                                        var11_21 = var9_12.substring(0, var10_17);
                                        var12_25 = var9_12.substring(var10_17 + 1);
                                        MiscUtils.reportForFindResourceAppend(var11_21, var12_25);
                                        break block27;
                                    }
                                    if (var5_5 == null) {
                                        var5_5 = "not found anywhere in classpath or filesystem";
                                    }
                                    MiscUtils.reportForFindResourceAppend(var5_5, (String)var3_3);
                                }
                                return var8_9;
                            }
                            if (var0 != null && !var0.isAbsolute()) {
                                var8_10 = System.getProperty("user.dir");
                                var3_3 = new File((String)var8_10, (String)var6_6).getAbsolutePath();
                            }
                            var4_4 = "filesystem";
                            var8_10 = new File((String)var3_3);
                            if (!var8_10.canRead()) break block23;
                            try {
                                var2_2 = FileUtilities.makeURL((String)var3_3);
                            }
                            catch (MalformedURLException var9_13) {
                                // empty catch block
                            }
                            if (var2_2 == null) ** GOTO lbl96
                            var9_14 = var2_2;
                            if (var2_2 == null) break block24;
                            var10_18 = "from " + var4_4 + ": " + var2_2;
                            var11_22 = var10_18.lastIndexOf("/");
                            var12_26 = var10_18.substring(0, var11_22);
                            var13_28 = var10_18.substring(var11_22 + 1);
                            MiscUtils.reportForFindResourceAppend(var12_26, var13_28);
                            break block28;
                        }
                        if (var5_5 == null) {
                            var5_5 = "not found anywhere in classpath or filesystem";
                        }
                        MiscUtils.reportForFindResourceAppend(var5_5, (String)var3_3);
                    }
                    return var9_14;
                }
                if (var8_10.exists()) {
                    var5_5 = "no read permission";
                }
lbl96:
                // 4 sources

                var9_15 = var2_2;
                if (var2_2 == null) break block25;
                var10_19 = "from " + var4_4 + ": " + var2_2;
                var11_23 = var10_19.lastIndexOf("/");
                var12_27 = var10_19.substring(0, var11_23);
                var13_29 = var10_19.substring(var11_23 + 1);
                MiscUtils.reportForFindResourceAppend(var12_27, var13_29);
                break block29;
            }
            if (var5_5 == null) {
                var5_5 = "not found anywhere in classpath or filesystem";
            }
            MiscUtils.reportForFindResourceAppend(var5_5, (String)var3_3);
        }
        return var9_15;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void reportForFindResourceAppend(String string, String string2) {
        Map<String, ArrayList<String>> map = reportForFindResource;
        synchronized (map) {
            ArrayList<String> arrayList = reportForFindResource.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList();
                reportForFindResource.put(string, arrayList);
            }
            arrayList.add(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String reportForFindResource() {
        StringBuilder stringBuilder = new StringBuilder();
        Map<String, ArrayList<String>> map = reportForFindResource;
        synchronized (map) {
            Set<Map.Entry<String, ArrayList<String>>> set = reportForFindResource.entrySet();
            for (Map.Entry<String, ArrayList<String>> object : set) {
                stringBuilder.append(object.getKey()).append("\n");
                String string = "     ";
                for (String string2 : object.getValue()) {
                    stringBuilder.append(string).append(string2);
                    string = ", ";
                }
                stringBuilder.append("\n");
            }
            for (ArrayList arrayList : reportForFindResource.values()) {
                arrayList.clear();
            }
            reportForFindResource.clear();
        }
        return stringBuilder.toString();
    }

    public static double getDividerLocation(JSplitPane jSplitPane) {
        int n = jSplitPane.getOrientation() == 1 ? jSplitPane.getWidth() : jSplitPane.getHeight();
        return (double)jSplitPane.getDividerLocation() / (double)(n - jSplitPane.getDividerSize());
    }

    public static Object[] whoCalled(Class<?> clazz) {
        int n;
        Object[] objectArray = new Object[3];
        StackTraceElement[] stackTraceElementArray = new Exception().getStackTrace();
        String string = clazz.getName();
        for (n = 0; n < stackTraceElementArray.length && !stackTraceElementArray[n].getClassName().equals(string); ++n) {
        }
        while (n < stackTraceElementArray.length) {
            String string2 = stackTraceElementArray[n].getClassName();
            if (!string2.equals(string)) {
                objectArray[0] = string2;
                objectArray[1] = stackTraceElementArray[n].getMethodName();
                objectArray[2] = new Long(stackTraceElementArray[n].getLineNumber());
                break;
            }
            ++n;
        }
        return objectArray;
    }

    public static String classname(Object object) {
        if (object == null) {
            return "null";
        }
        String string = object.getClass().getName();
        int n = string.lastIndexOf(46);
        return string.substring(n + 1);
    }

    public static String packageClassnameHash(Object object) {
        if (object == null) {
            return "null";
        }
        if (object instanceof BusinessObject) {
            BusinessObject businessObject = (BusinessObject)object;
            StringBuilder stringBuilder = new StringBuilder();
            String string = object.getClass().getName();
            stringBuilder.append(string.substring(string.lastIndexOf(46, string.lastIndexOf(46) - 1) + 1));
            stringBuilder.append("[");
            stringBuilder.append("name=").append(businessObject.getName());
            if (businessObject instanceof Entity) {
                stringBuilder.append(", eid=").append(((Entity)businessObject).getEntityID());
            }
            if (businessObject instanceof EntityPart) {
                stringBuilder.append(", epid=").append(((EntityPart)businessObject).getEntityPartId());
            }
            stringBuilder.append(", idhash=").append(System.identityHashCode(businessObject));
            try {
                if (businessObject.hashCode() != System.identityHashCode(businessObject)) {
                    stringBuilder.append(", hash=").append(businessObject.hashCode());
                }
            }
            catch (Exception exception) {
                stringBuilder.append(", hash=<failed>");
            }
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
        return object.getClass().getName() + "[idhash=" + System.identityHashCode(object) + "]";
    }

    public static boolean isJythonInstalled() {
        URL uRL = MiscUtils.findResource(null, "lib/jython.jar");
        return uRL != null;
    }

    public static int currentMemoryLoad() {
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.totalMemory() - runtime.freeMemory();
        int n = Math.round(100.0f * (float)l / (float)runtime.maxMemory());
        return n;
    }

    public static void resetJCSCache() {
        try {
            Log.logger(MiscUtils.class).info("Clearing all JCS cache regions");
            CompositeCacheManager compositeCacheManager = CompositeCacheManager.getInstance();
            Arrays.stream(compositeCacheManager.getCacheNames()).filter(string -> !string.equals("imageCache")).forEach(string -> {
                try {
                    Log.logger(MiscUtils.class).finest("Clearing cache : " + string);
                    compositeCacheManager.getCache(string).removeAll();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
        }
        catch (Exception exception) {
            Log.logger(MiscUtils.class).warning("Unable to clear cache " + exception.getMessage());
        }
    }

    public static void processFutures(ExecutorService executorService, List<Runnable> list) {
        MiscUtils.processFutures(executorService, list, 30);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void processFutures(ExecutorService executorService, List<Runnable> list, int n) {
        ConcurrentLinkedQueue concurrentLinkedQueue = new ConcurrentLinkedQueue();
        for (Runnable iterator : list) {
            concurrentLinkedQueue.add(executorService.submit(iterator));
        }
        boolean bl = false;
        block10: do {
            bl = true;
            for (Future future : concurrentLinkedQueue) {
                if (future.isDone() || future.isCancelled()) continue;
                bl = false;
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException interruptedException) {}
                continue block10;
            }
        } while (!bl);
        Iterator iterator = concurrentLinkedQueue.iterator();
        while (iterator.hasNext()) {
            Future future = (Future)iterator.next();
            try {
                future.get();
                continue;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            catch (ExecutionException executionException) {
                Log.logger(MiscUtils.class).warning(executionException.getMessage());
                executionException.printStackTrace();
                continue;
            }
            finally {
                executorService.shutdown();
                continue;
            }
            break;
        }
        return;
    }

    public static void importLastProject() {
        Object object;
        ObsProject obsProject = null;
        ObservingToolGui observingToolGui = ObservingToolController.getOTGui();
        String string = String.format("RecentFileList-aot.fileList", new Object[0]);
        Preferences preferences = Preferences.userNodeForPackage(GuiFactory.class);
        String string2 = preferences.get(string, null);
        File file = null;
        if (string2 != null) {
            object = string2.split(File.pathSeparator);
            if (((String[])object).length == 0) {
                return;
            }
            file = new File(object[0]);
        }
        if (file == null) {
            return;
        }
        try {
            object = new URL("file:" + file.getPath());
        }
        catch (MalformedURLException malformedURLException) {
            return;
        }
        try {
            obsProject = ImpexFactory.getInstance().importObsProject((URL)object, false);
        }
        catch (Exception exception) {
            Log.logger(MiscUtils.class).warning("Unable to import project");
            return;
        }
        if (obsProject == null) {
            return;
        }
        obsProject.getObsProgram();
        File file2 = null;
        String string3 = ((URL)object).toExternalForm();
        if (string3.startsWith("file:")) {
            file2 = new File(string3.substring(5));
        }
        observingToolGui.setPrimaryProject(obsProject, file2, false);
        observingToolGui.flagBrokenSchedBlocks(obsProject);
    }

    public static double minClosestToZero(double d, double d2) {
        if (d == 0.0) {
            return d2;
        }
        if (d2 == 0.0) {
            return d;
        }
        return d < d2 ? d : d2;
    }

    public static String getSanitizedSourceName(String string) {
        String string2 = string.trim();
        string2 = string2.replace("**", "_multiplestar_");
        string2 = string2.replace("*", "_star_");
        string2 = string2.replace("?", "_candidate_");
        string2 = string2.replaceAll("[ :,;=#()\\[\\]<>]", "_");
        string2 = string2.replaceAll("[^_a-zA-Z0-9.+-]", "");
        string2 = string2.replaceAll("_{2,}", "_");
        string2 = string2.replaceAll("^_", "").replaceAll("_$", "");
        return string2;
    }

    public static boolean isOTRunningInServletContainer() {
        try {
            new InitialContext().lookup("java:comp/env");
        }
        catch (NamingException namingException) {
            return false;
        }
        return true;
    }

    public static String getCurrentDocumentRevisionNumber() throws ObsProject.UnableToGetDocumentRevisionNumberException {
        return ObsProject.createObsProject().getCastorObject().getRevision();
    }

    public static Calendar convertToGmt(Calendar calendar) {
        Date date = calendar.getTime();
        TimeZone timeZone = calendar.getTimeZone();
        long l = date.getTime();
        int n = timeZone.getOffset(l);
        Calendar calendar2 = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        calendar2.setTime(date);
        calendar2.add(14, n);
        return calendar2;
    }

    public static void copyFile(@NonNull File file, @NonNull File file2, boolean bl) throws IOException {
        if (file == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (file2 == null) {
            throw new NullPointerException("dest is marked non-null but is null");
        }
        if (!file2.getParentFile().mkdirs() && !file2.getParentFile().exists()) {
            throw new IOException("Unable to create directory " + file2.getAbsolutePath());
        }
        Path path = Paths.get(file.getAbsolutePath(), new String[0]);
        Path path2 = Paths.get(file2.getAbsolutePath(), new String[0]);
        Files.copy(path, path2, StandardCopyOption.REPLACE_EXISTING);
        if (bl && !file2.setLastModified(file.lastModified())) {
            throw new IOException("Unable to set file modification time for " + file2.getAbsolutePath());
        }
    }
}

