/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.util;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.util.Convert;
import java.io.File;
import java.io.FilenameFilter;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.log4j.Appender;
import org.apache.log4j.varia.NullAppender;

public class LoggingSetup {
    private static ConsoleOut consoleOut;
    private static FileHandler fileOut;
    public static final String OT_LOGFILE_NAME = "ot.log";

    public static void configureBasicSetup() {
        try {
            File file = LoggingSetup.prepareLogfile();
            LogManager logManager = LogManager.getLogManager();
            logManager.reset();
            Logger logger = logManager.getLogger("");
            fileOut = new FileHandler(file.getPath());
            fileOut.setFormatter(new LoggingVerboseFormat());
            fileOut.setLevel(Level.ALL);
            logger.addHandler(fileOut);
            consoleOut = new ConsoleOut();
            LoggingSetup.configureConsole();
            logger.addHandler(consoleOut);
            logger.setLevel(Level.WARNING);
            org.apache.log4j.Logger.getRootLogger().setLevel(org.apache.log4j.Level.ERROR);
            org.apache.log4j.Logger.getLogger((String)"org.apache.commons.httpclient.params.DefaultHttpParams").addAppender((Appender)new NullAppender());
        }
        catch (Exception exception) {
            System.err.println("ObservingTool: Could not configure logging framework (basic setup). Stack trace: ");
            exception.printStackTrace(System.err);
        }
    }

    private static File prepareLogfile() {
        File file = new File(System.getProperty("user.home"), ".almaot");
        file.mkdir();
        File file2 = new File(file, OT_LOGFILE_NAME);
        File file3 = new File(file, OT_LOGFILE_NAME);
        if (file3.exists()) {
            long l = file3.lastModified();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy.MM.dd-HH.mm");
            String string = simpleDateFormat.format(new Date(l));
            File object = new File(file, "ot." + string + ".log");
            file3.renameTo(object);
        }
        if (file.isDirectory()) {
            int n = 5;
            Object[] objectArray = file.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File file, String string) {
                    return string.matches("ot.+log") && !string.equals(LoggingSetup.OT_LOGFILE_NAME);
                }
            });
            Arrays.sort(objectArray);
            for (int i = 0; i < objectArray.length - n; ++i) {
                ((File)objectArray[i]).delete();
            }
        }
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File file, String string) {
                    return string.matches("ot.+lck") && !string.equals("ot.log.lck");
                }
            });
            for (File file4 : fileArray) {
                file4.delete();
            }
        }
        return file2;
    }

    private static void configureConsole() {
        boolean bl = Boolean.getBoolean("OT.verboseConsole");
        if (bl) {
            consoleOut.setFormatter(new LoggingVerboseFormat());
            consoleOut.setLevel(Level.ALL);
        } else {
            consoleOut.setFormatter(new LoggingTerseFormat());
            consoleOut.setLevel(Level.INFO);
        }
    }

    public static void configureLoggers(List<String> list) {
        Log.DEBUG.hashCode();
        try {
            LogManager logManager = LogManager.getLogManager();
            for (String string : list) {
                String string2 = System.getProperty(string + ".level");
                Logger logger = logManager.getLogger(string);
                try {
                    Level level = null;
                    if (string2 != null) {
                        level = Level.parse(string2);
                    }
                    logger.setLevel(level);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    System.err.println("Ignoring illegal log level setting for logger " + string + ": '" + string2 + "'");
                }
            }
        }
        catch (Exception exception) {
            System.err.println("ObservingTool: Could not configure logging framework. Stack trace: ");
            exception.printStackTrace(System.err);
        }
    }

    public static void configureDebugging(List<String> list, String string, boolean bl) {
        Properties properties = System.getProperties();
        properties.remove("alma.obsprep.PrintStackTrace");
        properties.remove("OT.verboseConsole");
        for (String string2 : list) {
            properties.remove(string2 + ".level");
        }
        properties.put("OT.level", string);
        properties.put("OT.LO.level", "WARNING");
        if (bl) {
            properties.put("alma.obsprep.PrintStackTrace", "true");
            properties.put("OT.verboseConsole", "true");
        }
        LoggingSetup.configureLoggers(list);
        LoggingSetup.configureConsole();
    }

    static class LoggingVerboseFormat
    extends Formatter {
        LoggingVerboseFormat() {
        }

        @Override
        public String format(LogRecord logRecord) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(Convert.convertToISO(logRecord.getMillis()));
            stringBuffer.append("| ");
            stringBuffer.append(logRecord.getLevel().getName());
            stringBuffer.append("| ");
            stringBuffer.append(logRecord.getMessage());
            stringBuffer.append("  ((");
            stringBuffer.append(Thread.currentThread().getName());
            if (logRecord.getSourceClassName() != null && logRecord.getSourceMethodName() != null) {
                stringBuffer.append(", ");
                String string = logRecord.getSourceClassName();
                if (string.endsWith(".java")) {
                    string = string.substring(0, string.length() - 5);
                }
                stringBuffer.append(string.substring(string.lastIndexOf(46) + 1));
                stringBuffer.append("#");
                stringBuffer.append(logRecord.getSourceMethodName());
            }
            stringBuffer.append(", '");
            stringBuffer.append(logRecord.getLoggerName());
            stringBuffer.append("'))");
            stringBuffer.append(this.stackTrace(logRecord.getThrown()));
            stringBuffer.append("\n");
            return stringBuffer.toString();
        }

        protected String stackTrace(Throwable throwable) {
            if (throwable == null) {
                return "";
            }
            boolean bl = false;
            bl |= "true".equalsIgnoreCase(LogManager.getLogManager().getProperty("alma.obsprep.PrintStackTrace"));
            if (!(bl |= "true".equalsIgnoreCase(System.getProperty("alma.obsprep.PrintStackTrace")))) {
                return "";
            }
            StringBuffer stringBuffer = new StringBuffer(5000);
            stringBuffer.append("\n ~ Throwable was: ");
            stringBuffer.append(throwable);
            while (true) {
                StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
                for (int i = 0; i < stackTraceElementArray.length; ++i) {
                    stringBuffer.append("\n ~   ");
                    stringBuffer.append(stackTraceElementArray[i].toString());
                }
                if ((throwable = throwable.getCause()) == null) break;
                stringBuffer.append("\n ~ due to: ");
                stringBuffer.append(throwable);
            }
            return stringBuffer.toString();
        }
    }

    public static class LoggingTerseFormat
    extends Formatter {
        @Override
        public String format(LogRecord logRecord) {
            String string = logRecord.getMessage();
            String string2 = Convert.convertToDateTime(new Date(logRecord.getMillis()));
            Throwable throwable = logRecord.getThrown();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string2);
            stringBuffer.append("  ");
            stringBuffer.append(string);
            if (throwable != null) {
                stringBuffer.append(" (see log file for error details)");
            }
            stringBuffer.append("\n");
            return stringBuffer.toString();
        }
    }

    static class ConsoleOut
    extends Handler {
        private Writer stderr;
        private Writer stdout;
        private int deviate = Level.WARNING.intValue();

        ConsoleOut() {
            this.stderr = new OutputStreamWriter(System.err);
            this.stdout = new OutputStreamWriter(System.out);
        }

        @Override
        public void publish(LogRecord logRecord) {
            if (this.isLoggable(logRecord)) {
                Writer writer = logRecord.getLevel().intValue() >= this.deviate ? this.stderr : this.stdout;
                int n = 0;
                try {
                    n = 5;
                    String string = this.getFormatter().format(logRecord);
                    n = 1;
                    writer.write(string);
                    n = 2;
                    writer.flush();
                }
                catch (Exception exception) {
                    this.reportError(null, exception, n);
                }
            }
        }

        @Override
        public void flush() {
            try {
                this.stderr.flush();
                this.stdout.flush();
            }
            catch (Exception exception) {
                this.reportError(null, exception, 2);
            }
        }

        @Override
        public void close() throws SecurityException {
            this.flush();
        }
    }
}

