/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.util;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.ot.gui.toplevel.GuiFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.Charset;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.xhtmlrenderer.event.DefaultDocumentListener;
import org.xhtmlrenderer.event.DocumentListener;
import org.xhtmlrenderer.extend.ReplacedElementFactory;
import org.xhtmlrenderer.extend.UserAgentCallback;
import org.xhtmlrenderer.layout.SharedContext;
import org.xhtmlrenderer.resource.XMLResource;
import org.xhtmlrenderer.simple.FSScrollPane;
import org.xhtmlrenderer.simple.XHTMLPanel;
import org.xhtmlrenderer.swing.DelegatingUserAgent;
import org.xhtmlrenderer.swing.ImageResourceLoader;
import org.xhtmlrenderer.swing.RepaintListener;
import org.xhtmlrenderer.swing.SwingReplacedElementFactory;
import org.xhtmlrenderer.util.GeneralUtil;

public class JavaFXHTMLWindow {
    private String uri;
    private XHTMLPanel xhtmlPanel;
    private UserAgentCallback uac;
    private JDialog dialogWindow;

    public JDialog buildHTMLWindow(String string, String string2, int n, int n2) {
        this.dialogWindow = new JDialog();
        this.dialogWindow.setTitle(string2);
        this.dialogWindow.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.dialogWindow.setDefaultCloseOperation(2);
        this.dialogWindow.setSize(n, n2);
        GuiFactory guiFactory = GuiFactory.getFactory();
        JFrame jFrame = guiFactory.getParentWindow();
        this.dialogWindow.setLocationRelativeTo(jFrame);
        Container container = this.dialogWindow.getContentPane();
        container.setLayout(new BorderLayout());
        JButton jButton = new JButton("Close");
        jButton.addActionListener(actionEvent -> {
            this.dialogWindow.setVisible(false);
            this.dialogWindow.dispose();
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jButton, "Last");
        container.add((Component)jPanel, "Last");
        EventQueue.invokeLater(() -> {
            ByteArrayInputStream byteArrayInputStream;
            this.xhtmlPanel = new XHTMLPanel();
            SharedContext sharedContext = this.xhtmlPanel.getSharedContext();
            sharedContext.getTextRenderer().setSmoothingThreshold(0.0f);
            this.setupDocumentListener(this.xhtmlPanel);
            this.setupUserAgentCallback(this.xhtmlPanel);
            try {
                byteArrayInputStream = new ByteArrayInputStream(string.getBytes(Charset.forName("UTF-8")));
                this.xhtmlPanel.setDocument((InputStream)byteArrayInputStream, null);
            }
            catch (Exception exception) {
                Log.logger(JavaFXHTMLWindow.class).warning("Unable to render XML: " + exception.getMessage());
            }
            byteArrayInputStream = new FSScrollPane((JPanel)this.xhtmlPanel);
            container.add((Component)((Object)byteArrayInputStream));
            this.dialogWindow.pack();
            this.dialogWindow.setSize(1024, 768);
            this.dialogWindow.setVisible(true);
        });
        return this.dialogWindow;
    }

    public JDialog buildHTMLWindow(URL uRL, String string, int n, int n2) throws IOException {
        String string2;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
        StringBuffer stringBuffer = new StringBuffer();
        while ((string2 = bufferedReader.readLine()) != null) {
            stringBuffer.append(string2);
        }
        bufferedReader.close();
        return this.buildHTMLWindow(stringBuffer.toString(), string, n, n2);
    }

    private void setupUserAgentCallback(XHTMLPanel xHTMLPanel) {
        this.uac = new DelegatingUserAgent();
        ImageResourceLoader imageResourceLoader = new ImageResourceLoader();
        imageResourceLoader.setRepaintListener((RepaintListener)xHTMLPanel);
        ((DelegatingUserAgent)this.uac).setImageResourceLoader(imageResourceLoader);
        xHTMLPanel.getSharedContext().setUserAgentCallback(this.uac);
        xHTMLPanel.getSharedContext().setReplacedElementFactory((ReplacedElementFactory)new SwingReplacedElementFactory((RepaintListener)xHTMLPanel, imageResourceLoader));
    }

    private void setupDocumentListener(final XHTMLPanel xHTMLPanel) {
        xHTMLPanel.addDocumentListener((DocumentListener)new DefaultDocumentListener(){

            public void documentStarted() {
                xHTMLPanel.setCursor(new Cursor(3));
                super.documentStarted();
            }

            public void documentLoaded() {
                xHTMLPanel.setCursor(new Cursor(0));
                JavaFXHTMLWindow.this.dialogWindow.setTitle(xHTMLPanel.getDocumentTitle());
            }

            public void onLayoutException(Throwable throwable) {
                xHTMLPanel.setCursor(new Cursor(0));
                xHTMLPanel.setDocument(JavaFXHTMLWindow.this.getErrorDocument("can't layout: " + throwable.getMessage()).getDocument());
            }

            public void onRenderException(Throwable throwable) {
                xHTMLPanel.setCursor(new Cursor(0));
                xHTMLPanel.setDocument(JavaFXHTMLWindow.this.getErrorDocument("can't render: " + throwable.getMessage()).getDocument());
            }
        });
    }

    private XMLResource getErrorDocument(String string) {
        String string2 = GeneralUtil.escapeHTML((String)this.uri);
        String string3 = "<html><h1>Document not found</h1><p>Could not load URI <pre>" + string2 + "</pre>, because: " + string + "</p></html>";
        XMLResource xMLResource = XMLResource.load((Reader)new StringReader(string3));
        return xMLResource;
    }
}

