/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.summaryfeedback;

import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.SpectralScan;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.UnableToFindSolutionException;
import alma.valuetypes.Angle;
import alma.valuetypes.Time;

class SpectralScanTuningInfo {
    protected SpectralScan scan;
    protected Time integrationTime;
    protected Angle beamSize;

    public SpectralSetupParameters getSpectralSetupParameters() {
        return this.scan == null ? null : (SpectralSetupParameters)this.scan.getParent();
    }

    public SpectralScan.SpectralScanTunings getTunings() throws UnableToFindSolutionException {
        return this.scan == null ? null : this.scan.getTunings();
    }

    public int getNumTunings() {
        try {
            SpectralScan.SpectralScanTunings spectralScanTunings = this.getTunings();
            return spectralScanTunings == null ? 0 : spectralScanTunings.getNumberOfTunings();
        }
        catch (UnableToFindSolutionException unableToFindSolutionException) {
            return 0;
        }
    }

    public ScienceGoal getScienceGoal() {
        return this.scan.getSpectralSetupParameters().getScienceGoal();
    }

    public SpectralScanTuningInfo(SpectralScan spectralScan, Time time, Angle angle) {
        this.scan = spectralScan;
        this.integrationTime = time;
        this.beamSize = angle;
    }

    public SpectralScan getScan() {
        return this.scan;
    }

    public Time getIntegrationTime() {
        return this.integrationTime;
    }

    public Angle getBeamSize() {
        return this.beamSize;
    }
}

