/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.summaryfeedback;

import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.valuetypes.Angle;
import alma.valuetypes.SkyCoordinates;
import lombok.NonNull;

class ScienceGoalInfo {
    ScienceGoal sg;
    String sgname;
    SkyCoordinates sourceCoordinates;
    ReceiverBand receiverBand;
    Angle largestAngularScale;
    boolean isACAUsed;
    boolean isStandAloneACA;

    ScienceGoalInfo(@NonNull ScienceGoal scienceGoal) {
        if (scienceGoal == null) {
            throw new NullPointerException("sg is marked non-null but is null");
        }
        this.sg = scienceGoal;
        this.sgname = scienceGoal.getNameOrDefault();
        TargetParameters targetParameters = scienceGoal.getSoleTargetParameters();
        if (targetParameters != null) {
            this.sourceCoordinates = targetParameters.getSourceCoordinates();
        }
        PerformanceParameters performanceParameters = scienceGoal.getPerformanceParameters();
        this.receiverBand = scienceGoal.getSpectralSetupParameters().getReceiverBand();
        this.largestAngularScale = performanceParameters.getDesiredLargestScale();
        this.isACAUsed = performanceParameters.getUseACA();
        this.isStandAloneACA = scienceGoal.isStandAloneACA();
    }

    public ScienceGoal getSg() {
        return this.sg;
    }

    public String getSgname() {
        return this.sgname;
    }

    public SkyCoordinates getSourceCoordinates() {
        return this.sourceCoordinates;
    }

    public ReceiverBand getReceiverBand() {
        return this.receiverBand;
    }

    public Angle getLargestAngularScale() {
        return this.largestAngularScale;
    }

    public boolean isACAUsed() {
        return this.isACAUsed;
    }

    public boolean isStandAloneACA() {
        return this.isStandAloneACA;
    }
}

