/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.summaryfeedback;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.services.summaryfeedback.CompleteProposalExporter;
import alma.obsprep.services.summaryfeedback.CompleteProposalPrintable;
import alma.obsprep.services.summaryfeedback.ExportableFeedback;
import alma.obsprep.services.summaryfeedback.FeedbackSummary;
import alma.obsprep.services.summaryfeedback.FeedbackSummaryObsProposal;
import alma.obsprep.services.summaryfeedback.FeedbackSummarySgCollection;
import alma.obsprep.services.summaryfeedback.ObsProposalScienceGoalNavigator;
import alma.obsprep.services.summaryfeedback.PdfExporter;
import alma.obsprep.services.summaryfeedback.ProposalSummaryView;
import alma.obsprep.services.summaryfeedback.ScienceGoalSummaryView;
import alma.obsprep.services.summaryfeedback.SummaryDocument;
import java.awt.print.Printable;

public class FeedbackSummaryObsProject
extends FeedbackSummary
implements ExportableFeedback {
    private FeedbackSummaryObsProposal propSummary;
    private FeedbackSummarySgCollection allSgSummary;
    private ObsProposal proposal;
    private ObsProposalScienceGoalNavigator obsProposalScienceGoalNavigator;

    public FeedbackSummaryObsProject(ObsProject obsProject) {
        if (obsProject == null) {
            Log.logger((Object)this).warning("project must not be null");
            return;
        }
        this.setUserObject((BusinessObject)obsProject);
        try {
            this.proposal = obsProject.getObsProposal();
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger((Object)this).warning("Can not get proposal : " + unknownEntityException.getMessage());
            return;
        }
        assert (this.proposal != null);
        this.obsProposalScienceGoalNavigator = new ObsProposalScienceGoalNavigator(this.proposal, true);
        this.propSummary = new FeedbackSummaryObsProposal(this.proposal);
        this.allSgSummary = new FeedbackSummarySgCollection(this.proposal, this.obsProposalScienceGoalNavigator);
        this.setView(this.propSummary.view);
    }

    public Object getCurrentObject() {
        if (this.view == this.propSummary.view) {
            return this.proposal;
        }
        SummaryDocument summaryDocument = (SummaryDocument)this.view.getModel().getDocument();
        return summaryDocument == null ? null : summaryDocument.getUserObject();
    }

    @Override
    public boolean hasNext() {
        if (this.proposal == null) {
            return false;
        }
        Object object = this.getCurrentObject();
        if (object == null) {
            return false;
        }
        if (object == this.proposal) {
            return this.obsProposalScienceGoalNavigator.getScienceGoalCount() > 0;
        }
        if (object instanceof ScienceGoal) {
            ScienceGoal scienceGoal = (ScienceGoal)object;
            int n = this.obsProposalScienceGoalNavigator.indexOf(scienceGoal);
            if (n == -1) {
                return false;
            }
            return n < this.obsProposalScienceGoalNavigator.getScienceGoalCount() - 1;
        }
        Log.logger((Object)this).warning("Unexpected object : " + object);
        return false;
    }

    @Override
    public boolean hasPrev() {
        if (this.proposal == null) {
            return false;
        }
        Object object = this.getCurrentObject();
        if (object == null) {
            return false;
        }
        if (object == this.proposal) {
            return false;
        }
        if (object instanceof ScienceGoal) {
            return true;
        }
        Log.logger((Object)this).warning("Unexpected object : " + object);
        return false;
    }

    @Override
    public void showNext() {
        if (!this.hasNext()) {
            return;
        }
        if (this.proposal == null) {
            return;
        }
        Object object = this.getCurrentObject();
        if (object == this.proposal) {
            this.setView(this.allSgSummary.view);
            this.allSgSummary.buildPage(this.obsProposalScienceGoalNavigator.getScienceGoal(0));
        } else {
            int n = this.obsProposalScienceGoalNavigator.indexOf((ScienceGoal)object);
            this.allSgSummary.buildPage(this.obsProposalScienceGoalNavigator.getScienceGoal(n + 1));
        }
    }

    @Override
    public void showPrev() {
        if (!this.hasPrev()) {
            return;
        }
        if (this.proposal == null) {
            return;
        }
        Object object = this.getCurrentObject();
        if (object instanceof ScienceGoal) {
            int n = this.obsProposalScienceGoalNavigator.indexOf((ScienceGoal)object);
            if (n == 0) {
                this.propSummary.buildPage(this.proposal);
                this.setView(this.propSummary.view);
            } else {
                this.setView(this.allSgSummary.view);
                this.allSgSummary.buildPage(this.obsProposalScienceGoalNavigator.getScienceGoal(n - 1));
            }
        }
    }

    @Override
    public Printable getAllPagePrintable() {
        return new CompleteProposalPrintable(this.proposal);
    }

    @Override
    public PdfExporter getPdfExporter() {
        ProposalSummaryView proposalSummaryView = (ProposalSummaryView)this.propSummary.view.createOffView();
        ScienceGoalSummaryView scienceGoalSummaryView = (ScienceGoalSummaryView)this.allSgSummary.view.createOffView();
        CompleteProposalExporter completeProposalExporter = new CompleteProposalExporter(proposalSummaryView, scienceGoalSummaryView);
        completeProposalExporter.setObsProposal(this.proposal);
        return completeProposalExporter;
    }
}

