/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.summaryfeedback;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.ot.gui.toplevel.DialogId;
import alma.obsprep.ot.gui.toplevel.GuiFactory;
import alma.obsprep.services.summaryfeedback.PdfExporter;
import alma.obsprep.services.summaryfeedback.SummaryFeedbackView;
import alma.obsprep.util.FileUtilities;
import alma.obsprep.util.GUIUtilities;
import com.itextpdf.awt.FontMapper;
import com.itextpdf.awt.PdfGraphics2D;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.ExceptionConverter;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;

public class DefaultPdfExporter
implements PdfExporter {
    private static DialogId DIALOG_OVERWRITE_FILE = new DialogId("SummaryPDF.OverwriteFile");
    protected static FontMapper SWING_FONTMAPPER = new FontMapper(){

        public Font pdfToAwt(BaseFont baseFont, int n) {
            return null;
        }

        public BaseFont awtToPdf(Font font) {
            try {
                int n = font.getStyle() & 3;
                String string = n == 3 ? "BoldItalic" : (n == 1 ? "Bold" : (n == 2 ? "Italic" : "Regular"));
                String string2 = DefaultPdfExporter.class.getPackage().getName().replaceAll("\\.", "/");
                return BaseFont.createFont((String)(string2 + "/resources/LiberationSans-" + string + ".ttf"), (String)"Identity-H", (boolean)true);
            }
            catch (DocumentException documentException) {
                documentException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return null;
        }
    };
    protected SummaryFeedbackView offView;

    protected DefaultPdfExporter() {
    }

    protected DefaultPdfExporter(SummaryFeedbackView summaryFeedbackView) {
        this.setOffView(summaryFeedbackView);
    }

    @Override
    public void exportToPdf() {
        File file;
        block2: {
            int n;
            JFileChooser jFileChooser = GuiFactory.getFactory().giveFileChooser("pdf");
            FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter("PDF file", "pdf");
            jFileChooser.addChoosableFileFilter(fileNameExtensionFilter);
            do {
                int n2 = jFileChooser.showSaveDialog(null);
                file = jFileChooser.getSelectedFile();
                if (n2 != 0 || file == null) {
                    return;
                }
                if (!file.exists() || (n = GUIUtilities.offer(DIALOG_OVERWRITE_FILE, "File '" + file.getAbsolutePath() + "' already exists, do you want to overwrite it?", "Yes", "No", "Cancel")) == 0) break block2;
            } while (n == 1);
            return;
        }
        String string = file.getAbsolutePath();
        String string2 = FileUtilities.getExtension(string);
        string2 = string2 == null ? ".pdf" : (string2.length() == 0 ? "pdf" : (string2.equals("pdf") ? "" : ".pdf"));
        File file2 = new File(string + string2);
        this.exportToPdf(file2);
    }

    protected Rectangle getPdfPageSize() {
        return defaultPdfPageSize;
    }

    protected int getPdfPageMargin() {
        return 40;
    }

    @Override
    public void exportToPdf(File file) {
        block4: {
            Rectangle rectangle = this.getPdfPageSize();
            Document document = new Document(rectangle);
            try {
                PdfWriter pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(file));
                document.open();
                this.exportToPdfPage(document, pdfWriter, rectangle);
                document.close();
            }
            catch (DocumentException documentException) {
                Log.logger((Object)this).warning(documentException.getMessage());
                GUIUtilities.warning(null, documentException.getMessage());
            }
            catch (FileNotFoundException fileNotFoundException) {
                Log.logger((Object)this).warning(fileNotFoundException.getMessage());
                GUIUtilities.warning(null, fileNotFoundException.getMessage());
            }
            catch (ExceptionConverter exceptionConverter) {
                if (document.getPageNumber() <= 0) break block4;
                GUIUtilities.warning(null, exceptionConverter.getMessage());
                Log.logger((Object)this).warning(exceptionConverter.getMessage());
            }
        }
    }

    protected void exportToPdfPage(Document document, PdfWriter pdfWriter, Rectangle rectangle) {
        if (this.offView == null) {
            return;
        }
        int n = this.getPdfPageMargin();
        JFrame jFrame = new JFrame();
        jFrame.getContentPane().add(new JScrollPane(this.offView));
        jFrame.pack();
        float f = rectangle.getWidth();
        float f2 = rectangle.getHeight();
        double d = this.getPageFitScale(rectangle, n);
        PdfContentByte pdfContentByte = pdfWriter.getDirectContent();
        PdfTemplate pdfTemplate = pdfContentByte.createTemplate(f, f2);
        PdfGraphics2D pdfGraphics2D = new PdfGraphics2D((PdfContentByte)pdfTemplate, f, f2, SWING_FONTMAPPER);
        pdfGraphics2D.scale(d, d);
        this.offView.print((Graphics)pdfGraphics2D);
        pdfGraphics2D.dispose();
        pdfContentByte.addTemplate(pdfTemplate, (float)n, (float)(-n));
    }

    protected double getPageFitScale(Rectangle rectangle, int n) {
        float f = rectangle.getWidth();
        float f2 = rectangle.getHeight();
        double d = Math.min((f - (float)(n * 2)) / (float)this.offView.getWidth(), (f2 - (float)(n * 2)) / (float)this.offView.getHeight());
        d = d < 1.0 ? d : 1.0;
        return d;
    }

    protected void doLayout(Component component) {
        FutureTask<Void> futureTask = new FutureTask<Void>(() -> {
            this.innerDoLayout(component);
            return null;
        });
        if (SwingUtilities.isEventDispatchThread()) {
            futureTask.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(futureTask);
            }
            catch (InterruptedException interruptedException) {
                try {
                    futureTask.get();
                }
                catch (InterruptedException interruptedException2) {
                }
                catch (ExecutionException executionException) {
                    throw new RuntimeException(interruptedException.getCause());
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException(invocationTargetException.getCause());
            }
        }
    }

    private void innerDoLayout(Component component) {
        component.addNotify();
        component.doLayout();
        if (component.getParent() != null) {
            component.getParent().doLayout();
        }
        if (component instanceof Container) {
            Component[] componentArray;
            for (Component component2 : componentArray = ((Container)component).getComponents()) {
                this.innerDoLayout(component2);
            }
        }
    }

    protected JPanel addHaderLabelToView(JComponent jComponent, JLabel jLabel) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 3));
        jPanel.setBackground(Color.WHITE);
        jLabel.setHorizontalAlignment(4);
        jLabel.setOpaque(true);
        jLabel.setBackground(Color.WHITE);
        jLabel.setBorder(BorderFactory.createMatteBorder(0, 0, 2, 0, Color.BLACK));
        JLabel jLabel2 = new JLabel(" ");
        jLabel2.setOpaque(true);
        jLabel2.setBackground(Color.WHITE);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jLabel, "North");
        jPanel2.add((Component)jLabel2, "South");
        jPanel.add(jPanel2);
        jPanel.add(jComponent);
        new JScrollPane(jPanel);
        return jPanel;
    }

    public void setOffView(SummaryFeedbackView summaryFeedbackView) {
        this.offView = summaryFeedbackView;
    }
}

