/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.spectralspec;

import alma.obsprep.bo.schedblock.ACABaseBandConfig;
import alma.obsprep.bo.schedblock.AbstractBaseBandConfig;
import alma.obsprep.bo.schedblock.BLBaseBandConfig;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerationContext;
import alma.obsprep.services.generator.refactored.spectralspec.DGCB2BReferenceSpectralSpecBuilderBase;
import alma.obsprep.services.generator.refactored.spectralspec.DGCReferenceB2BSpectralSpecBuilderFactory;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.NonNull;

public class ACADGCB2BReferenceSpectralSpecBuilder
extends DGCB2BReferenceSpectralSpecBuilderBase
implements DGCReferenceB2BSpectralSpecBuilderFactory.DGCReferenceB2BBuilderInterface {
    public ACADGCB2BReferenceSpectralSpecBuilder(@NonNull Optional<SBGenerationContext> optional) {
        super(optional);
        if (optional == null) {
            throw new NullPointerException("sbGenerationContext is marked non-null but is null");
        }
    }

    @Override
    public void mergeSpectralSpecs(@NonNull SpectralSpec spectralSpec, @NonNull SpectralSpec spectralSpec2) {
        if (spectralSpec == null) {
            throw new NullPointerException("dgcReferenceSpectralSpec is marked non-null but is null");
        }
        if (spectralSpec2 == null) {
            throw new NullPointerException("scienceSpectralSpec is marked non-null but is null");
        }
        if (spectralSpec.getBaseBandConfigCount() != 4) {
            throw new WizardSBGenerationException("Expecting 4 basebands in the dgcReferenceSpectralSpec: " + spectralSpec.getBaseBandCount() + " were found");
        }
        int n = spectralSpec2.getBaseBandConfigCount();
        int n2 = 0;
        for (AbstractBaseBandConfig abstractBaseBandConfig : spectralSpec.getBaseBandConfig()) {
            ACABaseBandConfig aCABaseBandConfig = (ACABaseBandConfig)((Object)abstractBaseBandConfig);
            if (n2 < n) {
                BLBaseBandConfig bLBaseBandConfig = (BLBaseBandConfig)((Object)spectralSpec2.getBaseBandConfig(n2));
                aCABaseBandConfig.clearACASpectralWindow();
                Stream.of(bLBaseBandConfig.getBLSpectralWindow()).forEach(bLSpectralWindow -> aCABaseBandConfig.addSpectralWindow(bLSpectralWindow.deepCopy()));
            }
            ++n2;
        }
    }
}

