/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.sbbuilder;

import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.observatorycharacteristics.sbconfiguration.AlmaSBConfiguration;
import alma.obsprep.bo.obsproject.CalibrationSetupParameters;
import alma.obsprep.bo.obsproject.CalibrationTargetParameters;
import alma.obsprep.bo.obsproject.QuerySource;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.schedblock.FrequencySetup;
import alma.obsprep.bo.schedblock.ObservingGroup;
import alma.obsprep.bo.schedblock.OrderedTarget;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.services.experts.Configuration;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.MinTuningsCalculator;
import alma.obsprep.services.generator.refactored.ObsType;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.SchedBlockConsolidator;
import alma.obsprep.services.generator.refactored.SchedBlockWorker;
import alma.obsprep.services.generator.refactored.ScienceGoalSchedBlockGenerator;
import alma.obsprep.services.generator.refactored.intermediatetarget.IntermediateTarget;
import alma.obsprep.services.generator.refactored.intermediatetarget.IntermediateTargetFactory;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerationContext;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGeneratorTemplate;
import alma.valuetypes.Angle;
import alma.valuetypes.SkyCoordinates;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import lombok.NonNull;

public class TotalPowerSBGenerator
extends SBGeneratorTemplate {
    public static final int SINGLE_TUNING = 1;
    public static final double TP_BEAMWIDTH_SCALING_FACTOR = 1.0;
    private static final Collection<ReceiverBand> BANDS_REQUIRING_FOCUS_CAL = ImmutableList.of();
    private static final Collection<ObsType> SCIENCE_SB_CALIBRATIONS;
    private static final Collection<ObsType> CALIBRATION_SB_CALIBRATIONS;

    public TotalPowerSBGenerator() {
        super(RequestedArray.TP);
    }

    @Override
    public Collection<Collection<SchedBlock>> getSchedBlocks(@NonNull ScienceGoal scienceGoal) {
        EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet;
        if (scienceGoal == null) {
            throw new NullPointerException("clusteredSG is marked non-null but is null");
        }
        if (scienceGoal.isSpectralScan()) {
            throw new WizardSBGenerationException("SB generation for the ACA TP array with spectral scans is an invalid configuration");
        }
        try {
            this.antennaRelatedTOSTimeMultiplier = this.getAntennaMultiplier(scienceGoal);
            this.sbContext.setAntennaRelatedTOSTimeMultiplier(this.antennaRelatedTOSTimeMultiplier);
        }
        catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
            throw new WizardSBGenerationException("Unable to determine the array multiplier" + invalidObsProgramParametersException.getMessage());
        }
        try {
            enumSet = TotalPowerSBGenerator.determineSBGenerationSchema(scienceGoal, RequestedArray.TP.getType());
        }
        catch (UnknownEntityException unknownEntityException) {
            throw new WizardSBGenerationException("Unable to determine SB generation schema");
        }
        ArrayList<Collection<SchedBlock>> arrayList = new ArrayList<Collection<SchedBlock>>();
        ArrayList<SchedBlock> arrayList2 = new ArrayList<SchedBlock>();
        ArrayList<SchedBlock> arrayList3 = new ArrayList<SchedBlock>();
        this.parentScienceGoal = scienceGoal;
        this.sbContext.setSBGenerationSchema(enumSet).setScienceGoal(scienceGoal);
        List<Integer> list = AlmaSBConfiguration.getInstance().getTpAmpCalBands();
        int n = scienceGoal.getSpectralSetupParameters().getReceiverBand().getNumber();
        if (list.stream().anyMatch(n2 -> n2 == n)) {
            this.generateTPAmpCalSB(scienceGoal, enumSet, arrayList3);
        }
        SchedBlock schedBlock = this.createTPScienceSB(scienceGoal, enumSet, arrayList2);
        arrayList.add(arrayList3);
        arrayList.add(arrayList2);
        this.setObservingGroupDopplerTarget(schedBlock);
        return arrayList;
    }

    private SchedBlock createTPScienceSB(@NonNull ScienceGoal scienceGoal, @NonNull EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet, @NonNull Collection<SchedBlock> collection) {
        if (scienceGoal == null) {
            throw new NullPointerException("clusteredSG is marked non-null but is null");
        }
        if (enumSet == null) {
            throw new NullPointerException("schemaToUseForSBGeneration is marked non-null but is null");
        }
        if (collection == null) {
            throw new NullPointerException("memberOUS is marked non-null but is null");
        }
        this.sbContext.setSBType(SBGeneratorTemplate.SchedBlockType.TPSCIENCE);
        List<ScienceGoal> list = null;
        try {
            list = ScienceGoalSchedBlockGenerator.splitByTuning(scienceGoal);
            if (list.isEmpty()) {
                throw new WizardSBGenerationException("Unable to determine tunings - is the spectral setup valid?");
            }
        }
        catch (MinTuningsCalculator.UnableToCalculateMinNumberOfTunings | IndexOutOfBoundsException exception) {
            Log.logger(this.getClass()).warning("Unable to split the science goal up into distinct tunings");
            throw new WizardSBGenerationException(exception);
        }
        assert (list != null);
        ArrayList<IntermediateTarget> arrayList = new ArrayList();
        if (list.size() == 1) {
            arrayList = this.getScienceIntermediateTargets(scienceGoal, 1, enumSet);
            arrayList.addAll(this.getCalibrationIntermediateTargets(scienceGoal, SCIENCE_SB_CALIBRATIONS, 1, enumSet, this.sbContext, false));
            this.sortTargets(arrayList);
        } else {
            int n = 1;
            for (ScienceGoal scienceGoal2 : list) {
                arrayList.addAll(this.getCalibrationIntermediateTargets(scienceGoal, SCIENCE_SB_CALIBRATIONS, n, enumSet, this.sbContext, false));
                arrayList.addAll(this.getScienceIntermediateTargets(scienceGoal2, n, enumSet));
                ++n;
            }
            this.sortTargets(arrayList);
        }
        SchedBlock schedBlock = this.assembleTPScienceSB(scienceGoal, arrayList, enumSet, this.antennaRelatedTOSTimeMultiplier, this.sbContext.getSBType());
        schedBlock.setName(schedBlock.getName() + " - Science");
        collection.add(schedBlock);
        return schedBlock;
    }

    private void generateTPAmpCalSB(ScienceGoal scienceGoal, EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet, Collection<SchedBlock> collection) {
        this.sbContext.setSBType(SBGeneratorTemplate.SchedBlockType.TPAMPCAL);
        List<IntermediateTarget> list = this.getCalibrationIntermediateTargets(scienceGoal, CALIBRATION_SB_CALIBRATIONS, 1, enumSet, this.sbContext, true);
        SchedBlock schedBlock = this.assembleTPScienceSB(scienceGoal, list, enumSet, this.antennaRelatedTOSTimeMultiplier, this.sbContext.getSBType());
        schedBlock.setName(schedBlock.getName() + " - Amp Cal");
        collection.add(schedBlock);
        try {
            this.setObservingGroupDopplerTarget(schedBlock);
        }
        catch (WizardSBGenerationException wizardSBGenerationException) {
            // empty catch block
        }
        for (Target target : schedBlock.getTarget()) {
            if (!target.hasDelayCalParameters()) continue;
            target.getSpectralSpec().getFrequencySetup().setDopplerReference(FrequencySetup.DOPPLERREFERENCE_TOPO);
        }
    }

    private SchedBlock assembleTPScienceSB(@NonNull ScienceGoal scienceGoal, @NonNull List<IntermediateTarget> list, @NonNull EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet, double d, @NonNull SBGeneratorTemplate.SchedBlockType schedBlockType) {
        if (scienceGoal == null) {
            throw new NullPointerException("goal is marked non-null but is null");
        }
        if (list == null) {
            throw new NullPointerException("intermediateTargets is marked non-null but is null");
        }
        if (enumSet == null) {
            throw new NullPointerException("sbGenerationSchema is marked non-null but is null");
        }
        if (schedBlockType == null) {
            throw new NullPointerException("schedBlockType is marked non-null but is null");
        }
        assert (d > 0.0);
        SchedBlock schedBlock = SchedBlock.createSchedBlock();
        Target target = null;
        this.sbContext.setScienceGoal(scienceGoal).setSBGenerationSchema(enumSet).setSBType(schedBlockType).setSB(schedBlock).setAntennaRelatedTOSTimeMultiplier(d);
        schedBlock.setSbGenerationContext(this.sbContext.deepCopy());
        this.getObservingGroup(schedBlock, "Calibrators 1");
        for (IntermediateTarget intermediateTarget : list) {
            for (Target target2 : intermediateTarget.getTargets()) {
                this.addTargetToSchedBlock(schedBlock, target2);
            }
            for (OrderedTarget orderedTarget : intermediateTarget.getOrderedTargets()) {
                ObservingGroup observingGroup = this.getObservingGroup(schedBlock, orderedTarget.getTarget());
                orderedTarget.setIndex(observingGroup.getOrderedTargetCount() + 1);
                observingGroup.addOrderedTarget(orderedTarget);
            }
            target = intermediateTarget.getRepresentativeTarget();
            if (target == null) continue;
            this.setRepresentativeTarget(schedBlock, target);
        }
        SchedBlockWorker.setupSchedBlock(scienceGoal, schedBlock, this.array, d, enumSet);
        SchedBlockConsolidator.consolidate(schedBlock);
        SchedBlockWorker.renameMultipleTuningObservingGroups(schedBlock, enumSet);
        return schedBlock;
    }

    protected List<IntermediateTarget> getScienceIntermediateTargets(@NonNull ScienceGoal scienceGoal, int n, @NonNull EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet) {
        if (scienceGoal == null) {
            throw new NullPointerException("goal is marked non-null but is null");
        }
        if (enumSet == null) {
            throw new NullPointerException("sbGenerationSchema is marked non-null but is null");
        }
        ArrayList<IntermediateTarget> arrayList = new ArrayList<IntermediateTarget>();
        for (TargetParameters targetParameters : scienceGoal.getTargetParameters()) {
            arrayList.addAll(IntermediateTargetFactory.getIntermediateTarget(scienceGoal, targetParameters, scienceGoal.getSpectralSetupParameters(), this.array, this.getObservingGroupManager(), n, this.sbContext));
        }
        this.sortTargets(arrayList);
        return arrayList;
    }

    protected List<IntermediateTarget> getCalibrationIntermediateTargets(ScienceGoal scienceGoal, Collection<ObsType> collection, Integer n, EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet, SBGenerationContext sBGenerationContext, boolean bl) {
        ArrayList<IntermediateTarget> arrayList = new ArrayList<IntermediateTarget>();
        CalibrationSetupParameters calibrationSetupParameters = scienceGoal.getCalibrationSetupParameters();
        if (calibrationSetupParameters.isSystemDefinedCalibration() || calibrationSetupParameters.isAmplitudeSpecificSystemDefinedCalibration()) {
            arrayList.addAll(this.getSystemCalIntermediateTargets(scienceGoal, collection, n, enumSet, sBGenerationContext));
        } else {
            arrayList.addAll(this.getManualCalIntermediateTargets(scienceGoal, collection, n, enumSet, bl));
        }
        this.sortTargets(arrayList);
        return arrayList;
    }

    protected List<IntermediateTarget> getManualCalIntermediateTargets(ScienceGoal scienceGoal, Collection<ObsType> collection, Integer n, EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet, boolean bl) {
        ArrayList<IntermediateTarget> arrayList = new ArrayList<IntermediateTarget>();
        QuerySource querySource = QuerySource.createQuerySource(QuerySource.INTENDEDUSE_POINTING);
        SkyCoordinates skyCoordinates = scienceGoal.getKeyTargetParameters().getSourceCoordinates().getJ2000SkyCoordinates();
        querySource.setSearchRadius(Angle.createAngle((double)20.0, (String)Angle.UNIT_DEG));
        querySource.setQueryCenter(skyCoordinates.deepCopy());
        querySource.setMaxSources(40);
        arrayList.addAll(IntermediateTargetFactory.getIntermediateTarget(this.parentScienceGoal, querySource, scienceGoal.getSpectralSetupParameters(), this.array, this.getObservingGroupManager(), n, this.sbContext));
        CalibrationSetupParameters calibrationSetupParameters = scienceGoal.getCalibrationSetupParameters();
        boolean bl2 = false;
        for (CalibrationTargetParameters calibrationTargetParameters : calibrationSetupParameters.getCalibrationTargetParameters()) {
            if (!collection.contains((Object)calibrationTargetParameters.getObsType())) continue;
            if (calibrationTargetParameters.getObsType().equals((Object)ObsType.AMPLITUDE)) {
                bl2 = true;
            }
            if (calibrationTargetParameters.getObsType().equals((Object)ObsType.POINTING)) continue;
            arrayList.addAll(IntermediateTargetFactory.getIntermediateTarget(this.parentScienceGoal, calibrationTargetParameters, scienceGoal.getSpectralSetupParameters(), this.array, this.getObservingGroupManager(), n, this.sbContext));
        }
        for (QuerySource querySource2 : calibrationSetupParameters.getQuerySource()) {
            if (!collection.contains((Object)querySource2.getObsType())) continue;
            if (querySource2.getObsType().equals((Object)ObsType.AMPLITUDE)) {
                bl2 = true;
            }
            if (querySource2.getObsType().equals((Object)ObsType.POINTING)) continue;
            arrayList.addAll(IntermediateTargetFactory.getIntermediateTarget(this.parentScienceGoal, querySource2, scienceGoal.getSpectralSetupParameters(), this.array, this.getObservingGroupManager(), n, this.sbContext));
        }
        if (!bl2 && bl) {
            QuerySource querySource3 = QuerySource.createQuerySource(QuerySource.INTENDEDUSE_AMPLITUDE);
            querySource3.setQueryCenter(scienceGoal.getKeyTargetParameters().getSourceCoordinates().getJ2000SkyCoordinates());
            querySource3.setMaxSources(40);
            arrayList.addAll(IntermediateTargetFactory.getIntermediateTarget(this.parentScienceGoal, querySource3, scienceGoal.getSpectralSetupParameters(), this.array, this.getObservingGroupManager(), n, this.sbContext));
        }
        return arrayList;
    }

    protected List<IntermediateTarget> getSystemCalIntermediateTargets(@NonNull ScienceGoal scienceGoal, @NonNull Collection<ObsType> collection, int n, @NonNull EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet, SBGenerationContext sBGenerationContext) {
        if (scienceGoal == null) {
            throw new NullPointerException("goal is marked non-null but is null");
        }
        if (collection == null) {
            throw new NullPointerException("systemIntents is marked non-null but is null");
        }
        if (enumSet == null) {
            throw new NullPointerException("sbGenerationSchema is marked non-null but is null");
        }
        ArrayList<IntermediateTarget> arrayList = new ArrayList<IntermediateTarget>();
        SkyCoordinates skyCoordinates = scienceGoal.getKeyTargetParameters().getSourceCoordinates().getJ2000SkyCoordinates();
        SpectralSetupParameters spectralSetupParameters = scienceGoal.getSpectralSetupParameters();
        for (ObsType obsType : TotalPowerSBGenerator.getCalibrations(spectralSetupParameters, collection)) {
            QuerySource querySource;
            block12: {
                block11: {
                    querySource = QuerySource.createQuerySource(obsType.getCalIntent());
                    querySource.setKeyTargetParameters(scienceGoal.getKeyTargetParameters());
                    if (obsType.equals((Object)ObsType.DELAY) || obsType.equals((Object)ObsType.FOCUS)) {
                        querySource.setSearchRadius(Angle.createAngle((double)45.0, (String)Angle.UNIT_DEG));
                    } else {
                        querySource.setSearchRadius(Angle.createAngle((double)20.0, (String)Angle.UNIT_DEG));
                    }
                    if (!SBGeneratorTemplate.SchedBlockType.TPAMPCAL.equals((Object)sBGenerationContext.getSBType())) break block11;
                    switch (obsType) {
                        case DELAY: 
                        case FOCUS: 
                        case POINTING: 
                        case AMPLITUDE: {
                            querySource.setQueryCenter(SkyCoordinates.createSkyCoordinates());
                            break block12;
                        }
                        default: {
                            throw new WizardSBGenerationException("Unable to determine which sky coordinates to use for intent: it's not been defined");
                        }
                    }
                }
                querySource.setQueryCenter(skyCoordinates.deepCopy());
            }
            querySource.setMaxSources(40);
            arrayList.addAll(IntermediateTargetFactory.getIntermediateTarget(this.parentScienceGoal, querySource, spectralSetupParameters, this.array, this.getObservingGroupManager(), n, sBGenerationContext));
            for (IntermediateTarget intermediateTarget : arrayList) {
                for (Target target : intermediateTarget.getTargets()) {
                    if (!target.hasCheckSourceCalParameters() && !target.hasDelayCalParameters() && !target.hasPointingCalParameters() && !target.hasFocusCalParameters()) continue;
                    target.getFieldSource().clearReference();
                }
            }
        }
        return arrayList;
    }

    private static Collection<ObsType> getCalibrations(@NonNull SpectralSetupParameters spectralSetupParameters, @NonNull Collection<ObsType> collection) {
        if (spectralSetupParameters == null) {
            throw new NullPointerException("ssp is marked non-null but is null");
        }
        if (collection == null) {
            throw new NullPointerException("systemIntents is marked non-null but is null");
        }
        ArrayList<ObsType> arrayList = new ArrayList<ObsType>();
        arrayList.addAll(collection);
        if (BANDS_REQUIRING_FOCUS_CAL.contains(spectralSetupParameters.getReceiverBand())) {
            arrayList.add(ObsType.FOCUS);
        }
        return arrayList;
    }

    @Override
    protected List<IntermediateTarget> getManualCalIntermediateTargets(ScienceGoal scienceGoal, Integer n, EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected List<IntermediateTarget> getSystemCalIntermediateTargets(ScienceGoal scienceGoal, Integer n, EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getAntennaMultiplier(ScienceGoal scienceGoal) throws InvalidObsProgramParametersException {
        return Configuration.getArrayTimeMultiplier(Configuration.MultiplierEnumType.ACATP, scienceGoal);
    }

    @Override
    protected List<IntermediateTarget> getAmpCalInclusiveSystemCalIntermediateTargets(ScienceGoal scienceGoal, Integer n, EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet) {
        throw new UnsupportedOperationException();
    }

    static {
        CALIBRATION_SB_CALIBRATIONS = ImmutableList.of((Object)((Object)ObsType.POINTING), (Object)((Object)ObsType.AMPLITUDE));
        SCIENCE_SB_CALIBRATIONS = ImmutableList.of((Object)((Object)ObsType.POINTING));
    }
}

