/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.sbbuilder;

import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.observatorycharacteristics.capabilities.AlmaCapabilities;
import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.services.experts.Configuration;
import alma.obsprep.services.experts.InvalidConfigurationParametersException;
import alma.obsprep.services.experts.SchedBlockExpert;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.sbbuilder.ACASBGenerator;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerator;
import alma.obsprep.services.generator.refactored.sbbuilder.TotalPowerSBGenerator;
import alma.obsprep.services.generator.refactored.sbbuilder.TwelveMetreCompactConfigurationSBGenerator;
import alma.obsprep.services.generator.refactored.sbbuilder.TwelveMetreExtendedConfigurationSBGenerator;
import alma.valuetypes.Time;
import java.util.ArrayList;
import java.util.Collection;
import lombok.NonNull;

public class SBGeneratorFactory {
    public static final Time SPECTRAL_SCAN_MULTIPLE_SB_THRESHOLD_TIME = Time.createTime((double)30.0, (String)Time.UNIT_MIN);

    public static Collection<SBGenerator> getBuilders(@NonNull ScienceGoal scienceGoal) throws InvalidObsProgramParametersException, InvalidConfigurationParametersException, UnknownEntityException {
        if (scienceGoal == null) {
            throw new NullPointerException("clusteredSG is marked non-null but is null");
        }
        ArrayList<SBGenerator> arrayList = new ArrayList<SBGenerator>();
        for (RequestedArray requestedArray : SBGeneratorFactory.getArraysForWhichSBsAreToBeGenerated(scienceGoal)) {
            AlmaCapabilities almaCapabilities = AlmaCapabilities.getInstance();
            SpectralSetupParameters spectralSetupParameters = scienceGoal.getSpectralSetupParameters();
            switch (requestedArray) {
                case TWELVE_M: {
                    if (scienceGoal.isStandAloneACA() || almaCapabilities.getNumAntennas(Array.ARRAY_12M, spectralSetupParameters) < 2) break;
                    arrayList.add(new TwelveMetreExtendedConfigurationSBGenerator(scienceGoal));
                    if (scienceGoal.getNumberOf12mConfigurations() <= 1) break;
                    double d = Configuration.getArrayTimeMultiplier(Configuration.MultiplierEnumType.COMPACT12M, scienceGoal);
                    arrayList.add(new TwelveMetreCompactConfigurationSBGenerator(scienceGoal, d));
                    break;
                }
                case ACA: {
                    if (almaCapabilities.getNumAntennas(Array.ARRAY_7M, spectralSetupParameters) < 2) break;
                    arrayList.add(new ACASBGenerator());
                    break;
                }
                case TP: {
                    if (almaCapabilities.getNumAntennas(Array.ARRAY_TP, spectralSetupParameters) < 2) break;
                    arrayList.add(new TotalPowerSBGenerator());
                }
            }
        }
        return arrayList;
    }

    private static Collection<RequestedArray> getArraysForWhichSBsAreToBeGenerated(@NonNull ScienceGoal scienceGoal) throws UnknownEntityException {
        if (scienceGoal == null) {
            throw new NullPointerException("goal is marked non-null but is null");
        }
        ArrayList<RequestedArray> arrayList = new ArrayList<RequestedArray>();
        arrayList.add(RequestedArray.TWELVE_M);
        boolean bl = scienceGoal.getPerformanceParameters().getUseACA();
        if (bl && !scienceGoal.isSolarScienceGoal()) {
            arrayList.add(RequestedArray.ACA);
        }
        SchedBlockExpert schedBlockExpert = SchedBlockExpert.getInstance(scienceGoal);
        if (bl && schedBlockExpert.getUseTPArray()) {
            arrayList.add(RequestedArray.TP);
        }
        return arrayList;
    }
}

