/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.obsparams;

import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetWithIntent;
import alma.obsprep.bo.schedblock.AmplitudeCalParameters;
import alma.obsprep.bo.schedblock.AtmosphericCalParameters;
import alma.obsprep.bo.schedblock.BandpassCalParameters;
import alma.obsprep.bo.schedblock.CalibratorParameters;
import alma.obsprep.bo.schedblock.CheckSourceCalParameters;
import alma.obsprep.bo.schedblock.DGCReferenceCalParameters;
import alma.obsprep.bo.schedblock.DGCScienceCalParameters;
import alma.obsprep.bo.schedblock.DelayCalParameters;
import alma.obsprep.bo.schedblock.FocusCalParameters;
import alma.obsprep.bo.schedblock.ObservingParameters;
import alma.obsprep.bo.schedblock.PhaseCalParameters;
import alma.obsprep.bo.schedblock.PointingCalParameters;
import alma.obsprep.bo.schedblock.PolarizationCalParameters;
import alma.obsprep.bo.schedblock.ScienceParameters;
import alma.obsprep.bo.schedblock.SidebandRatioCalParameters;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.services.calibration.CalTimeCalculator;
import alma.obsprep.services.calibration.CalTimeDataAdapter;
import alma.obsprep.services.etc.SourceNeverVisibleException;
import alma.obsprep.services.experts.CorrelatorExpert;
import alma.obsprep.services.experts.InvalidFrequencyException;
import alma.obsprep.services.generator.refactored.ObsType;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.obsparams.ACAAmplitudeTimer;
import alma.obsprep.services.generator.refactored.obsparams.ACAAtmosphericTimer;
import alma.obsprep.services.generator.refactored.obsparams.ACABandpassTimer;
import alma.obsprep.services.generator.refactored.obsparams.ACAPhaseTimer;
import alma.obsprep.services.generator.refactored.obsparams.ACAPointingTimer;
import alma.obsprep.services.generator.refactored.obsparams.ACAPolarizationTimer;
import alma.obsprep.services.generator.refactored.obsparams.BLAmplitudeTimer;
import alma.obsprep.services.generator.refactored.obsparams.BLAtmosphericTimer;
import alma.obsprep.services.generator.refactored.obsparams.BLBandpassTimer;
import alma.obsprep.services.generator.refactored.obsparams.BLPhaseTimer;
import alma.obsprep.services.generator.refactored.obsparams.BLPointingTimer;
import alma.obsprep.services.generator.refactored.obsparams.BLPolarizationTimer;
import alma.obsprep.services.generator.refactored.obsparams.CalibrationTimerInterface;
import alma.obsprep.services.generator.refactored.obsparams.ConfigurationDrivenPhaseTimer;
import alma.obsprep.services.generator.refactored.obsparams.ObservingParametersFactory;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerationContext;
import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import alma.valuetypes.Time;
import alma.valuetypes.UserAngle;
import lombok.NonNull;

public abstract class AbstractObservingParametersFactory
implements ObservingParametersFactory {
    public static final int NONHARMONIC_SWITCHING_INTERNAL_CYCLE_COUNT = 3;
    public static final int HARMONIC_SWITCHING_INTERNAL_CYCLE_COUNT = 5;
    protected final CorrelatorExpert correlatorExpert;
    protected final Time integrationTime;
    protected final SpectralSpec spectralSpec;
    protected final TargetWithIntent target;
    protected final RequestedArray array;
    protected ScienceGoal goal = null;
    protected SBGenerationContext sbContext;

    protected AbstractObservingParametersFactory(@NonNull ScienceGoal scienceGoal, SpectralSpec spectralSpec, TargetWithIntent targetWithIntent, RequestedArray requestedArray, @NonNull SBGenerationContext sBGenerationContext) {
        if (scienceGoal == null) {
            throw new NullPointerException("goal is marked non-null but is null");
        }
        if (sBGenerationContext == null) {
            throw new NullPointerException("sbContext is marked non-null but is null");
        }
        this.sbContext = sBGenerationContext;
        this.goal = scienceGoal;
        this.spectralSpec = spectralSpec;
        this.correlatorExpert = spectralSpec.getCorrelatorExpert();
        this.integrationTime = this.spectralSpec.getCorrelatorConfiguration().getIntegrationDuration();
        this.array = requestedArray;
        this.target = targetWithIntent;
    }

    protected AbstractObservingParametersFactory(SpectralSpec spectralSpec, TargetWithIntent targetWithIntent, RequestedArray requestedArray, SBGenerationContext sBGenerationContext) {
        this.spectralSpec = spectralSpec;
        this.correlatorExpert = spectralSpec.getCorrelatorExpert();
        this.integrationTime = this.spectralSpec.getCorrelatorConfiguration().getIntegrationDuration();
        this.array = requestedArray;
        this.sbContext = sBGenerationContext;
        this.target = targetWithIntent;
    }

    protected AmplitudeCalParameters getAmplitudeCalParameters(int n) {
        AmplitudeCalParameters amplitudeCalParameters = AmplitudeCalParameters.createAmplitudeCalParameters();
        amplitudeCalParameters.setName("");
        CalibrationTimerInterface calibrationTimerInterface = CalibrationTimerFactory.getCalibrationTimer(this.goal, this.spectralSpec, ObsType.AMPLITUDE, this.array, this.sbContext);
        amplitudeCalParameters.setDefaultIntegrationTime(calibrationTimerInterface.getDefaultIntegrationTime());
        amplitudeCalParameters.setSubScanDuration(calibrationTimerInterface.getScanDuration(calibrationTimerInterface.getDefaultIntegrationTime()));
        amplitudeCalParameters.setCycleTime(calibrationTimerInterface.getCycleTime());
        this.setMissingParameters((CalibratorParameters)((Object)amplitudeCalParameters));
        return amplitudeCalParameters;
    }

    protected ScienceParameters getTPAmplitudeCalParameters(SpectralSetupParameters spectralSetupParameters) {
        ScienceParameters scienceParameters = this.getScienceParameters(spectralSetupParameters);
        scienceParameters.getIntegrationTime().setContentAndUnit((ValueUnitPair)this.getIntegrationTime());
        return scienceParameters;
    }

    protected AtmosphericCalParameters getAtmosphericCalParameters(int n) {
        AtmosphericCalParameters atmosphericCalParameters = AtmosphericCalParameters.createAtmosphericCalParameters();
        CalibrationTimerInterface calibrationTimerInterface = CalibrationTimerFactory.getCalibrationTimer(this.goal, this.spectralSpec, ObsType.ATMOSPHERIC, this.array, this.sbContext);
        atmosphericCalParameters.setDefaultIntegrationTime(this.getIntegrationTime());
        atmosphericCalParameters.setCycleTime(calibrationTimerInterface.getCycleTime());
        atmosphericCalParameters.setUseHotLoad(true);
        double d = atmosphericCalParameters.getDefaultIntegrationTime().getContentInUnits(Time.UNIT_S);
        double d2 = this.integrationTime.getContentInUnits(Time.UNIT_S);
        double d3 = this.correlatorExpert.calcSubscanDuration(d, d2, 4);
        atmosphericCalParameters.setSubScanDuration(Time.createTime((double)d3, (String)Time.UNIT_S));
        this.setMissingParameters((CalibratorParameters)((Object)atmosphericCalParameters));
        return atmosphericCalParameters;
    }

    protected BandpassCalParameters getBandpassCalParameters(int n) {
        BandpassCalParameters bandpassCalParameters = BandpassCalParameters.createBandpassCalParameters();
        bandpassCalParameters.setDataOrigin(BandpassCalParameters.DATAORIGIN_FULL_RESOLUTION_CROSS);
        CalibrationTimerInterface calibrationTimerInterface = CalibrationTimerFactory.getCalibrationTimer(this.goal, this.spectralSpec, ObsType.BANDPASS, this.array, this.sbContext);
        bandpassCalParameters.setDefaultIntegrationTime(calibrationTimerInterface.getDefaultIntegrationTime());
        bandpassCalParameters.setSubScanDuration(calibrationTimerInterface.getScanDuration(calibrationTimerInterface.getDefaultIntegrationTime()));
        bandpassCalParameters.setCycleTime(calibrationTimerInterface.getCycleTime());
        bandpassCalParameters.setDesiredPhaseAccuracy(Angle.createAngle((double)1.0, (String)Angle.UNIT_ARCSEC));
        bandpassCalParameters.setMaximumElapsedTime(Time.createTime((double)99999.0, (String)Time.UNIT_H));
        bandpassCalParameters.setDesiredAmplitudeAccuracy(5.0);
        this.setMissingParameters((CalibratorParameters)((Object)bandpassCalParameters));
        return bandpassCalParameters;
    }

    @Override
    public ObservingParameters getObservingParameters(ObsType obsType, int n, SpectralSetupParameters spectralSetupParameters, SpectralSpec spectralSpec, SBGenerationContext sBGenerationContext) {
        switch (obsType) {
            case AMPLITUDE: {
                if (RequestedArray.TP.equals((Object)this.array)) {
                    return this.getTPAmplitudeCalParameters(spectralSetupParameters);
                }
                return this.getAmplitudeCalParameters(n);
            }
            case ATMOSPHERIC: {
                return this.getAtmosphericCalParameters(n);
            }
            case BANDPASS: {
                return this.getBandpassCalParameters(n);
            }
            case DELAY: {
                if (RequestedArray.TP.equals((Object)this.array)) {
                    return this.getTPDelayCalParameters();
                }
                return this.getDelayCalParameters(n);
            }
            case CHECKSOURCE: {
                return this.getCheckSourceCalParameters(n);
            }
            case FOCUS: {
                if (RequestedArray.TP.equals((Object)this.array)) {
                    return this.getTPFocusCalParameters();
                }
                return this.getFocusCalParameters(n);
            }
            case PHASE: {
                return this.getPhaseCalParameters(this.goal, spectralSpec);
            }
            case POINTING: {
                return this.getPointingCalParameters(n);
            }
            case SIDEBANDRATIO: {
                return this.getSidebandRatioCalParameters(n);
            }
            case POLARIZATION: {
                return this.getPolarizationCalParameters(n);
            }
            case SCIENCE: {
                return this.getScienceParameters(spectralSetupParameters);
            }
            case DGCREFERENCE: {
                return this.getDGCReferenceParameters();
            }
            case DGCSCIENCE: {
                return this.getDGCScienceParameters();
            }
        }
        throw new AssertionError((Object)("Unhandled observing intent: " + obsType));
    }

    private ObservingParameters getDGCScienceParameters() {
        DGCScienceCalParameters dGCScienceCalParameters = DGCScienceCalParameters.createDGCScienceCalParameters();
        dGCScienceCalParameters.setDefaultIntegrationTime(Time.createTimeSec(24.0));
        dGCScienceCalParameters.setSubScanDuration(this.getAlignedSubscanDuration(24.0));
        dGCScienceCalParameters.setInternalCycleCount(3);
        dGCScienceCalParameters.setExternalCycleTime(Time.createTimeMin(360.0));
        this.setMissingParameters((CalibratorParameters)((Object)dGCScienceCalParameters));
        return dGCScienceCalParameters;
    }

    private ObservingParameters getDGCReferenceParameters() {
        DGCReferenceCalParameters dGCReferenceCalParameters = DGCReferenceCalParameters.createDGCReferenceCalParameters();
        dGCReferenceCalParameters.setDefaultIntegrationTime(Time.createTimeSec(12.0));
        dGCReferenceCalParameters.setSubScanDuration(this.getAlignedSubscanDuration(12.0));
        this.setMissingParameters((CalibratorParameters)((Object)dGCReferenceCalParameters));
        return dGCReferenceCalParameters;
    }

    private ObservingParameters getTPFocusCalParameters() {
        FocusCalParameters focusCalParameters = FocusCalParameters.createFocusCalParameters();
        focusCalParameters.setDefaultIntegrationTime(Time.createTime((double)20.0, (String)Time.UNIT_S));
        focusCalParameters.setSubScanDuration(this.getAlignedSubscanDuration(15.0));
        this.setMissingParameters((CalibratorParameters)((Object)focusCalParameters));
        return focusCalParameters;
    }

    private ObservingParameters getTPDelayCalParameters() {
        DelayCalParameters delayCalParameters = DelayCalParameters.createDelayCalParameters();
        delayCalParameters.setDefaultIntegrationTime(Time.createTime((double)20.0, (String)Time.UNIT_S));
        delayCalParameters.setSubScanDuration(this.getAlignedSubscanDuration(15.0));
        this.setMissingParameters((CalibratorParameters)((Object)delayCalParameters));
        return delayCalParameters;
    }

    protected DelayCalParameters getDelayCalParameters(int n) {
        DelayCalParameters delayCalParameters = DelayCalParameters.createDelayCalParameters();
        delayCalParameters.setDefaultIntegrationTime(this.getIntegrationTime());
        delayCalParameters.setSubScanDuration(this.getAlignedSubscanDuration(30.0));
        delayCalParameters.setCycleTime(Time.createTime((double)4.0, (String)Time.UNIT_H));
        this.setMissingParameters((CalibratorParameters)((Object)delayCalParameters));
        return delayCalParameters;
    }

    protected CheckSourceCalParameters getCheckSourceCalParameters(int n) {
        CheckSourceCalParameters checkSourceCalParameters = CheckSourceCalParameters.createCheckSourceCalParameters();
        checkSourceCalParameters.setDefaultIntegrationTime(Time.createTimeSec(60.0));
        checkSourceCalParameters.setSubScanDuration(this.getAlignedSubscanDuration(Time.createTimeSec(60.48)));
        checkSourceCalParameters.setCycleTime(Time.createTime((double)4.0, (String)Time.UNIT_H));
        this.setMissingParameters((CalibratorParameters)((Object)checkSourceCalParameters));
        return checkSourceCalParameters;
    }

    protected FocusCalParameters getFocusCalParameters(int n) {
        FocusCalParameters focusCalParameters = FocusCalParameters.createFocusCalParameters();
        focusCalParameters.setDefaultIntegrationTime(this.getIntegrationTime());
        focusCalParameters.setSubScanDuration(this.getAlignedSubscanDuration(30.0));
        this.setMissingParameters((CalibratorParameters)((Object)focusCalParameters));
        return focusCalParameters;
    }

    protected PhaseCalParameters getPhaseCalParameters(ScienceGoal scienceGoal, SpectralSpec spectralSpec) {
        PhaseCalParameters phaseCalParameters = PhaseCalParameters.createPhaseCalParameters();
        phaseCalParameters.setName("");
        phaseCalParameters.setDataOrigin(CalibratorParameters.DATAORIGIN_CHANNEL_AVERAGE_CROSS);
        CalibrationTimerInterface calibrationTimerInterface = CalibrationTimerFactory.getCalibrationTimer(scienceGoal, this.spectralSpec, ObsType.PHASE, this.array, this.sbContext);
        phaseCalParameters.setDefaultIntegrationTime(calibrationTimerInterface.getDefaultIntegrationTime());
        phaseCalParameters.setSubScanDuration(calibrationTimerInterface.getScanDuration(calibrationTimerInterface.getDefaultIntegrationTime()));
        phaseCalParameters.setCycleTime(calibrationTimerInterface.getCycleTime());
        this.setMissingParameters((CalibratorParameters)((Object)phaseCalParameters));
        return phaseCalParameters;
    }

    protected PointingCalParameters getPointingCalParameters(int n) {
        PointingCalParameters pointingCalParameters = PointingCalParameters.createPointingCalParameters();
        pointingCalParameters.setDataOrigin(PointingCalParameters.DATAORIGIN_CHANNEL_AVERAGE_CROSS);
        pointingCalParameters.setMaximumElapsedTime(Time.createTime((double)99999.0, (String)Time.UNIT_H));
        Frequency frequency = this.spectralSpec.getRestFrequency();
        UserAngle userAngle = UserAngle.createUserAngle(0.5, UserAngle.USERUNIT_FRACTION_OF_MAIN_BEAM, frequency);
        Angle angle = Angle.createAngle((double)userAngle.getContentInUnits(Angle.UNIT_ARCSEC), (String)Angle.UNIT_ARCSEC);
        pointingCalParameters.setExcursion(angle);
        pointingCalParameters.setDesiredAccuracy(pointingCalParameters.getExcursion().deepCopy());
        CalibrationTimerInterface calibrationTimerInterface = CalibrationTimerFactory.getCalibrationTimer(this.goal, this.spectralSpec, ObsType.POINTING, this.array, this.sbContext);
        pointingCalParameters.setDefaultIntegrationTime(calibrationTimerInterface.getDefaultIntegrationTime());
        pointingCalParameters.setSubScanDuration(calibrationTimerInterface.getScanDuration(calibrationTimerInterface.getDefaultIntegrationTime()));
        pointingCalParameters.setCycleTime(calibrationTimerInterface.getCycleTime());
        return pointingCalParameters;
    }

    protected PolarizationCalParameters getPolarizationCalParameters(int n) {
        PolarizationCalParameters polarizationCalParameters = PolarizationCalParameters.createPolarizationCalParameters();
        polarizationCalParameters.setName("");
        CalibrationTimerInterface calibrationTimerInterface = CalibrationTimerFactory.getCalibrationTimer(this.goal, this.spectralSpec, ObsType.POLARIZATION, this.array, this.sbContext);
        polarizationCalParameters.setDefaultIntegrationTime(calibrationTimerInterface.getDefaultIntegrationTime());
        polarizationCalParameters.setSubScanDuration(calibrationTimerInterface.getScanDuration(calibrationTimerInterface.getDefaultIntegrationTime()));
        polarizationCalParameters.setCycleTime(calibrationTimerInterface.getCycleTime());
        this.setMissingParameters((CalibratorParameters)((Object)polarizationCalParameters));
        return polarizationCalParameters;
    }

    protected abstract ScienceParameters getScienceParameters(SpectralSetupParameters var1);

    protected SidebandRatioCalParameters getSidebandRatioCalParameters(int n) {
        SidebandRatioCalParameters sidebandRatioCalParameters = SidebandRatioCalParameters.createSidebandRatioCalParameters();
        sidebandRatioCalParameters.setDefaultIntegrationTime(this.getIntegrationTime());
        sidebandRatioCalParameters.setSubScanDuration(this.getAlignedSubscanDuration(10.0));
        this.setMissingParameters((CalibratorParameters)((Object)sidebandRatioCalParameters));
        return sidebandRatioCalParameters;
    }

    protected void setMissingParameters(CalibratorParameters calibratorParameters) {
        if (calibratorParameters.getDefaultIntegrationTime().getContent() == 0.0) {
            calibratorParameters.setDefaultIntegrationTime(this.integrationTime.deepCopy());
        }
        if (calibratorParameters.getSubScanDuration().getContent() == 0.0) {
            Time time = this.getAlignedSubscanDuration(calibratorParameters.getDefaultIntegrationTime());
            calibratorParameters.setSubScanDuration(time);
        }
        if (calibratorParameters.getCycleTime().getContent() == 0.0) {
            calibratorParameters.setCycleTime(Time.createTime((double)99999.0, (String)Time.UNIT_H));
        }
    }

    public Time getAlignedSubscanDuration(double d) {
        return this.getAlignedSubscanDuration(Time.createTimeSec(d));
    }

    protected Time getAlignedSubscanDuration(Time time) {
        double d = time.getContentInUnits(Time.UNIT_S);
        double d2 = this.integrationTime.getContentInUnits(Time.UNIT_S);
        double d3 = this.correlatorExpert.calcSubscanDuration(d, d2, null);
        return Time.createTime((double)d3, (String)Time.UNIT_S);
    }

    protected Time getIntegrationTime() {
        CalTimeDataAdapter calTimeDataAdapter = new CalTimeDataAdapter(this.spectralSpec, this.array, this.target);
        try {
            return this.clipCalTime(CalTimeCalculator.rawCalTime(calTimeDataAdapter), this.target.getObsType());
        }
        catch (SourceNeverVisibleException | InvalidFrequencyException exception) {
            return this.getFallbackIntegrationTime();
        }
    }

    private Time clipCalTime(Time time, ObsType obsType) {
        double d = time.getContentInUnits(Time.UNIT_S);
        switch (obsType) {
            case DELAY: 
            case PHASE: {
                double d2 = Math.min(d, 120.0);
                double d3 = Math.max(d2, 30.0);
                return Time.createTimeSec(d3);
            }
            case AMPLITUDE: {
                double d4 = Math.min(d, 240.0);
                double d5 = Math.max(d4, 120.0);
                return Time.createTimeSec(d5);
            }
            case BANDPASS: {
                double d6 = Math.min(d, 300.0);
                double d7 = Math.max(d6, 180.0);
                return Time.createTimeSec(d7);
            }
            case POINTING: {
                double d8 = Math.min(d, 120.0);
                double d9 = Math.max(d8, 10.0);
                return Time.createTimeSec(d9);
            }
        }
        return time;
    }

    private Time getFallbackIntegrationTime() {
        switch (this.target.getObsType()) {
            case AMPLITUDE: {
                return Time.createTimeSec(120.0);
            }
            case ATMOSPHERIC: {
                return Time.createTimeSec(4.0);
            }
            case BANDPASS: {
                return Time.createTimeSec(180.0);
            }
            case DELAY: {
                return Time.createTimeSec(60.0);
            }
            case PHASE: {
                return Time.createTimeSec(30.0);
            }
            case POINTING: {
                return Time.createTimeSec(10.0);
            }
        }
        return Time.createTimeSec(60.0);
    }

    public static class CalibrationTimerFactory {
        private CalibrationTimerFactory() {
        }

        public static CalibrationTimerInterface getCalibrationTimer(@NonNull ScienceGoal scienceGoal, @NonNull SpectralSpec spectralSpec, @NonNull ObsType obsType, RequestedArray requestedArray, SBGenerationContext sBGenerationContext) {
            if (scienceGoal == null) {
                throw new NullPointerException("scienceGoal is marked non-null but is null");
            }
            if (spectralSpec == null) {
                throw new NullPointerException("ss is marked non-null but is null");
            }
            if (obsType == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            switch (obsType) {
                case AMPLITUDE: {
                    return CalibrationTimerFactory.getAmplitudeCalibrationTimer(spectralSpec, sBGenerationContext);
                }
                case BANDPASS: {
                    return CalibrationTimerFactory.getBandpassCalibrationTimer(spectralSpec, sBGenerationContext);
                }
                case CHECKSOURCE: 
                case PHASE: {
                    return CalibrationTimerFactory.getPhaseCalibrationTimer(scienceGoal, spectralSpec, requestedArray, sBGenerationContext);
                }
                case POINTING: {
                    return CalibrationTimerFactory.getPointingCalibrationTimer(spectralSpec, sBGenerationContext);
                }
                case POLARIZATION: {
                    return CalibrationTimerFactory.getPolarizationCalibrationTimer(spectralSpec, sBGenerationContext);
                }
                case ATMOSPHERIC: {
                    return CalibrationTimerFactory.getAtmosphericCalibrationTimer(spectralSpec, sBGenerationContext);
                }
            }
            throw new IllegalArgumentException(obsType.getCalIntent() + " is not a handled type");
        }

        private static CalibrationTimerInterface getAtmosphericCalibrationTimer(SpectralSpec spectralSpec, SBGenerationContext sBGenerationContext) {
            if (spectralSpec.isBLSpectralSpec()) {
                return new BLAtmosphericTimer(spectralSpec, sBGenerationContext);
            }
            return new ACAAtmosphericTimer(spectralSpec, sBGenerationContext);
        }

        private static CalibrationTimerInterface getPolarizationCalibrationTimer(SpectralSpec spectralSpec, SBGenerationContext sBGenerationContext) {
            if (spectralSpec.isBLSpectralSpec()) {
                return new BLPolarizationTimer(spectralSpec, sBGenerationContext);
            }
            return new ACAPolarizationTimer(spectralSpec, sBGenerationContext);
        }

        private static CalibrationTimerInterface getAmplitudeCalibrationTimer(SpectralSpec spectralSpec, SBGenerationContext sBGenerationContext) {
            if (spectralSpec.isBLSpectralSpec()) {
                return new BLAmplitudeTimer(spectralSpec, sBGenerationContext);
            }
            return new ACAAmplitudeTimer(spectralSpec, sBGenerationContext);
        }

        private static CalibrationTimerInterface getBandpassCalibrationTimer(SpectralSpec spectralSpec, SBGenerationContext sBGenerationContext) {
            if (spectralSpec.isBLSpectralSpec()) {
                return new BLBandpassTimer(spectralSpec, sBGenerationContext);
            }
            return new ACABandpassTimer(spectralSpec, sBGenerationContext);
        }

        private static CalibrationTimerInterface getPhaseCalibrationTimer(ScienceGoal scienceGoal, SpectralSpec spectralSpec, RequestedArray requestedArray, SBGenerationContext sBGenerationContext) {
            if (requestedArray.isTM() && !sBGenerationContext.isVLBI()) {
                return new ConfigurationDrivenPhaseTimer(scienceGoal, spectralSpec, sBGenerationContext);
            }
            if (spectralSpec.isBLSpectralSpec()) {
                return new BLPhaseTimer(spectralSpec, sBGenerationContext);
            }
            return new ACAPhaseTimer(spectralSpec, sBGenerationContext);
        }

        private static CalibrationTimerInterface getPointingCalibrationTimer(SpectralSpec spectralSpec, SBGenerationContext sBGenerationContext) {
            if (spectralSpec.isBLSpectralSpec()) {
                return new BLPointingTimer(spectralSpec, sBGenerationContext);
            }
            return new ACAPointingTimer(spectralSpec, sBGenerationContext);
        }
    }
}

