/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.intermediatetarget;

import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.SpectralScan;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetWithIntent;
import alma.obsprep.bo.obsproject.UnableToFindSolutionException;
import alma.obsprep.bo.schedblock.FieldPattern;
import alma.obsprep.bo.schedblock.OrderedTarget;
import alma.obsprep.bo.schedblock.RectanglePattern;
import alma.obsprep.bo.schedblock.ScienceParameters;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.services.experts.CorrelatorExpert;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.ObsType;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.intermediatetarget.AbstractIntermediateTarget;
import alma.obsprep.services.generator.refactored.intermediatetarget.ObservingGroupManager;
import alma.obsprep.services.generator.refactored.intermediatetarget.TPRasterData;
import alma.obsprep.services.generator.refactored.intermediatetarget.TPReferencePositionWorker;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerationContext;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGeneratorTemplate;
import alma.obsprep.services.generator.refactored.targetcreator.TargetCreator;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.Time;
import alma.valuetypes.data.SkyCoordinatesData;
import java.util.EnumSet;
import java.util.List;
import java.util.logging.Level;
import lombok.NonNull;

public class ScienceIntermediateTarget
extends AbstractIntermediateTarget {
    private Target representativeTarget = null;

    public ScienceIntermediateTarget(ScienceGoal scienceGoal, TargetWithIntent targetWithIntent, SpectralSetupParameters spectralSetupParameters, RequestedArray requestedArray, ObservingGroupManager observingGroupManager, Integer n, EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet, SBGenerationContext sBGenerationContext) {
        this.sbContext = sBGenerationContext;
        this.setObservingGroupManager(observingGroupManager);
        Target target = null;
        if (enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.SPECTRAL_SCAN) || enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.SPECTRAL_SCAN_MULTIPLE_SB)) {
            this.representativeTarget = this.addSpectralScanTunings(spectralSetupParameters, requestedArray, targetWithIntent, scienceGoal);
        } else {
            Integer n2 = enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.MULTIPLE_TUNING) ? observingGroupManager.getObservingGroupIndex(ObservingGroupManager.ObservingGroupType.SCIENCE, n) : observingGroupManager.getObservingGroupIndex(ObservingGroupManager.ObservingGroupType.SCIENCE, 1);
            target = TargetCreator.createTarget(scienceGoal, targetWithIntent, spectralSetupParameters, n2, sBGenerationContext);
            if (RequestedArray.TP.equals((Object)requestedArray)) {
                this.modifyTargetForTP(target, scienceGoal);
                TPReferencePositionWorker.setupReferencePosition(target);
            }
            this.targets.add(target);
            OrderedTarget orderedTarget = OrderedTarget.createOrderedTarget();
            orderedTarget.setTarget(target);
            this.orderedTargets.add(orderedTarget);
            ScienceGoal scienceGoal2 = spectralSetupParameters.getScienceGoal();
            this.representativeTarget = targetWithIntent == scienceGoal2.getKeyTargetParameters() ? target : null;
        }
    }

    private void modifyTargetForTP(@NonNull Target target, @NonNull ScienceGoal scienceGoal) {
        if (target == null) {
            throw new NullPointerException("scienceTarget is marked non-null but is null");
        }
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        ScienceParameters scienceParameters = target.getFirstScienceParameters().orElseThrow(() -> new WizardSBGenerationException("Unable to get first science parameters"));
        FieldPattern fieldPattern = target.getFieldSource().getFieldPattern();
        if (fieldPattern instanceof RectanglePattern) {
            Object object;
            Time time;
            Object object2;
            RectanglePattern rectanglePattern = (RectanglePattern)((Object)fieldPattern);
            Integer n = target.getSpectralSpec().getReceiverBand().getNumber();
            double d = AlmaPolicies.getInstance().getTpMaxTOSPerSB().getSecs();
            double d2 = CorrelatorExpert.TPCorrelatorConfiguratorHelper.getEstimatedSubscanDuration(n, ObsType.SCIENCE);
            Time time2 = target.getSpectralSpec().getAbstractCorrelatorConfiguration().getIntegrationDuration();
            double d3 = CorrelatorExpert.TPCorrelatorConfiguratorHelper.calcSubscanDuration(d2, time2.getContentInUnits(Time.UNIT_S));
            scienceParameters.setSubScanDuration(Time.createTime((double)d3, (String)Time.UNIT_S));
            double d4 = (double)rectanglePattern.getRowCount() * d3;
            double d5 = Math.floor(d / d4);
            try {
                object2 = new TPRasterData.Builder();
                if (scienceGoal.isSolarScienceGoal()) {
                    time = AlmaPolicies.getInstance().getItosForSolarSource();
                    ((TPRasterData.Builder)object2).n_rowcount(rectanglePattern.getRowCount()).t_osmax(Time.createTimeSec(d)).t_rect(time).isSolarTPSB(true).t_expectedTotalITOS(time);
                } else {
                    time = Time.createTimeSec(d4);
                    ((TPRasterData.Builder)object2).n_rowcount(rectanglePattern.getRowCount()).t_osmax(Time.createTimeSec(d)).t_rect(Time.createTimeSec(d4)).isSolarTPSB(false).t_expectedTotalITOS((Time)time.multiply(d5));
                }
                object = ((TPRasterData.Builder)object2).build();
                scienceParameters.setTPRasterData((TPRasterData)object);
            }
            catch (UnknownEntityException unknownEntityException) {
                throw new WizardSBGenerationException("Unable to determine if science goal is solar " + unknownEntityException.getMessage());
            }
            scienceParameters.getIntegrationTime().setContentAndUnit((ValueUnitPair)time);
            object2 = rectanglePattern.getFieldCenterCoordinates().deepCopy();
            object = target.getFieldSource().getSourceCoordinates();
            object2 = ((SkyCoordinates)object2).getAbsoluteCoordinates((SkyCoordinates)object);
            ((SkyCoordinates)object2).convertToSystem(SkyCoordinatesData.SYSTEM_ICRS);
            if (((SkyCoordinates)object2).isAbsoluteCoordinates()) {
                object2 = ((SkyCoordinates)object2).getOffsetCoordinates((SkyCoordinates)object);
            }
            rectanglePattern.setPatternCenterCoordinates((SkyCoordinates)object2);
        }
    }

    private Target addSpectralScanTunings(SpectralSetupParameters spectralSetupParameters, RequestedArray requestedArray, TargetWithIntent targetWithIntent, ScienceGoal scienceGoal) {
        Object object;
        EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet = this.sbContext.getSchemaToUseForSBGeneration();
        assert (enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.SPECTRAL_SCAN) || enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.SPECTRAL_SCAN_MULTIPLE_SB)) : "The SB generation schema should be spectral scan";
        Target target = null;
        try {
            object = spectralSetupParameters.getSpectralScan().getTunings();
            if (enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.SPECTRAL_SCAN)) {
                Integer n = 1;
                for (List list : ((SpectralScan.SpectralScanTunings)object).getTunings()) {
                    SpectralSetupParameters spectralSetupParameters2 = SpectralScan.createSPWBasedSSPFromSpectralScanTuning(spectralSetupParameters, list);
                    Integer n2 = this.getObservingGroupManager().getObservingGroupIndex(ObservingGroupManager.ObservingGroupType.SCIENCE, n);
                    target = TargetCreator.createTarget(scienceGoal, targetWithIntent, spectralSetupParameters2, n2, this.sbContext);
                    Object object2 = n;
                    Integer n3 = n = Integer.valueOf(n + 1);
                    this.targets.add(target);
                    object2 = OrderedTarget.createOrderedTarget();
                    object2.setTarget(target);
                    this.orderedTargets.add(object2);
                }
            } else if (enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.SPECTRAL_SCAN_MULTIPLE_SB)) {
                Integer n = this.sbContext.getSpectralScanTuningIndex();
                assert (n != null) : "The tuning index should be specified";
                SpectralSetupParameters spectralSetupParameters3 = SpectralScan.createSPWBasedSSPFromSpectralScanTuning(spectralSetupParameters, ((SpectralScan.SpectralScanTunings)object).getTuning(n));
                Integer n4 = this.getObservingGroupManager().getObservingGroupIndex(ObservingGroupManager.ObservingGroupType.SCIENCE, 1);
                target = TargetCreator.createTarget(targetWithIntent, spectralSetupParameters3, n4, this.sbContext);
                this.targets.add(target);
                OrderedTarget orderedTarget = OrderedTarget.createOrderedTarget();
                orderedTarget.setTarget(target);
                this.orderedTargets.add(orderedTarget);
            }
        }
        catch (SpectralScan.SpectralScanTunings.SpectralScanTuningException spectralScanTuningException) {
            Log.Logger logger = Log.logger((Object)this);
            logger.log(Level.WARNING, "Failed to add spectral scan tunings to target ", (Throwable)spectralScanTuningException);
            return null;
        }
        catch (UnableToFindSolutionException unableToFindSolutionException) {
            Log.Logger logger = Log.logger((Object)this);
            logger.log(Level.WARNING, "Failed to add spectral scan tunings to target ", (Throwable)unableToFindSolutionException);
            return null;
        }
        object = spectralSetupParameters.getScienceGoal();
        Target target2 = targetWithIntent == ((ScienceGoal)object).getSoleTargetParameters() ? target : null;
        return target2;
    }

    @Override
    public Target getRepresentativeTarget() {
        return this.representativeTarget;
    }

    @Override
    public void assignMultipleVelocitySourceTargetsToObservingGroups(TargetWithIntent targetWithIntent, SpectralSetupParameters spectralSetupParameters, RequestedArray requestedArray, ObservingGroupManager observingGroupManager, Integer n) {
    }
}

