/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.intermediatetarget;

import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetWithIntent;
import alma.obsprep.services.generator.refactored.ObsType;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.intermediatetarget.AtmosphericWindow;
import alma.obsprep.services.generator.refactored.intermediatetarget.AtmosphericWindowNotFoundException;
import alma.obsprep.services.generator.refactored.intermediatetarget.IntegrationTimeResolverInterface;
import alma.obsprep.services.generator.refactored.intermediatetarget.ObservingGroupManager;
import alma.obsprep.services.generator.refactored.intermediatetarget.StandardCalIntermediateTarget;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerationContext;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGeneratorTemplate;
import alma.valuetypes.Time;
import java.util.EnumSet;

public class PolarizationCalIntermediateTarget
extends StandardCalIntermediateTarget {
    public PolarizationCalIntermediateTarget(TargetWithIntent targetWithIntent, SpectralSetupParameters spectralSetupParameters, RequestedArray requestedArray, ObservingGroupManager observingGroupManager, EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet, Integer n, SBGenerationContext sBGenerationContext, ObservingGroupManager.ObservingGroupType observingGroupType) {
        super(targetWithIntent, spectralSetupParameters, requestedArray, ObsType.POLARIZATION, observingGroupManager, n, observingGroupType, enumSet, sBGenerationContext);
    }

    public PolarizationCalIntermediateTarget(TargetWithIntent targetWithIntent, SpectralSetupParameters spectralSetupParameters, RequestedArray requestedArray, ObservingGroupManager observingGroupManager, Integer n, EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet, SBGenerationContext sBGenerationContext) {
        super(targetWithIntent, spectralSetupParameters, requestedArray, ObsType.POLARIZATION, observingGroupManager, n, ObservingGroupManager.ObservingGroupType.SCIENCE, enumSet, sBGenerationContext);
    }

    @Override
    protected void determineAdditionalTargetsRequiredForSpectralScans(TargetWithIntent targetWithIntent, SpectralSetupParameters spectralSetupParameters, RequestedArray requestedArray) {
    }

    @Override
    public Time get7mTDMIntegrationTimes(SpectralSetupParameters spectralSetupParameters) throws IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException {
        return this.getPolarizationCalibrationTimes(spectralSetupParameters);
    }

    @Override
    public Time get12mTDMIntegrationTimes(SpectralSetupParameters spectralSetupParameters) throws IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException {
        return this.getPolarizationCalibrationTimes(spectralSetupParameters);
    }

    @Override
    public Time get7mFDMIntegrationTimes(SpectralSetupParameters spectralSetupParameters) throws IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException {
        return this.getPolarizationCalibrationTimes(spectralSetupParameters);
    }

    @Override
    public Time get12mFDMIntegrationTimes(SpectralSetupParameters spectralSetupParameters) throws IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException {
        return this.getPolarizationCalibrationTimes(spectralSetupParameters);
    }

    private Time getPolarizationCalibrationTimes(SpectralSetupParameters spectralSetupParameters) throws IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException {
        Time time = null;
        if (spectralSetupParameters == null || spectralSetupParameters.getReceiverBand() == null) {
            throw new IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException("Unable to determine receiver band");
        }
        int n = spectralSetupParameters.getReceiverBand().getNumber();
        if (n == 5) {
            time = this.getB5PolarizationCalibrationTime(spectralSetupParameters);
        } else if (n == 6) {
            time = Time.createTime((double)5.0, (String)Time.UNIT_MIN);
        } else if (n == 7) {
            time = Time.createTime((double)8.0, (String)Time.UNIT_MIN);
        }
        if (time == null) {
            throw new IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException("Unable to determine integration time for polarization cal" + n);
        }
        return time;
    }

    private Time getB5PolarizationCalibrationTime(SpectralSetupParameters spectralSetupParameters) throws IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException {
        if (spectralSetupParameters == null || spectralSetupParameters.getReceiverBand() == null) {
            throw new IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException("Unable to determine receiver band");
        }
        int n = spectralSetupParameters.getReceiverBand().getNumber();
        Time time = null;
        if (n == 5) {
            AtmosphericWindow atmosphericWindow = null;
            try {
                atmosphericWindow = AtmosphericWindow.determineAtmosphericWindow(spectralSetupParameters.getRepresentativeFrequency(), EnumSet.of(AtmosphericWindow.GHZ175));
                if (atmosphericWindow.equals((Object)AtmosphericWindow.GHZ175)) {
                    time = Time.createTime((double)10.0, (String)Time.UNIT_MIN);
                }
            }
            catch (AtmosphericWindowNotFoundException atmosphericWindowNotFoundException) {
                time = Time.createTime((double)4.0, (String)Time.UNIT_MIN);
            }
        }
        if (time == null) {
            throw new IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException("Unable to determine integration time for ampcal" + n);
        }
        return time;
    }
}

