/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.intermediatetarget;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.obsproject.SpectralScan;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetWithIntent;
import alma.obsprep.bo.obsproject.UnableToFindSolutionException;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.services.generator.refactored.ObsType;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.intermediatetarget.ObservingGroupManager;
import alma.obsprep.services.generator.refactored.intermediatetarget.StandardCalIntermediateTarget;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerationContext;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGeneratorTemplate;
import alma.obsprep.services.generator.refactored.targetcreator.TargetCreator;
import alma.valuetypes.Frequency;
import java.util.EnumSet;
import java.util.List;

public class PointingCalForCalGroupIntermediateTarget
extends StandardCalIntermediateTarget {
    @Override
    protected void determineAdditionalTargetsRequiredForSpectralScans(TargetWithIntent targetWithIntent, SpectralSetupParameters spectralSetupParameters, RequestedArray requestedArray) {
        EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet = this.sbContext.getSchemaToUseForSBGeneration();
        assert (enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.SPECTRAL_SCAN)) : "The SB generation schema should be spectral scan";
        try {
            SpectralScan.SpectralScanTunings spectralScanTunings = spectralSetupParameters.getSpectralScan().getTunings();
            SpectralSetupParameters spectralSetupParameters2 = SpectralScan.createSPWBasedSSPFromSpectralScanTuning(spectralSetupParameters, (List<Frequency>)spectralScanTunings.getTunings().get(0));
            int n = this.getObservingGroupManager().getObservingGroupIndex(ObservingGroupManager.ObservingGroupType.CALIBRATOR, 1);
            Target target = TargetCreator.createTarget(targetWithIntent, spectralSetupParameters2, n, this.sbContext);
            target.getFieldSource().setName("Bandpass pointing");
            this.completeTargetConstruction(target, spectralSetupParameters2, requestedArray);
            boolean bl = this.sbContext.getGoal().getCalibrationSetupParameters().isAmplitudeSpecificSystemDefinedCalibration();
            if (bl) {
                spectralSetupParameters2 = SpectralScan.createSPWBasedSSPFromSpectralScanTuning(spectralSetupParameters, (List<Frequency>)spectralScanTunings.getTunings().get(0));
                target = TargetCreator.createTarget(targetWithIntent, spectralSetupParameters2, n, this.sbContext);
                target.getFieldSource().setName("Amplitude pointing");
                this.completeTargetConstruction(target, spectralSetupParameters2, requestedArray);
            }
        }
        catch (SpectralScan.SpectralScanTunings.SpectralScanTuningException | UnableToFindSolutionException exception) {
            Log.logger(PointingCalForCalGroupIntermediateTarget.class).warning("Unable to generate spectral scan tuning : " + exception.getMessage());
        }
    }

    public PointingCalForCalGroupIntermediateTarget(TargetWithIntent targetWithIntent, SpectralSetupParameters spectralSetupParameters, RequestedArray requestedArray, ObservingGroupManager observingGroupManager, Integer n, EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet, SBGenerationContext sBGenerationContext) {
        super(targetWithIntent, spectralSetupParameters, requestedArray, ObsType.POINTING, observingGroupManager, n, enumSet, sBGenerationContext);
        this.setTargetPriority(1);
        if (!this.targets.isEmpty()) {
            Target target = (Target)this.targets.get(0);
            boolean bl = sBGenerationContext.getGoal().isSpectralScan();
            target.getObservingParameters(0).setName("PointingCalParameters (Cal Group)");
            target.getFieldSource().setName(bl ? "Bandpass pointing" : "Pointing Template (Cal Group)");
        }
    }

    @Override
    public void assignMultipleVelocitySourceTargetsToObservingGroups(TargetWithIntent targetWithIntent, SpectralSetupParameters spectralSetupParameters, RequestedArray requestedArray, ObservingGroupManager observingGroupManager, Integer n) {
    }
}

