/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.intermediatetarget;

import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetWithIntent;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.services.generator.refactored.ObsType;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.intermediatetarget.AbstractIntermediateTarget;
import alma.obsprep.services.generator.refactored.intermediatetarget.ObservingGroupManager;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerationContext;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGeneratorTemplate;
import alma.obsprep.services.generator.refactored.spectralspec.SpectralSpecFactory;
import alma.obsprep.services.generator.refactored.targetcreator.TargetCreator;
import alma.valuetypes.Velocity;
import java.util.EnumSet;
import lombok.NonNull;

public class DGCScienceIntermediateTarget
extends AbstractIntermediateTarget {
    public DGCScienceIntermediateTarget(@NonNull TargetWithIntent targetWithIntent, @NonNull SpectralSetupParameters spectralSetupParameters, @NonNull RequestedArray requestedArray, @NonNull ObservingGroupManager observingGroupManager, Integer n, @NonNull EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet, @NonNull SBGenerationContext sBGenerationContext) {
        if (targetWithIntent == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (spectralSetupParameters == null) {
            throw new NullPointerException("ssp is marked non-null but is null");
        }
        if (requestedArray == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (observingGroupManager == null) {
            throw new NullPointerException("observingGroupManager is marked non-null but is null");
        }
        if (enumSet == null) {
            throw new NullPointerException("schemaToUseForSBGeneration is marked non-null but is null");
        }
        if (sBGenerationContext == null) {
            throw new NullPointerException("sbContext is marked non-null but is null");
        }
        this.sbContext = sBGenerationContext;
        this.setObservingGroupManager(observingGroupManager);
        if (enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.STANDARD)) {
            Integer n2 = observingGroupManager.getObservingGroupIndex(ObservingGroupManager.ObservingGroupType.SCIENCE, 1);
            Target target = TargetCreator.createTarget(targetWithIntent, spectralSetupParameters, n2, sBGenerationContext);
            this.completeTargetConstruction(target, spectralSetupParameters, sBGenerationContext);
            this.addOrderedTarget(target);
        } else if (enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.MULTIPLE_TUNING)) {
            this.assignMultipleVelocitySourceTargetsToObservingGroups(targetWithIntent, spectralSetupParameters, requestedArray, observingGroupManager, n);
        } else if (enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.SPECTRAL_SCAN)) {
            this.createDGCScienceCalibratorsForSpectralScans(targetWithIntent, spectralSetupParameters, observingGroupManager, sBGenerationContext);
        } else {
            throw new UnsupportedOperationException("Unknown SB schema specified " + enumSet);
        }
        this.setTargetPriority(4);
    }

    private void createDGCScienceCalibratorsForSpectralScans(@NonNull TargetWithIntent targetWithIntent, @NonNull SpectralSetupParameters spectralSetupParameters, @NonNull ObservingGroupManager observingGroupManager, @NonNull SBGenerationContext sBGenerationContext) {
        if (targetWithIntent == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (spectralSetupParameters == null) {
            throw new NullPointerException("ssp is marked non-null but is null");
        }
        if (observingGroupManager == null) {
            throw new NullPointerException("observingGroupManager is marked non-null but is null");
        }
        if (sBGenerationContext == null) {
            throw new NullPointerException("sbContext is marked non-null but is null");
        }
    }

    @Override
    public void assignMultipleVelocitySourceTargetsToObservingGroups(@NonNull TargetWithIntent targetWithIntent, @NonNull SpectralSetupParameters spectralSetupParameters, @NonNull RequestedArray requestedArray, @NonNull ObservingGroupManager observingGroupManager, @NonNull Integer n) {
        if (targetWithIntent == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (spectralSetupParameters == null) {
            throw new NullPointerException("ssp is marked non-null but is null");
        }
        if (requestedArray == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (observingGroupManager == null) {
            throw new NullPointerException("observingGroupManager is marked non-null but is null");
        }
        if (n == null) {
            throw new NullPointerException("observingGroupPointer is marked non-null but is null");
        }
    }

    private void completeTargetConstruction(@NonNull Target target, @NonNull SpectralSetupParameters spectralSetupParameters, @NonNull SBGenerationContext sBGenerationContext) {
        if (target == null) {
            throw new NullPointerException("dgcScienceTarget is marked non-null but is null");
        }
        if (spectralSetupParameters == null) {
            throw new NullPointerException("ssp is marked non-null but is null");
        }
        if (sBGenerationContext == null) {
            throw new NullPointerException("sbContext is marked non-null but is null");
        }
        Velocity velocity = spectralSetupParameters.getSourceVelocity().deepCopy();
        SpectralSpecFactory spectralSpecFactory = new SpectralSpecFactory(sBGenerationContext);
        target.setSpectralSpec(spectralSpecFactory.getSpectralSpec(spectralSetupParameters, velocity, ObsType.SCIENCE));
        this.targets.add(target);
    }
}

