/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.intermediatetarget;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.obsproject.SpectralScan;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetWithIntent;
import alma.obsprep.bo.obsproject.UnableToFindSolutionException;
import alma.obsprep.bo.schedblock.BandpassCalParameters;
import alma.obsprep.bo.schedblock.OrderedTarget;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.ObsType;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.intermediatetarget.AbstractIntermediateTarget;
import alma.obsprep.services.generator.refactored.intermediatetarget.AtmosphericWindow;
import alma.obsprep.services.generator.refactored.intermediatetarget.AtmosphericWindowNotFoundException;
import alma.obsprep.services.generator.refactored.intermediatetarget.IntegrationTimeResolverInterface;
import alma.obsprep.services.generator.refactored.intermediatetarget.ObservingGroupManager;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerationContext;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGeneratorTemplate;
import alma.obsprep.services.generator.refactored.spectralspec.SpectralSpecFactory;
import alma.obsprep.services.generator.refactored.targetcreator.TargetCreator;
import alma.valuetypes.Frequency;
import alma.valuetypes.Time;
import alma.valuetypes.Velocity;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.logging.Level;

public class BandpassCalIntermediateTarget
extends AbstractIntermediateTarget {
    private final ObsType intent = ObsType.BANDPASS;

    public BandpassCalIntermediateTarget(TargetWithIntent targetWithIntent, SpectralSetupParameters spectralSetupParameters, RequestedArray requestedArray, ObservingGroupManager observingGroupManager, Integer n, EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet, SBGenerationContext sBGenerationContext) {
        this.sbContext = sBGenerationContext;
        this.setObservingGroupManager(observingGroupManager);
        if (enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.STANDARD)) {
            Integer n2 = observingGroupManager.getObservingGroupIndex(ObservingGroupManager.ObservingGroupType.CALIBRATOR, 1);
            Target target = TargetCreator.createTarget(targetWithIntent, spectralSetupParameters, n2, sBGenerationContext);
            Target target2 = TargetCreator.createTarget(targetWithIntent, spectralSetupParameters, n2, sBGenerationContext);
            this.completeTargetConstruction(target, target2, spectralSetupParameters, sBGenerationContext);
        } else if (enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.MULTIPLE_TUNING)) {
            this.assignMultipleVelocitySourceTargetsToObservingGroups(targetWithIntent, spectralSetupParameters, requestedArray, observingGroupManager, n);
        } else if (enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.SPECTRAL_SCAN_MULTIPLE_SB)) {
            Integer n3 = sBGenerationContext.getSpectralScanTuningIndex();
            assert (n3 != null) : "The tuning index for which we should generate an SB should be specified";
            SpectralScan.SpectralScanTunings spectralScanTunings = null;
            try {
                spectralScanTunings = spectralSetupParameters.getSpectralScan().getTunings();
                SpectralSetupParameters spectralSetupParameters2 = SpectralScan.createSPWBasedSSPFromSpectralScanTuning(spectralSetupParameters, spectralScanTunings.getTuning(n3));
                Integer n4 = observingGroupManager.getObservingGroupIndex(ObservingGroupManager.ObservingGroupType.SCIENCE, 1);
                Target target = TargetCreator.createTarget(targetWithIntent, spectralSetupParameters2, n4, sBGenerationContext);
                Target target3 = TargetCreator.createTarget(targetWithIntent, spectralSetupParameters2, n4, sBGenerationContext);
                this.completeTargetConstruction(target3, target, spectralSetupParameters2, sBGenerationContext);
            }
            catch (SpectralScan.SpectralScanTunings.SpectralScanTuningException | UnableToFindSolutionException exception) {
                Log.Logger logger = Log.logger((Object)this);
                logger.log(Level.WARNING, "Failed to create a bandpass intermediate target ", (Throwable)exception);
                return;
            }
        } else if (enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.SPECTRAL_SCAN)) {
            this.createBandpassCalibratorsForSpectralScans(targetWithIntent, spectralSetupParameters, observingGroupManager, sBGenerationContext);
        } else {
            throw new UnsupportedOperationException("Unknown SB schema specified " + enumSet);
        }
        this.setTargetPriority(3);
    }

    private void createBandpassCalibratorsForSpectralScans(TargetWithIntent targetWithIntent, SpectralSetupParameters spectralSetupParameters, ObservingGroupManager observingGroupManager, SBGenerationContext sBGenerationContext) {
        Integer n = observingGroupManager.getObservingGroupIndex(ObservingGroupManager.ObservingGroupType.CALIBRATOR, 1);
        SpectralScan.SpectralScanTunings spectralScanTunings = null;
        try {
            spectralScanTunings = spectralSetupParameters.getSpectralScan().getTunings();
            for (ArrayList<Frequency> arrayList : spectralScanTunings.getTunings()) {
                SpectralSetupParameters spectralSetupParameters2 = SpectralScan.createSPWBasedSSPFromSpectralScanTuning(spectralSetupParameters, arrayList);
                Target target = TargetCreator.createTarget(targetWithIntent, spectralSetupParameters2, n, sBGenerationContext);
                Target target2 = TargetCreator.createTarget(targetWithIntent, spectralSetupParameters2, n, sBGenerationContext);
                this.completeTargetConstruction(target2, target, spectralSetupParameters2, sBGenerationContext);
            }
        }
        catch (SpectralScan.SpectralScanTunings.SpectralScanTuningException | UnableToFindSolutionException exception) {
            Log.Logger logger = Log.logger((Object)this);
            logger.log(Level.WARNING, "Failed to create a bandpass intermediate target ", (Throwable)exception);
        }
    }

    @Override
    public Time get7mTDMIntegrationTimes(SpectralSetupParameters spectralSetupParameters) throws IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException {
        Time time = null;
        if (spectralSetupParameters == null || spectralSetupParameters.getReceiverBand() == null) {
            throw new IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException("Unable to determine receiver band");
        }
        int n = spectralSetupParameters.getReceiverBand().getNumber();
        if (n == 1 || n == 3 || n == 4 || n == 6) {
            time = Time.createTime((double)10.0, (String)Time.UNIT_MIN);
        } else if (n == 7 || n == 8 || n == 9 || n == 10) {
            time = Time.createTime((double)10.0, (String)Time.UNIT_MIN);
        } else if (n == 5) {
            AtmosphericWindow atmosphericWindow = null;
            try {
                atmosphericWindow = AtmosphericWindow.determineAtmosphericWindow(spectralSetupParameters.getRepresentativeFrequency(), EnumSet.of(AtmosphericWindow.GHZ175));
                if (atmosphericWindow.equals((Object)AtmosphericWindow.GHZ175)) {
                    time = Time.createTime((double)20.0, (String)Time.UNIT_MIN);
                }
            }
            catch (AtmosphericWindowNotFoundException atmosphericWindowNotFoundException) {
                time = Time.createTime((double)10.0, (String)Time.UNIT_MIN);
            }
        }
        if (time == null) {
            throw new IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException("Unable to determine integration time for 7m TDM and receiver band " + n);
        }
        return time;
    }

    @Override
    public Time get12mTDMIntegrationTimes(SpectralSetupParameters spectralSetupParameters) throws IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException {
        Time time = null;
        if (spectralSetupParameters == null || spectralSetupParameters.getReceiverBand() == null) {
            throw new IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException("Unable to determine receiver band");
        }
        int n = spectralSetupParameters.getReceiverBand().getNumber();
        if (n == 1 || n == 3 || n == 4 || n == 6) {
            time = Time.createTime((double)5.0, (String)Time.UNIT_MIN);
        } else if (n == 5 || n == 7 || n == 8 || n == 9 || n == 10) {
            time = Time.createTime((double)5.0, (String)Time.UNIT_MIN);
        }
        if (time == null) {
            throw new IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException("Unable to determine integration time for 12m TDM and receiver band " + n);
        }
        return time;
    }

    @Override
    public Time get7mFDMIntegrationTimes(SpectralSetupParameters spectralSetupParameters) throws IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException {
        Time time = null;
        if (spectralSetupParameters == null || spectralSetupParameters.getReceiverBand() == null) {
            throw new IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException("Unable to determine receiver band");
        }
        int n = spectralSetupParameters.getReceiverBand().getNumber();
        if (n == 1 || n == 3 || n == 4 || n == 6) {
            time = Time.createTime((double)10.0, (String)Time.UNIT_MIN);
        } else if (n == 9 || n == 8) {
            time = Time.createTime((double)30.0, (String)Time.UNIT_MIN);
        } else if (n == 5) {
            AtmosphericWindow atmosphericWindow = null;
            try {
                atmosphericWindow = AtmosphericWindow.determineAtmosphericWindow(spectralSetupParameters.getRepresentativeFrequency(), EnumSet.of(AtmosphericWindow.GHZ175));
                if (atmosphericWindow.equals((Object)AtmosphericWindow.GHZ175)) {
                    time = Time.createTime((double)30.0, (String)Time.UNIT_MIN);
                }
            }
            catch (AtmosphericWindowNotFoundException atmosphericWindowNotFoundException) {
                time = Time.createTime((double)10.0, (String)Time.UNIT_MIN);
            }
        } else if (n == 7) {
            AtmosphericWindow atmosphericWindow = null;
            try {
                atmosphericWindow = AtmosphericWindow.determineAtmosphericWindow(spectralSetupParameters.getRepresentativeFrequency(), EnumSet.of(AtmosphericWindow.GHZ321, AtmosphericWindow.GHZ365));
                assert (atmosphericWindow != null);
                switch (atmosphericWindow) {
                    case GHZ321: {
                        time = Time.createTime((double)30.0, (String)Time.UNIT_MIN);
                        break;
                    }
                    case GHZ365: {
                        time = Time.createTime((double)30.0, (String)Time.UNIT_MIN);
                        break;
                    }
                    default: {
                        throw new WizardSBGenerationException("Unknown atmospheric window detected " + atmosphericWindow);
                    }
                }
            }
            catch (AtmosphericWindowNotFoundException atmosphericWindowNotFoundException) {
                time = Time.createTime((double)20.0, (String)Time.UNIT_MIN);
            }
        } else if (n == 10) {
            time = Time.createTime((double)30.0, (String)Time.UNIT_MIN);
        }
        if (time == null) {
            throw new IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException("Unable to determine integration time for 7m FDM and receiver band " + n);
        }
        return time;
    }

    @Override
    public Time get12mFDMIntegrationTimes(SpectralSetupParameters spectralSetupParameters) throws IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException {
        Time time = null;
        if (spectralSetupParameters == null || spectralSetupParameters.getReceiverBand() == null) {
            throw new IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException("Unable to determine receiver band");
        }
        int n = spectralSetupParameters.getReceiverBand().getNumber();
        if (n == 1 || n == 3 || n == 4 || n == 6) {
            time = Time.createTime((double)5.0, (String)Time.UNIT_MIN);
        } else if (n == 9 || n == 8) {
            time = Time.createTime((double)15.0, (String)Time.UNIT_MIN);
        } else if (n == 5) {
            AtmosphericWindow atmosphericWindow = null;
            try {
                atmosphericWindow = AtmosphericWindow.determineAtmosphericWindow(spectralSetupParameters.getRepresentativeFrequency(), EnumSet.of(AtmosphericWindow.GHZ175));
                if (atmosphericWindow.equals((Object)AtmosphericWindow.GHZ175)) {
                    time = Time.createTime((double)15.0, (String)Time.UNIT_MIN);
                }
            }
            catch (AtmosphericWindowNotFoundException atmosphericWindowNotFoundException) {
                time = Time.createTime((double)10.0, (String)Time.UNIT_MIN);
            }
        } else if (n == 7) {
            AtmosphericWindow atmosphericWindow = null;
            try {
                atmosphericWindow = AtmosphericWindow.determineAtmosphericWindow(spectralSetupParameters.getRepresentativeFrequency(), EnumSet.of(AtmosphericWindow.GHZ321, AtmosphericWindow.GHZ365));
                switch (atmosphericWindow) {
                    case GHZ321: {
                        time = Time.createTime((double)15.0, (String)Time.UNIT_MIN);
                        break;
                    }
                    case GHZ365: {
                        time = Time.createTime((double)15.0, (String)Time.UNIT_MIN);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown atmospheric window detected " + atmosphericWindow);
                    }
                }
            }
            catch (AtmosphericWindowNotFoundException atmosphericWindowNotFoundException) {
                time = Time.createTime((double)10.0, (String)Time.UNIT_MIN);
            }
        } else if (n == 10) {
            time = Time.createTime((double)15.0, (String)Time.UNIT_MIN);
        }
        if (time == null) {
            throw new IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException("Unable to determine integration time for 12m FDM and receiver band " + n);
        }
        return time;
    }

    private void completeTargetConstruction(Target target, Target target2, SpectralSetupParameters spectralSetupParameters, SBGenerationContext sBGenerationContext) {
        boolean bl;
        ArrayList<Target> arrayList = new ArrayList<Target>();
        Velocity velocity = spectralSetupParameters.getSourceVelocity().deepCopy();
        SpectralSpecFactory spectralSpecFactory = new SpectralSpecFactory(sBGenerationContext);
        SpectralSpec spectralSpec = spectralSpecFactory.getSpectralSpec(spectralSetupParameters, velocity, ObsType.SCIENCE);
        target2.setSpectralSpec(spectralSpec);
        this.targets.add(target2);
        arrayList.add(target2);
        for (BandpassCalParameters bandpassCalParameters : target2.getBandpassCalParametersList()) {
            Time time = null;
            try {
                boolean bl2 = !spectralSetupParameters.isPureTDM();
                time = this.determineIntegrationTimes(bl2, spectralSetupParameters, sBGenerationContext.getArray());
            }
            catch (IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException integrationTimeUndeterminedException) {
                this.logger.warning("Unable to determine integration time for science bandpass calibration " + integrationTimeUndeterminedException.getMessage() + " reverting to default");
            }
            if (time != null) {
                bandpassCalParameters.setDefaultIntegrationTime(time);
            }
            bandpassCalParameters.setName("BandpassCalParameters (" + target2.getSpectralSpec().getName() + ")");
        }
        boolean bl3 = bl = sBGenerationContext.getSchemaToUseForSBGeneration().contains((Object)SBGeneratorTemplate.SBGenerationSchema.DGC) && !sBGenerationContext.isTM2SB();
        if (spectralSetupParameters.needsTDMSpec(sBGenerationContext.getArray()) || bl) {
            velocity = spectralSetupParameters.getSourceVelocity().deepCopy();
            SpectralSpec spectralSpec2 = spectralSpecFactory.getSpectralSpec(spectralSetupParameters, velocity, this.intent);
            target.setSpectralSpec(spectralSpec2);
            for (BandpassCalParameters bandpassCalParameters : target.getBandpassCalParametersList()) {
                bandpassCalParameters.setName("BandpassCalParameters (" + target.getSpectralSpec().getName() + ")");
                Time time = null;
                try {
                    time = this.determineIntegrationTimes(false, spectralSetupParameters, sBGenerationContext.getArray());
                }
                catch (IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException integrationTimeUndeterminedException) {
                    this.logger.warning("Unable to determine integration time for science bandpass calibration " + integrationTimeUndeterminedException.getMessage() + " reverting to default");
                }
                if (time != null) {
                    bandpassCalParameters.setDefaultIntegrationTime(time);
                    continue;
                }
                bandpassCalParameters.setDefaultIntegrationTime(Time.createTime((double)1.0, (String)Time.UNIT_MIN));
            }
            for (BandpassCalParameters bandpassCalParameters : target2.getBandpassCalParametersList()) {
                bandpassCalParameters.setName("BandpassCalParameters (" + target2.getSpectralSpec().getName() + ")");
            }
            target.setFieldSource(target2.getFieldSource());
            this.targets.add(target);
            arrayList.add(target);
        }
        for (Target target3 : arrayList) {
            OrderedTarget orderedTarget = OrderedTarget.createOrderedTarget();
            orderedTarget.setTarget(target3);
            this.orderedTargets.add(orderedTarget);
        }
    }

    @Override
    public void assignMultipleVelocitySourceTargetsToObservingGroups(TargetWithIntent targetWithIntent, SpectralSetupParameters spectralSetupParameters, RequestedArray requestedArray, ObservingGroupManager observingGroupManager, Integer n) {
        Integer n2 = observingGroupManager.getObservingGroupIndex(ObservingGroupManager.ObservingGroupType.SCIENCE, n);
        Target target = TargetCreator.createTarget(targetWithIntent, spectralSetupParameters, n2, this.sbContext);
        Target target2 = TargetCreator.createTarget(targetWithIntent, spectralSetupParameters, n2, this.sbContext);
        this.completeTargetConstruction(target2, target, spectralSetupParameters, this.sbContext);
    }
}

