/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored;

import alma.obsprep.bo.schedblock.ObservingGroup;
import alma.obsprep.bo.schedblock.PhaseCalParameters;
import alma.obsprep.bo.schedblock.Reference;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.ScienceParameters;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.services.etc.SolarExecutionTimeCalculator;
import alma.valuetypes.IntTimeSource;
import alma.valuetypes.Latitude;
import alma.valuetypes.Longitude;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.Time;
import java.util.List;
import java.util.Optional;
import lombok.NonNull;

public class SolarSBConfigurator {
    @NonNull
    private final SchedBlock sb;
    @NonNull
    private final SolarExecutionTimeCalculator.SolarExecutionTimeResult solarExecutionTimeResult;

    public void configureSBForSolar() {
        if (this.sb.is12mCompactArraySB() || this.sb.is12mExtendedArraySB() || this.sb.isACA7mArraySB()) {
            this.setInterferometricSBParameters();
        } else {
            this.configureTPRelatedParameters();
        }
    }

    private void setInterferometricSBParameters() {
        this.configureInterferometricScienceReferencePosition();
        this.configureInterferometricScienceSubscanDuration();
        this.configureInterferometricPhaseCalibratorCycleTime();
        this.configureInterferometricScienceSpec();
        this.configureInterferometricIntegrationTimeOnSource();
        this.sb.getSchedBlockControl().setExecutionCount(this.solarExecutionTimeResult.n_EB_int);
    }

    private void configureInterferometricIntegrationTimeOnSource() {
        assert (this.solarExecutionTimeResult != null && this.sb != null);
        List<Target> list = this.sb.getAllTargets(ScienceParameters.scienceParametersFilter);
        int n = list.size();
        for (Target target : list) {
            for (ScienceParameters scienceParameters : target.getScienceParametersList()) {
                scienceParameters.setIntegrationTime(IntTimeSource.createIntTimeSource((double)((Time)this.solarExecutionTimeResult.t_t_EB.divide(n)).getMins(), (String)IntTimeSource.UNIT_MIN));
            }
        }
    }

    private void configureInterferometricScienceSpec() {
        if (this.sb == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: sb");
        }
    }

    private void configureTPRelatedParameters() {
        assert (this.sb != null && this.solarExecutionTimeResult != null);
        this.sb.getSchedBlockControl().setExecutionCount(this.solarExecutionTimeResult.n_tp_EB);
        this.sb.getAllTargets(ScienceParameters.scienceParametersFilter).stream().forEach(target -> target.getScienceParametersCollection().stream().forEach(scienceParameters -> scienceParameters.setIntegrationTime(IntTimeSource.createIntTimeSource((double)this.solarExecutionTimeResult.t_tp.getMins(), (String)IntTimeSource.UNIT_MIN))));
    }

    private void configureInterferometricPhaseCalibratorCycleTime() {
        if (this.sb == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: sb");
        }
        List<Target> list = this.sb.getAllTargets(Optional.empty());
        for (ObservingGroup observingGroup : this.sb.getObservingGroup()) {
            for (Target target2 : observingGroup.getAllOrderedTargets(Optional.of(target -> target.hasPhaseCalParameters()))) {
                SpectralSpec spectralSpec = target2.getSpectralSpec();
                Optional<Target> optional = list.stream().filter(target -> target.hasScienceParameters() && target.getSpectralSpec().equals(spectralSpec)).findFirst();
                long l = list.stream().filter(target -> target.hasScienceParameters() && target.getSpectralSpec().equals(spectralSpec)).count();
                boolean bl = false;
                bl |= l > 1L;
                if (optional.isPresent()) {
                    PhaseCalParameters[] phaseCalParametersArray = optional.get();
                    bl |= phaseCalParametersArray.getFieldSource().getNumberOfPointings() > 1;
                }
                if (!bl) continue;
                for (PhaseCalParameters phaseCalParameters : target2.getPhaseCalParametersList()) {
                    phaseCalParameters.setCycleTime(Time.createTimeMin(5.0));
                }
            }
        }
    }

    private void configureInterferometricScienceSubscanDuration() {
        if (this.sb == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: sb");
        }
        for (ObservingGroup observingGroup : this.sb.getObservingGroup()) {
            for (Target target2 : observingGroup.getAllOrderedTargets(Optional.of(target -> target.hasScienceParameters()))) {
                int n = target2.getFieldSource().getNumberOfPointings();
                for (ScienceParameters scienceParameters : target2.getScienceParametersList()) {
                    double d = n == 1 ? 30.24 : 6.048;
                    scienceParameters.setSubScanDuration(Time.createTimeSec(d));
                }
            }
        }
    }

    private void configureInterferometricScienceReferencePosition() {
        if (this.sb == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: sb");
        }
        for (Target target : this.sb.getAllTargets(ScienceParameters.scienceParametersFilter)) {
            for (Reference reference : target.getFieldSource().getReference()) {
                SkyCoordinates skyCoordinates = reference.getReferenceCoordinates();
                skyCoordinates.getLatitude().setUnit(Latitude.UNIT_DEG);
                skyCoordinates.getLongitude().setUnit(Longitude.UNIT_DEG);
                reference.setIntegrationTime(Time.createTimeSec(12.0));
            }
        }
    }

    public SolarSBConfigurator(@NonNull SchedBlock schedBlock, @NonNull SolarExecutionTimeCalculator.SolarExecutionTimeResult solarExecutionTimeResult) {
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        if (solarExecutionTimeResult == null) {
            throw new NullPointerException("solarExecutionTimeResult is marked non-null but is null");
        }
        this.sb = schedBlock;
        this.solarExecutionTimeResult = solarExecutionTimeResult;
    }
}

