/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.observatorycharacteristics.capabilities.AlmaCapabilities;
import alma.obsprep.bo.annotations.SpectralWindowI;
import alma.obsprep.bo.obsproject.NonOverlappingBandwidthCalculator;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.ScienceSpectralWindow;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.schedblock.AbstractBaseBandConfig;
import alma.obsprep.bo.schedblock.BLSpectralWindow;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.services.etc.SourceNeverVisibleException;
import alma.obsprep.services.experts.Configuration;
import alma.obsprep.services.experts.InvalidConfigurationParametersException;
import alma.obsprep.services.experts.InvalidFrequencyException;
import alma.obsprep.services.experts.RequiredConfigurations;
import alma.obsprep.services.experts.SchedBlockExpert;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.obsparams.UnableToDetermineCalibrationTimeException;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerationContext;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGeneratorTemplate;
import alma.obsprep.services.generator.refactored.spectralspec.SpectralSpecFactory;
import alma.obsprep.services.sfi.SingleFieldScienceGoalModel;
import alma.valuetypes.Frequency;
import alma.valuetypes.UserFrequency;
import alma.valuetypes.Velocity;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import lombok.NonNull;

public class DGCExpert {
    public static final Collection<ReceiverBand> b2bDGCLegalBands = AlmaCapabilities.getInstance().getDGCB2BReceiverBands();
    public static final Set<DGCTypeEnum> allDGCStrategies = EnumSet.of(DGCTypeEnum.DGCBandToBand, DGCTypeEnum.DGCBandwidthSwitching);

    public static boolean isDGCScheduled(@NonNull ScienceGoal scienceGoal, boolean bl) {
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        return !Sets.intersection(DGCExpert.dgcObservingStrategiesRequired(scienceGoal, true), allDGCStrategies).isEmpty();
    }

    public static Set<DGCTypeEnum> dgcObservingStrategiesRequired(ScienceGoal scienceGoal, boolean bl) {
        EnumSet<DGCTypeEnum> enumSet = EnumSet.of(DGCTypeEnum.None);
        if (scienceGoal == null || scienceGoal.isStandAloneACA()) {
            return enumSet;
        }
        if (bl && scienceGoal.getCalibrationSetupParameters().getIsDGCOverride()) {
            return enumSet;
        }
        EnumSet<DGCTypeEnum> enumSet2 = EnumSet.noneOf(DGCTypeEnum.class);
        if (DGCExpert.isBandwidthSwitchingEnabled(scienceGoal)) {
            enumSet2.add(DGCTypeEnum.DGCBandwidthSwitching);
        }
        if (DGCExpert.isB2B(scienceGoal)) {
            enumSet2.add(DGCTypeEnum.DGCBandToBand);
        }
        return enumSet2.isEmpty() ? enumSet : enumSet2;
    }

    private static boolean isBandwidthSwitchingEnabled(@NonNull ScienceGoal scienceGoal) {
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        NonOverlappingBandwidthCalculator nonOverlappingBandwidthCalculator = NonOverlappingBandwidthCalculator.getCalculator(scienceGoal.getSpectralSetupParameters(), scienceGoal.getKeyTargetParameters());
        Frequency frequency = nonOverlappingBandwidthCalculator.calculatePerPoln();
        if (frequency == null) {
            return false;
        }
        return frequency.isLessThan((AbstractDoubleWithUnit)Frequency.createFrequencyGHZ(0.9375));
    }

    private static boolean isB2B(@NonNull ScienceGoal scienceGoal) {
        Object object;
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        ReceiverBand receiverBand = scienceGoal.getReceiverBand();
        if (receiverBand == null || !b2bDGCLegalBands.contains(receiverBand) || scienceGoal.isStandAloneACA()) {
            return false;
        }
        RequiredConfigurations requiredConfigurations = null;
        try {
            object = scienceGoal.getPerformanceParameters();
            requiredConfigurations = SchedBlockExpert.getRecommended12mConfigurations(scienceGoal, object.getRepresentativeFrequency());
        }
        catch (InvalidConfigurationParametersException invalidConfigurationParametersException) {
            Log.logger(DGCExpert.class).warning("Unable to verify if science goal " + scienceGoal.getName() + " is non-standard mode " + invalidConfigurationParametersException.getMessage());
            return false;
        }
        assert (requiredConfigurations != null);
        object = requiredConfigurations.getBest12mExtConfig();
        try {
            return SingleFieldScienceGoalModel.isInBandWithLongbaselineConfigurationNonStandard(scienceGoal, receiverBand, (Configuration)object, b2bDGCLegalBands);
        }
        catch (SourceNeverVisibleException | InvalidFrequencyException | InvalidObsProgramParametersException | UnableToDetermineCalibrationTimeException exception) {
            Log.logger(DGCExpert.class).warning("Unable to verify if science goal " + scienceGoal.getName() + " is non-standard mode " + exception.getMessage());
            return false;
        }
    }

    public static DGCTypeEnum prioritiseDGCReferenceCalibrationStrategy(@NonNull ScienceGoal scienceGoal, @NonNull SpectralSpec spectralSpec) {
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        if (spectralSpec == null) {
            throw new NullPointerException("tdmPhaseCalSpectralSpec is marked non-null but is null");
        }
        ScienceGoal scienceGoal2 = scienceGoal.deepCopy();
        DGCExpert.createTDMSpectralSetup(spectralSpec, scienceGoal2.getSpectralSetupParameters());
        return DGCExpert.getDGCReferenceCalibratorStrategy(scienceGoal2);
    }

    private static DGCTypeEnum getDGCReferenceCalibratorStrategy(@NonNull ScienceGoal scienceGoal) {
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        ReceiverBand receiverBand = scienceGoal.getReceiverBand();
        if (receiverBand == null || !b2bDGCLegalBands.contains(receiverBand) || scienceGoal.isStandAloneACA()) {
            return DGCTypeEnum.DGCBandToBand;
        }
        RequiredConfigurations requiredConfigurations = null;
        try {
            requiredConfigurations = SchedBlockExpert.getRecommended12mConfigurations(scienceGoal, scienceGoal.getPerformanceParameters().getRepresentativeFrequency());
        }
        catch (InvalidConfigurationParametersException invalidConfigurationParametersException) {
            Log.logger(DGCExpert.class).warning("Unable to verify if science goal " + scienceGoal.getName() + " is a non-standard mode " + invalidConfigurationParametersException.getMessage());
            return DGCTypeEnum.DGCBandToBand;
        }
        assert (requiredConfigurations != null);
        Configuration configuration = requiredConfigurations.getBest12mExtConfig();
        try {
            boolean bl = SingleFieldScienceGoalModel.isInBandWithLongbaselineConfigurationNonStandard(scienceGoal, receiverBand, configuration, b2bDGCLegalBands);
            if (!bl) {
                return DGCTypeEnum.DGCBandwidthSwitching;
            }
        }
        catch (SourceNeverVisibleException | InvalidFrequencyException | InvalidObsProgramParametersException | UnableToDetermineCalibrationTimeException exception) {
            Log.logger(DGCExpert.class).warning("Unable to verify if science goal " + scienceGoal.getName() + " is a non-standard mode " + exception.getMessage());
            return DGCTypeEnum.DGCBandToBand;
        }
        return DGCTypeEnum.DGCBandToBand;
    }

    private static void createTDMSpectralSetup(@NonNull SpectralSpec spectralSpec, @NonNull SpectralSetupParameters spectralSetupParameters) {
        if (spectralSpec == null) {
            throw new NullPointerException("tdmPhaseSpectralSpec is marked non-null but is null");
        }
        if (spectralSetupParameters == null) {
            throw new NullPointerException("tdmSSP is marked non-null but is null");
        }
        Frequency frequency = spectralSetupParameters.getRepresentativeFrequency().deepCopy();
        int n = 0;
        spectralSetupParameters.setSpectralType(SpectralSetupParameters.SpectralSetupTypeChoice.SINGLECONTINUUM);
        spectralSetupParameters.clearAbstractScienceSpectralWindow();
        for (AbstractBaseBandConfig abstractBaseBandConfig : spectralSpec.getBaseBandConfig()) {
            int n2 = 0;
            for (SpectralWindowI spectralWindowI : abstractBaseBandConfig.getSpectralWindow()) {
                Frequency frequency2 = ((BLSpectralWindow)spectralWindowI).getSkyFrequency();
                ScienceSpectralWindow scienceSpectralWindow = ScienceSpectralWindow.createSingleContinuum();
                scienceSpectralWindow.setCenterFrequency(frequency2);
                scienceSpectralWindow.setBandWidth(UserFrequency.createUserFrequencyGHZ(2.0));
                spectralSetupParameters.addScienceSpectralWindow(n, n2++, scienceSpectralWindow);
            }
            ++n;
        }
        spectralSetupParameters.setOverrideLO1(Optional.of(spectralSpec.getFrequencySetup().getLO1Frequency().deepCopy()));
        spectralSetupParameters.setRepresentativeFrequency(frequency);
    }

    public static Set<DGCTypeEnum> resolveWhichDGCStrategyToUse(@NonNull ScienceGoal scienceGoal, @NonNull RequestedArray requestedArray, @NonNull Optional<SBGeneratorTemplate.SchedBlockType> optional, Set<DGCTypeEnum> set, Optional<EnumSet<SBGeneratorTemplate.SBGenerationSchema>> optional2) {
        if (scienceGoal == null) {
            throw new NullPointerException("userDefinedScienceGoal is marked non-null but is null");
        }
        if (requestedArray == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (optional == null) {
            throw new NullPointerException("sbType is marked non-null but is null");
        }
        if (!set.containsAll(allDGCStrategies)) {
            return set;
        }
        EnumSet<DGCTypeEnum> enumSet = EnumSet.noneOf(DGCTypeEnum.class);
        SBGenerationContext sBGenerationContext = new SBGenerationContext();
        try {
            sBGenerationContext.setArray(requestedArray).setScienceGoal(scienceGoal).setSB(SchedBlock.createSchedBlock()).setSBType(optional.orElse(SBGeneratorTemplate.SchedBlockType.TWELVEMEXTENDEDCONFIGURATION)).setConfiguration(Configuration.getMostCompactConfiguration(RequestedArray.TWELVE_M)).setSBGenerationSchema(optional2.orElseGet(() -> {
                EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet;
                try {
                    enumSet = SBGeneratorTemplate.determineSBGenerationSchema(scienceGoal, requestedArray, Optional.empty());
                }
                catch (UnknownEntityException unknownEntityException) {
                    throw new WizardSBGenerationException();
                }
                return enumSet;
            }));
        }
        catch (Configuration.UnableToDetermineConfigurationException unableToDetermineConfigurationException) {
            throw new WizardSBGenerationException("Unable to create SB generation context");
        }
        TargetParameters targetParameters = scienceGoal.getSoleTargetParameters();
        Velocity velocity = targetParameters.getSourceVelocity().getVelocityInDefaultReferenceFrame(targetParameters.getSourceCoordinates(), Optional.of(scienceGoal));
        SpectralSpecFactory spectralSpecFactory = new SpectralSpecFactory(sBGenerationContext);
        SpectralSpec spectralSpec = spectralSpecFactory.getTDMPhaseSpectralSpec(scienceGoal.getSpectralSetupParameters(), velocity);
        enumSet.clear();
        enumSet.add(DGCExpert.prioritiseDGCReferenceCalibrationStrategy(scienceGoal, spectralSpec));
        return enumSet;
    }

    public static boolean isB2BScheduled(@NonNull ScienceGoal scienceGoal) {
        if (scienceGoal == null) {
            throw new NullPointerException("clusteredScienceGoal is marked non-null but is null");
        }
        Set<DGCTypeEnum> set = DGCExpert.dgcObservingStrategiesRequired(scienceGoal, true);
        if (set.containsAll(allDGCStrategies)) {
            RequestedArray requestedArray = scienceGoal.isStandAloneACA() ? RequestedArray.SEVEN_M : RequestedArray.TWELVE_M;
            SBGeneratorTemplate.SchedBlockType schedBlockType = scienceGoal.isStandAloneACA() ? SBGeneratorTemplate.SchedBlockType.ACA7M : SBGeneratorTemplate.SchedBlockType.TWELVEMEXTENDEDCONFIGURATION;
            set = DGCExpert.resolveWhichDGCStrategyToUse(scienceGoal, requestedArray, Optional.of(schedBlockType), set, Optional.empty());
        }
        return set.contains((Object)DGCTypeEnum.DGCBandToBand);
    }

    public static enum DGCTypeEnum {
        None("None"),
        DGCBandwidthSwitching("BWSW"),
        DGCBandToBand("B2B");

        private final String label;

        private DGCTypeEnum(String string2) {
            this.label = string2;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

