/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.obsprep.bo.schedblock.AbstractBaseBandConfig;
import alma.obsprep.bo.schedblock.AbstractCorrelatorConfiguration;
import alma.obsprep.bo.schedblock.AbstractSpectralWindow;
import alma.obsprep.bo.schedblock.BaseBandSpecification;
import alma.obsprep.bo.schedblock.FrequencySetup;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.ScienceParameters;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.Target;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;

public class BasebandPostProcessor {
    @NonNull
    private final SchedBlock schedBlock;

    public void sortBasebandsInScienceSpectralSpecsByFrequency() {
        ArrayList<SpectralSpec> arrayList = new ArrayList<SpectralSpec>(20);
        for (Target target : this.schedBlock.getAllTargets(ScienceParameters.scienceParametersFilter)) {
            SpectralSpec spectralSpec = target.getSpectralSpec();
            if (arrayList.contains(spectralSpec)) continue;
            if (spectralSpec.getReceiverType().equals("TSB")) {
                this.sortBBsinTSBReceiver(spectralSpec);
            } else {
                this.sortBBsinNonTSBReceiver(spectralSpec);
            }
            arrayList.add(spectralSpec);
        }
    }

    private void sortBBsinNonTSBReceiver(@NonNull SpectralSpec spectralSpec) {
        if (spectralSpec == null) {
            throw new NullPointerException("spectralSpec is marked non-null but is null");
        }
        List<AbstractBaseBandConfig> list = spectralSpec.getBaseBandConfig();
        list.sort((abstractBaseBandConfig, abstractBaseBandConfig2) -> abstractBaseBandConfig.getCenterFrequency().compareTo((AbstractDoubleWithUnit)abstractBaseBandConfig2.getCenterFrequency()));
        @NonNull AbstractCorrelatorConfiguration abstractCorrelatorConfiguration = spectralSpec.getAbstractCorrelatorConfiguration();
        List<BaseBandSpecification> list2 = Arrays.asList(spectralSpec.getFrequencySetup().getBaseBandSpecification());
        list2.sort((baseBandSpecification, baseBandSpecification2) -> baseBandSpecification.getCenterFrequency().compareTo((AbstractDoubleWithUnit)baseBandSpecification2.getCenterFrequency()));
        spectralSpec.clearBaseBand();
        for (int i = 0; i < list.size(); ++i) {
            abstractCorrelatorConfiguration.addBaseBandConfig(i, list.get(i));
        }
        FrequencySetup frequencySetup = spectralSpec.getFrequencySetup();
        for (int i = 0; i < list2.size(); ++i) {
            BaseBandSpecification baseBandSpecification3 = list2.get(i);
            baseBandSpecification3.setBaseBandName("BB_" + (i + 1));
            frequencySetup.addBaseBandSpecification(i, baseBandSpecification3);
        }
    }

    private void sortBBsinTSBReceiver(@NonNull SpectralSpec spectralSpec) {
        BaseBandSpecification baseBandSpecification;
        if (spectralSpec == null) {
            throw new NullPointerException("spectralSpec is marked non-null but is null");
        }
        List<AbstractBaseBandConfig> list = spectralSpec.getBaseBandConfig();
        list.sort((abstractBaseBandConfig, abstractBaseBandConfig2) -> abstractBaseBandConfig.getCenterFrequency().compareTo((AbstractDoubleWithUnit)abstractBaseBandConfig2.getCenterFrequency()));
        List list2 = list.stream().filter(abstractBaseBandConfig -> abstractBaseBandConfig.getSingleSpectralWindow(0).getSideBand().equals(AbstractSpectralWindow.SIDEBAND_LSB)).collect(Collectors.toList());
        List list3 = list.stream().filter(abstractBaseBandConfig -> abstractBaseBandConfig.getSingleSpectralWindow(0).getSideBand().equals(AbstractSpectralWindow.SIDEBAND_USB)).collect(Collectors.toList());
        spectralSpec.clearBaseBand();
        @NonNull AbstractCorrelatorConfiguration abstractCorrelatorConfiguration = spectralSpec.getAbstractCorrelatorConfiguration();
        FrequencySetup frequencySetup = spectralSpec.getFrequencySetup();
        int n = 1;
        int n2 = 0;
        for (AbstractBaseBandConfig abstractBaseBandConfig3 : list2) {
            abstractCorrelatorConfiguration.addBaseBandConfig(n2, abstractBaseBandConfig3);
            baseBandSpecification = abstractBaseBandConfig3.getBaseBandSpecification();
            frequencySetup.addBaseBandSpecification(baseBandSpecification);
            baseBandSpecification.setBaseBandName("BB_" + n++);
            ++n2;
        }
        if (list3.size() != 4 && !list2.isEmpty()) {
            n = 3;
        }
        for (AbstractBaseBandConfig abstractBaseBandConfig3 : list3) {
            abstractCorrelatorConfiguration.addBaseBandConfig(n2, abstractBaseBandConfig3);
            baseBandSpecification = abstractBaseBandConfig3.getBaseBandSpecification();
            frequencySetup.addBaseBandSpecification(baseBandSpecification);
            baseBandSpecification.setBaseBandName("BB_" + n++);
            ++n2;
        }
    }

    public BasebandPostProcessor(@NonNull SchedBlock schedBlock) {
        if (schedBlock == null) {
            throw new NullPointerException("schedBlock is marked non-null but is null");
        }
        this.schedBlock = schedBlock;
    }
}

