/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator;

import alma.obsprep.bo.annotations.SpatialDocument;
import alma.obsprep.bo.obsproject.CalibratedAbstractScienceGoal;
import alma.obsprep.bo.obsproject.CalibrationSetupParameters;
import alma.obsprep.bo.obsproject.CalibrationTargetParameters;
import alma.obsprep.bo.obsproject.CalibrationTargetProperties;
import alma.obsprep.bo.schedblock.FieldPattern;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.bo.schedblock.ObservingGroup;
import alma.obsprep.bo.schedblock.OrderedTarget;
import alma.obsprep.bo.schedblock.PointingPattern;
import alma.obsprep.bo.schedblock.QuerySource;
import alma.obsprep.bo.schedblock.Reference;
import alma.obsprep.bo.schedblock.SourceProperty;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.services.experts.ObservingModeExpert;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.valuetypes.Angle;
import alma.valuetypes.Latitude;
import alma.valuetypes.Longitude;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.Time;
import alma.valuetypes.Velocity;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

public class CalibratedGoalFieldSourceWorker {
    public static final List<String> GROUP_ONE_CALIBRATORS = new ArrayList<String>();
    public static final List<String> GROUP_TWO_CALIBRATORS = new ArrayList<String>();
    private final CalibratedAbstractScienceGoal goal;
    private final Map<String, Queue<FieldSource>> calibratorFieldSources = new HashMap<String, Queue<FieldSource>>();
    private final Map<String, Queue<Target>> calibratorTargets = new HashMap<String, Queue<Target>>();
    private final List<FieldSource> targetFieldSources = new ArrayList<FieldSource>();
    private final Map<String, Queue<Target>> surveyTargets = new HashMap<String, Queue<Target>>();
    private final ObservingGroup initialCalibrationGroup = ObservingGroup.createObservingGroup();
    private final ObservingGroup targetsGroup = ObservingGroup.createObservingGroup();
    private SkyCoordinates defaultCenterCoords;

    public CalibratedGoalFieldSourceWorker(CalibratedAbstractScienceGoal calibratedAbstractScienceGoal) {
        this.goal = calibratedAbstractScienceGoal;
    }

    public void calculate() {
        HashSet<String> hashSet = new HashSet<String>(ObservingModeExpert.getCalibratorQuerySourceIntents(this.goal));
        HashSet<String> hashSet2 = new HashSet<String>(ObservingModeExpert.getCalibratorTargetIntents(this.goal));
        HashSet<String> hashSet3 = new HashSet<String>(ObservingModeExpert.getCalibratorIntents(this.goal));
        this.defaultCenterCoords = this.getRepresentativeFieldSource().getSourceCoordinates();
        this.calculateDynamicCalibratorFieldSources(hashSet);
        this.calculateStaticCalibratorFieldSources(hashSet2);
        this.calculateInitialCalibrationGroup(hashSet3);
        this.calculateTargetGroup(hashSet3);
    }

    public ObservingGroup getTargetsObservingGroup() {
        return this.targetsGroup;
    }

    public ObservingGroup getInitialCalibrationObservingGroup() {
        return this.initialCalibrationGroup;
    }

    public Queue<Target> getTargets() {
        return this.surveyTargets.get("Science");
    }

    public Queue<Target> getTargets(String string) {
        return this.surveyTargets.get(string);
    }

    public List<FieldSource> getTargetFieldSources() {
        return this.targetFieldSources;
    }

    public Queue<FieldSource> getCalibratorFieldSources(String string) {
        return this.calibratorFieldSources.get(string);
    }

    public Queue<Target> getCalibratorTargets(String string) {
        return this.calibratorTargets.get(string);
    }

    public Collection<Target> getCalibratorTargets() {
        ArrayList<Target> arrayList = new ArrayList<Target>();
        for (Queue<Target> queue : this.calibratorTargets.values()) {
            arrayList.addAll(queue);
        }
        return arrayList;
    }

    public FieldSource getRepresentativeFieldSource() {
        if (this.targetFieldSources.size() > 0) {
            return this.targetFieldSources.get(0);
        }
        return null;
    }

    private void calculateTargetGroup(Collection<String> collection) {
        Object object;
        Object object2;
        SpatialDocument spatialDocument;
        int n = 1;
        for (String object3 : GROUP_TWO_CALIBRATORS) {
            if (!this.calibratorFieldSources.containsKey(object3)) continue;
            spatialDocument = this.calibratorFieldSources.get(object3).remove();
            this.calibratorFieldSources.get(object3).add((FieldSource)spatialDocument);
            if (object3.equals(QuerySource.INTENDEDUSE_AMPLITUDE) || object3.equals(QuerySource.INTENDEDUSE_BANDPASS) || object3.equals(QuerySource.INTENDEDUSE_PHASE)) {
                object2 = Target.createTarget();
                object2.setFieldSource((FieldSource)spatialDocument);
                if (!this.calibratorTargets.containsKey(QuerySource.INTENDEDUSE_ATMOSPHERIC)) {
                    this.calibratorTargets.put(QuerySource.INTENDEDUSE_ATMOSPHERIC, new ArrayDeque());
                }
                this.calibratorTargets.get(QuerySource.INTENDEDUSE_ATMOSPHERIC).add((Target)object2);
                object = OrderedTarget.createOrderedTarget();
                object.setIndex(n++);
                object.setTarget(object2);
                this.targetsGroup.addOrderedTarget((OrderedTarget)((Object)object));
            }
            object2 = Target.createTarget();
            object2.setFieldSource((FieldSource)spatialDocument);
            if (!this.calibratorTargets.containsKey(object3)) {
                this.calibratorTargets.put(object3, new ArrayDeque());
            }
            this.calibratorTargets.get(object3).add((Target)object2);
            object = OrderedTarget.createOrderedTarget();
            object.setIndex(n++);
            object.setTarget(object2);
            this.targetsGroup.addOrderedTarget((OrderedTarget)((Object)object));
        }
        for (FieldSource fieldSource : this.targetFieldSources) {
            spatialDocument = Target.createTarget();
            spatialDocument.setFieldSource(fieldSource);
            if (!this.surveyTargets.containsKey(QuerySource.INTENDEDUSE_ATMOSPHERIC)) {
                this.surveyTargets.put(QuerySource.INTENDEDUSE_ATMOSPHERIC, new ArrayDeque());
            }
            this.surveyTargets.get(QuerySource.INTENDEDUSE_ATMOSPHERIC).add((Target)spatialDocument);
            object2 = OrderedTarget.createOrderedTarget();
            object2.setIndex(n++);
            object2.setTarget(spatialDocument);
            this.targetsGroup.addOrderedTarget((OrderedTarget)((Object)object2));
            object = Target.createTarget();
            object.setFieldSource(fieldSource);
            if (!this.surveyTargets.containsKey("Science")) {
                this.surveyTargets.put("Science", new ArrayDeque());
            }
            this.surveyTargets.get("Science").add((Target)object);
            OrderedTarget orderedTarget = OrderedTarget.createOrderedTarget();
            orderedTarget.setIndex(n++);
            orderedTarget.setTarget((Target)object);
            this.targetsGroup.addOrderedTarget(orderedTarget);
        }
    }

    private void calculateInitialCalibrationGroup(Collection<String> collection) {
        int n = 1;
        for (String string : GROUP_ONE_CALIBRATORS) {
            OrderedTarget orderedTarget;
            Target target;
            if (!this.calibratorFieldSources.containsKey(string)) continue;
            FieldSource fieldSource = this.calibratorFieldSources.get(string).remove();
            this.calibratorFieldSources.get(string).add(fieldSource);
            if (string.equals(QuerySource.INTENDEDUSE_AMPLITUDE) || string.equals(QuerySource.INTENDEDUSE_BANDPASS) || string.equals(QuerySource.INTENDEDUSE_PHASE)) {
                target = Target.createTarget();
                target.setFieldSource(fieldSource);
                if (!this.calibratorTargets.containsKey(QuerySource.INTENDEDUSE_ATMOSPHERIC)) {
                    this.calibratorTargets.put(QuerySource.INTENDEDUSE_ATMOSPHERIC, new ArrayDeque());
                }
                this.calibratorTargets.get(QuerySource.INTENDEDUSE_ATMOSPHERIC).add(target);
                orderedTarget = OrderedTarget.createOrderedTarget();
                orderedTarget.setIndex(n++);
                orderedTarget.setTarget(target);
                this.initialCalibrationGroup.addOrderedTarget(orderedTarget);
            }
            target = Target.createTarget();
            target.setFieldSource(fieldSource);
            if (!this.calibratorTargets.containsKey(string)) {
                this.calibratorTargets.put(string, new ArrayDeque());
            }
            this.calibratorTargets.get(string).add(target);
            orderedTarget = OrderedTarget.createOrderedTarget();
            orderedTarget.setIndex(n++);
            orderedTarget.setTarget(target);
            this.initialCalibrationGroup.addOrderedTarget(orderedTarget);
        }
    }

    private void calculateDynamicCalibratorFieldSources(Set<String> set) throws WizardSBGenerationException {
        for (String string : set) {
            for (FieldSource fieldSource : this.createCalibratorQueryFieldSource(string)) {
                this.addCalibratorFieldSource(fieldSource, string);
            }
        }
    }

    private void calculateStaticCalibratorFieldSources(Set<String> set) throws WizardSBGenerationException {
        for (String string : set) {
            for (FieldSource fieldSource : this.createCalibratorTargetFieldSource(string)) {
                this.addCalibratorFieldSource(fieldSource, string);
            }
        }
    }

    private void addCalibratorFieldSource(FieldSource fieldSource, String string) {
        if (!this.calibratorFieldSources.containsKey(string)) {
            this.calibratorFieldSources.put(string, new ArrayDeque());
        }
        this.calibratorFieldSources.get(string).add(fieldSource);
    }

    private Collection<FieldSource> createCalibratorQueryFieldSource(String string) {
        ArrayList<FieldSource> arrayList = new ArrayList<FieldSource>();
        for (QuerySource querySource : this.getQuerySource(string)) {
            if (string.equals(QuerySource.INTENDEDUSE_ATMOSPHERIC)) continue;
            FieldSource fieldSource = this.createCalibratorFieldSource();
            fieldSource.setIsQuery(true);
            fieldSource.setQuerySource(querySource);
            fieldSource.setName(string);
            fieldSource.setSourceName("query");
            if (string.equals(QuerySource.INTENDEDUSE_AMPLITUDE) || string.equals(QuerySource.INTENDEDUSE_BANDPASS) || string.equals(QuerySource.INTENDEDUSE_PHASE)) {
                Reference reference = Reference.createReference();
                reference.setCycleTime(Time.createTimeSec(360000.0));
                reference.setIntegrationTime(Time.createTimeSec(4.0));
                reference.setSubScanDuration(Time.createTimeSec(2.0));
                SkyCoordinates skyCoordinates = SkyCoordinates.createOffsetCoordinates();
                skyCoordinates.setSystem(SkyCoordinates.SYSTEM_HORIZON);
                skyCoordinates.setLatitude(Latitude.createLatitude((double)0.0, (String)Angle.UNIT_ARCMIN));
                skyCoordinates.setLongitude(Longitude.createLongitude((double)2.0, (String)Angle.UNIT_ARCMIN));
                reference.setReferenceCoordinates(skyCoordinates);
                fieldSource.addReference(reference);
            }
            arrayList.add(fieldSource);
        }
        return arrayList;
    }

    private Collection<FieldSource> createCalibratorTargetFieldSource(String string) {
        ArrayList<FieldSource> arrayList = new ArrayList<FieldSource>();
        for (CalibrationTargetParameters calibrationTargetParameters : this.getCalibrationTargetParameters(string)) {
            if (string.equals(QuerySource.INTENDEDUSE_ATMOSPHERIC)) continue;
            FieldSource fieldSource = this.createCalibratorFieldSource();
            fieldSource.setIsQuery(false);
            if (string.equals(QuerySource.INTENDEDUSE_AMPLITUDE) || string.equals(QuerySource.INTENDEDUSE_BANDPASS) || string.equals(QuerySource.INTENDEDUSE_PHASE)) {
                Reference reference = Reference.createReference();
                reference.setCycleTime(Time.createTimeSec(360000.0));
                reference.setIntegrationTime(Time.createTimeSec(4.0));
                reference.setSubScanDuration(Time.createTimeSec(2.0));
                SkyCoordinates skyCoordinates = SkyCoordinates.createOffsetCoordinates();
                skyCoordinates.setSystem(SkyCoordinates.SYSTEM_HORIZON);
                skyCoordinates.setLatitude(Latitude.createLatitude((double)0.0, (String)Angle.UNIT_ARCMIN));
                skyCoordinates.setLongitude(Longitude.createLongitude((double)2.0, (String)Angle.UNIT_ARCMIN));
                reference.setReferenceCoordinates(skyCoordinates);
                fieldSource.addReference(reference);
            }
            fieldSource.setName(string + " calibrator");
            this.setupFieldSource(calibrationTargetParameters, fieldSource);
            arrayList.add(fieldSource);
        }
        return arrayList;
    }

    private Collection<CalibrationTargetParameters> getCalibrationTargetParameters(String string) {
        ArrayList<CalibrationTargetParameters> arrayList = new ArrayList<CalibrationTargetParameters>();
        CalibrationSetupParameters calibrationSetupParameters = this.goal.getCalibrationSetupParameters();
        for (CalibrationTargetParameters calibrationTargetParameters : calibrationSetupParameters.getCalibrationTargetParameters()) {
            if (!calibrationTargetParameters.getIntendedUse().equals(string)) continue;
            arrayList.add(calibrationTargetParameters);
        }
        return arrayList;
    }

    protected void setupFieldSource(CalibrationTargetParameters calibrationTargetParameters, FieldSource fieldSource) {
        Object object = calibrationTargetParameters.gettrueSourceCoordinates();
        if (object != null) {
            fieldSource.setSourceCoordinates((SkyCoordinates)object.deepCopy());
        }
        fieldSource.setNonSiderealMotion(calibrationTargetParameters.gettrueNonSiderealMotion());
        if (calibrationTargetParameters.getNonSiderealMotion()) {
            fieldSource.setSolarSystemObject(calibrationTargetParameters.getSolarSystemObject());
            fieldSource.setSourceName(calibrationTargetParameters.getSolarSystemObject());
        } else {
            fieldSource.setSourceName(calibrationTargetParameters.gettrueSourceName());
        }
        object = calibrationTargetParameters.gettrueSourceVelocity();
        if (object != null) {
            fieldSource.setSourceVelocity((Velocity)object.deepCopy());
        }
        for (CalibrationTargetProperties calibrationTargetProperties : calibrationTargetParameters.getCalibrationTargetProperties()) {
            SourceProperty sourceProperty = SourceProperty.createSourceProperty();
            sourceProperty.setSourceFluxI(calibrationTargetProperties.getFlux().deepCopy());
            sourceProperty.setSourceFrequency(calibrationTargetProperties.getFrequency().deepCopy());
            fieldSource.addSourceProperty(sourceProperty);
        }
    }

    private PointingPattern getPointingPattern() {
        PointingPattern pointingPattern = PointingPattern.createPointingPattern();
        pointingPattern.setType(PointingPattern.TYPE_POINT);
        SkyCoordinates skyCoordinates = SkyCoordinates.createSkyCoordinates(SkyCoordinates.TYPE_RELATIVE);
        skyCoordinates.setLongitude(Longitude.createLongitude((double)0.0, (String)Longitude.UNIT_ARCMIN));
        skyCoordinates.setLatitude(Latitude.createLatitude((double)0.0, (String)Latitude.UNIT_ARCMIN));
        pointingPattern.setPhaseCenterCoordinates(new SkyCoordinates[]{skyCoordinates});
        return pointingPattern;
    }

    private FieldSource createCalibratorFieldSource() {
        FieldSource fieldSource = FieldSource.createFieldSource();
        fieldSource.setFieldPattern((FieldPattern)((Object)this.getPointingPattern()));
        return fieldSource;
    }

    private Collection<QuerySource> getQuerySource(String string) {
        Collection<QuerySource> collection = this.getSystemDefinedQueries(string);
        Collection<QuerySource> collection2 = null;
        String string2 = this.goal.getCalibrationSetupParameters().getSelection();
        if (string2.equals(CalibrationSetupParameters.SELECTION_SYSTEM) || string2.equals(CalibrationSetupParameters.SELECTION_SYSTEMALTERNATE)) {
            return collection;
        }
        collection2 = this.getUserDefinedQueries(string);
        for (int i = collection2.size(); i < collection.size(); ++i) {
            QuerySource querySource = QuerySource.createQuerySource();
            querySource.setIntendedUse(string);
            querySource.setQueryCenter(this.defaultCenterCoords.deepCopy());
            querySource.setSearchRadius(Angle.createAngle((double)20.0, (String)Angle.UNIT_DEG));
            querySource.setMaxSources(40);
            collection2.add(querySource);
        }
        return collection2;
    }

    private Collection<QuerySource> getUserDefinedQueries(String string) {
        ArrayList<QuerySource> arrayList = new ArrayList<QuerySource>();
        CalibrationSetupParameters calibrationSetupParameters = this.goal.getCalibrationSetupParameters();
        for (alma.obsprep.bo.obsproject.QuerySource querySource : calibrationSetupParameters.getQuerySource()) {
            if (!querySource.getIntendedUse().equals(string)) continue;
            QuerySource querySource2 = QuerySource.createQuerySource(querySource);
            arrayList.add(querySource2);
        }
        return arrayList;
    }

    private Collection<QuerySource> getSystemDefinedQueries(String string) {
        ArrayList<QuerySource> arrayList = new ArrayList<QuerySource>();
        Collection<String> collection = ObservingModeExpert.getCalibratorQuerySourceIntents(this.goal);
        for (String string2 : collection) {
            if (!string2.equals(string)) continue;
            QuerySource querySource = QuerySource.createQuerySource();
            querySource.setIntendedUse(string2);
            querySource.setQueryCenter(this.defaultCenterCoords.deepCopy());
            querySource.setSearchRadius(Angle.createAngle((double)20.0, (String)Angle.UNIT_DEG));
            querySource.setMaxSources(40);
            arrayList.add(querySource);
        }
        return arrayList;
    }

    static {
        GROUP_ONE_CALIBRATORS.add(QuerySource.INTENDEDUSE_POINTING);
        GROUP_ONE_CALIBRATORS.add(QuerySource.INTENDEDUSE_ATMOSPHERIC);
        GROUP_ONE_CALIBRATORS.add(QuerySource.INTENDEDUSE_AMPLITUDE);
        GROUP_ONE_CALIBRATORS.add(QuerySource.INTENDEDUSE_POINTING);
        GROUP_ONE_CALIBRATORS.add(QuerySource.INTENDEDUSE_ATMOSPHERIC);
        GROUP_ONE_CALIBRATORS.add(QuerySource.INTENDEDUSE_BANDPASS);
        GROUP_ONE_CALIBRATORS.add(QuerySource.INTENDEDUSE_BANDPASS);
        GROUP_ONE_CALIBRATORS.add(QuerySource.INTENDEDUSE_SIDEBANDRATIO);
        GROUP_ONE_CALIBRATORS.add(QuerySource.INTENDEDUSE_POLARIZATION);
        GROUP_TWO_CALIBRATORS.add(QuerySource.INTENDEDUSE_POINTING);
        GROUP_TWO_CALIBRATORS.add(QuerySource.INTENDEDUSE_ATMOSPHERIC);
        GROUP_TWO_CALIBRATORS.add(QuerySource.INTENDEDUSE_PHASE);
    }
}

