/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.experts.spectralline.gui.filters;

import alma.obsprep.services.experts.spectralline.SpectralLine;
import alma.valuetypes.Frequency;
import alma.valuetypes.Velocity;
import ca.odell.glazedlists.matchers.AbstractMatcherEditor;
import ca.odell.glazedlists.matchers.Matcher;
import javax.swing.JSpinner;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MinimumFrequencyMatcherEditor
extends AbstractMatcherEditor<SpectralLine>
implements ChangeListener {
    private final JSpinner spinner;
    private final Velocity velocity;

    public MinimumFrequencyMatcherEditor(JSpinner jSpinner, Velocity velocity) {
        this.spinner = jSpinner;
        this.spinner.addChangeListener(this);
        this.velocity = velocity;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Double d = (Double)this.spinner.getValue();
        if (d == null) {
            this.fireMatchAll();
        } else {
            Frequency frequency = Frequency.createFrequencyGHZ(d);
            Frequency frequency2 = this.velocity.reverseShift(frequency);
            this.fireChanged(new MinimumFrequencyMatcher(frequency2.getContentInGHz()));
        }
    }

    private static class MinimumFrequencyMatcher
    implements Matcher<SpectralLine> {
        private final Double threshold;

        public MinimumFrequencyMatcher(Double d) {
            this.threshold = d;
        }

        public boolean matches(SpectralLine spectralLine) {
            Double d = spectralLine.getFrequencyInGHz();
            return d >= this.threshold;
        }
    }
}

