/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.experts.spectralline.gui.filters;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.services.experts.spectralline.SpectralLine;
import alma.obsprep.util.FrequencyRange;
import alma.valuetypes.Frequency;
import alma.valuetypes.Velocity;
import ca.odell.glazedlists.matchers.Matcher;
import java.util.ArrayList;
import java.util.Collection;

public class Lo1SidebandMatcher
implements Matcher<SpectralLine> {
    protected final Collection<FrequencyRange> sidebands = new ArrayList<FrequencyRange>();
    private final Frequency lo1;

    public Lo1SidebandMatcher(Frequency frequency, ReceiverBand receiverBand, Velocity velocity) {
        Object object;
        this.lo1 = frequency.deepCopy();
        FrequencyRange frequencyRange = receiverBand.getIFRange();
        if (receiverBand.hasLower()) {
            object = new FrequencyRange((Frequency)frequency.minus((AbstractDoubleWithUnit)((Frequency)((Object)frequencyRange.max()))), (Frequency)frequency.minus((AbstractDoubleWithUnit)((Frequency)((Object)frequencyRange.min()))));
            this.sidebands.add((FrequencyRange)object);
        }
        if (receiverBand.hasUpper()) {
            object = new FrequencyRange((Frequency)frequency.plus((AbstractDoubleWithUnit)((Frequency)((Object)frequencyRange.min()))), (Frequency)frequency.plus((AbstractDoubleWithUnit)((Frequency)((Object)frequencyRange.max()))));
            this.sidebands.add((FrequencyRange)object);
        }
        for (FrequencyRange frequencyRange2 : this.sidebands) {
            FrequencyRange frequencyRange3 = FrequencyRange.centredOn((Frequency)((Object)frequencyRange2.mid()), (Frequency)((Object)frequencyRange2.range()));
            frequencyRange2.setMin(velocity.reverseShift((Frequency)((Object)frequencyRange3.min())));
            frequencyRange2.setMax(velocity.reverseShift((Frequency)((Object)frequencyRange3.max())));
        }
    }

    public boolean matches(SpectralLine spectralLine) {
        Frequency frequency = spectralLine.getFrequency();
        for (FrequencyRange frequencyRange : this.sidebands) {
            if (!frequencyRange.contains(frequency)) continue;
            return true;
        }
        return false;
    }

    public Frequency getLo1() {
        return this.lo1.deepCopy();
    }
}

