/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.experts.spectralline.gui.filters;

import alma.obsprep.services.experts.spectralline.SpectralLine;
import ca.odell.glazedlists.matchers.AbstractMatcherEditor;
import ca.odell.glazedlists.matchers.Matcher;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.EnumSet;
import javax.swing.JComboBox;

public class FlagsMatcherEditor
extends AbstractMatcherEditor<SpectralLine>
implements ActionListener {
    private final JComboBox combobox;

    public FlagsMatcherEditor(JComboBox jComboBox) {
        this.combobox = jComboBox;
        this.combobox.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = this.combobox.getSelectedItem();
        if (object == null) {
            this.fireMatchAll();
        } else {
            Filter filter = (Filter)((Object)object);
            this.fireChanged(filter.matcher);
        }
    }

    private static class AvoidFlagMatcher
    implements Matcher<SpectralLine> {
        private final Collection<SpectralLine.Flag> avoidFlags = EnumSet.noneOf(SpectralLine.Flag.class);

        public AvoidFlagMatcher(SpectralLine.Flag ... flagArray) {
            for (SpectralLine.Flag flag : flagArray) {
                this.avoidFlags.add(flag);
            }
        }

        public boolean matches(SpectralLine spectralLine) {
            EnumSet<SpectralLine.Flag> enumSet = spectralLine.getFlags();
            for (SpectralLine.Flag flag : this.avoidFlags) {
                if (!enumSet.contains((Object)flag)) continue;
                return false;
            }
            return true;
        }
    }

    private static class RequiredFlagMatcher
    implements Matcher<SpectralLine> {
        private final Collection<SpectralLine.Flag> requiredFlags = EnumSet.noneOf(SpectralLine.Flag.class);

        public RequiredFlagMatcher(SpectralLine.Flag ... flagArray) {
            for (SpectralLine.Flag flag : flagArray) {
                this.requiredFlags.add(flag);
            }
        }

        public boolean matches(SpectralLine spectralLine) {
            return spectralLine.getFlags().containsAll(this.requiredFlags);
        }
    }

    public static enum Filter {
        ALL("all atoms and molecules", new SpectralLine.Flag[0]),
        TOP("most common molecules", SpectralLine.Flag.COMMON),
        HOTCORE("hot cores", SpectralLine.Flag.ISM_HOTCORE),
        DARK_CLOUD("dark clouds", SpectralLine.Flag.ISM_DARK_CLOUD),
        DIFFUSE_CLOUD("diffuse clouds", SpectralLine.Flag.ISM_DIFFUSECLOUD),
        AGB_PPN_PN("AGBs, PPNs and PNs", SpectralLine.Flag.AGB_PPN_PN),
        COMET("comets", SpectralLine.Flag.COMET),
        PLANET("planets", SpectralLine.Flag.PLANET),
        EXTRAGALACTIC("extra-Galactic", SpectralLine.Flag.EXTRAGALACTIC);

        public static final Collection<Filter> ALL_FILTERS;
        public static final Filter[] ALL_FILTERS_ARRAY;
        private final String description;
        private final Matcher<SpectralLine> matcher;

        private Filter(String string2, SpectralLine.Flag ... flagArray) {
            this.description = string2;
            this.matcher = new RequiredFlagMatcher(flagArray);
        }

        public String toString() {
            return this.description;
        }

        static {
            ALL_FILTERS = EnumSet.allOf(Filter.class);
            ALL_FILTERS_ARRAY = EnumSet.allOf(Filter.class).toArray(new Filter[ALL_FILTERS.size()]);
        }
    }
}

