/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.experts.spectralline.gui;

import javax.swing.JButton;

public class RestrictedSearchButton
extends JButton {
    private static final String ONLINE_TOOLTIP = "Search online for transitions matching your criteria";
    private static final String DISABLED_TOOLTIP = "<html><i>Search</i> requires valid species and frequency constraints</html>";
    private static final String ENABLED_TEXT = "Search";
    private static final String DISABLED_TEXT = "Search";
    private static final String INPROGRESS_TEXT = "Search in Progress";
    private int prefixLength;
    private int suffixLength;
    private double minFrequency = Double.MIN_VALUE;
    private double maxFrequency = Double.MAX_VALUE;
    private String species = "";
    private boolean searchInProgress = false;

    public RestrictedSearchButton(int n, int n2) {
        this.prefixLength = n;
        this.suffixLength = n2;
    }

    public void setSpecies(String string) {
        this.species = string.substring(this.prefixLength, string.length() - this.suffixLength);
        this.checkEnabled();
    }

    public void setMaxFrequency(double d) {
        this.maxFrequency = d;
        this.checkEnabled();
    }

    public void setMinFrequency(double d) {
        this.minFrequency = d;
        this.checkEnabled();
    }

    public void setSearchInProgress(boolean bl) {
        this.searchInProgress = bl;
        this.checkEnabled();
    }

    private void checkEnabled() {
        if (this.searchInProgress) {
            this.setText(INPROGRESS_TEXT);
            this.setToolTipText(ONLINE_TOOLTIP);
            this.setEnabled(false);
        } else if (!this.species.isEmpty() && this.maxFrequency > this.minFrequency) {
            this.setText("Search");
            this.setToolTipText(ONLINE_TOOLTIP);
            this.setEnabled(true);
        } else {
            this.setText("Search");
            this.setEnabled(false);
            this.setToolTipText(DISABLED_TOOLTIP);
        }
    }

    public void setPrefixLength(int n) {
        this.prefixLength = n;
    }

    public void setSuffixLength(int n) {
        this.suffixLength = n;
    }
}

