/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.experts.spectralline.gui;

import alma.obsprep.bo.enumerations.ReceiverType;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.guiutil.ScrollWhenFocusedPane;
import alma.obsprep.ot.models.sciencegoals.SelectedSpectralLineValidatorInterface;
import alma.obsprep.ot.models.sciencegoals.SpectralWindowGroupModel;
import alma.obsprep.services.experts.spectralline.SpectralLine;
import alma.obsprep.services.experts.spectralline.gui.AvailableLinesTableFormat;
import alma.obsprep.services.experts.spectralline.gui.FilteredCatalogue;
import alma.obsprep.services.experts.spectralline.gui.FilteredCatalogueControlPanel;
import alma.obsprep.services.experts.spectralline.gui.LineSelectorDialog;
import alma.obsprep.services.experts.spectralline.gui.SelectedLinesTableFormat;
import alma.obsprep.services.experts.spectralline.gui.SpectralLineSelectorInterface;
import alma.obsprep.services.experts.spectralline.gui.TableCellRendererFactory;
import alma.obsprep.services.experts.spectralline.gui.TableColumnResizer;
import alma.obsprep.services.experts.spectralline.gui.filters.BasebandMatcher;
import alma.obsprep.services.experts.spectralline.gui.filters.DoubleSidebandMatcher;
import alma.obsprep.services.experts.spectralline.gui.filters.SidebandMatcherEditor;
import alma.obsprep.services.experts.spectralline.gui.filters.SingleSidebandMatcher;
import alma.obsprep.util.GUIUtilities;
import alma.valuetypes.Frequency;
import alma.valuetypes.Velocity;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.matchers.Matcher;
import ca.odell.glazedlists.swing.EventTableModel;
import ca.odell.glazedlists.swing.TableComparatorChooser;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class MultiLineSelectorDialog
extends LineSelectorDialog
implements SpectralLineSelectorInterface,
ItemListener {
    private EnumMap<UILabels, String> uiLabellingMap = new EnumMap(UILabels.class);
    private final FilteredCatalogue catalogue;
    private final EventList<SpectralLine> baseSelected = new BasicEventList();
    private final SortedList<SpectralLine> sortedSelected = new SortedList(this.baseSelected, null);
    private final Velocity velocity;
    private final boolean isBasebandUnconstrained;
    private JButton addButton;
    private JLabel availableLabel;
    private JPanel availablePanel;
    private JScrollPane availableScrollPane;
    private JTable availableTable;
    private JButton cancelButton;
    protected FilteredCatalogueControlPanel filterControlPanel;
    private JButton okButton;
    private JButton removeButton;
    private JPanel selectedPanel;
    private JScrollPane selectedScrollPane;
    private JTable selectedTable;
    private JLabel selectedTableLabel;
    private JSplitPane splitPane;
    private SelectedSpectralLineValidatorInterface selectedLineValidator = null;
    private JLabel helpNotes;
    protected Optional<SpectralSetupParameters> ssp = Optional.empty();
    private boolean isModal = true;
    private Optional<String> dialogTitle = Optional.empty();
    private static FilteredCatalogueControlPanel.ObservableLineFilter lastLineFilterSelected = FilteredCatalogueControlPanel.ObservableLineFilter.PotentiallySelectableLinesFilter;

    public MultiLineSelectorDialog(Frame frame, EventList<SpectralLine> eventList, List<SpectralLine> list, Velocity velocity, boolean bl, Optional<SpectralSetupParameters> optional, Optional<String> optional2) {
        super(frame);
        if (bl) {
            this.uiLabellingMap.put(UILabels.ADDBUTTONLABEL, "Add to Selected Transitions");
            this.uiLabellingMap.put(UILabels.SELECTEDWINDOWHEADER, "Selected Transitions");
            this.uiLabellingMap.put(UILabels.REMOVEBUTTONLABEL, "Remove from selected transitions");
        } else {
            this.uiLabellingMap.put(UILabels.ADDBUTTONLABEL, "Add to spectral window list");
            this.uiLabellingMap.put(UILabels.SELECTEDWINDOWHEADER, "Spectral windows in this baseband (maximum of four)");
            this.uiLabellingMap.put(UILabels.REMOVEBUTTONLABEL, "Remove spectral window(s)");
        }
        this.catalogue = new FilteredCatalogue(eventList);
        this.velocity = velocity;
        this.isBasebandUnconstrained = bl;
        this.ssp = optional;
        this.dialogTitle = optional2;
        this.setupUI(list, velocity, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setupUI(List<SpectralLine> list, Velocity velocity, boolean bl) {
        this.initComponents();
        TableColumn tableColumn = this.availableTable.getColumnModel().getColumn(2);
        tableColumn.setCellRenderer(TableCellRendererFactory.getTableCellRenderer(TableCellRendererFactory.Units.FREQUENCY));
        tableColumn = this.availableTable.getColumnModel().getColumn(3);
        tableColumn.setCellRenderer(TableCellRendererFactory.getTableCellRenderer(TableCellRendererFactory.Units.FREQUENCY));
        tableColumn = this.availableTable.getColumnModel().getColumn(4);
        tableColumn.setCellRenderer(TableCellRendererFactory.getTableCellRenderer(TableCellRendererFactory.Units.TEMPERATURE));
        tableColumn = this.availableTable.getColumnModel().getColumn(6);
        tableColumn.setCellRenderer(TableCellRendererFactory.getTableCellRenderer(TableCellRendererFactory.Units.DEBYE_SQUARED));
        tableColumn = this.selectedTable.getColumnModel().getColumn(2);
        tableColumn.setCellRenderer(TableCellRendererFactory.getTableCellRenderer(TableCellRendererFactory.Units.FREQUENCY));
        tableColumn = this.selectedTable.getColumnModel().getColumn(3);
        tableColumn.setCellRenderer(TableCellRendererFactory.getTableCellRenderer(TableCellRendererFactory.Units.FREQUENCY));
        this.filterControlPanel.setVelocity(velocity);
        this.filterControlPanel.clearHideObservableLineFilters();
        if (list != null) {
            this.baseSelected.getReadWriteLock().writeLock().lock();
            try {
                this.baseSelected.addAll(list);
            }
            finally {
                this.baseSelected.getReadWriteLock().writeLock().unlock();
            }
        }
        this.filterControlPanel.controlCatalogue(this.catalogue);
        this.filterControlPanel.registerTable(this.selectedTable);
        FilteredCatalogueControlPanel.ObservableLineFilter observableLineFilter = lastLineFilterSelected;
        this.filterControlPanel.setStateNonObservableLineFilters(true);
        if (bl) {
            this.filterControlPanel.setLinesFilterType(observableLineFilter);
            this.filterControlPanel.setHideNonObservableLinesRadioButtonHandler(this);
        }
        SortedList<SpectralLine> sortedList = this.catalogue.getSorted();
        TableComparatorChooser tableComparatorChooser = TableComparatorChooser.install((JTable)this.availableTable, sortedList, (Object)TableComparatorChooser.MULTIPLE_COLUMN_MOUSE, (TableFormat)new AvailableLinesTableFormat(velocity));
        tableComparatorChooser.fromString("column 2, column 0");
        tableComparatorChooser = TableComparatorChooser.install((JTable)this.selectedTable, this.sortedSelected, (Object)TableComparatorChooser.MULTIPLE_COLUMN_MOUSE, (TableFormat)new SelectedLinesTableFormat(velocity));
        tableComparatorChooser.fromString("column 2, column 0");
        TableColumnResizer.resize(this.availableTable);
        TableColumnResizer.resize(this.selectedTable);
        this.setAddButtonState();
        this.setRemoveButtonState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addLinesToSelectedLinePool() {
        Object object;
        Object object2;
        Object object3;
        ArrayList<SpectralLine> arrayList = new ArrayList<SpectralLine>();
        for (int n : this.availableTable.getSelectedRows()) {
            object3 = this.catalogue.get(n);
            if (object3 != null) {
                arrayList.add((SpectralLine)object3);
            }
            if (!this.isBasebandUnconstrained && SpectralWindowGroupModel.MAX_WINDOWS_PER_BASEBAND <= arrayList.size()) break;
        }
        this.baseSelected.getReadWriteLock().readLock().lock();
        try {
            arrayList.removeAll((Collection<?>)this.baseSelected);
            object2 = new LinkedHashSet();
            for (SpectralLine spectralLine2 : this.baseSelected) {
                object2.add(new BasicSpectralLine(spectralLine2));
            }
            object = new LinkedHashSet();
            for (SpectralLine spectralLine3 : arrayList) {
                object.add(new BasicSpectralLine(spectralLine3));
            }
            object.removeAll((Collection<?>)object2);
            arrayList.clear();
            Object object4 = object.iterator();
            while (object4.hasNext()) {
                BasicSpectralLine basicSpectralLine = (BasicSpectralLine)object4.next();
                arrayList.add(basicSpectralLine.getWrapped());
            }
        }
        finally {
            this.baseSelected.getReadWriteLock().readLock().unlock();
        }
        if (this.filterControlPanel.isHideObservableLineFilterEnabled() && !this.isBasebandUnconstrained) {
            object2 = new ArrayList();
            object = new ArrayList<BasicSpectralLine>();
            for (SpectralLine spectralLine4 : arrayList) {
                object3 = spectralLine4.getFrequency();
                Frequency frequency = this.velocity.dopplerShift((Frequency)((Object)object3));
                boolean bl = true;
                Iterator<Object> iterator = object2.iterator();
                while (iterator.hasNext()) {
                    Object object5 = (Matcher)iterator.next();
                    if (object5.matches((Object)spectralLine4)) continue;
                    bl = false;
                    object.add(spectralLine4);
                }
                if (!bl) continue;
                for (Object object5 : ReceiverBand.getFullReceiverBands()) {
                    if (((ReceiverBand)object5).getRFRange().contains(frequency)) {
                        ReceiverType receiverType = ((ReceiverBand)object5).getReceiverType();
                        if (ReceiverType.SSB.equals((Object)receiverType)) {
                            object2.add(new SingleSidebandMatcher(frequency, (ReceiverBand)object5, this.velocity, SidebandMatcherEditor.MIN_BANDWIDTH));
                        } else {
                            object2.add(new DoubleSidebandMatcher(frequency, (ReceiverBand)object5, this.velocity, SidebandMatcherEditor.MIN_BANDWIDTH));
                        }
                    }
                    object2.add(new BasebandMatcher(frequency, this.velocity, SidebandMatcherEditor.MIN_BANDWIDTH));
                }
            }
            arrayList.removeAll((Collection<?>)object);
        }
        try {
            this.baseSelected.getReadWriteLock().writeLock().lock();
            int n = this.baseSelected.size();
            n = (int)((long)n + arrayList.stream().filter(spectralLine -> this.isBasebandUnconstrained || this.baseSelected.size() < SpectralWindowGroupModel.MAX_WINDOWS_PER_BASEBAND).count());
            if (this.isBasebandUnconstrained && n > 50) {
                GUIUtilities.info(null, String.format("<html>A maximum of %d transitions may be selected.</html>", 50));
                return;
            }
            for (Object object4 : arrayList) {
                if (this.isBasebandUnconstrained || this.baseSelected.size() < SpectralWindowGroupModel.MAX_WINDOWS_PER_BASEBAND) {
                    this.baseSelected.add(object4);
                    continue;
                }
                break;
            }
        }
        finally {
            this.baseSelected.getReadWriteLock().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeLinesFromSelected() {
        ArrayList<SpectralLine> arrayList = new ArrayList<SpectralLine>();
        this.sortedSelected.getReadWriteLock().readLock().lock();
        try {
            for (int n : this.selectedTable.getSelectedRows()) {
                arrayList.add((SpectralLine)this.sortedSelected.get(n));
            }
        }
        finally {
            this.sortedSelected.getReadWriteLock().readLock().unlock();
        }
        this.baseSelected.getReadWriteLock().writeLock().lock();
        try {
            if (this.baseSelected.size() == arrayList.size()) {
                this.baseSelected.clear();
            } else {
                this.baseSelected.removeAll(arrayList);
            }
        }
        finally {
            this.baseSelected.getReadWriteLock().writeLock().unlock();
        }
    }

    private void initComponents() {
        this.filterControlPanel = FilteredCatalogueControlPanel.getInstance();
        this.filterControlPanel.setSpectralLinePicker(this);
        this.filterControlPanel.setSpectralSetupParameters(this.ssp);
        this.splitPane = new JSplitPane();
        this.availablePanel = new JPanel();
        this.availableLabel = new JLabel();
        this.availableScrollPane = new ScrollWhenFocusedPane();
        this.availableTable = new JTable();
        this.availableTable.getTableHeader().setReorderingAllowed(false);
        this.addButton = new JButton();
        this.selectedPanel = new JPanel();
        this.removeButton = new JButton();
        this.selectedScrollPane = new ScrollWhenFocusedPane();
        this.selectedTable = new JTable();
        this.selectedTableLabel = new JLabel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.helpNotes = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle(this.dialogTitle.orElse("Create spectral windows centred on spectral lines"));
        this.setModal(this.isModal);
        this.setName("Form");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                MultiLineSelectorDialog.this.formWindowClosing(windowEvent);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
                MultiLineSelectorDialog.this.dispose();
                if (MultiLineSelectorDialog.this.publisher != null) {
                    MultiLineSelectorDialog.this.publisher.complete();
                }
            }
        });
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setOrientation(0);
        this.availableLabel.setFont(this.availableLabel.getFont().deriveFont(this.availableLabel.getFont().getStyle() | 1));
        this.availableLabel.setText("Transitions matching your filter settings:");
        this.helpNotes.setText("(double-click column header for primary sort, single-click subsequent columns for secondary sorting. Single clicks will reverse sort order of already selected columns.)");
        this.availableTable.setModel(this.catalogue.getTableModel(this.velocity));
        this.availableTable.setSelectionModel((ListSelectionModel)this.catalogue.getSelectionModel());
        this.availableTable.setSelectionMode(2);
        this.availableTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                MultiLineSelectorDialog.this.availableTableMouseClicked(mouseEvent);
            }
        });
        this.availableTable.getSelectionModel().addListSelectionListener(listSelectionEvent -> this.setAddButtonState());
        this.availableScrollPane.setViewportView(this.availableTable);
        this.addButton.setText(this.uiLabellingMap.get((Object)UILabels.ADDBUTTONLABEL));
        this.addButton.setToolTipText("Add the highlighted lines to your selection");
        this.addButton.addActionListener(actionEvent -> this.addButtonActionPerformed(actionEvent));
        this.addButton.setEnabled(false);
        GroupLayout groupLayout = new GroupLayout(this.availablePanel);
        this.availablePanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.availableLabel).addContainerGap(222, Short.MAX_VALUE)).addComponent(this.helpNotes).addComponent(this.addButton, -1, 274, Short.MAX_VALUE).addComponent(this.availableScrollPane, -1, 274, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.availableLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.helpNotes).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.availableScrollPane, -1, 321, Short.MAX_VALUE).addGap(0, 0, 0).addComponent(this.addButton, -2, 26, -2)));
        this.splitPane.setLeftComponent(this.availablePanel);
        this.removeButton.setText(this.uiLabellingMap.get((Object)UILabels.REMOVEBUTTONLABEL));
        this.removeButton.setToolTipText("Remove the highlighted lines from your selection");
        this.removeButton.addActionListener(actionEvent -> this.removeButtonActionPerformed(actionEvent));
        this.removeButton.setEnabled(false);
        this.selectedTable.setModel((TableModel)new EventTableModel(this.sortedSelected, (TableFormat)new SelectedLinesTableFormat(this.velocity)));
        this.selectedTable.setSelectionMode(2);
        this.selectedTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                MultiLineSelectorDialog.this.selectedTableMouseClicked(mouseEvent);
            }
        });
        this.selectedTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                MultiLineSelectorDialog.this.setRemoveButtonState();
            }
        });
        TableColumn tableColumn = this.selectedTable.getColumnModel().getColumn(0);
        tableColumn.setCellRenderer(TableCellRendererFactory.getTableCellRenderer(TableCellRendererFactory.Units.LINETITLE));
        this.selectedScrollPane.setViewportView(this.selectedTable);
        this.selectedTableLabel.setFont(this.selectedTableLabel.getFont().deriveFont(this.selectedTableLabel.getFont().getStyle() | 1));
        this.selectedTableLabel.setText(this.uiLabellingMap.get((Object)UILabels.SELECTEDWINDOWHEADER));
        GroupLayout groupLayout2 = new GroupLayout(this.selectedPanel);
        this.selectedPanel.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addComponent(this.selectedTableLabel).addContainerGap(222, Short.MAX_VALUE)).addComponent(this.removeButton, -1, 267, Short.MAX_VALUE).addComponent(this.selectedScrollPane, -1, 267, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.CENTER, groupLayout2.createSequentialGroup().addComponent(this.selectedTableLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.selectedScrollPane, -1, 321, Short.MAX_VALUE).addGap(0, 0, 0).addComponent(this.removeButton)));
        this.splitPane.setRightComponent(this.selectedPanel);
        this.splitPane.addComponentListener(new ComponentAdapter(){
            private boolean firstResize = true;

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                if (this.firstResize) {
                    MultiLineSelectorDialog.this.splitPane.setResizeWeight(0.7);
                    MultiLineSelectorDialog.this.splitPane.setDividerLocation(0.7);
                    this.firstResize = false;
                }
            }
        });
        this.okButton.setText("Ok");
        this.okButton.setToolTipText("Accept selected lines and close the dialog");
        this.okButton.addActionListener(actionEvent -> this.okButtonActionPerformed(actionEvent));
        this.cancelButton.setText("Cancel");
        this.cancelButton.setToolTipText("Cancel selection and return to the application");
        this.cancelButton.addActionListener(actionEvent -> this.cancelButtonActionPerformed(actionEvent));
        JPanel jPanel = new JPanel();
        GroupLayout groupLayout3 = new GroupLayout(jPanel);
        jPanel.setLayout(groupLayout3);
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        this.getContentPane().add(jScrollPane);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addContainerGap().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(groupLayout3.createSequentialGroup().addComponent(this.filterControlPanel, -2, -1, -2).addGap(18, 18, 18).addComponent(this.splitPane, -1, 547, Short.MAX_VALUE)).addGroup(groupLayout3.createSequentialGroup().addComponent(this.cancelButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.okButton))).addContainerGap()));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addContainerGap().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.filterControlPanel, -2, -1, -2).addComponent(this.splitPane, -1, 367, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton)).addContainerGap()));
        this.pack();
        this.addButton.setName("MultiLineSelectorDialog.addButton");
        this.availableLabel.setName("MultiLineSelectorDialog.availableLabel");
        this.helpNotes.setName("MultiLineSelectorDialog.helpNotes");
        this.availablePanel.setName("MultiLineSelectorDialog.availablePanel");
        this.availableScrollPane.setName("MultiLineSelectorDialog.availableScrollPane");
        this.availableTable.setName("MultiLineSelectorDialog.availableTable");
        this.cancelButton.setName("MultiLineSelectorDialog.cancelButton");
        this.filterControlPanel.setName("MultiLineSelectorDialog.filterControlPanel");
        this.okButton.setName("MultiLineSelectorDialog.okButton");
        this.removeButton.setName("MultiLineSelectorDialog.removeButton");
        this.selectedPanel.setName("MultiLineSelectorDialog.selectedPanel");
        this.selectedScrollPane.setName("MultiLineSelectorDialog.selectedScrollPane");
        this.selectedTable.setName("MultiLineSelectorDialog.selectedTable");
        this.selectedTableLabel.setName("MultiLineSelectorDialog.selectedTableLabel");
        this.splitPane.setName("MultiLineSelectorDialog.splitPane");
    }

    private void addButtonActionPerformed(ActionEvent actionEvent) {
        this.addLinesToSelectedLinePool();
        this.setAddButtonState();
    }

    private void removeButtonActionPerformed(ActionEvent actionEvent) {
        this.removeLinesFromSelected();
        this.setAddButtonState();
    }

    private void selectedTableMouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() > 1) {
            this.removeLinesFromSelected();
            this.setAddButtonState();
        }
    }

    private void availableTableMouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() > 1) {
            this.addLinesToSelectedLinePool();
            this.setAddButtonState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void okButtonActionPerformed(ActionEvent actionEvent) {
        boolean bl = true;
        this.sortedSelected.getReadWriteLock().readLock().lock();
        if (this.selectedLineValidator != null) {
            bl = this.selectedLineValidator.verifySelectedLinesAreValid(this.sortedSelected);
        }
        if (!bl) {
            this.sortedSelected.getReadWriteLock().readLock().unlock();
            GUIUtilities.error(null, "<html><left>One or more of the selected lines do not fall within the spectral <br>windows which have been defined in the spectral setup.</left></html>");
            return;
        }
        this.dispose();
        ArrayList<SpectralLine> arrayList = new ArrayList<SpectralLine>();
        try {
            for (SpectralLine spectralLine : this.sortedSelected) {
                arrayList.add(new SpectralLine(spectralLine));
            }
        }
        finally {
            this.sortedSelected.getReadWriteLock().readLock().unlock();
        }
        if (this.publisher != null) {
            this.publisher.publish(arrayList);
            this.publisher.complete();
        }
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.dispose();
        if (this.publisher != null) {
            this.publisher.complete();
        }
    }

    private void formWindowClosing(WindowEvent windowEvent) {
        if (this.publisher != null) {
            this.publisher.complete();
        }
    }

    private void setAddButtonState() {
        if (this.availableTable.getSelectedRows().length > 0 && (this.isBasebandUnconstrained || SpectralWindowGroupModel.MAX_WINDOWS_PER_BASEBAND > this.selectedTable.getModel().getRowCount())) {
            this.addButton.setEnabled(true);
        } else {
            this.addButton.setEnabled(false);
        }
    }

    private void setRemoveButtonState() {
        if (this.selectedTable.getSelectedRows().length > 0) {
            this.removeButton.setEnabled(true);
        } else {
            this.removeButton.setEnabled(false);
        }
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.splitPane.setResizeWeight(0.8);
            this.splitPane.setDividerLocation(0.8);
        }
    }

    public void setLo1(Frequency frequency) {
        this.filterControlPanel.setLo1(frequency);
        if (frequency == null) {
            this.filterControlPanel.setStateNonObservableLineFilters(false);
        } else {
            FilteredCatalogueControlPanel.ObservableLineFilter observableLineFilter = lastLineFilterSelected;
            this.filterControlPanel.setStateNonObservableLineFilters(true);
            this.filterControlPanel.setLinesFilterType(observableLineFilter);
        }
    }

    public void setLinesInOtherBasebands(Collection<SpectralLine> collection) {
        this.filterControlPanel.setLinesInOtherBasebands(collection);
    }

    @Override
    public boolean isLinesSelected() {
        return !this.sortedSelected.isEmpty();
    }

    public void setSelectedLineValidator(SelectedSpectralLineValidatorInterface selectedSpectralLineValidatorInterface) {
        this.selectedLineValidator = selectedSpectralLineValidatorInterface;
    }

    @Override
    public boolean isModal() {
        return this.isModal;
    }

    @Override
    public void setModal(boolean bl) {
        this.isModal = bl;
    }

    public boolean isBasebandUnconstrained() {
        return this.isBasebandUnconstrained;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Component component = (Component)itemEvent.getSource();
        lastLineFilterSelected = this.filterControlPanel.getObservableFilterSelected(component);
    }

    public EnumMap<UILabels, String> getUiLabellingMap() {
        return this.uiLabellingMap;
    }

    public void setUiLabellingMap(EnumMap<UILabels, String> enumMap) {
        this.uiLabellingMap = enumMap;
    }

    class BasicSpectralLine {
        private SpectralLine wrapped;

        public BasicSpectralLine(SpectralLine spectralLine) {
            this.wrapped = spectralLine;
        }

        public Frequency getFrequency() {
            return this.wrapped.getFrequency();
        }

        public String getTitle() {
            return this.wrapped.getTitle();
        }

        public SpectralLine getWrapped() {
            return this.wrapped;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof BasicSpectralLine)) {
                return false;
            }
            BasicSpectralLine basicSpectralLine = (BasicSpectralLine)object;
            boolean bl = basicSpectralLine.getFrequency().equals((Object)this.getFrequency());
            return bl && basicSpectralLine.getTitle().equals(this.getTitle());
        }

        public int hashCode() {
            int n = 1723;
            n = 31 * n + this.wrapped.getFrequency().hashCode();
            n = 31 * n + this.wrapped.getTitle().hashCode();
            return n;
        }
    }

    static enum UILabels {
        SELECTEDWINDOWHEADER,
        ADDBUTTONLABEL,
        REMOVEBUTTONLABEL;

    }
}

