/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.experts.spectralline.gui;

import alma.obsprep.services.experts.spectralline.SpectralLine;
import alma.valuetypes.Frequency;
import alma.valuetypes.Velocity;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.gui.AdvancedTableFormat;
import java.util.Comparator;

public class AvailableLinesTableFormat
implements AdvancedTableFormat<SpectralLine> {
    private final Velocity velocity;

    public AvailableLinesTableFormat(Velocity velocity) {
        this.velocity = velocity.deepCopy();
    }

    public int getColumnCount() {
        return 8;
    }

    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return "Transition";
            }
            case 1: {
                return "Description";
            }
            case 2: {
                return "Rest Frequency";
            }
            case 3: {
                return "Sky Frequency";
            }
            case 4: {
                return "Upper-state Energy";
            }
            case 5: {
                return "Lovas Intensity";
            }
            case 6: {
                return "Sij \u03bc\u00b2";
            }
            case 7: {
                return "Catalog";
            }
        }
        throw new IllegalStateException();
    }

    public Object getColumnValue(SpectralLine spectralLine, int n) {
        switch (n) {
            case 0: {
                return spectralLine.getTitle();
            }
            case 1: {
                return spectralLine.getDescription();
            }
            case 2: {
                return spectralLine.getFrequency().getContentInUnits(Frequency.UNIT_HZ);
            }
            case 3: {
                Frequency frequency = spectralLine.getFrequency().dopplerShifted(this.velocity);
                return frequency.getContentInUnits(Frequency.UNIT_HZ);
            }
            case 4: {
                return spectralLine.getUpperStateEnergy();
            }
            case 5: {
                return spectralLine.getObservedIntensity();
            }
            case 6: {
                return spectralLine.getSmu();
            }
            case 7: {
                return spectralLine.getProvenance();
            }
        }
        throw new IllegalStateException();
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return Double.class;
            }
            case 3: {
                return Double.class;
            }
            case 4: {
                return Double.class;
            }
            case 5: {
                return Double.class;
            }
            case 6: {
                return Double.class;
            }
            case 7: {
                return String.class;
            }
        }
        throw new IllegalStateException();
    }

    public Comparator getColumnComparator(int n) {
        switch (n) {
            case 0: {
                return GlazedLists.caseInsensitiveComparator();
            }
            case 1: {
                return GlazedLists.caseInsensitiveComparator();
            }
            case 2: {
                return GlazedLists.comparableComparator();
            }
            case 3: {
                return GlazedLists.comparableComparator();
            }
            case 4: {
                return GlazedLists.comparableComparator();
            }
            case 5: {
                return GlazedLists.comparableComparator();
            }
            case 6: {
                return GlazedLists.comparableComparator();
            }
            case 7: {
                return GlazedLists.caseInsensitiveComparator();
            }
        }
        throw new IllegalStateException();
    }
}

