/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.experts.calibrators;

import alma.common.sourcecatalog.CatalogQueryParameters;
import alma.common.sourcecatalog.SourceCatalogQueryParameters;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.obsproject.QuerySource;
import alma.obsprep.bo.obsproject.QuerySourceAdapter;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.services.experts.calibrators.CalibratorExpertController;
import alma.obsprep.services.experts.calibrators.CalibratorExpertEditor;
import alma.obsprep.services.experts.calibrators.CalibratorExpertModel;
import java.util.logging.Level;
import javax.swing.JFrame;

public class CalibratorTool {
    private static final SourceCatalogQueryParameters junk = new CatalogQueryParameters();

    public CalibratorTool(JFrame jFrame) {
        QuerySource querySource = QuerySource.createQuerySource(QuerySource.INTENDEDUSE_AMPLITUDE);
        QuerySourceAdapter querySourceAdapter = new QuerySourceAdapter(querySource);
        CalibratorExpertModel calibratorExpertModel = new CalibratorExpertModel(querySourceAdapter);
        CalibratorExpertEditor calibratorExpertEditor = new CalibratorExpertEditor(calibratorExpertModel);
        CalibratorExpertController calibratorExpertController = new CalibratorExpertController();
        calibratorExpertModel.subscribe(calibratorExpertController);
        jFrame.getContentPane().add(calibratorExpertEditor);
    }

    public static void main(String[] stringArray) {
        try {
            InitServices.init();
        }
        catch (Exception exception) {
            Log.logger(CalibratorTool.class).log(Level.WARNING, "", (Throwable)exception);
        }
        JFrame jFrame = new JFrame("ALMA Calibrator Selection Tool");
        CalibratorTool calibratorTool = new CalibratorTool(jFrame);
        jFrame.setDefaultCloseOperation(3);
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

