/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.experts;

import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.hla.runtime.obsprep.interfaces.PropertyChangeNotifier;
import alma.observatorycharacteristics.site.SiteCharacteristics;
import alma.obsprep.bo.enumerations.Antenna;
import alma.obsprep.bo.enumerations.ReceiverType;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.services.etc.AtmosphereTable;
import alma.obsprep.services.etc.ExposureTimeCalculator;
import alma.obsprep.services.etc.SourceNeverVisibleException;
import alma.obsprep.services.etc.editor.WaterVaporColumns;
import alma.obsprep.services.experts.InvalidFrequencyException;
import alma.obsprep.services.experts.ReceiverTemperature;
import alma.obsprep.util.DoubleRange;
import alma.obsprep.util.FrequencyRange;
import alma.obsprep.util.Range;
import alma.obsprep.util.VupRange;
import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import alma.valuetypes.Latitude;
import alma.valuetypes.Sensitivity;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.Speed;
import alma.valuetypes.Temperature;
import alma.valuetypes.UserSensitivity;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class ReceiverBandProperties {
    private final ReceiverBand band;
    private String title;
    private Frequency ifmin;
    private Frequency ifmax;
    private FrequencyRange ifrange;
    private Frequency rfmin;
    private Frequency rfmax;
    private FrequencyRange rfrange;
    private Range<Temperature> trxRange;
    private Range<Temperature> tsysRange;
    private Range<Double> opacityRange;
    private Speed velocityResolution;
    private Range<Temperature> brightnessTempUnitRange;
    private Range<Angle> beamsize12mRange;
    private Range<Angle> beamsize7mRange;
    private Range<Angle> resln12mArrRange;
    private Range<Angle> resln7mArrRange;
    private PropertyChangeListener guard;
    private static Map<ReceiverBand, ReceiverBandProperties> store = new HashMap<ReceiverBand, ReceiverBandProperties>();

    public static ReceiverBandProperties getReceiverBandProperties(ReceiverBand receiverBand) {
        ReceiverBandProperties receiverBandProperties = store.get(receiverBand);
        if (receiverBandProperties == null) {
            receiverBandProperties = new ReceiverBandProperties(receiverBand);
            store.put(receiverBand, receiverBandProperties);
        }
        return receiverBandProperties;
    }

    private ReceiverBandProperties(ReceiverBand receiverBand) {
        this.band = receiverBand == null ? ReceiverBand.ILLEGAL_RECEIVER : receiverBand;
    }

    public String getTitleString() {
        if (this.title == null) {
            if (this.band == ReceiverBand.ILLEGAL_RECEIVER) {
                this.title = "Invalid Frequency : No Receiver Band";
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(String.format("ALMA Band %02d General Properties : ", this.band.getNumber()));
                stringBuilder.append(String.format("%.0f - %.0f GHz ", this.band.getRFMin(), this.band.getRFMax()));
                stringBuilder.append(String.format("(%s)", this.band == ReceiverBand.ILLEGAL_RECEIVER ? this.band.getType() : this.band.getReceiverType()));
                this.title = stringBuilder.toString();
            }
        }
        return this.title;
    }

    public ReceiverType getReceiverType() {
        return this.band.getReceiverType();
    }

    private void guard(final PropertyChangeNotifier propertyChangeNotifier) {
        if (this.guard == null) {
            this.guard = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    throw new RuntimeException("This object can not be changed : " + propertyChangeNotifier);
                }
            };
        }
        propertyChangeNotifier.addPropertyChangeListener(this.guard);
    }

    public Frequency getIFMin() {
        if (this.ifmin == null) {
            this.ifmin = Frequency.createFrequencyGHZ(this.band.getIFMin());
            this.guard((PropertyChangeNotifier)this.ifmin);
        }
        return this.ifmin;
    }

    public Frequency getIFMax() {
        if (this.ifmax == null) {
            this.ifmax = Frequency.createFrequencyGHZ(this.band.getIFMax());
            this.guard((PropertyChangeNotifier)this.ifmax);
        }
        return this.ifmax;
    }

    public FrequencyRange getIFRange() {
        if (this.ifrange == null) {
            this.ifrange = new FrequencyRange(this.getIFMin(), this.getIFMax());
        }
        return this.ifrange;
    }

    public Frequency getRFMin() {
        if (this.rfmin == null) {
            this.rfmin = Frequency.createFrequencyGHZ(this.band.getRFMin());
            this.guard((PropertyChangeNotifier)this.rfmin);
        }
        return this.rfmin;
    }

    public Frequency getRFMax() {
        if (this.rfmax == null) {
            this.rfmax = Frequency.createFrequencyGHZ(this.band.getRFMax());
            this.guard((PropertyChangeNotifier)this.rfmax);
        }
        return this.rfmax;
    }

    public FrequencyRange getRFRange() {
        if (this.rfrange == null) {
            this.rfrange = new FrequencyRange(this.getRFMin(), this.getRFMax());
        }
        return this.rfrange;
    }

    public Range<Temperature> getTrxRange() {
        if (this.trxRange == null) {
            try {
                Temperature temperature = ReceiverTemperature.getReceiverTemperature((Frequency)((Object)this.getRFRange().mid()));
                this.trxRange = new VupRange<Temperature>(temperature, temperature);
            }
            catch (InvalidFrequencyException invalidFrequencyException) {
                Temperature temperature = Temperature.createTemperature();
                this.trxRange = new VupRange<Temperature>(temperature, temperature);
            }
        }
        return this.trxRange;
    }

    public Range<Temperature> getTsysRange() {
        if (this.tsysRange == null) {
            this.tsysRange = this.getTsysRange(this.band);
        }
        return this.tsysRange;
    }

    public Range<Double> getOpacityRange() {
        if (this.opacityRange == null) {
            this.opacityRange = this.getOpacityRange(this.band);
        }
        return this.opacityRange;
    }

    private Range<Temperature> getTsysRange(ReceiverBand receiverBand) {
        if (receiverBand == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: rb");
        }
        AtmosphereTable atmosphereTable = AtmosphereTable.getInstance();
        double d = SiteCharacteristics.getInstance().getObsLatitude().getContentInDeg();
        SkyCoordinates skyCoordinates = SkyCoordinates.createSkyCoordinates();
        skyCoordinates.getLatitude().setContentAndUnit(d, Latitude.UNIT_DEG);
        double d2 = receiverBand.getRFMin();
        double d3 = receiverBand.getRFMax();
        double d4 = 0.0;
        double d5 = Double.MAX_VALUE;
        for (double d6 = d2; d6 <= d3; d6 += 0.1) {
            double d7;
            int n = WaterVaporColumns.wvindexSelector(d6, d, Optional.ofNullable(receiverBand));
            try {
                d7 = ExposureTimeCalculator.getTsys(skyCoordinates, d, d6, n, Double.NaN, Optional.ofNullable(receiverBand));
            }
            catch (InvalidFrequencyException invalidFrequencyException) {
                throw new RuntimeException(invalidFrequencyException.getMessage());
            }
            catch (SourceNeverVisibleException sourceNeverVisibleException) {
                throw new RuntimeException(sourceNeverVisibleException.getMessage());
            }
            d4 = d7 > d4 ? d7 : d4;
            d5 = d7 < d5 ? d7 : d5;
        }
        Temperature temperature = Temperature.createTemperature((double)d4, (String)Temperature.UNIT_K);
        Temperature temperature2 = Temperature.createTemperature((double)d5, (String)Temperature.UNIT_K);
        return new VupRange<Temperature>(temperature2, temperature);
    }

    private Range<Double> getOpacityRange(ReceiverBand receiverBand) {
        AtmosphereTable atmosphereTable = AtmosphereTable.getInstance();
        SkyCoordinates skyCoordinates = SkyCoordinates.createSkyCoordinates();
        double d = SiteCharacteristics.getInstance().getObsLatitude().getContentInDeg();
        double d2 = receiverBand.getRFMin();
        double d3 = receiverBand.getRFMax();
        double d4 = 0.0;
        double d5 = Double.MAX_VALUE;
        for (double d6 = d2; d6 <= d3; d6 += 0.1) {
            int n = WaterVaporColumns.wvindexSelector(d6, d, Optional.ofNullable(receiverBand));
            AtmosphereTable.Data data = atmosphereTable.lookup((float)d6, n);
            double d7 = data.getTau();
            d4 = d7 > d4 ? d7 : d4;
            d5 = d7 < d5 ? d7 : d5;
        }
        DoubleRange doubleRange = new DoubleRange(d5, d4);
        return doubleRange;
    }

    public Speed getVelocityResolutionPerMHz() {
        if (this.velocityResolution == null) {
            Frequency frequency = Frequency.createFrequencyMHZ(1.0);
            Frequency frequency2 = (Frequency)((Object)this.getRFRange().mid());
            this.velocityResolution = Speed.getSpeedResolution(frequency, frequency2);
        }
        return this.velocityResolution;
    }

    public Range<Temperature> getBrightnessTempUnitRange() {
        if (this.brightnessTempUnitRange == null) {
            Angle angle = Angle.createAngle((double)1.0, (String)Angle.UNIT_ARCSEC);
            UserSensitivity userSensitivity = UserSensitivity.createUserSensitivity(1.0, Sensitivity.UNIT_MJY);
            userSensitivity.setBeamsize(angle);
            userSensitivity.setObservingFrequency(this.getRFMax().deepCopy());
            Temperature temperature = Temperature.createTemperature();
            temperature.setContentAndUnit((ValueUnitPair)userSensitivity.asTemperature());
            userSensitivity.setObservingFrequency(this.getRFMin().deepCopy());
            Temperature temperature2 = Temperature.createTemperature();
            temperature2.setContentAndUnit((ValueUnitPair)userSensitivity.asTemperature());
            this.brightnessTempUnitRange = new VupRange<Temperature>(temperature, temperature2);
        }
        return this.brightnessTempUnitRange;
    }

    public Range<Angle> getBeamsize12mRange() {
        if (this.beamsize12mRange == null) {
            Angle angle = Antenna.ANTENNA_12M.getBeamSize(this.getRFMax()).deepCopy();
            Angle angle2 = Antenna.ANTENNA_12M.getBeamSize(this.getRFMin()).deepCopy();
            this.beamsize12mRange = new VupRange<Angle>(angle, angle2);
        }
        return this.beamsize12mRange;
    }

    public Range<Angle> getBeamsize7mRange() {
        if (this.beamsize7mRange == null) {
            Angle angle = Antenna.ANTENNA_7M.getBeamSize(this.getRFMax()).deepCopy();
            Angle angle2 = Antenna.ANTENNA_7M.getBeamSize(this.getRFMin()).deepCopy();
            this.beamsize7mRange = new VupRange<Angle>(angle, angle2);
        }
        return this.beamsize7mRange;
    }
}

