/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.experts;

import alma.hla.runtime.obsprep.util.Log;
import alma.valuetypes.Angle;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.Speed;
import alma.valuetypes.Velocity;
import lombok.NonNull;
import org.la4j.Matrix;
import org.la4j.Vector;
import org.la4j.matrix.dense.Basic2DMatrix;
import org.la4j.vector.DenseVector;
import org.la4j.vector.dense.BasicVector;

public class BaryCentricVelocity {
    static double jdcnv(long l, long l2, long l3, long l4) {
        if (l2 < 1L || l2 > 12L) {
            throw new IllegalArgumentException("Illegal argument: month did not pass the test: month < 1 || month > 12");
        }
        if (l4 < 0L || l4 > 24L) {
            throw new IllegalArgumentException("Illegal argument: month did not pass the test: hour < 0 || hour > 24");
        }
        if (l3 < 0L || l3 > 31L) {
            throw new IllegalArgumentException("Illegal argument: day did not pass the test: day < 1 || day > 31");
        }
        long l5 = (long)((double)(l2 - 14L) / 12.0);
        double d = (double)(l3 - 32075L + (long)((double)(1461L * (l + 4800L + l5)) / 4.0) + (long)((double)(367L * (l2 - 2L - l5 * 12L)) / 12.0) - (long)((double)(3L * (long)((double)(l + 4900L + l5) / 100.0)) / 4.0)) + (double)l4 / 24.0 - 0.5;
        return d;
    }

    private static Vector multiplyVectors(@NonNull Vector vector, @NonNull Vector vector2) {
        if (vector == null) {
            throw new NullPointerException("a is marked non-null but is null");
        }
        if (vector2 == null) {
            throw new NullPointerException("b is marked non-null but is null");
        }
        if (vector.length() != vector2.length()) {
            throw new IllegalArgumentException("Vectors are not the same length");
        }
        double[] dArray = new double[vector.length()];
        for (int i = 0; i < vector.length(); ++i) {
            dArray[i] = vector.get(i) * vector2.get(i);
        }
        return BasicVector.fromArray((double[])dArray);
    }

    private static double pythonMod(double d, double d2) {
        return d - d2 * Math.floor(d / d2);
    }

    private static Basic2DMatrix premat(double d, double d2, @NonNull Epoch epoch) {
        double d3;
        double d4;
        double d5;
        double d6;
        if (epoch == null) {
            throw new NullPointerException("epoch is marked non-null but is null");
        }
        double d7 = 0.001 * (d2 - d);
        if (Epoch.FK4.equals((Object)epoch)) {
            d6 = 0.001 * (d - 1900.0);
            d5 = 4.84813681109536E-6 * d7 * (23042.53 + d6 * (139.75 + 0.06 * d6) + d7 * (30.23 - 0.27 * d6 + 18.0 * d7));
            d4 = 4.84813681109536E-6 * d7 * d7 * (79.27 + 0.66 * d6 + 0.32 * d7) + d5;
            d3 = 4.84813681109536E-6 * d7 * (20046.85 - d6 * (85.33 + 0.37 * d6) + d7 * (-42.67 - 0.37 * d6 - 41.8 * d7));
        } else {
            d6 = 0.001 * (d - 2000.0);
            d5 = 4.84813681109536E-6 * d7 * (23062.181 + d6 * (139.656 + 0.0139 * d6) + d7 * (30.188 - 0.344 * d6 + 17.998 * d7));
            d4 = 4.84813681109536E-6 * d7 * d7 * (79.28 + 0.41 * d6 + 0.205 * d7) + d5;
            d3 = 4.84813681109536E-6 * d7 * (20043.109 - d6 * (85.33 + 0.217 * d6) + d7 * (-42.665 - 0.217 * d6 - 41.833 * d7));
        }
        d6 = Math.sin(d5);
        double d8 = Math.sin(d4);
        double d9 = Math.sin(d3);
        double d10 = Math.cos(d5);
        double d11 = Math.cos(d4);
        double d12 = Math.cos(d3);
        double[][] dArrayArray = new double[][]{{d10 * d11 * d12 - d6 * d8, d6 * d11 + d10 * d8 * d12, d10 * d9}, {-d10 * d8 - d6 * d11 * d12, d10 * d11 - d6 * d8 * d12, -d6 * d9}, {-d11 * d9, -d8 * d9, d12}};
        return new Basic2DMatrix((double[][])dArrayArray);
    }

    private static BaryVelResult baryVel(double d2, double d3) {
        double[] dArray = new double[]{1.7400353, 628.33195099091, 5.2796E-6, 6.2565836, 628.30194572674, -2.618E-6, 4.7199666, 8399.7091449254, -1.978E-5, 0.19636505, 8433.466291172, -5.6044E-5, 4.1547339, 52.993466764997, 5.8845E-6, 4.6524223, 21.354275911213, 5.6797E-6, 4.2620486, 7.5025342197656, 5.5317E-6, 1.4740694, 3.8377331909193, 5.6093E-6};
        Matrix matrix = Matrix.from1DArray((int)8, (int)3, (double[])dArray);
        double[] dArray2 = new double[]{0.4093198, -2.27111E-4, -2.860401E-8};
        DenseVector denseVector = DenseVector.fromArray((double[])dArray2);
        double[] dArray3 = new double[]{0.01675104, -4.179579E-5, -1.260516E-7, 0.2220221, 0.02809917, 1.852532E-5, 1.589963, 0.03418075, 1.4302E-5, 2.994089, 0.02590824, 4.15584E-6, 0.8155457, 0.02486352, 6.83684E-6, 1.735614, 0.01763719, 6.37044E-6, 1.968564, 0.0152402, -2.517152E-6, 1.282417, 0.008703393, 2.289292E-5, 2.28082, 0.0191801, 4.48452E-6, 0.04833473, 1.641773E-4, -4.6542E-7, 0.05589232, -3.455092E-4, -7.38856E-7, 0.04634443, -2.658234E-5, 7.757E-8, 0.008997041, 6.329728E-6, -1.939256E-9, 0.02284178, -9.94159E-5, 6.7874E-8, 0.04350267, -6.839749E-5, -2.714956E-7, 0.01348204, 1.091504E-5, 6.90376E-7, 0.0310657, -1.665665E-4, -1.590188E-7};
        Matrix matrix2 = Matrix.from1DArray((int)17, (int)3, (double[])dArray3);
        double[] dArray4 = new double[]{5.0974222, -786.04195454652, 3.9584962, -575.33848094674, 1.633807, -1150.6769618935, 2.5487111, -393.02097727326, 4.9255514, -588.49265665348, 1.3363463, -550.76098609303, 1.6072053, -522.37501616674, 1.362948, -1179.0629318198, 5.5657014, -1097.7134971135, 5.0708205, -157.74000881978, 3.9318944, 52.96346478, 4.8989497, 39.809289073258, 1.3097446, 77.540959633708, 3.5147141, 79.618578146517, 3.5413158, -548.68336758022};
        Matrix matrix3 = Matrix.from1DArray((int)15, (int)2, (double[])dArray4);
        double[] dArray5 = new double[]{-2.279594E-5, 1.407414E-5, 8.273188E-6, 1.340565E-5, -2.490817E-7, -3.494537E-5, 2.860401E-7, 1.289448E-7, 1.627237E-5, -1.823138E-7, 6.593466E-7, 1.322572E-5, 9.258695E-6, -4.674248E-7, -3.646275E-7, 1.140767E-5, -2.049792E-5, -4.74793E-6, -2.638763E-6, -1.245408E-7, 9.516893E-6, -2.748894E-6, -1.319381E-6, -4.549908E-6, -1.864821E-7, 7.31099E-6, -1.92471E-6, -8.772849E-7, -3.334143E-6, -1.745256E-7, -2.603449E-6, 7.359472E-6, 3.168357E-6, 1.119056E-6, -1.655307E-7, -3.228859E-6, 1.308997E-7, 1.013137E-7, 2.403899E-6, -3.736225E-7, 3.442177E-7, 2.671323E-6, 1.832858E-6, -2.394688E-7, -3.478444E-7, 8.702406E-6, -8.421214E-6, -1.372341E-6, -1.455234E-6, -4.998479E-8, -1.488378E-6, -1.251789E-5, 5.226868E-7, -2.049301E-7, 0.0, -8.043059E-6, -2.9913E-6, 1.473654E-7, -3.154542E-7, 0.0, 3.699128E-6, -3.316126E-6, 2.901257E-7, 3.407826E-7, 0.0, 2.55012E-6, -1.241123E-6, 9.901116E-8, 2.210482E-7, 0.0, -6.351059E-7, 2.34165E-6, 1.061492E-6, 2.878231E-7, 0.0};
        Matrix matrix4 = Matrix.from1DArray((int)15, (int)5, (double[])dArray5);
        double[] dArray6 = new double[]{1.2896E-6, 0.5550147, 2.076942, 3.10281E-5, 4.035027, 0.3525565, 9.12419E-6, 0.9990265, 2.622706, 9.79324E-7, 5.508259, 15.59103};
        Matrix matrix5 = Matrix.from1DArray((int)4, (int)3, (double[])dArray6);
        double[] dArray7 = new double[]{5.167983, 8328.6911095275, 5.491315, -7214.06328381, 5.959853, 15542.754389685};
        Matrix matrix6 = Matrix.from1DArray((int)3, (int)2, (double[])dArray7);
        double[] dArray8 = new double[]{0.1097594, 2.896773E-7, 0.05450474, 1.438491E-7, -0.02223581, 5.083103E-8, 0.01002548, -2.291823E-8, 0.01148966, 5.658888E-8, 0.008249439, 4.063015E-8};
        Matrix matrix7 = Matrix.from1DArray((int)3, (int)4, (double[])dArray8);
        double[] dArray9 = new double[]{8.326827E-11, 1.843484E-11, 1.988712E-12, 1.881276E-12};
        DenseVector denseVector2 = DenseVector.fromArray((double[])dArray9);
        double d4 = (d2 - 2415020.0) / 36525.0;
        double[] dArray10 = new double[]{1.0, d4, d4 * d4};
        DenseVector denseVector3 = DenseVector.fromArray((double[])dArray10);
        Vector vector = denseVector3.multiply(matrix.transpose()).transform((n, d) -> BaryCentricVelocity.pythonMod(d, Math.PI * 2));
        double d5 = vector.get(0);
        Vector vector2 = vector.slice(1, 8);
        double d6 = vector2.get(0);
        double d7 = BaryCentricVelocity.pythonMod(BaryCentricVelocity.multiplyVectors((Vector)denseVector3, (Vector)denseVector).sum(), Math.PI * 2);
        Vector vector3 = denseVector3.multiply(matrix2.transpose()).transform((n, d) -> BaryCentricVelocity.pythonMod(d, Math.PI * 2));
        double d8 = vector3.get(0);
        Vector vector4 = denseVector3.slice(0, 2).multiply(matrix5.slice(0, 1, 4, 3).transpose()).transform((n, d) -> BaryCentricVelocity.pythonMod(d, Math.PI * 2)).transform((n, d) -> Math.sin(d));
        Matrix matrix8 = matrix5.slice(0, 0, 4, 1).rotate().rotate().rotate();
        double d9 = matrix8.multiply(vector4).sum() + d4 * -7.75702E-8 * vector4.get(2);
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = 0.0;
        for (int i = 0; i < 15; ++i) {
            double d13 = BaryCentricVelocity.pythonMod(matrix3.get(i, 0) + d4 * matrix3.get(i, 1), Math.PI * 2);
            double d14 = Math.cos(d13);
            double d15 = Math.sin(d13);
            d9 = d9 + matrix4.get(i, 0) * d14 + matrix4.get(i, 1) * d15;
            d11 = d11 + matrix4.get(i, 2) * d14 + matrix4.get(i, 3) * d15;
            if (i >= 11) continue;
            d10 += (matrix4.get(i, 1) * d14 - matrix4.get(i, 0) * d15) * matrix4.get(i, 4);
            d12 += (matrix4.get(i, 3) * d14 - matrix4.get(i, 2) * d15) * matrix4.get(i, 4);
        }
        double d16 = d8 * d8 / 4.0 * ((8.0 / d8 - d8) * Math.sin(d6) + 5.0 * Math.sin(2.0 * d6) + 4.333333333333333 * d8 * Math.sin(3.0 * d6));
        double d17 = d6 + d16;
        double d18 = Math.sin(d17);
        double d19 = Math.cos(d17);
        double d20 = (1.0 - d8 * d8) / (1.0 + d8 * d19);
        double d21 = 2.0 * d8 * 1.990969E-7 * ((1.0 + 1.5 * d8 * d8) * d19 + d8 * (1.25 - 0.5 * d18 * d18));
        double d22 = 1.990969E-7 * d8 * d18 / Math.sqrt(1.0 - d8 * d8);
        double d23 = 1.0 + d11;
        double d24 = d23 * (d22 + d20 * d12);
        double d25 = d23 * d20 * (1.990987E-7 + d21 + d10);
        double d26 = BaryCentricVelocity.pythonMod(d5 + d16 + d9, Math.PI * 2);
        double d27 = Math.sin(d26);
        double d28 = Math.cos(d26);
        double d29 = d24 * d28 - d25 * d27;
        double d30 = d24 * d27 + d25 * d28;
        d9 = 0.0;
        d10 = 0.0;
        double d31 = 0.0;
        double d32 = 0.0;
        for (int i = 0; i < 3; ++i) {
            double d33 = BaryCentricVelocity.pythonMod(matrix6.get(i, 0) + d4 * matrix6.get(i, 1), Math.PI * 2);
            double d34 = Math.sin(d33);
            double d35 = Math.cos(d33);
            d9 += matrix7.get(i, 0) * d34;
            d10 += matrix7.get(i, 1) * d35;
            d31 += matrix7.get(i, 2) * d35;
            d32 -= matrix7.get(i, 3) * d34;
        }
        double d36 = vector2.get(1) + d9;
        double d37 = Math.sin(d36);
        double d38 = Math.cos(d36);
        double d39 = 3.12214E-5 / (1.0 + d31);
        double d40 = d39 * (2.661699E-6 + d10);
        double d41 = d39 * d32;
        d29 = d29 + d40 * d37 + d41 * d38;
        d30 = d30 - d40 * d38 + d41 * d37;
        double d42 = -d39 * 2.399485E-7 * Math.cos(vector2.get(2));
        double d43 = d29 * 0.99999696;
        double d44 = d30 * 0.99999696;
        double d45 = d42 * 0.99999696;
        for (int i = 0; i < 4; ++i) {
            double d46 = vector2.get(i + 3);
            double d47 = vector3.get(i + 1);
            double d48 = vector3.get(i + 9);
            d36 = BaryCentricVelocity.pythonMod(d46 + 2.0 * d48 * Math.sin(d46 - d47), Math.PI * 2);
            d43 += denseVector2.get(i) * (Math.sin(d36) + d48 * Math.sin(d47));
            d44 -= denseVector2.get(i) * (Math.cos(d36) + d48 * Math.cos(d47));
            d45 -= denseVector2.get(i) * vector3.get(i + 13) * Math.cos(d46 - vector3.get(i + 5));
        }
        double d49 = Math.cos(d7);
        double d50 = Math.sin(d7);
        double d51 = d49 * d30 - d50 * d42;
        double d52 = d50 * d30 + d49 * d42;
        double d53 = d49 * d44 - d50 * d45;
        double d54 = d50 * d44 + d49 * d45;
        if (d3 == 0.0) {
            Vector vector5 = DenseVector.fromArray((double[])new double[]{d29, d51, d52}).multiply(1.4959787E8);
            Vector vector6 = DenseVector.fromArray((double[])new double[]{d43, d53, d54}).multiply(1.4959787E8);
            return new BaryVelResult(vector6, vector5);
        }
        double d55 = (d2 - 2415020.0 - 0.313) / 365.24219572 + 1900.0;
        Basic2DMatrix basic2DMatrix = BaryCentricVelocity.premat(d55, d3, Epoch.FK4);
        Vector vector7 = basic2DMatrix.transpose().multiply((Vector)DenseVector.fromArray((double[])new double[]{d29, d51, d52})).multiply(1.4959787E8);
        Vector vector8 = basic2DMatrix.transpose().multiply((Vector)DenseVector.fromArray((double[])new double[]{d43, d53, d54})).multiply(1.4959787E8);
        return new BaryVelResult(vector8, vector7);
    }

    public static Velocity calculateSunEarthBaryVelocityForDate(int n, int n2, int n3, int n4, double d, @NonNull SkyCoordinates skyCoordinates, @NonNull Velocity velocity) {
        if (skyCoordinates == null) {
            throw new NullPointerException("skyCoordinates is marked non-null but is null");
        }
        if (velocity == null) {
            throw new NullPointerException("velocityToTransform is marked non-null but is null");
        }
        double d2 = skyCoordinates.getLongitude().getContentInUnits(Angle.UNIT_RAD);
        double d3 = skyCoordinates.getLatitude().getContentInUnits(Angle.UNIT_RAD);
        Vector vector = BaryCentricVelocity.calculateEarthBaryVelocity(n, n2, n3, n4, d).getBaryCentricVelocity();
        assert (vector != null);
        double d4 = vector.get(0) * Math.cos(d3) * Math.cos(d2) + vector.get(1) * Math.cos(d3) * Math.sin(d2) + vector.get(2) * Math.sin(d3);
        d4 *= -1.0;
        if (Log.logger(BaryCentricVelocity.class).finer()) {
            Log.logger(BaryCentricVelocity.class).fine(String.format("ra %.10g", d2));
            Log.logger(BaryCentricVelocity.class).fine(String.format("dec %.10g", d3));
            Log.logger(BaryCentricVelocity.class).fine(String.format("velocity %.10g", d4));
            Log.logger(BaryCentricVelocity.class).fine(String.format("bcV[0] %.10g", vector.get(0)));
            Log.logger(BaryCentricVelocity.class).fine(String.format("bcV[1] %.10g", vector.get(1)));
            Log.logger(BaryCentricVelocity.class).fine(String.format("bcV[2] %.10g", vector.get(2)));
        }
        Velocity velocity2 = velocity.deepCopy();
        velocity2.getCenterVelocity().setContentAndUnit(d4, Speed.UNIT_KM_S);
        return velocity2;
    }

    static BaryVelResult calculateEarthBaryVelocity(long l, long l2, long l3, long l4, double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("Illegal argument: epoch (" + d + ") did not pass the test: epoch >= 0");
        }
        double d2 = BaryCentricVelocity.jdcnv(l, l2, l3, l4);
        BaryVelResult baryVelResult = BaryCentricVelocity.baryVel(d2, d);
        assert (baryVelResult != null);
        return baryVelResult;
    }

    public static void main(String[] stringArray) {
        BaryVelResult baryVelResult = BaryCentricVelocity.baryVel(123.0, 0.0);
        baryVelResult = BaryCentricVelocity.baryVel(123.0, 123.0);
        System.out.println(baryVelResult);
    }

    private static enum Epoch {
        FK4,
        FK5;

    }

    public static class BaryVelResult {
        @NonNull
        Vector baryCentricVelocity;
        @NonNull
        Vector heliocentricVelocity;

        public BaryVelResult(Vector vector, Vector vector2) {
            this.baryCentricVelocity = vector;
            this.heliocentricVelocity = vector2;
        }

        public String toString() {
            return "BaryCentricVelocity.BaryVelResult(baryCentricVelocity=" + this.getBaryCentricVelocity() + ", heliocentricVelocity=" + this.getHeliocentricVelocity() + ")";
        }

        @NonNull
        public Vector getBaryCentricVelocity() {
            return this.baryCentricVelocity;
        }

        @NonNull
        public Vector getHeliocentricVelocity() {
            return this.heliocentricVelocity;
        }
    }
}

