/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.etc.editor;

import alma.observatorycharacteristics.site.SiteCharacteristics;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.services.etc.AtmosphereTable;
import alma.obsprep.services.etc.ExposureTimeCalculator;
import alma.obsprep.services.etc.SourceNeverVisibleException;
import alma.obsprep.services.experts.InvalidFrequencyException;
import alma.valuetypes.Frequency;
import alma.valuetypes.Latitude;
import alma.valuetypes.Length;
import alma.valuetypes.SkyCoordinates;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.jcs.JCS;
import org.apache.commons.jcs.access.CacheAccess;

public class WaterVaporColumns {
    private static CacheAccess<String, Integer> wvCache = JCS.getInstance((String)"wvCache");
    public static final String CHOICE_AUTO = "Automatic Choice";
    public static final String CHOICE_MANUAL = "Manual Choice";
    public static final int WORST_WVINDEX = 6;
    private static final double timeIncreaseFactor = 2.0;
    private static Map<ReceiverBand, Integer> wvmap;
    private static final double obsLat;

    public static int wvindexSelector(ReceiverBand receiverBand) {
        Integer n = wvmap.get(receiverBand);
        if (n == null) {
            throw new IllegalArgumentException("Unknown ReceiverBand : " + receiverBand);
        }
        return n;
    }

    public static int wvindexSelector(Frequency frequency, Latitude latitude, Optional<ReceiverBand> optional) {
        return WaterVaporColumns.wvindexSelector(frequency.getContentInGHz(), latitude.getContentInDeg(), optional);
    }

    public static int wvindexSelector(double d, double d2, Optional<ReceiverBand> optional) {
        int n;
        Object object;
        Integer n2 = new Integer(Objects.hash(d, d2));
        if (!Double.isNaN(n2.intValue()) && (object = (Integer)wvCache.get((Object)n2.toString())) != null) {
            return (Integer)object;
        }
        object = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        double[] dArray = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        Object object2 = Double.MAX_VALUE;
        int n3 = -1;
        SkyCoordinates skyCoordinates = SkyCoordinates.createAbsoluteCoordinates();
        skyCoordinates.getLatitude().setContentInDeg(d2);
        for (n = 0; n < AtmosphereTable.WV_MAP.length; ++n) {
            try {
                double d3 = ExposureTimeCalculator.pointSourceExposureTime(1.0, d, 15.0, 1.0, skyCoordinates, 50, 12.0, obsLat, n, true, Double.NaN, 1.0, optional);
                object[n] = d3;
                dArray[n] = (double)(object[n] / object[0]);
            }
            catch (InvalidFrequencyException invalidFrequencyException) {
            }
            catch (SourceNeverVisibleException sourceNeverVisibleException) {
                // empty catch block
            }
            if (!(object[n] < object2)) continue;
            object2 = object[n];
        }
        for (n = 0; n < AtmosphereTable.WV_MAP.length; ++n) {
            if (!(dArray[n] > 2.0)) continue;
            n3 = n - 1;
            break;
        }
        if (n3 == -1) {
            n3 = AtmosphereTable.WV_MAP.length - 1;
        }
        wvCache.put((Object)n2.toString(), (Object)n3);
        return n3;
    }

    public static int wvindexSelectorUsingLength(Length length) {
        return WaterVaporColumns.wvindexSelectorUsingLength(length.getContent());
    }

    public static int wvindexSelectorUsingLength(double d) {
        double[] dArray = AtmosphereTable.WV_MAP_VALUES;
        int n = 0;
        for (int i = 0; i < AtmosphereTable.WV_MAP_VALUES.length; ++i) {
            if (!(dArray[i] <= d) || !(dArray[n] < dArray[i])) continue;
            n = i;
        }
        return n;
    }

    public static String getSelectorDescriptions(boolean bl) {
        String string = bl ? "<BR>" : "";
        String string2 = bl ? "&nbsp;&lt;&nbsp;" : " < ";
        String string3 = "35";
        String string4 = "163";
        String string5 = "163";
        String string6 = "275";
        String string7 = "275";
        String string8 = "500";
        String string9 = "602";
        String string10 = "950";
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(WaterVaporColumns.getWVIndexLabel(5)).append(" for Reciever Band 1 to 4 (").append(string3).append("GHz").append(string2).append("freq").append(string2).append(string4).append("GHz)").append(string);
        stringBuilder.append(WaterVaporColumns.getWVIndexLabel(4)).append(" for Reciever Band 5 and 6 (").append(string5).append("GHz").append(string2).append("freq").append(string2).append(string6).append("GHz)").append(string);
        stringBuilder.append(WaterVaporColumns.getWVIndexLabel(3)).append(" for Reciever Band 7 and 8 (").append(string7).append("GHz").append(string2).append("freq").append(string2).append(string8).append("GHz)").append(string);
        stringBuilder.append(WaterVaporColumns.getWVIndexLabel(1)).append(" for Reciever Band 9 and 10 (").append(string9).append("GHz").append(string2).append("freq").append(string2).append(string10).append("GHz)").append(string);
        return stringBuilder.toString();
    }

    public static int wvindexSelector(String string) {
        for (int i = 0; i < AtmosphereTable.WV_MAP.length; ++i) {
            if (!AtmosphereTable.WV_MAP[i].equals(string)) continue;
            return i;
        }
        return -1;
    }

    public static String getWVIndexLabel(int n) {
        if (n < 0) {
            return CHOICE_AUTO;
        }
        return AtmosphereTable.WV_MAP[n];
    }

    static {
        obsLat = SiteCharacteristics.getInstance().getObsLatitude().getContentInDeg();
        wvmap = new HashMap<ReceiverBand, Integer>();
        wvmap.put(ReceiverBand.getReceiverBand(1), 5);
        wvmap.put(ReceiverBand.getReceiverBand(2), 5);
        wvmap.put(ReceiverBand.getReceiverBand(3), 5);
        wvmap.put(ReceiverBand.getReceiverBand(4), 5);
        wvmap.put(ReceiverBand.getReceiverBand(5), 4);
        wvmap.put(ReceiverBand.getReceiverBand(6), 4);
        wvmap.put(ReceiverBand.getReceiverBand(7), 3);
        wvmap.put(ReceiverBand.getReceiverBand(8), 3);
        wvmap.put(ReceiverBand.getReceiverBand(9), 1);
        wvmap.put(ReceiverBand.getReceiverBand(10), 1);
    }
}

