/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.etc.editor;

import alma.common.sensitivitycalculatorcore.calc.SensitivityCalculatorEngine;
import alma.common.sensitivitycalculatorcore.enumerations.Polarization;
import alma.common.sensitivitycalculatorcore.lookup.AtmosphereTable;
import alma.common.sensitivitycalculatorcore.lookup.BasicReceiverBand;
import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.InvalidCoordException;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.ModelChangeSubscriber;
import alma.obsprep.guiutil.mvc.OutOfRangeException;
import alma.obsprep.guiutil.mvc.verifiers.IntegerVerifier;
import alma.obsprep.guiutil.mvc.widgets.OTButtonGroup;
import alma.obsprep.ot.boEditors.FrequencyVerifier;
import alma.obsprep.ot.boEditors.PositiveVerifier;
import alma.obsprep.ot.boEditors.ValueUnitPairVerifier;
import alma.obsprep.ot.editors.valuetypes.ExtendedValueUnitPairEditor;
import alma.obsprep.ot.editors.valuetypes.UserUnitValueUnitPairEditor;
import alma.obsprep.ot.editors.valuetypes.ValueUnitPairEditor;
import alma.obsprep.ot.gui.resources.Colors;
import alma.obsprep.ot.models.valuetypes.UserUnitValueUnitPairModel;
import alma.obsprep.ot.models.valuetypes.ValueUnitPairModel;
import alma.obsprep.services.etc.editor.SensitivityCalculatorModel;
import alma.obsprep.services.etc.editor.SourceVisibleDecVerifier;
import alma.obsprep.services.etc.editor.SpectralResolutionVerifier;
import alma.obsprep.services.etc.editor.WarningAwareBox;
import alma.obsprep.services.etc.editor.WarningAwarePanel;
import alma.obsprep.services.etc.editor.WarningList;
import alma.obsprep.util.LogLoggerProviderImpl;
import alma.obsprep.util.TextUtils;
import alma.obsprep.util.UnitMapConfigurator;
import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import alma.valuetypes.Latitude;
import alma.valuetypes.Length;
import alma.valuetypes.Time;
import alma.valuetypes.UserAngle;
import alma.valuetypes.UserSensitivity;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.text.html.HTMLEditorKit;
import lombok.NonNull;

public class SensitivityCalculatorEditor
extends Editor
implements WarningList {
    private static final String ALL_INTEGRATION_TIME_VALUES = "A valid integration time";
    public static final String ALL_SENSITIVITY_VALUES = "A valid sensitivity";
    public static final String _7M_INTEGRATION_TIME = "7M Integration Time";
    public static final String TP_INTEGRATION_TIME = "TP Integration Time";
    public static final String _12M_INTEGRATION_TIME = "12M Integration Time";
    public static final String _7M_SENSITIVITY = "7M Sensitivity";
    public static final String TP_SENSITIVITY = "TP Sensitivity";
    public static final String _12M_SENSITIVITY = "12M Sensitivity";
    private static final String CALCULATION_ERROR_ID = "Calculation Error:";
    public static final String RESOLUTION_12_ID = "Beamsize of 12m array";
    public static final String RESOLUTION_7_ID = "Beamsize of 7m array";
    private static final String RESOLUTION_TP_ID = "Beamsize of TP array";
    private static final String FREQUENCY_NOTE = "Note";
    private final HashMap<JComponent, String> sceComponentLabels = new HashMap();
    private static final long serialVersionUID = -1181541362866626171L;
    static final FieldID decFID = new FieldID();
    static final FieldID polarizationFID = new FieldID();
    public static final FieldID obsFrequencyVUPFID = new FieldID();
    public static final FieldID observingBandFID = new FieldID();
    static final FieldID bandwidthVUPFID = new FieldID();
    static final FieldID waterVapourChoiceTypeFID = new FieldID();
    static final FieldID waterVapourChooserFID = new FieldID();
    static final FieldID waterVapourFeedbackFID = new FieldID();
    static final FieldID tsysFID = new FieldID();
    static final FieldID ttauFID = new FieldID();
    static final FieldID numberAntennasBFID = new FieldID();
    static final FieldID numberAntennasAFID = new FieldID();
    static final FieldID numberAntennasSFID = new FieldID();
    public static final FieldID beamSize12mVUPFID = new FieldID();
    public static final FieldID beamsize7mVUPFID = new FieldID();
    static final FieldID beamsizeTPVUPFID = new FieldID();
    public static final FieldID sensitivity12mVUPFID = new FieldID();
    public static final FieldID sensitivity7mVUPFID = new FieldID();
    public static final FieldID sensitivityTPVUPFID = new FieldID();
    public static final FieldID sensitivity12mVUP_FB_FID = new FieldID("12M_FB");
    public static final FieldID sensitivity7mVUP_FB_FID = new FieldID("7M_FB");
    public static final FieldID sensitivityTPVUP_FB_FID = new FieldID("TP_FB");
    public static final FieldID intTime12mVUPFID = new FieldID();
    private static final FieldID intTime7mVUPFID = new FieldID();
    private static final FieldID intTimeTPVUPFID = new FieldID();
    public static final FieldID calculateExpTimeFID = new FieldID();
    private static final FieldID calculateSensitivityFID = new FieldID();
    private static final FieldID closeButtonFID = new FieldID();
    private static final FieldID printButtonFID = new FieldID();
    public static final FieldID errorMessageFID = new FieldID();
    public static final FieldID sensitivity12InTempFID = new FieldID();
    public static final FieldID sensitivity7InTempFID = new FieldID();
    public static final FieldID sensitivityTPInTempFID = new FieldID();
    public static final FieldID sensitivityDisplayOptionFID = new FieldID();
    private JEditorPane messageArea;
    private final HashMap<String, String> errorMessages = new HashMap();
    private final boolean isDebugEnabled = false;
    private JButton calcSensButton;
    private JButton calcIntButton;
    private final ArrayList<Component> traverse = new ArrayList();
    private JComboBox timeDisplayOptionCombo;
    private JComboBox sensitivityDisplayOptionCombo;
    private SourceVisibleDecVerifier decVerifier;
    private SpectralResolutionVerifier bwVerifier;
    private JTextField decField;
    private final JComboBox<String> obsBandDropdown = new JComboBox();
    private ValueUnitPairEditor sens12editor;
    private ValueUnitPairEditor sens7editor;
    private ValueUnitPairEditor sensTPeditor;
    private final ModelChangeSubscriber beamsizeTooltipUpdater = (model, fieldID, object) -> this.updateBeamsizeTooltipsAndVerifiers();
    private final ModelChangeSubscriber sensitivityUpdater = (model, fieldID, object) -> {
        if (fieldID == beamSize12mVUPFID) {
            SensitivityCalculatorModel.sensitivity12mModel.setBeamsize((Angle)((Object)((Object)((UserAngle)object))));
        } else if (fieldID == beamsize7mVUPFID) {
            SensitivityCalculatorModel.sensitivity12mModel.setBeamsize((Angle)((Object)((Object)((UserAngle)object))));
        }
        SensitivityCalculatorModel.sensitivity12mModel.publish();
        SensitivityCalculatorModel.sensitivity7mModel.publish();
        SensitivityCalculatorModel.sensitivityTPModel.publish();
        this.updateBeamsizeTooltipsAndVerifiers();
    };

    public SensitivityCalculatorEditor(Model model2) {
        this.setModel(model2);
        this.build();
        model2.publish();
    }

    @Override
    public SensitivityCalculatorModel getModel() {
        return (SensitivityCalculatorModel)super.getModel();
    }

    @Override
    protected void build() {
        WarningAwareBox warningAwareBox = new WarningAwareBox(3);
        warningAwareBox.add(this.createCommonParametersPanel());
        warningAwareBox.add(this.createIndividualParametersPanel());
        warningAwareBox.add(this.createButtonBoxPanel());
        warningAwareBox.add(this.createFeedbackPanel());
        this.add(warningAwareBox);
        this.setupFocusTransversalPolicy();
    }

    protected boolean showsCloseButton() {
        return true;
    }

    private ExtendedValueUnitPairEditor createVupe(ValueUnitPairModel valueUnitPairModel) {
        return this.createVupe(valueUnitPairModel, null);
    }

    private ExtendedValueUnitPairEditor createSensitivityVupe(UserUnitValueUnitPairModel userUnitValueUnitPairModel) {
        UserUnitValueUnitPairEditor userUnitValueUnitPairEditor = new UserUnitValueUnitPairEditor(userUnitValueUnitPairModel){
            private static final long serialVersionUID = 3576140176032401239L;

            @Override
            public void flashBackground() {
            }
        };
        this.layoutVupe(userUnitValueUnitPairEditor);
        return userUnitValueUnitPairEditor;
    }

    private ExtendedValueUnitPairEditor createSensitivityFeedbackVupe(ValueUnitPairModel valueUnitPairModel) {
        ExtendedValueUnitPairEditor extendedValueUnitPairEditor = new ExtendedValueUnitPairEditor(valueUnitPairModel, null){
            private static final long serialVersionUID = 3576140176032401239L;

            @Override
            public void flashBackground() {
            }

            @Override
            public void setEnabled(boolean bl) {
                this.getInput().setEnabled(bl);
                this.getUnits().setEnabled(bl);
            }

            @Override
            public void update(FieldID fieldID, Object object) {
                if (fieldID == this.getValueFID()) {
                    try {
                        double d = Double.parseDouble(object.toString());
                        if (Double.isInfinite(d)) {
                            object = "Unknown";
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                super.update(fieldID, object);
            }
        };
        this.layoutVupe(extendedValueUnitPairEditor);
        extendedValueUnitPairEditor.getInput().setEditable(false);
        return extendedValueUnitPairEditor;
    }

    private ExtendedValueUnitPairEditor createVupe(ValueUnitPairModel valueUnitPairModel, String[] stringArray) {
        ExtendedValueUnitPairEditor extendedValueUnitPairEditor = new ExtendedValueUnitPairEditor(valueUnitPairModel, stringArray){
            private static final long serialVersionUID = 3576140176032401239L;

            @Override
            public void flashBackground() {
            }

            @Override
            public void setEnabled(boolean bl) {
                this.getInput().setEnabled(bl);
                this.getUnits().setEnabled(bl);
            }
        };
        this.layoutVupe(extendedValueUnitPairEditor);
        return extendedValueUnitPairEditor;
    }

    private ValueUnitPairEditor createBandwidthVupe(UserUnitValueUnitPairModel userUnitValueUnitPairModel) {
        ExtendedValueUnitPairEditor extendedValueUnitPairEditor = this.createVupe(userUnitValueUnitPairModel);
        this.layoutVupe(extendedValueUnitPairEditor);
        return extendedValueUnitPairEditor;
    }

    private UserUnitValueUnitPairEditor createBeamsizeVupe(UserUnitValueUnitPairModel userUnitValueUnitPairModel) {
        UserUnitValueUnitPairEditor userUnitValueUnitPairEditor = new UserUnitValueUnitPairEditor(userUnitValueUnitPairModel){
            private static final long serialVersionUID = 4100965405606551725L;

            @Override
            public void setEnabled(boolean bl) {
                this.getInput().setEnabled(bl);
                this.getUnits().setEnabled(bl);
            }
        };
        this.layoutVupe(userUnitValueUnitPairEditor);
        return userUnitValueUnitPairEditor;
    }

    private void layoutVupe(ValueUnitPairEditor valueUnitPairEditor) {
        JTextField jTextField = valueUnitPairEditor.getInput();
        JComboBox jComboBox = valueUnitPairEditor.getUnits();
        Dimension dimension = jTextField.getPreferredSize();
        dimension.height = jComboBox.getPreferredSize().height;
        jTextField.setPreferredSize(dimension);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(jTextField, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        ++gridBagConstraints.gridx;
        gridBagLayout.setConstraints(jComboBox, gridBagConstraints);
        valueUnitPairEditor.setLayout(gridBagLayout);
    }

    private JComponent createCommonParametersPanel() {
        int n = 0;
        WarningAwarePanel warningAwarePanel = new WarningAwarePanel();
        JLabel jLabel = new JLabel("Dec");
        this.decField = new JTextField();
        this.decField.setToolTipText("Valid format is [+|-]DD:MM:SS.SSS");
        this.addLabeledWidget(warningAwarePanel, jLabel, this.decField);
        this.decVerifier = new SourceVisibleDecVerifier(this, this.decField);
        this.initEvents(this.decField, decFID, "KEYSTROKE_VERIFIER", this.decVerifier);
        this.traverse.add(this.decField);
        this.sceComponentLabels.put(this.decField, "Dec");
        ++n;
        jLabel = new JLabel("Polarization");
        JComboBox<String> jComboBox = new JComboBox<String>(Polarization.getLabels());
        jComboBox.setToolTipText("Polarization type");
        this.addLabeledWidget(warningAwarePanel, jLabel, jComboBox);
        this.initEvents(jComboBox, polarizationFID);
        this.traverse.add(jComboBox);
        ++n;
        jLabel = new JLabel("Observing Frequency");
        ValueUnitPairModel valueUnitPairModel = SensitivityCalculatorModel.obsFrequencyModel;
        ValueUnitPairEditor valueUnitPairEditor = this.createVupe(valueUnitPairModel);
        valueUnitPairModel.subscribe(this.beamsizeTooltipUpdater);
        valueUnitPairModel.subscribe(this.sensitivityUpdater);
        this.register(valueUnitPairEditor, obsFrequencyVUPFID);
        valueUnitPairEditor.setToolTipText(BasicReceiverBand.getAllowedFrequencyRangesDesc((boolean)true));
        FrequencyVerifier frequencyVerifier = new FrequencyVerifier(valueUnitPairEditor, true){

            @Override
            protected void checkReceiverBand(Double d) throws OutOfRangeException {
                ValueUnitPair valueUnitPair = (ValueUnitPair)this.vuped.getModel().getDocument();
                Frequency frequency = Frequency.createFrequency((double)d, (String)valueUnitPair.getUnit());
                double d2 = frequency.getContentInGHz();
                if (d2 != 0.0) {
                    try {
                        List<Frequency> list = Arrays.asList(frequency);
                        Set<ReceiverBand> set = ReceiverBand.getReceiverBands(list);
                        if (set.size() == 0) {
                            SensitivityCalculatorEditor.this.setReceiverBand("No valid reciever");
                        } else if (set.size() == 1) {
                            SensitivityCalculatorEditor.this.setReceiverBand(set.iterator().next().getName());
                        } else {
                            SensitivityCalculatorEditor.this.setReceiverBandList(set);
                        }
                        ReceiverBand receiverBand = ReceiverBand.getReceiverBand("ALMA_RB_09");
                        ReceiverBand receiverBand2 = ReceiverBand.getReceiverBand("ALMA_RB_10");
                        if (set.contains(receiverBand) || set.contains(receiverBand2)) {
                            SensitivityCalculatorEditor.this.addWarningToList(SensitivityCalculatorEditor.FREQUENCY_NOTE, " that the Observing Tool will calculate a different time or sensitivity for a Band 9 or 10 project as it can properly include the contribution from the image sideband. See the Technical Handbook for more details about DSB receivers.");
                        } else {
                            SensitivityCalculatorEditor.this.clearWarnings(SensitivityCalculatorEditor.FREQUENCY_NOTE);
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("<html>");
                        stringBuilder.append(illegalArgumentException.getMessage().replaceAll("\n", "<br>"));
                        stringBuilder.append("</html>");
                        throw new OutOfRangeException(stringBuilder.toString());
                    }
                }
            }
        };
        valueUnitPairEditor.setVerifier("KEYSTROKE_VERIFIER", frequencyVerifier);
        valueUnitPairEditor.getInput().setColumns(12);
        this.addLabeledWidget(warningAwarePanel, jLabel, valueUnitPairEditor);
        this.traverse.add(valueUnitPairEditor.getInput());
        this.traverse.add(valueUnitPairEditor.getUnits());
        ++n;
        jLabel = new JLabel("Observing Band");
        this.obsBandDropdown.setEditable(false);
        this.addLabeledWidget(warningAwarePanel, jLabel, this.obsBandDropdown);
        this.initEvents(this.obsBandDropdown, observingBandFID);
        ++n;
        valueUnitPairEditor = this.createVupe(valueUnitPairModel);
        valueUnitPairModel.subscribe(this.beamsizeTooltipUpdater);
        valueUnitPairModel.subscribe(this.sensitivityUpdater);
        this.register(valueUnitPairEditor, obsFrequencyVUPFID);
        jLabel = new JLabel("Bandwidth per Polarization");
        valueUnitPairEditor = this.createBandwidthVupe(SensitivityCalculatorModel.bandwidthModel);
        valueUnitPairEditor.getInput().setColumns(12);
        this.register(valueUnitPairEditor, bandwidthVUPFID);
        valueUnitPairEditor.setToolTipText("<html>Bandwidth (frequency resolution) per polarization.<br>Valid range is between 0 GHz and 16 GHz.<br>This value multipled by the number of polarizations is used as effective bandwidth.<br>A speed unit(km/s, m/s) is allowed as well as a frequency unit(GHz,MHz,kHz,Hz).</html>");
        this.bwVerifier = new SpectralResolutionVerifier(valueUnitPairEditor, (double)Double.MIN_VALUE, 16.0);
        valueUnitPairEditor.setVerifier("KEYSTROKE_VERIFIER", this.bwVerifier);
        this.addLabeledWidget(warningAwarePanel, jLabel, valueUnitPairEditor);
        this.traverse.add(valueUnitPairEditor.getInput());
        this.traverse.add(valueUnitPairEditor.getUnits());
        ++n;
        jLabel = new JLabel("<html>Water Vapour<br>&nbsp;&nbsp;&nbsp;Column Density</html>");
        OTButtonGroup oTButtonGroup = new OTButtonGroup(new String[]{"Automatic Choice", "Manual Choice"});
        oTButtonGroup.setToolTipText(new String[]{"Calculator chooses based on observing frequency", "User chooses preferred PWV octile"});
        this.initEvents(oTButtonGroup, waterVapourChoiceTypeFID);
        JComboBox<String> jComboBox2 = new JComboBox<String>(AtmosphereTable.WV_MAP);
        jComboBox2.setToolTipText("PWV octile used to calculate Tsys");
        this.initEvents(jComboBox2, waterVapourChooserFID);
        this.traverse.add(jComboBox2);
        JTextField jTextField = new JTextField();
        jTextField.setEditable(false);
        jTextField.setToolTipText("PWV octile used to calculate Tsys");
        this.register(jTextField, waterVapourFeedbackFID);
        Box box = Box.createVerticalBox();
        Component component = Box.createVerticalStrut(2);
        box.add(oTButtonGroup);
        box.add(component);
        box.add(jTextField);
        box.add(component);
        box.add(jComboBox2);
        box.add(component);
        this.addLabeledWidget(warningAwarePanel, jLabel, box);
        box.add(component);
        ++n;
        jLabel = new JLabel("Trx, tau, Tsky");
        jTextField = new JTextField();
        jTextField.setEditable(false);
        jTextField.setToolTipText("<html>Atmospheric parameters &tau &amp Tsky, not editable.");
        this.addLabeledWidget(warningAwarePanel, jLabel, jTextField);
        this.register(jTextField, ttauFID);
        ++n;
        jLabel = new JLabel("Tsys");
        jTextField = new JTextField();
        jTextField.setEditable(false);
        jTextField.setToolTipText("The system temperature at the frequency of the selected band, not editable.");
        this.addLabeledWidget(warningAwarePanel, jLabel, jTextField);
        this.register(jTextField, tsysFID);
        this.layoutLabeledWidgets(warningAwarePanel, ++n);
        TitledBorder titledBorder = new TitledBorder("Common Parameters");
        warningAwarePanel.setBorder(titledBorder);
        return warningAwarePanel;
    }

    private void setReceiverBandList(Set<ReceiverBand> set) {
        this.obsBandDropdown.removeAllItems();
        for (ReceiverBand receiverBand : set) {
            this.obsBandDropdown.addItem(receiverBand.getName());
        }
        this.obsBandDropdown.setEnabled(true);
    }

    protected void setReceiverBand(@NonNull String string) {
        if (string == null) {
            throw new NullPointerException("bandName is marked non-null but is null");
        }
        this.obsBandDropdown.removeAllItems();
        this.obsBandDropdown.addItem(string);
        this.obsBandDropdown.setEnabled(false);
    }

    private JComponent createIndividualParametersPanel() {
        WarningAwarePanel warningAwarePanel = new WarningAwarePanel();
        @NonNull SensitivityCalculatorModel sensitivityCalculatorModel = this.getModel();
        Vector<Component> vector = new Vector<Component>();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        warningAwarePanel.setLayout(gridBagLayout);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        ImmutableList.of((Object)"", (Object)"12m Array", (Object)"7m Array", (Object)"Total Power Array").stream().forEach(string -> vector.add(new JLabel((String)string)));
        this.addLine(warningAwarePanel, gridBagLayout, gridBagConstraints, vector);
        Vector<Component> vector2 = new Vector<Component>();
        JLabel jLabel = new JLabel("Number of Antennas");
        vector2.add(jLabel);
        JTextField jTextField = new JTextField();
        jTextField.setToolTipText("Less than or equal to 50");
        this.initEvents(jTextField, numberAntennasBFID, "KEYSTROKE_VERIFIER", new IntegerVerifier(this, jTextField, 0, 50));
        this.sceComponentLabels.put(jTextField, "Number of 12M Antennas");
        vector2.add(jTextField);
        this.traverse.add(jTextField);
        jTextField = new JTextField();
        jTextField.setToolTipText("Less than or equal to 12");
        this.initEvents(jTextField, numberAntennasAFID, "KEYSTROKE_VERIFIER", new IntegerVerifier(this, jTextField, 0, 12));
        this.sceComponentLabels.put(jTextField, "Number of 7M Antennas");
        vector2.add(jTextField);
        this.traverse.add(jTextField);
        jTextField = new JTextField();
        jTextField.setToolTipText("Less than or equal to 4");
        this.initEvents(jTextField, numberAntennasSFID, "KEYSTROKE_VERIFIER", new IntegerVerifier(this, jTextField, 0, 4));
        this.sceComponentLabels.put(jTextField, "Number of TP Antennas");
        vector2.add(jTextField);
        this.traverse.add(jTextField);
        this.addLine(warningAwarePanel, gridBagLayout, gridBagConstraints, vector2);
        vector2 = new Vector();
        jLabel = new JLabel("Resolution");
        vector2.add(jLabel);
        ExtendedValueUnitPairEditor extendedValueUnitPairEditor = this.createBeamsizeVupe(SensitivityCalculatorModel.beamsize12mModel);
        SensitivityCalculatorModel.beamsize12mModel.subscribe(this.sensitivityUpdater);
        this.register(extendedValueUnitPairEditor, beamSize12mVUPFID);
        vector2.add(extendedValueUnitPairEditor);
        this.traverse.add(extendedValueUnitPairEditor.getInput());
        this.traverse.add(extendedValueUnitPairEditor.getUnits());
        extendedValueUnitPairEditor = this.createBeamsizeVupe(SensitivityCalculatorModel.beamsize7mModel);
        SensitivityCalculatorModel.beamsize7mModel.subscribe(this.sensitivityUpdater);
        this.register(extendedValueUnitPairEditor, beamsize7mVUPFID);
        vector2.add(extendedValueUnitPairEditor);
        this.traverse.add(extendedValueUnitPairEditor.getInput());
        this.traverse.add(extendedValueUnitPairEditor.getUnits());
        extendedValueUnitPairEditor = this.createBeamsizeVupe(SensitivityCalculatorModel.beamsizeTPModel);
        SensitivityCalculatorModel.beamsizeTPModel.subscribe(this.sensitivityUpdater);
        this.register(extendedValueUnitPairEditor, beamsizeTPVUPFID);
        extendedValueUnitPairEditor.setToolTipText("Main beam size of ACA 12m antennas. Not editable");
        extendedValueUnitPairEditor.setEditable(false);
        vector2.add(extendedValueUnitPairEditor);
        this.addLine(warningAwarePanel, gridBagLayout, gridBagConstraints, vector2);
        vector2 = new Vector();
        jLabel = new JLabel("Sensitivity (rms)");
        vector2.add(jLabel);
        Object object = "<html>Either in flux density units(Jy,mJy) or in brightness temperature(K,mK) units.<br>Beamsize is needed if one of the units for brightness temperature is choosed.<br>To calculate sensitivity against integration time, choose one of the units in which you desire<br> the result and then press \"Calculate Sensitivity\" button</html>";
        this.sens12editor = this.createSensitivityVupe(SensitivityCalculatorModel.sensitivity12mModel);
        this.sens12editor.setVerifier("KEYSTROKE_VERIFIER", new ValueUnitPairVerifier(this.sens12editor, 0.0, (double)Double.MAX_VALUE));
        this.sceComponentLabels.put(this.sens12editor.getInput(), _12M_SENSITIVITY);
        this.register(this.sens12editor, sensitivity12mVUPFID);
        this.sens12editor.setToolTipText((String)object);
        vector2.add(this.sens12editor);
        this.traverse.add(this.sens12editor.getInput());
        this.traverse.add(this.sens12editor.getUnits());
        this.sens7editor = this.createSensitivityVupe(SensitivityCalculatorModel.sensitivity7mModel);
        this.sens7editor.setVerifier("KEYSTROKE_VERIFIER", new ValueUnitPairVerifier(this.sens7editor, 0.0, (double)Double.MAX_VALUE));
        this.sceComponentLabels.put(this.sens7editor.getInput(), _7M_SENSITIVITY);
        this.register(this.sens7editor, sensitivity7mVUPFID);
        this.sens7editor.setToolTipText((String)object);
        vector2.add(this.sens7editor);
        this.traverse.add(this.sens7editor.getInput());
        this.traverse.add(this.sens7editor.getUnits());
        this.sensTPeditor = this.createSensitivityVupe(SensitivityCalculatorModel.sensitivityTPModel);
        this.register(this.sensTPeditor, sensitivityTPVUPFID);
        this.sensTPeditor.setVerifier("KEYSTROKE_VERIFIER", new ValueUnitPairVerifier(this.sensTPeditor, 0.0, (double)Double.MAX_VALUE));
        this.sceComponentLabels.put(this.sensTPeditor.getInput(), TP_SENSITIVITY);
        this.sensTPeditor.setToolTipText((String)object);
        vector2.add(this.sensTPeditor);
        this.traverse.add(this.sensTPeditor.getInput());
        this.traverse.add(this.sensTPeditor.getUnits());
        this.addLine(warningAwarePanel, gridBagLayout, gridBagConstraints, vector2);
        vector2 = new Vector();
        jLabel = new JLabel("  (equivalent to)");
        vector2.add(jLabel);
        object = "Information. Not editable";
        extendedValueUnitPairEditor = this.createSensitivityFeedbackVupe(SensitivityCalculatorModel.sensitivity12mModel.getFeedbackModel());
        extendedValueUnitPairEditor.setToolTipText((String)object);
        vector2.add(extendedValueUnitPairEditor);
        extendedValueUnitPairEditor = this.createSensitivityFeedbackVupe(SensitivityCalculatorModel.sensitivity7mModel.getFeedbackModel());
        extendedValueUnitPairEditor.setToolTipText((String)object);
        vector2.add(extendedValueUnitPairEditor);
        extendedValueUnitPairEditor = this.createSensitivityFeedbackVupe(SensitivityCalculatorModel.sensitivityTPModel.getFeedbackModel());
        extendedValueUnitPairEditor.setToolTipText((String)object);
        vector2.add(extendedValueUnitPairEditor);
        this.addLine(warningAwarePanel, gridBagLayout, gridBagConstraints, vector2);
        vector2 = new Vector();
        jLabel = new JLabel("Integration Time");
        vector2.add(jLabel);
        String[] stringArray = TimeDisplayOption.getKnownUnits();
        extendedValueUnitPairEditor = this.createVupe(sensitivityCalculatorModel.intTime12mModel, stringArray);
        this.register(extendedValueUnitPairEditor, intTime12mVUPFID);
        extendedValueUnitPairEditor.setVerifier("KEYSTROKE_VERIFIER", new PositiveVerifier(extendedValueUnitPairEditor));
        this.sceComponentLabels.put(extendedValueUnitPairEditor.getInput(), _12M_INTEGRATION_TIME);
        extendedValueUnitPairEditor.setToolTipText("Does not include time for calibration or setup");
        vector2.add(extendedValueUnitPairEditor);
        this.traverse.add(extendedValueUnitPairEditor.getInput());
        this.traverse.add(extendedValueUnitPairEditor.getUnits());
        extendedValueUnitPairEditor = this.createVupe(sensitivityCalculatorModel.intTime7mModel, stringArray);
        this.register(extendedValueUnitPairEditor, intTime7mVUPFID);
        extendedValueUnitPairEditor.setToolTipText("Does not include time for calibration or setup");
        extendedValueUnitPairEditor.setVerifier("KEYSTROKE_VERIFIER", new PositiveVerifier(extendedValueUnitPairEditor));
        this.sceComponentLabels.put(extendedValueUnitPairEditor.getInput(), _7M_INTEGRATION_TIME);
        vector2.add(extendedValueUnitPairEditor);
        this.traverse.add(extendedValueUnitPairEditor.getInput());
        this.traverse.add(extendedValueUnitPairEditor.getUnits());
        extendedValueUnitPairEditor = this.createVupe(sensitivityCalculatorModel.intTimeTPModel, stringArray);
        this.register(extendedValueUnitPairEditor, intTimeTPVUPFID);
        extendedValueUnitPairEditor.setToolTipText("Does not include time for calibration or setup");
        extendedValueUnitPairEditor.setVerifier("KEYSTROKE_VERIFIER", new PositiveVerifier(extendedValueUnitPairEditor));
        this.sceComponentLabels.put(extendedValueUnitPairEditor.getInput(), TP_INTEGRATION_TIME);
        vector2.add(extendedValueUnitPairEditor);
        this.traverse.add(extendedValueUnitPairEditor.getInput());
        this.traverse.add(extendedValueUnitPairEditor.getUnits());
        this.addLine(warningAwarePanel, gridBagLayout, gridBagConstraints, vector2);
        WarningAwarePanel warningAwarePanel2 = new WarningAwarePanel();
        jLabel = new JLabel("Integration Time Unit Option");
        this.timeDisplayOptionCombo = new JComboBox<TimeDisplayOption>(TimeDisplayOption.getIntegrationTimeUnits());
        this.timeDisplayOptionCombo.addActionListener(actionEvent -> {
            TimeDisplayOption timeDisplayOption = (TimeDisplayOption)((Object)((Object)this.timeDisplayOptionCombo.getSelectedItem()));
            this.getModel().setTimeDisplayOption(timeDisplayOption);
        });
        object = "<html>This is the option to control the unit of result value in calculating integration time.<br>The calculator selects one of the units in " + TimeDisplayOption.AUTOMATIC + " case,<br>returns the results in the unit currently displayed in " + TimeDisplayOption.CURRENT + " case, <br>and retuns the results in the specified unit in other cases.<br></html>";
        this.timeDisplayOptionCombo.setToolTipText((String)object);
        this.timeDisplayOptionCombo.setSelectedItem((Object)TimeDisplayOption.getDefault());
        warningAwarePanel2.add(jLabel);
        warningAwarePanel2.add(this.timeDisplayOptionCombo);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        ++gridBagConstraints.gridy;
        gridBagLayout.setConstraints(warningAwarePanel2, gridBagConstraints);
        warningAwarePanel.add(warningAwarePanel2);
        WarningAwarePanel warningAwarePanel3 = new WarningAwarePanel();
        jLabel = new JLabel("Sensitivity Unit Option");
        this.sensitivityDisplayOptionCombo = new JComboBox<SensitivityDisplayOption>(SensitivityDisplayOption.getSensitivityUnits());
        this.sensitivityDisplayOptionCombo.addActionListener(actionEvent -> {
            SensitivityDisplayOption sensitivityDisplayOption = (SensitivityDisplayOption)((Object)((Object)this.sensitivityDisplayOptionCombo.getSelectedItem()));
            if (sensitivityDisplayOption != null) {
                String string;
                if (this.sens12editor != null) {
                    string = (String)this.sens12editor.getUnits().getSelectedItem();
                    SensitivityCalculatorModel.sensitivity12mModel.setSensitivityDisplayOption(sensitivityDisplayOption, string);
                }
                if (this.sens7editor != null) {
                    string = (String)this.sens7editor.getUnits().getSelectedItem();
                    SensitivityCalculatorModel.sensitivity7mModel.setSensitivityDisplayOption(sensitivityDisplayOption, string);
                }
                if (this.sensTPeditor != null) {
                    string = (String)this.sens7editor.getUnits().getSelectedItem();
                    SensitivityCalculatorModel.sensitivityTPModel.setSensitivityDisplayOption(sensitivityDisplayOption, string);
                }
            }
        });
        object = "<html>This is the option to control the unit of result value in calculating sensitivity.<br>The calculator selects one of the units in " + SensitivityDisplayOption.AUTOMATIC + " case,<br>returns the results in the unit currently displayed in " + SensitivityDisplayOption.CURRENT + " case, <br>and retuns the results in the specified unit in other cases.<br></html>";
        this.sensitivityDisplayOptionCombo.setToolTipText((String)object);
        this.sensitivityDisplayOptionCombo.setSelectedItem((Object)SensitivityDisplayOption.getDefault());
        warningAwarePanel3.add(jLabel);
        warningAwarePanel3.add(this.sensitivityDisplayOptionCombo);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        ++gridBagConstraints.gridy;
        gridBagLayout.setConstraints(warningAwarePanel3, gridBagConstraints);
        warningAwarePanel.add(warningAwarePanel3);
        warningAwarePanel.setBorder(new TitledBorder("Individual Parameters"));
        return warningAwarePanel;
    }

    private void addLine(JComponent jComponent, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, Vector<Component> vector) {
        gridBagConstraints.gridx = 0;
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            Component component = vector.get(i);
            gridBagLayout.setConstraints(component, gridBagConstraints);
            jComponent.add(component);
            ++gridBagConstraints.gridx;
            Component component2 = Box.createHorizontalStrut(5);
            gridBagLayout.setConstraints(component2, gridBagConstraints);
            jComponent.add(component2);
            ++gridBagConstraints.gridx;
        }
        ++gridBagConstraints.gridy;
    }

    private JComponent createButtonBoxPanel() {
        JPanel jPanel = new JPanel();
        this.calcIntButton = new JButton("Calculate Integration Time");
        this.calcIntButton.setToolTipText("Calculate integration time against the sensitivity provided.");
        this.initEvents(this.calcIntButton, calculateExpTimeFID);
        this.traverse.add(this.calcIntButton);
        this.calcSensButton = new JButton("Calculate Sensitivity");
        this.calcSensButton.setToolTipText("Calculate sensitivity against the integration time provided.");
        this.initEvents(this.calcSensButton, calculateSensitivityFID);
        this.traverse.add(this.calcSensButton);
        jPanel.add(this.calcIntButton);
        jPanel.add(Box.createHorizontalStrut(20));
        jPanel.add(this.calcSensButton);
        if (this.showsCloseButton()) {
            JButton jButton = new JButton("Close");
            jButton.setToolTipText("Exit the Sensitivity Calculator Tool");
            this.initEvents(jButton, closeButtonFID);
            this.traverse.add(jButton);
            jPanel.add(Box.createHorizontalStrut(20));
            jPanel.add(jButton);
        }
        return jPanel;
    }

    private JComponent createFeedbackPanel() {
        this.messageArea = new JEditorPane();
        this.messageArea.setEditable(false);
        this.messageArea.setEditorKit(new HTMLEditorKit());
        this.messageArea.setPreferredSize(new Dimension(200, 150));
        return this.messageArea;
    }

    public JEditorPane getMessageArea() {
        return this.messageArea;
    }

    private void setupFocusTransversalPolicy() {
        FocusTraversalPolicy focusTraversalPolicy = new FocusTraversalPolicy(){
            int size;
            {
                this.size = SensitivityCalculatorEditor.this.traverse.size();
            }

            @Override
            public Component getFirstComponent(Container container) {
                return SensitivityCalculatorEditor.this.traverse.get(0);
            }

            @Override
            public Component getLastComponent(Container container) {
                return SensitivityCalculatorEditor.this.traverse.get(this.size - 1);
            }

            @Override
            public Component getComponentAfter(Container container, Component component) {
                int n = SensitivityCalculatorEditor.this.traverse.indexOf(component);
                Component component2 = SensitivityCalculatorEditor.this.traverse.get((n + 1) % this.size);
                return component2.isEnabled() ? component2 : this.getComponentAfter(container, component2);
            }

            @Override
            public Component getComponentBefore(Container container, Component component) {
                int n = SensitivityCalculatorEditor.this.traverse.indexOf(component);
                Component component2 = SensitivityCalculatorEditor.this.traverse.get((n - 1 + this.size) % this.size);
                return component2.isEnabled() ? component2 : this.getComponentBefore(container, component2);
            }

            @Override
            public Component getDefaultComponent(Container container) {
                return SensitivityCalculatorEditor.this.traverse.get(0);
            }
        };
        this.setFocusTraversalPolicyProvider(true);
        this.setFocusTraversalPolicy(focusTraversalPolicy);
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        @NonNull SensitivityCalculatorModel sensitivityCalculatorModel = this.getModel();
        if (fieldID.equals(closeButtonFID)) {
            JRootPane jRootPane = this.getRootPane();
            if (jRootPane != null) {
                ((JFrame)jRootPane.getParent()).dispose();
            }
            return;
        }
        if (fieldID.equals(printButtonFID)) {
            sensitivityCalculatorModel.getDocument().toString();
            return;
        }
        if (fieldID.equals(polarizationFID)) {
            if (object instanceof Polarization) {
                super.update(fieldID, ((Polarization)object).getLabel());
            } else {
                super.update(fieldID, object);
            }
            return;
        }
        if (fieldID.equals(waterVapourChoiceTypeFID)) {
            boolean bl = "Automatic Choice".equals(object);
            this.retrieve(waterVapourChooserFID).setVisible(!bl);
            this.retrieve(waterVapourFeedbackFID).setVisible(bl);
            super.update(fieldID, object);
        } else if (fieldID.equals(calculateExpTimeFID)) {
            SensitivityCalculatorModel sensitivityCalculatorModel2 = sensitivityCalculatorModel;
            sensitivityCalculatorModel2.calcIntegrationTime();
        } else if (fieldID.equals(calculateSensitivityFID)) {
            SensitivityCalculatorModel sensitivityCalculatorModel3 = sensitivityCalculatorModel;
            sensitivityCalculatorModel3.calcSensitivity();
        } else if (fieldID.equals(errorMessageFID)) {
            if (object == null) {
                this.clearWarnings(CALCULATION_ERROR_ID);
            } else {
                String string = object.toString();
                this.addWarningToList(CALCULATION_ERROR_ID, string);
            }
        } else if (fieldID.equals(sensitivity12InTempFID) || fieldID.equals(sensitivity7InTempFID)) {
            this.updateBeamsizeTooltipsAndVerifiers();
            if (!fieldID.equals(sensitivity12InTempFID) || object != null) {
                // empty if block
            }
            if (fieldID.equals(sensitivity12InTempFID) && object != null) {
                // empty if block
            }
        } else if (fieldID.equals(sensitivityTPInTempFID)) {
            if (object == null) {
                this.clearWarnings(RESOLUTION_TP_ID);
            } else {
                String string = object.toString();
                this.addWarningToList(RESOLUTION_TP_ID, string);
            }
        } else {
            if (fieldID.equals(decFID)) {
                if (object instanceof Latitude) {
                    try {
                        super.update(fieldID, ((Latitude)((Object)object)).toDDMMSS());
                    }
                    catch (OutOfRangeException outOfRangeException) {
                        Log.logger((Object)this).warning(outOfRangeException.getMessage());
                    }
                    catch (InvalidCoordException invalidCoordException) {
                        Log.logger((Object)this).warning(invalidCoordException.getMessage());
                    }
                } else {
                    super.update(fieldID, object);
                }
                return;
            }
            super.update(fieldID, object);
        }
    }

    private static UserAngle syntheticBeamsize(@NonNull Frequency frequency, @NonNull Length length) {
        if (frequency == null) {
            throw new NullPointerException("f is marked non-null but is null");
        }
        if (length == null) {
            throw new NullPointerException("baseline is marked non-null but is null");
        }
        UserAngle userAngle = UserAngle.arcAngle(frequency.getWavelength(), length);
        userAngle.setObservingFrequency(frequency);
        return userAngle;
    }

    private void updateBeamsizeTooltipsAndVerifiers() {
        Frequency frequency = (Frequency)SensitivityCalculatorModel.obsFrequencyModel.getVUP();
        if (frequency == null) {
            return;
        }
        ValueUnitPairEditor valueUnitPairEditor = (ValueUnitPairEditor)this.retrieve(beamSize12mVUPFID);
        ValueUnitPairEditor valueUnitPairEditor2 = (ValueUnitPairEditor)this.retrieve(beamsize7mVUPFID);
        this.updateBeamsizeToolTipAndVerifier(RESOLUTION_12_ID, valueUnitPairEditor, frequency, (UserSensitivity)SensitivityCalculatorModel.sensitivity12mModel.getVUP(), Length.createLength((double)120.0, (String)Length.UNIT_M), Length.createLength((double)16.0, (String)Length.UNIT_KM));
        this.updateBeamsizeToolTipAndVerifier(RESOLUTION_7_ID, valueUnitPairEditor2, frequency, (UserSensitivity)SensitivityCalculatorModel.sensitivity7mModel.getVUP(), Length.createLength((double)25.0, (String)Length.UNIT_M), Length.createLength((double)60.0, (String)Length.UNIT_M));
        valueUnitPairEditor.validate();
        valueUnitPairEditor2.validate();
    }

    private ValueUnitPairEditor updateBeamsizeToolTipAndVerifier(final String string, final ValueUnitPairEditor valueUnitPairEditor, final Frequency frequency, final UserSensitivity userSensitivity, Length length, Length length2) {
        UserAngle userAngle = SensitivityCalculatorEditor.syntheticBeamsize(frequency, length);
        userAngle.convertToUnit(Angle.UNIT_ARCSEC);
        final Angle angle = Angle.createAngle();
        angle.setContentAndUnit((ValueUnitPair)userAngle.multiply(2.0));
        userAngle = SensitivityCalculatorEditor.syntheticBeamsize(frequency, length2);
        userAngle.convertToUnit(Angle.UNIT_ARCSEC);
        final Angle angle2 = Angle.createAngle();
        angle2.setContentAndUnit(userAngle);
        String string2 = String.format("Desired angular resolution. Should be between wavelength/(L=%.2f[km]) and 2 * wavelength/(L=%.0f[m]) : %.3f and %.3f(arcsec)", length2.getContentInUnits(Length.UNIT_KM), length.getContentInUnits(Length.UNIT_M), angle2.getContent(), angle.getContent());
        valueUnitPairEditor.setToolTipText(string2);
        ValueUnitPairVerifier valueUnitPairVerifier = new ValueUnitPairVerifier(valueUnitPairEditor, SensitivityCalculatorEditor.round(angle2.getContentInDefaultUnits(), 8), SensitivityCalculatorEditor.round(angle.getContentInDefaultUnits(), 8)){

            @Override
            public Object validate(JTextField jTextField) throws OutOfRangeException, NumberFormatException {
                SensitivityCalculatorEditor.this.clearWarnings(string);
                try {
                    Object object = super.validate(jTextField);
                    return object;
                }
                catch (OutOfRangeException outOfRangeException) {
                    double d = Double.parseDouble(jTextField.getText());
                    if (userSensitivity.inFluxUnit() && d == 0.0) {
                        return d;
                    }
                    StringBuilder stringBuilder = new StringBuilder();
                    if (jTextField.isEnabled() && jTextField.isEditable()) {
                        stringBuilder.append(TextUtils.format(angle2, 3));
                        stringBuilder.append(" &lt; ");
                        stringBuilder.append("(");
                        stringBuilder.append(string);
                        stringBuilder.append(")");
                        stringBuilder.append(" &lt; ");
                        stringBuilder.append(TextUtils.format(angle, 3));
                        stringBuilder.append(" for ");
                        stringBuilder.append(TextUtils.format(frequency, 3));
                        stringBuilder.append(" observation.");
                        SensitivityCalculatorEditor.this.addWarningToList(string, stringBuilder.toString());
                        if (userSensitivity.inTemperatureUnit() && d <= 0.0) {
                            Object object;
                            if (d == 0.0) {
                                object = SensitivityCalculatorEditor.this.getModel();
                                ((SensitivityCalculatorModel)object).update(valueUnitPairEditor, valueUnitPairEditor.getValueFID(), "0.00");
                            }
                            object = "Beamsize must be greater than 0.0 to specify sensitivity in one of the Temperature units..<br>" + stringBuilder.toString();
                            SensitivityCalculatorEditor.this.addWarningToList(string, (String)object);
                            throw new OutOfRangeException((String)object);
                        }
                        SensitivityCalculatorEditor.this.addWarningToList(string, stringBuilder.toString());
                        throw new OutOfRangeException(stringBuilder.toString());
                    }
                    return d;
                }
            }
        };
        valueUnitPairEditor.setVerifier("KEYSTROKE_VERIFIER", valueUnitPairVerifier);
        valueUnitPairVerifier.verify();
        return valueUnitPairEditor;
    }

    public static double round(double d, int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        BigDecimal bigDecimal = new BigDecimal(d);
        bigDecimal = bigDecimal.setScale(n, RoundingMode.HALF_UP);
        return bigDecimal.doubleValue();
    }

    public static void main(String[] stringArray) {
        System.setProperty("otData.dir", "config\\otData");
        Log.setRuntimeImplementation((Log.LoggerProvider)new LogLoggerProviderImpl());
        UnitMapConfigurator.configureUnitMaps();
        JFrame jFrame = new JFrame("Sensitivity Calculator");
        SensitivityCalculatorModel sensitivityCalculatorModel = new SensitivityCalculatorModel(null);
        SensitivityCalculatorEditor sensitivityCalculatorEditor = new SensitivityCalculatorEditor(sensitivityCalculatorModel);
        SensitivityCalculatorEngine sensitivityCalculatorEngine = new SensitivityCalculatorEngine();
        sensitivityCalculatorEngine.setNum12MAntennas(43);
        sensitivityCalculatorEngine.setObservingFrequencyInGHZ(345.0);
        sensitivityCalculatorEngine.setBandwidth(7.5);
        sensitivityCalculatorEngine.set12MIntegrationTimeInSec(60.0);
        sensitivityCalculatorEngine.set7MIntegrationTimeInSec(60.0);
        sensitivityCalculatorEngine.setTPIntegrationTimeInSec(60.0);
        sensitivityCalculatorEngine.set12MBeamsizeInArcsecs(0.0);
        sensitivityCalculatorEngine.set7MBeamsizeInArcsecs(0.0);
        sensitivityCalculatorEngine.set12MSensitivityInJ(0.0);
        sensitivityCalculatorEngine.set7MSensitivityInJ(0.0);
        sensitivityCalculatorEngine.setTPSensitivityInJ(0.0);
        sensitivityCalculatorEngine.set12MSensitivityUnit(SensitivityCalculatorEngine.UserSensitivityType.UJY);
        sensitivityCalculatorEngine.set7MSensitivityUnit(SensitivityCalculatorEngine.UserSensitivityType.MJY);
        sensitivityCalculatorEngine.setTPSensitivityUnit(SensitivityCalculatorEngine.UserSensitivityType.MJY);
        sensitivityCalculatorModel.setDocument(sensitivityCalculatorEngine);
        jFrame.getContentPane().add(sensitivityCalculatorEditor);
        jFrame.setDefaultCloseOperation(3);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    private int numberOfNonSensitivityOrIntegrationWarnings(@NonNull Set<String> set) {
        if (set == null) {
            throw new NullPointerException("messageSet is marked non-null but is null");
        }
        ImmutableSet immutableSet = ImmutableSet.of((Object)FREQUENCY_NOTE, (Object)_12M_SENSITIVITY, (Object)TP_SENSITIVITY, (Object)_7M_SENSITIVITY, (Object)_12M_INTEGRATION_TIME, (Object)TP_INTEGRATION_TIME, (Object[])new String[]{_7M_INTEGRATION_TIME, ALL_SENSITIVITY_VALUES, ALL_INTEGRATION_TIME_VALUES, RESOLUTION_12_ID, RESOLUTION_7_ID});
        set.removeAll((Collection<?>)immutableSet);
        return set.size();
    }

    private boolean isIntegrationEnabled() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(this.errorMessages.keySet());
        if (hashSet.contains(_12M_SENSITIVITY) && hashSet.contains(TP_SENSITIVITY) && hashSet.contains(_7M_SENSITIVITY)) {
            this.errorMessages.put(ALL_SENSITIVITY_VALUES, "must be entered in order to calculate an integration time.");
            return false;
        }
        this.errorMessages.remove(ALL_SENSITIVITY_VALUES);
        return this.numberOfNonSensitivityOrIntegrationWarnings(hashSet) == 0;
    }

    private boolean isSensitivityEnabled() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(this.errorMessages.keySet());
        if (hashSet.contains(_12M_INTEGRATION_TIME) && hashSet.contains(TP_INTEGRATION_TIME) && hashSet.contains(_7M_INTEGRATION_TIME)) {
            this.errorMessages.put(ALL_INTEGRATION_TIME_VALUES, "must be entered in order to calculate a sensitivity.");
            return false;
        }
        this.errorMessages.remove(ALL_INTEGRATION_TIME_VALUES);
        return this.numberOfNonSensitivityOrIntegrationWarnings(hashSet) == 0;
    }

    private void revalidateButtons() {
        if (this.errorMessages.size() > 0 && (this.errorMessages.size() > 1 || this.errorMessages.get(CALCULATION_ERROR_ID) == null)) {
            this.calcSensButton.setEnabled(this.isSensitivityEnabled());
            this.calcIntButton.setEnabled(this.isIntegrationEnabled());
        } else {
            this.calcIntButton.setEnabled(true);
            this.calcSensButton.setEnabled(true);
        }
    }

    private boolean shouldHideWarning(String string) {
        return string.equals(TP_INTEGRATION_TIME) || string.equals(TP_SENSITIVITY) || string.equals(_12M_INTEGRATION_TIME) || string.equals(_12M_SENSITIVITY) || string.equals(_7M_INTEGRATION_TIME) || string.equals(_7M_SENSITIVITY);
    }

    private void DisplayList() {
        Object object = "";
        if (this.errorMessages.isEmpty()) {
            this.messageArea.setText("<html>&nbsp</html>");
        } else {
            object = "<html><body text='red'><ul>";
            Set<Map.Entry<String, String>> set = this.errorMessages.entrySet();
            for (Map.Entry<String, String> entry : set) {
                if (this.shouldHideWarning(entry.getKey())) continue;
                object = (String)object + "<li>" + entry.getKey() + " " + entry.getValue() + "</li>";
            }
            object = (String)object + "</ul></body></html>";
            this.messageArea.setText((String)object);
            this.messageArea.setForeground(Colors.OT_RED);
        }
    }

    @Override
    public void invalidate(JComponent jComponent, String string) {
        super.invalidate(jComponent, string);
        String string2 = this.sceComponentLabels.get(jComponent);
        if (null != string2) {
            this.addWarningToList(string2, string);
        }
    }

    @Override
    public void revalidate(JComponent jComponent) {
        super.revalidate(jComponent);
        this.revalidateButtons();
        String string = this.sceComponentLabels.get(jComponent);
        if (null != string) {
            this.clearWarnings(string);
        }
    }

    @Override
    public void addWarningToList(String string, String string2) {
        this.errorMessages.put(string, string2);
        this.revalidateButtons();
        this.DisplayList();
    }

    @Override
    public void clearWarnings(String string) {
        if (this.errorMessages.containsKey(string)) {
            this.errorMessages.remove(string);
        }
        this.revalidateButtons();
        this.DisplayList();
    }

    public static enum SensitivityDisplayOption {
        AUTOMATIC("Automatic", null),
        CURRENT("Keep displayed unit", null),
        SENSITIVITY_JY("In Jy", UserSensitivity.USERUNIT_JY),
        SENSITIVITY_MJY("In mJy", UserSensitivity.USERUNIT_MJY),
        SENSITIVITY_UJY("In uJy", UserSensitivity.USERUNIT_UJY),
        SENSITIVITY_K("In K", UserSensitivity.USERUNIT_K),
        SENSITIVITY_MK("In mK", UserSensitivity.USERUNIT_MK);

        private final String label;
        private final String unit;

        static SensitivityDisplayOption getDefault() {
            return AUTOMATIC;
        }

        static SensitivityDisplayOption[] getSensitivityUnits() {
            ArrayList<SensitivityDisplayOption> arrayList = new ArrayList<SensitivityDisplayOption>();
            for (SensitivityDisplayOption sensitivityDisplayOption : SensitivityDisplayOption.values()) {
                if (sensitivityDisplayOption.unit != null) continue;
                arrayList.add(sensitivityDisplayOption);
            }
            return arrayList.toArray(new SensitivityDisplayOption[arrayList.size()]);
        }

        static String[] getKnownUnits() {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (SensitivityDisplayOption sensitivityDisplayOption : SensitivityDisplayOption.values()) {
                if (sensitivityDisplayOption.unit == null) continue;
                arrayList.add(sensitivityDisplayOption.unit);
            }
            return arrayList.toArray(new String[arrayList.size()]);
        }

        public String toString() {
            return this.label;
        }

        private SensitivityDisplayOption(String string2, String string3) {
            this.label = string2;
            this.unit = string3;
        }

        public String getLabel() {
            return this.label;
        }

        public String getUnit() {
            return this.unit;
        }
    }

    static enum TimeDisplayOption {
        AUTOMATIC("Automatic", null),
        CURRENT("Keep displayed unit", null),
        TIME_NS("In nanoseconds", Time.UNIT_NS),
        TIME_US("In microseconds", Time.UNIT_US),
        TIME_MS("In miliseconds", Time.UNIT_MS),
        TIME_SEC("In sec", Time.UNIT_S),
        TIME_MIN("In min", Time.UNIT_MIN),
        TIME_HOUR("In hour", Time.UNIT_H),
        TIME_DAY("In day", Time.UNIT_D);

        private final String label;
        private final String unit;

        static TimeDisplayOption getDefault() {
            return AUTOMATIC;
        }

        static TimeDisplayOption[] getIntegrationTimeUnits() {
            ArrayList<TimeDisplayOption> arrayList = new ArrayList<TimeDisplayOption>();
            for (TimeDisplayOption timeDisplayOption : TimeDisplayOption.values()) {
                if (timeDisplayOption.unit != null) continue;
                arrayList.add(timeDisplayOption);
            }
            return arrayList.toArray(new TimeDisplayOption[arrayList.size()]);
        }

        static String[] getKnownUnits() {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (TimeDisplayOption timeDisplayOption : TimeDisplayOption.values()) {
                if (timeDisplayOption.unit == null) continue;
                arrayList.add(timeDisplayOption.unit);
            }
            return arrayList.toArray(new String[arrayList.size()]);
        }

        public String toString() {
            return this.label;
        }

        private TimeDisplayOption(String string2, String string3) {
            this.label = string2;
            this.unit = string3;
        }

        public String getLabel() {
            return this.label;
        }

        public String getUnit() {
            return this.unit;
        }
    }
}

