/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.etc;

import alma.obsprep.bo.obsproject.CalibrationSetupParameters;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.services.calibration.CalObs;
import alma.obsprep.services.calibration.CalType;
import alma.obsprep.services.calibration.SBTimeEstimateHelper;
import alma.obsprep.services.etc.TimeEstimatesPointingCalculatorInterface;
import java.util.EnumSet;
import lombok.NonNull;

public class DGCTimeEstimatesPointingCalculator
implements TimeEstimatesPointingCalculatorInterface {
    @Override
    public int getNoOfPointingCalibrations(SBTimeEstimateHelper sBTimeEstimateHelper, @NonNull ScienceGoal scienceGoal, @NonNull SBTimeEstimateHelper.GroupType groupType, int n, int n2) {
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        if (groupType == null) {
            throw new NullPointerException("observingGroup is marked non-null but is null");
        }
        boolean bl = n > 1;
        String string = scienceGoal.getCalibrationSetupParameters().getSelection();
        switch (groupType) {
            case CALIBRATORS: {
                if (bl) {
                    return 2;
                }
                if (string.equals(CalibrationSetupParameters.SELECTION_SYSTEM)) {
                    return 3;
                }
                if (string.equals(CalibrationSetupParameters.SELECTION_SYSTEMALTERNATE)) {
                    return 4;
                }
                return this.getNoOfPointingCalibrationsForUserDefinedStrategy(sBTimeEstimateHelper, groupType);
            }
            case SCIENCE: {
                if (string.equals(CalibrationSetupParameters.SELECTION_SYSTEM)) {
                    return bl ? 2 : 1;
                }
                if (string.equals(CalibrationSetupParameters.SELECTION_SYSTEMALTERNATE)) {
                    return bl ? 3 : 1;
                }
                return this.getNoOfPointingCalibrationsForUserDefinedStrategy(sBTimeEstimateHelper, groupType);
            }
        }
        throw new RuntimeException("observingGroup not recognised " + groupType);
    }

    @Override
    public int getNoOfPointingCalibrationsForUserDefinedStrategy(SBTimeEstimateHelper sBTimeEstimateHelper, SBTimeEstimateHelper.GroupType groupType) {
        EnumSet<CalType> enumSet = EnumSet.of(CalType.Amplitude, CalType.Bandpass, CalType.Phase);
        int n = 0;
        for (CalObs[] calObsArray : sBTimeEstimateHelper.getCalibrationsForGroup(groupType)) {
            for (CalObs calObs : calObsArray) {
                for (CalType calType : enumSet) {
                    if (!calType.equals((Object)calObs.getCalType())) continue;
                    ++n;
                }
            }
        }
        return n += 2;
    }
}

