/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.etc;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.services.etc.AtmCalList;
import alma.obsprep.services.etc.ObservingTimeCalculator;
import alma.valuetypes.Time;
import java.util.ArrayList;
import java.util.List;

class AtmCalsForSB {
    final List<Long> atmCals = new ArrayList<Long>();
    int sbExecutionCount = 0;

    AtmCalsForSB() {
    }

    public void add(long l) {
        this.atmCals.add(l);
    }

    public long getTotalNumberOfAtmCals() {
        if (this.sbExecutionCount == 0) {
            throw new IllegalArgumentException("Illegal argument: sbExecutionCount  (" + this.sbExecutionCount + ") did not pass the test: sbExecutionCount  == 0");
        }
        long l = 0L;
        for (Long l2 : this.atmCals) {
            l += l2.longValue();
        }
        Log.logger(AtmCalList.class).fine("Total number of atm cals for science targets is: " + (l *= (long)this.sbExecutionCount));
        return l;
    }

    public Time getTotalAmountOfAtmCalTime() {
        if (this.sbExecutionCount == 0) {
            throw new IllegalArgumentException("Illegal argument: sbExecutionCount  (" + this.sbExecutionCount + ") did not pass the test: sbExecutionCount  == 0");
        }
        Time time = Time.createTimeSec(0.0);
        time.aggregate((Time)ObservingTimeCalculator.ATM_CAL_TIME.multiply(this.getTotalNumberOfAtmCals()));
        Log.logger(AtmCalList.class).fine("Total amount of atm cal time for science targets: " + time);
        return time;
    }

    public void setSbExecutionCount(int n) {
        this.sbExecutionCount = n;
    }
}

