/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.calibration;

import alma.hla.runtime.obsprep.util.UnitMap;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.editors.valuetypes.SkyCoordsEditor;
import alma.obsprep.ot.editors.valuetypes.ValueUnitPairEditor;
import alma.obsprep.ot.models.valuetypes.AbstractValueUnitPairModel;
import alma.obsprep.services.calibration.CalibrationTimeModel;
import alma.obsprep.services.etc.AtmosphereTable;
import alma.obsprep.util.TextUtils;
import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import alma.valuetypes.Temperature;
import alma.valuetypes.Time;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class CalTimeEditor
extends EditorWithGridBagLayout {
    public CalTimeEditor(Model model) {
        this.setModel(model);
        this.build();
    }

    @Override
    public void set(JComponent jComponent, Object object) {
        if (jComponent instanceof JPanel) {
            this.set((JPanel)jComponent, object);
        } else {
            super.set(jComponent, object);
        }
    }

    @Override
    protected void build() {
        this.setBorder(BorderFactory.createTitledBorder("Calibration Time"));
        super.build("Calibration Time");
    }

    @Override
    protected void addComponents(String string) {
        this.constraints.anchor = 18;
        CalibrationTimeModel calibrationTimeModel = (CalibrationTimeModel)this.getModel();
        Box box = Box.createHorizontalBox();
        box.add(this.makeTextField(CalibrationTimeModel.srcNameFid, "Source Name"));
        box.add(this.makeButton(CalibrationTimeModel.resolveSrcFid, "Resolve", "Resolve the object name"));
        this.addLabeledComponent((JComponent)this, this.layout, this.constraints, "Source Name", (JComponent)box);
        this.addLabeledComponent((JComponent)this, this.layout, this.constraints, "", (JComponent)new SkyCoordsEditor(calibrationTimeModel.getSrcCoordsModel()));
        this.addVerticalSpace(this, this.layout, this.constraints);
        box = Box.createHorizontalBox();
        box.add(this.makeTextField(CalibrationTimeModel.calNameFid, "Calibrator Name"));
        box.add(this.makeButton(CalibrationTimeModel.resolveCalFid, "Resolve", "Resolve the object name"));
        this.addLabeledComponent((JComponent)this, this.layout, this.constraints, "Calibrator", (JComponent)box);
        this.addLabeledComponent((JComponent)this, this.layout, this.constraints, "", (JComponent)new SkyCoordsEditor(calibrationTimeModel.getCalCoordsModel()));
        this.addValueUnitPair((JComponent)this, this.layout, this.constraints, calibrationTimeModel.getFluxModel(), "Calibrator Flux", "Calibrator Flux");
        JTextField jTextField = this.makeTextField(CalibrationTimeModel.offAngleFid, false, "Offset Angle from the source to the calibrator");
        this.addLabeledComponent((JComponent)this, this.layout, this.constraints, "Offset Angle", (JComponent)jTextField);
        jTextField = this.makeTextField(CalibrationTimeModel.mvTimeFid, false, "Antenna movement time(one way) : rough estimation (angle / 3.0[deg/sec] + 1.5[sec])");
        this.addLabeledComponent((JComponent)this, this.layout, this.constraints, "One way movement", (JComponent)jTextField);
        this.addVerticalSpace(this, this.layout, this.constraints);
        this.addValueUnitPair((JComponent)this, this.layout, this.constraints, calibrationTimeModel.getFrequencyModel(), "Center Frequency", "observing frequency (center)");
        this.addLabeledComponent((JComponent)this, this.layout, this.constraints, "Water Vapour", (JComponent)this.wvlabelComponent());
        String string2 = "<html>Desired SNR. 1000:1 for Full ALMA, 100:1 for ES ALMA are recommended.</html>";
        jTextField = this.makeTextFieldWithDoubleVerifier(CalibrationTimeModel.snrFid, string2, Double.MIN_VALUE, Double.MAX_VALUE);
        this.addLabeledComponent((JComponent)this, this.layout, this.constraints, "Desired SNR", (JComponent)jTextField);
        jTextField = this.makeTextFieldWithIntegerVerifier(CalibrationTimeModel.nAntennaFid, "Number of Antennas", 1, 64);
        this.addLabeledComponent((JComponent)this, this.layout, this.constraints, "Number of Antennas", (JComponent)jTextField);
        jTextField = this.makeTextField(CalibrationTimeModel.apEffFid, false, "Aperture Efficiency");
        this.addLabeledComponent((JComponent)this, this.layout, this.constraints, "Aperture Efficiency", (JComponent)jTextField);
        jTextField = this.makeTextField(CalibrationTimeModel.tsysFid, false, "Tsys at the center frequency");
        this.addLabeledComponent((JComponent)this, this.layout, this.constraints, "Tsys", (JComponent)jTextField);
        jTextField = this.makeTextField(CalibrationTimeModel.sciResFid, false, "Spectral resolution for the target observation");
        this.addLabeledComponent((JComponent)this, this.layout, this.constraints, "Resolution (Obs)", (JComponent)jTextField);
        EditorWithGridBagLayout.ComponentCollection componentCollection = new EditorWithGridBagLayout.ComponentCollection(this);
        JComponent[] jComponentArray = new JComponent[1];
        JLabel jLabel = this.makeLabel("Resolution(Cal)");
        jComponentArray[0] = jLabel;
        componentCollection.remember(jComponentArray);
        JComponent[] jComponentArray2 = new JComponent[1];
        ValueUnitPairEditor valueUnitPairEditor = this.makeValueUnitPairEditor((AbstractValueUnitPairModel)calibrationTimeModel.getResolutionModel(), UnitMap.getFrequencyUnits(), "Spectral Resolution for this calibartion");
        jComponentArray2[0] = valueUnitPairEditor;
        componentCollection.remember(jComponentArray2);
        this.addComponentArray(this, this.layout, this.constraints, componentCollection);
        box = Box.createHorizontalBox();
        box.add(this.makeTextField(CalibrationTimeModel.calTimeFid, false, "Estimated calibration time per cal"));
        box.add(this.makeButton(CalibrationTimeModel.calCalcBtnFid, "Calculate", "Click to calculate/update calibration time estimate"));
        this.addLabeledComponent((JComponent)this, this.layout, this.constraints, "Calibration Time", (JComponent)box);
        jTextField = this.makeTextField(CalibrationTimeModel.totalTimeFid, false, "Total time for calibration : calibration time + two-way movement");
        this.addLabeledComponent((JComponent)this, this.layout, this.constraints, "Total Time", (JComponent)jTextField);
    }

    private JComboBox wvlabelComponent() {
        String string = "Maximum allowd column density of precipatable water vapor.";
        JComboBox jComboBox = this.makeComboBox(CalibrationTimeModel.wvindexFid, AtmosphereTable.WV_MAP, string);
        return jComboBox;
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        if (fieldID.equals(CalibrationTimeModel.documentFid)) {
            return;
        }
        if (fieldID.equals(CalibrationTimeModel.offAngleFid)) {
            Angle angle = (Angle)((Object)object);
            super.update(fieldID, TextUtils.format(angle, 0, 3));
            return;
        }
        if (fieldID.equals(CalibrationTimeModel.snrFid)) {
            double d = (Double)object;
            super.update(fieldID, TextUtils.format(d, 0, 1));
            return;
        }
        if (fieldID.equals(CalibrationTimeModel.apEffFid)) {
            if (object == null) {
                super.update(fieldID, null);
                return;
            }
            double d = (Double)object;
            super.update(fieldID, TextUtils.format(d, 0, 3));
            return;
        }
        if (fieldID.equals(CalibrationTimeModel.tsysFid)) {
            Temperature temperature = (Temperature)((Object)object);
            super.update(fieldID, TextUtils.format(temperature, 3));
            return;
        }
        if (fieldID.equals(CalibrationTimeModel.sciResFid)) {
            Frequency frequency = (Frequency)((Object)object);
            super.update(fieldID, TextUtils.format(frequency, 1));
            return;
        }
        if (fieldID.equals(CalibrationTimeModel.calCalcBtnFid)) {
            return;
        }
        if (fieldID.equals(CalibrationTimeModel.mvTimeFid) || fieldID.equals(CalibrationTimeModel.totalTimeFid)) {
            Time time = (Time)object;
            if (time == null) {
                super.update(fieldID, null);
                return;
            }
            time.convertToFriendlyUnit();
            super.update(fieldID, TextUtils.format(time, 0, 2));
            return;
        }
        super.update(fieldID, object);
    }
}

