/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.calibration;

import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.ot.editors.misc.ValueUnitPairParser;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.util.MiscUtils;
import alma.valuetypes.Angle;
import alma.valuetypes.Flux;
import alma.valuetypes.Speed;
import alma.valuetypes.Time;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import lombok.NonNull;

public class CalObsProperties {
    private Map<CalObsProperty, Object> calObsProperties = new HashMap<CalObsProperty, Object>();
    private ValueUnitPairParser vupParser = new ValueUnitPairParser();
    private static ArrayList<ChangeListener> listeners = new ArrayList();
    private static final File PROPERTIES_FOLDER = new File("alma/obsprep/services/calibration");
    private static final String PROPERTIES_NAME = "CalObs.properties";
    private static CalObsProperties instance = null;

    private CalObsProperties() throws InvalidObsProgramParametersException {
        Properties properties = CalObsProperties.loadProperties();
        for (Object object : properties.keySet()) {
            CalObsProperty calObsProperty;
            String string = (String)object;
            String string2 = properties.getProperty(string);
            try {
                calObsProperty = CalObsProperty.getCalObsProperty((String)object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new InvalidObsProgramParametersException(illegalArgumentException);
            }
            Class clazz = calObsProperty.getValueType();
            Object object2 = null;
            try {
                if (ValueUnitPair.class.isAssignableFrom(clazz)) {
                    object2 = this.vupParser.parse(string2, clazz);
                } else if (clazz == Double.class) {
                    object2 = Double.parseDouble(string2);
                } else if (clazz == Integer.class) {
                    object2 = Integer.parseInt(string2);
                } else if (clazz == String.class) {
                    object2 = string2;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (object2 == null) {
                throw new InvalidObsProgramParametersException("Can not parse string \"" + string2 + "\" as a value for property " + calObsProperty);
            }
            this.calObsProperties.put(calObsProperty, object2);
        }
    }

    public static CalObsProperties getInstance() {
        if (instance == null) {
            try {
                instance = new CalObsProperties();
            }
            catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                Log.logger(CalObsProperties.class).log(Level.WARNING, invalidObsProgramParametersException.getMessage(), (Throwable)invalidObsProgramParametersException);
            }
        }
        return instance;
    }

    public static void refresh() {
        instance = null;
        ChangeEvent changeEvent = new ChangeEvent(CalObsProperties.class);
        for (ChangeListener changeListener : listeners) {
            changeListener.stateChanged(changeEvent);
        }
    }

    private static Properties loadProperties() {
        Properties properties = new Properties();
        String string = System.getProperty("Telescope", "ESALMA");
        try {
            URL uRL = MiscUtils.findResource(PROPERTIES_FOLDER, string + PROPERTIES_NAME);
            properties.load(uRL.openStream());
        }
        catch (Exception exception) {
            Log.logger(CalObsProperties.class).warning("Error accessing " + string + "CalObs.properties file: " + exception.getMessage());
            exception.printStackTrace(System.err);
        }
        return properties;
    }

    public static void addChangeListener(ChangeListener changeListener) {
        listeners.add(changeListener);
    }

    public Flux getBandpassFlux() {
        return (Flux)((Object)this.calObsProperties.get((Object)CalObsProperty.BANDPASS_FLUX));
    }

    public Flux getBandpassFlux(String string) {
        if ("ALMA_RB_03".equals(string)) {
            return (Flux)((Object)this.calObsProperties.get((Object)CalObsProperty.BANDPASS_B3_FLUX));
        }
        if ("ALMA_RB_06".equals(string)) {
            return (Flux)((Object)this.calObsProperties.get((Object)CalObsProperty.BANDPASS_B6_FLUX));
        }
        if ("ALMA_RB_07".equals(string)) {
            return (Flux)((Object)this.calObsProperties.get((Object)CalObsProperty.BANDPASS_B7_FLUX));
        }
        if ("ALMA_RB_09".equals(string)) {
            return (Flux)((Object)this.calObsProperties.get((Object)CalObsProperty.BANDPASS_B9_FLUX));
        }
        return this.getBandpassFlux();
    }

    public Flux getBandpassStrongFlux() {
        return (Flux)((Object)this.calObsProperties.get((Object)CalObsProperty.BANDPASS_STRONG_FLUX));
    }

    public Flux getPhaseFlux() {
        return (Flux)((Object)this.calObsProperties.get((Object)CalObsProperty.PHASE_FLUX));
    }

    public Flux getPhaseFlux(String string) {
        if ("ALMA_RB_03".equals(string)) {
            return (Flux)((Object)this.calObsProperties.get((Object)CalObsProperty.PHASE_B3_FLUX));
        }
        if ("ALMA_RB_06".equals(string)) {
            return (Flux)((Object)this.calObsProperties.get((Object)CalObsProperty.PHASE_B6_FLUX));
        }
        if ("ALMA_RB_07".equals(string)) {
            return (Flux)((Object)this.calObsProperties.get((Object)CalObsProperty.PHASE_B7_FLUX));
        }
        if ("ALMA_RB_09".equals(string)) {
            return (Flux)((Object)this.calObsProperties.get((Object)CalObsProperty.PHASE_B9_FLUX));
        }
        return this.getPhaseFlux();
    }

    public Flux getDelayFlux(String string) {
        if ("ALMA_RB_03".equals(string)) {
            return (Flux)((Object)this.calObsProperties.get((Object)CalObsProperty.DELAY_B3_FLUX));
        }
        if ("ALMA_RB_06".equals(string)) {
            return (Flux)((Object)this.calObsProperties.get((Object)CalObsProperty.DELAY_B6_FLUX));
        }
        if ("ALMA_RB_07".equals(string)) {
            return (Flux)((Object)this.calObsProperties.get((Object)CalObsProperty.DELAY_B7_FLUX));
        }
        if ("ALMA_RB_09".equals(string)) {
            return (Flux)((Object)this.calObsProperties.get((Object)CalObsProperty.DELAY_B9_FLUX));
        }
        return this.getBandpassFlux();
    }

    public Flux getAmplitudeFlux() {
        return (Flux)((Object)this.calObsProperties.get((Object)CalObsProperty.AMPLITUDE_FLUX));
    }

    public Flux getPointingFlux() {
        return (Flux)((Object)this.calObsProperties.get((Object)CalObsProperty.POINTING_FLUX));
    }

    public Time getBandpassCycleTime() {
        return (Time)this.calObsProperties.get((Object)CalObsProperty.BANDPASS_CYCLE);
    }

    public Time getAmplitudeCycleTime() {
        return (Time)this.calObsProperties.get((Object)CalObsProperty.AMPLITUDE_CYCLE);
    }

    public Time getPointingCycleTime() {
        return (Time)this.calObsProperties.get((Object)CalObsProperty.POINTING_CYCLE);
    }

    public double getBandpassCalSNR() {
        return (Double)this.calObsProperties.get((Object)CalObsProperty.BANDPASS_SNR);
    }

    public double getPhaseCalSNR() {
        return (Double)this.calObsProperties.get((Object)CalObsProperty.PHASE_SNR);
    }

    public double getAmplitudeCalResolvedSNR() {
        return (Double)this.calObsProperties.get((Object)CalObsProperty.AMPLITUDE_RESOLVED_SNR);
    }

    public double getAmplitudeCalUnresolvedSNR() {
        return (Double)this.calObsProperties.get((Object)CalObsProperty.AMPLITUDE_UNRESOLVED_SNR);
    }

    public double getPolarizationCalSNR() {
        return (Double)this.calObsProperties.get((Object)CalObsProperty.POLARIZATION_SNR);
    }

    public Flux getAmplitudeCalResolvedFlux() {
        return (Flux)((Object)this.calObsProperties.get((Object)CalObsProperty.AMPLITUDE_RESOLVED_FLUX));
    }

    public int getBandpassCalBinsizeFDM() {
        return (Integer)this.calObsProperties.get((Object)CalObsProperty.BANDPASS_BINSIZE_FDM);
    }

    public int getBandpassCalBinsizeTDM() {
        return (Integer)this.calObsProperties.get((Object)CalObsProperty.BANDPASS_BINSIZE_TDM);
    }

    public Speed getAverageWindSpeed() {
        return (Speed)((Object)this.calObsProperties.get((Object)CalObsProperty.AVERAGE_WIND_SPEED));
    }

    public double getPhaseFluctuationsBest() {
        return (Double)this.calObsProperties.get((Object)CalObsProperty.PHASE_FLUCTUATIONS_BEST);
    }

    public double getPhaseFluctuations1st() {
        return (Double)this.calObsProperties.get((Object)CalObsProperty.PHASE_FLUCTUATIONS_1ST);
    }

    public double getPhaseFluctuations2nd() {
        return (Double)this.calObsProperties.get((Object)CalObsProperty.PHASE_FLUCTUATIONS_2ND);
    }

    public double getPhaseFluctuations3rd() {
        return (Double)this.calObsProperties.get((Object)CalObsProperty.PHASE_FLUCTUATIONS_3RD);
    }

    public double getPhaseFluctuationsFunction() {
        return (Double)this.calObsProperties.get((Object)CalObsProperty.PHASE_FLUCTUATIONS_FUNCTION);
    }

    public Angle getPointingSpec() {
        return (Angle)((Object)this.calObsProperties.get((Object)CalObsProperty.POINTING_SPEC));
    }

    public Time getAtmosphericCalTime() {
        return (Time)this.calObsProperties.get((Object)CalObsProperty.ATMOSPHERIC_CAL_TIME);
    }

    public Time getSidebandRatioCalTime() {
        return (Time)this.calObsProperties.get((Object)CalObsProperty.SIDEBAND_RATIO_CAL_TIME);
    }

    public Time getSidebandRatioCycleTime() {
        return (Time)this.calObsProperties.get((Object)CalObsProperty.SIDEBAND_RATIO_CYCLE_TIME);
    }

    public Time getDelayCalTime() {
        return (Time)this.calObsProperties.get((Object)CalObsProperty.DELAY_CAL_TIME);
    }

    public Time getDelayCycleTime() {
        return (Time)this.calObsProperties.get((Object)CalObsProperty.DELAY_CYCLE_TIME);
    }

    public Time getCheckSourceCalTime() {
        return (Time)this.calObsProperties.get((Object)CalObsProperty.DELAY_CAL_TIME);
    }

    public Time getCheckSourceCycleTime() {
        return (Time)this.calObsProperties.get((Object)CalObsProperty.DELAY_CYCLE_TIME);
    }

    public Time getAtmosphericCycleTime() {
        return (Time)this.calObsProperties.get((Object)CalObsProperty.ATMOSPHERIC_CYCLE_TIME);
    }

    @NonNull
    public Time getDGCReferenceCycleTime() {
        return (Time)this.calObsProperties.get((Object)CalObsProperty.DGC_REFERENCE_CYCLE_TIME);
    }

    @NonNull
    public Time getDGCScienceCycleTime() {
        return (Time)this.calObsProperties.get((Object)CalObsProperty.DGC_SCIENCE_CYCLE_TIME);
    }

    public static void main(String[] stringArray) throws Exception {
        InitServices.init();
        System.setProperty("Telescope", "ALMA");
        CalObsProperties calObsProperties = CalObsProperties.getInstance();
        System.out.println("Bandpass B3                 : " + calObsProperties.getBandpassFlux("ALMA_RB_03"));
        System.out.println("Bandpass B6                 : " + calObsProperties.getBandpassFlux("ALMA_RB_06"));
        System.out.println("Bandpass B7                 : " + calObsProperties.getBandpassFlux("ALMA_RB_07"));
        System.out.println("Bandpass B9                 : " + calObsProperties.getBandpassFlux("ALMA_RB_09"));
        System.out.println("Delay B3                    : " + calObsProperties.getDelayFlux("ALMA_RB_03"));
        System.out.println("Delay B6                    : " + calObsProperties.getDelayFlux("ALMA_RB_06"));
        System.out.println("Delay B7                    : " + calObsProperties.getDelayFlux("ALMA_RB_07"));
        System.out.println("Delay B9                    : " + calObsProperties.getDelayFlux("ALMA_RB_09"));
        System.out.println("Phase B3                    : " + calObsProperties.getPhaseFlux("ALMA_RB_03"));
        System.out.println("Phase B6                    : " + calObsProperties.getPhaseFlux("ALMA_RB_06"));
        System.out.println("Phase B7                    : " + calObsProperties.getPhaseFlux("ALMA_RB_07"));
        System.out.println("Phase B9                    : " + calObsProperties.getPhaseFlux("ALMA_RB_09"));
        System.out.println("Bandpass Flux (Weak)        : " + calObsProperties.getBandpassFlux());
        System.out.println("Bandpass Flux (Strong)      : " + calObsProperties.getBandpassStrongFlux());
        System.out.println("Phase Flux                  : " + calObsProperties.getPhaseFlux());
        System.out.println("Amplitude Flux              : " + calObsProperties.getAmplitudeFlux());
        System.out.println("Amplitude Flux (Resolved)   : " + calObsProperties.getAmplitudeCalResolvedFlux());
        System.out.println("Pointing Flux               : " + calObsProperties.getPointingFlux());
        System.out.println("Bandpass Time               : " + calObsProperties.getBandpassCycleTime().convertToFriendlyUnit());
        System.out.println("Amplitude Time              : " + calObsProperties.getAmplitudeCycleTime().convertToFriendlyUnit());
        System.out.println("Pointing Time               : " + calObsProperties.getPointingCycleTime().convertToFriendlyUnit());
        System.out.println("Bandpass SNR                : " + calObsProperties.getBandpassCalSNR());
        System.out.println("Phase SNR                   : " + calObsProperties.getPhaseCalSNR());
        System.out.println("Amp.resolved SNR            : " + calObsProperties.getAmplitudeCalResolvedSNR());
        System.out.println("Amp.unresolved SNR          : " + calObsProperties.getAmplitudeCalUnresolvedSNR());
        System.out.println("PolarizationSNR             : " + calObsProperties.getPolarizationCalSNR());
        System.out.println("Bandpass Bin FDM            : " + calObsProperties.getBandpassCalBinsizeFDM());
        System.out.println("Bandpass Bin TDM            : " + calObsProperties.getBandpassCalBinsizeTDM());
        System.out.println("Average Wind Speed          : " + calObsProperties.getAverageWindSpeed());
        System.out.println("Phase Fluctuations Best     : " + calObsProperties.getPhaseFluctuationsBest());
        System.out.println("Phase Fluctuations 1st      : " + calObsProperties.getPhaseFluctuations1st());
        System.out.println("Phase Fluctuations 2nd      : " + calObsProperties.getPhaseFluctuations2nd());
        System.out.println("Phase Fluctuations 3rd      : " + calObsProperties.getPhaseFluctuations3rd());
        System.out.println("Phase Fluctuations Function : " + calObsProperties.getPhaseFluctuationsFunction());
        System.out.println("Pointing Spec               : " + calObsProperties.getPointingSpec());
        System.out.println("Atmospheric Cal Time        : " + calObsProperties.getAtmosphericCalTime());
        System.out.println("Atmospheric Cycle Time      : " + calObsProperties.getAtmosphericCycleTime());
    }

    private static enum CalObsProperty {
        BANDPASS_B3_FLUX(Flux.class),
        BANDPASS_B6_FLUX(Flux.class),
        BANDPASS_B7_FLUX(Flux.class),
        BANDPASS_B9_FLUX(Flux.class),
        DELAY_B3_FLUX(Flux.class),
        DELAY_B6_FLUX(Flux.class),
        DELAY_B7_FLUX(Flux.class),
        DELAY_B9_FLUX(Flux.class),
        PHASE_B3_FLUX(Flux.class),
        PHASE_B6_FLUX(Flux.class),
        PHASE_B7_FLUX(Flux.class),
        PHASE_B9_FLUX(Flux.class),
        BANDPASS_FLUX(Flux.class),
        BANDPASS_STRONG_FLUX(Flux.class),
        PHASE_FLUX(Flux.class),
        AMPLITUDE_FLUX(Flux.class),
        AMPLITUDE_RESOLVED_FLUX(Flux.class),
        POINTING_FLUX(Flux.class),
        BANDPASS_CYCLE(Time.class),
        AMPLITUDE_CYCLE(Time.class),
        POINTING_CYCLE(Time.class),
        BANDPASS_SNR(Double.class),
        PHASE_SNR(Double.class),
        AMPLITUDE_RESOLVED_SNR(Double.class),
        AMPLITUDE_UNRESOLVED_SNR(Double.class),
        POLARIZATION_SNR(Double.class),
        BANDPASS_BINSIZE_FDM(Integer.class),
        BANDPASS_BINSIZE_TDM(Integer.class),
        AVERAGE_WIND_SPEED(Speed.class),
        PHASE_FLUCTUATIONS_BEST(Double.class),
        PHASE_FLUCTUATIONS_1ST(Double.class),
        PHASE_FLUCTUATIONS_2ND(Double.class),
        PHASE_FLUCTUATIONS_3RD(Double.class),
        PHASE_FLUCTUATIONS_FUNCTION(Double.class),
        POINTING_SPEC(Angle.class),
        ATMOSPHERIC_CAL_TIME(Time.class),
        ATMOSPHERIC_CYCLE_TIME(Time.class),
        SIDEBAND_RATIO_CAL_TIME(Time.class),
        SIDEBAND_RATIO_CYCLE_TIME(Time.class),
        DELAY_CAL_TIME(Time.class),
        DELAY_CYCLE_TIME(Time.class),
        CHECKSOURCE_CAL_TIME(Time.class),
        CHECKSOURCE_CYCLE_TIME(Time.class),
        DGC_REFERENCE_CYCLE_TIME(Time.class),
        DGC_SCIENCE_CYCLE_TIME(Time.class);

        private Class valueType;

        private CalObsProperty(Class clazz) {
            this.valueType = clazz;
        }

        public Class getValueType() {
            return this.valueType;
        }

        public static CalObsProperty getCalObsProperty(@NonNull String string) {
            if (string == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            for (CalObsProperty calObsProperty : CalObsProperty.values()) {
                if (!calObsProperty.name().equals(string)) continue;
                return calObsProperty;
            }
            throw new IllegalArgumentException("Unknown CalObsProperty name : " + string);
        }
    }
}

