/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.calibration;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.observatorycharacteristics.capabilities.AlmaCapabilities;
import alma.observatorycharacteristics.site.SiteCharacteristics;
import alma.obsprep.bo.annotations.NameResolvable;
import alma.obsprep.bo.enumerations.Antenna;
import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.obsproject.CalibrationTargetParameters;
import alma.obsprep.bo.obsproject.CalibrationTargetProperties;
import alma.obsprep.bo.obsproject.IQuerySource;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.services.calibration.AmplitudeCalObs;
import alma.obsprep.services.calibration.AtmosphericCalObs;
import alma.obsprep.services.calibration.BandpassCalObs;
import alma.obsprep.services.calibration.CalObsProperties;
import alma.obsprep.services.calibration.CalTimeCalculator;
import alma.obsprep.services.calibration.CalTimeData;
import alma.obsprep.services.calibration.CalType;
import alma.obsprep.services.calibration.CheckSourceCalObs;
import alma.obsprep.services.calibration.DGCReferenceCalObs;
import alma.obsprep.services.calibration.DGCScienceCalObs;
import alma.obsprep.services.calibration.DelayCalObs;
import alma.obsprep.services.calibration.PhaseCalObs;
import alma.obsprep.services.calibration.PointingCalObs;
import alma.obsprep.services.calibration.PolarizationCalObs;
import alma.obsprep.services.calibration.SidebandRatioCalObs;
import alma.obsprep.services.etc.ExposureTimeCalculator;
import alma.obsprep.services.etc.SourceNeverVisibleException;
import alma.obsprep.services.etc.editor.WaterVaporColumns;
import alma.obsprep.services.experts.InvalidFrequencyException;
import alma.valuetypes.Angle;
import alma.valuetypes.Flux;
import alma.valuetypes.Frequency;
import alma.valuetypes.Latitude;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.Temperature;
import alma.valuetypes.Time;
import alma.valuetypes.UserFrequency;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;

public abstract class CalObs
implements CalTimeData {
    private Optional<Time> preCalculatedCalTime = Optional.empty();
    private CalType secondaryIntentCalType;
    private CalibratorSecondaryIntentEnum calibratorSecondaryIntent = CalibratorSecondaryIntentEnum.UNDEFINED;
    private Optional<Integer> internalCycleCount = Optional.empty();
    private int noOfAtmCalsToBePerformed = 1;
    private boolean isIncludedInTimeEstimateAccounting = true;
    private int noOfScansPerNonRepeatingCal = 1;
    static final double BOLTZMANN = 1.38E-23;
    static final double LIGHTSPEED = 2.99792458E8;
    public static final double UNINITIALIZE_DEFAULT_FREQUENCY_GHZ = 345.0;
    protected ScienceGoal scienceGoal;
    private CalType calType;
    private SourceObject source = new SourceObject();
    private SourceObject calibrator = new SourceObject();
    private boolean isQuerySource = true;
    protected boolean isExecutingRepeatedly = true;
    protected Frequency sciFrequency;
    protected Frequency calFrequency;
    private Frequency spectralResolution;
    private Frequency channelWidth;
    private Angle desiredLargestScale;
    private Flux calibratorFlux;
    private int wvchoice = 3;
    private double sNR;
    private double correlatorEfficiency = 0.88;
    private Antenna antenna = Antenna.ANTENNA_12M;
    private int noOfAntennas = AlmaCapabilities.getInstance().getNominalNumAntennas(Array.ARRAY_12M);
    protected Time SBSuggestedCalibrationDefaultIntegrationTime = null;
    protected Time SBSuggestedCalibrationCycleTime = null;
    public static final List<CalType> supportedCal = new ArrayList<CalType>(EnumSet.allOf(CalType.class));

    public static CalObs createCalObs(CalType calType, ScienceGoal scienceGoal) {
        switch (calType) {
            case Bandpass: {
                return new BandpassCalObs(scienceGoal);
            }
            case Phase: {
                return new PhaseCalObs(scienceGoal);
            }
            case Amplitude: {
                return new AmplitudeCalObs(scienceGoal);
            }
            case Pointing: {
                return new PointingCalObs(scienceGoal);
            }
            case Atmospheric: {
                return new AtmosphericCalObs(scienceGoal);
            }
            case Polarization: {
                return new PolarizationCalObs(scienceGoal);
            }
            case SidebandRatio: {
                return new SidebandRatioCalObs(scienceGoal);
            }
            case Focus: 
            case Delay: {
                return new DelayCalObs(scienceGoal);
            }
            case CheckSource: {
                return new CheckSourceCalObs(scienceGoal);
            }
            case DGCScience: {
                return new DGCScienceCalObs(scienceGoal);
            }
            case DGCReference: {
                return new DGCReferenceCalObs(scienceGoal);
            }
        }
        throw new IllegalArgumentException("Unexpected CalType : " + calType);
    }

    public void configure() {
        if (this.scienceGoal != null) {
            PerformanceParameters performanceParameters = this.scienceGoal.getPerformanceParameters();
            this.configureScienceFrequency();
            this.setDesiredLargestScale(performanceParameters.getDesiredLargestScale().deepCopy());
            TargetParameters targetParameters = this.scienceGoal.getSoleTargetParameters();
            this.setSourceName(targetParameters.getSourceName());
            this.setSourceCoordinates(targetParameters.getSourceCoordinates().deepCopy());
            this.source.setNonSiderealMotion(targetParameters.getNonSiderealMotion());
            SpectralSetupParameters spectralSetupParameters = this.scienceGoal.getSpectralSetupParameters();
            this.noOfAntennas = AlmaCapabilities.getInstance().getNumAntennas(Array.ARRAY_12M, spectralSetupParameters);
            if (!spectralSetupParameters.isSpectralScan() && !spectralSetupParameters.getSSPDerivedFromSpectralScanSetup().booleanValue() && spectralSetupParameters.getAbstractScienceSpectralWindowCount() > 0) {
                UserFrequency userFrequency = spectralSetupParameters.getStringentSpectralWindow().getSpectralResolution().deepCopy();
                userFrequency.convertToUnit(userFrequency.getFriendlyUnit());
                this.setSpectralResolution((Frequency)((Object)userFrequency));
            }
        }
        this.setChannelWidth(this.getDefaultChannelWidth());
        this.setSNR(this.getDefaultSNR());
        this.setCalibratorFlux(this.getDefaultFlux());
    }

    private void configureScienceFrequency() {
        Frequency frequency;
        if (this.sciFrequency != null) {
            return;
        }
        this.sciFrequency = this.scienceGoal == null ? Frequency.createFrequencyGHZ(345.0) : (frequency = this.scienceGoal.getRepresentativeFrequencyInSky());
    }

    public static CalObsProperties getCalObsProperties() {
        return CalObsProperties.getInstance();
    }

    public boolean isSystemDefinedCal() {
        if (this.scienceGoal == null) {
            return false;
        }
        return this.scienceGoal.getCalibrationSetupParameters().isSystemDefinedCalibration();
    }

    public void setCalibrationTargetParameters(CalibrationTargetParameters calibrationTargetParameters) {
        if (calibrationTargetParameters == null || CalType.getCalType(calibrationTargetParameters.getIntendedUse()) != this.calType) {
            return;
        }
        this.setCalibratorCoordinates(calibrationTargetParameters.getSourceCoordinates().deepCopy());
        this.calibrator.setNonSiderealMotion(calibrationTargetParameters.getNonSiderealMotion());
        CalibrationTargetProperties calibrationTargetProperties = calibrationTargetParameters.getClosestProperties(this.sciFrequency);
        if (calibrationTargetProperties != null) {
            Flux flux = calibrationTargetProperties.getFlux();
            if (flux.isZero()) {
                this.setCalibratorFlux(this.getDefaultFlux());
            } else {
                this.setCalibratorFlux(calibrationTargetProperties.getFlux().deepCopy());
            }
        }
        this.setIsQuerySource(false);
    }

    public void setQuerySource(IQuerySource iQuerySource) {
        if (iQuerySource == null || CalType.getCalType(iQuerySource.getIntendedUse()) != this.calType) {
            return;
        }
        Flux flux = iQuerySource.getMinFlux();
        Flux flux2 = iQuerySource.getMaxFlux();
        if (flux.isZero() && flux2.isZero()) {
            this.setCalibratorFlux(this.getDefaultFlux());
        } else {
            this.setCalibratorFlux((Flux)((Flux)flux.plus((AbstractDoubleWithUnit)flux2)).half());
        }
        this.setIsQuerySource(true);
    }

    @Override
    public Temperature getTsys() throws InvalidFrequencyException, SourceNeverVisibleException {
        ReceiverBand receiverBand = null;
        if (this.scienceGoal != null) {
            receiverBand = this.scienceGoal.getReceiverBand();
        }
        Temperature temperature = ExposureTimeCalculator.getTsys(this.getCalibratorCoordinates(), this.getObservatoryLatitude(), this.getCalFrequency(), this.getWvindex(), Double.NaN, Optional.ofNullable(receiverBand));
        return temperature;
    }

    double getApertureEfficiency() {
        if (this.getCalFrequency() == null) {
            throw new NullPointerException("observingFrequency must not be null!");
        }
        return ExposureTimeCalculator.apertureEfficiency(this.getCalFrequency().getContentInGHz());
    }

    @Override
    public double getEffectiveApertureArea() {
        return this.getAntenna().getApertureArea() * this.getApertureEfficiency();
    }

    public Time rawCalTime() throws InvalidFrequencyException, SourceNeverVisibleException {
        return CalTimeCalculator.rawCalTime(this);
    }

    public Time calTime(Time time) throws InvalidFrequencyException, SourceNeverVisibleException {
        return time;
    }

    public Time calTime() throws InvalidFrequencyException, SourceNeverVisibleException {
        if (this.SBSuggestedCalibrationDefaultIntegrationTime != null) {
            return this.SBSuggestedCalibrationDefaultIntegrationTime;
        }
        return this.calTime(this.rawCalTime());
    }

    public void setSBSuggestedDefaultIntegrationTime(Time time) {
        this.SBSuggestedCalibrationDefaultIntegrationTime = time.deepCopy();
    }

    public void setSBSuggestedCycleTime(Time time) {
        this.SBSuggestedCalibrationCycleTime = time.deepCopy();
    }

    public Time rawCycleTime() {
        return Time.createTime();
    }

    public Time cycleTime(Time time) {
        return time;
    }

    public Time cycleTime() {
        if (this.SBSuggestedCalibrationCycleTime != null) {
            return this.SBSuggestedCalibrationCycleTime;
        }
        return this.cycleTime(this.rawCycleTime());
    }

    public Time onewayMotionTime() {
        if (this.getIsQuerySource() || this.source.isNonSiderealMotion() || this.calibrator.isNonSiderealMotion() || this.source.getSourceCoordinates() == null || this.calibrator.getSourceCoordinates() == null) {
            return Time.createTimeSec(3.0);
        }
        Angle angle = this.getOffsetAngle();
        double d = 3.0;
        double d2 = 1.5;
        double d3 = angle.getContentInUnits(Angle.UNIT_DEG) / d + d2;
        return Time.createTime((double)d3, (String)Time.UNIT_S);
    }

    public Time atmCalTime(SchedBlock schedBlock) {
        Time time = Time.createTime();
        if (this.atmCalRequired(schedBlock)) {
            AtmosphericCalObs atmosphericCalObs = new AtmosphericCalObs(this.scienceGoal);
            try {
                return atmosphericCalObs.calTime();
            }
            catch (SourceNeverVisibleException | InvalidFrequencyException exception) {
                // empty catch block
            }
        }
        return time;
    }

    public abstract boolean atmCalRequired(SchedBlock var1);

    public abstract double getDefaultSNR();

    public abstract Frequency getDefaultChannelWidth();

    public abstract Flux getDefaultFlux();

    public Angle getOffsetAngle() {
        SkyCoordinates skyCoordinates = this.getSourceCoordinates();
        SkyCoordinates skyCoordinates2 = this.getCalibratorCoordinates();
        double d = skyCoordinates.getLatitude().getContentInUnits(Angle.UNIT_RAD);
        double d2 = skyCoordinates2.getLatitude().getContentInUnits(Angle.UNIT_RAD);
        double d3 = skyCoordinates.getLongitude().getContentInUnits(Angle.UNIT_RAD);
        double d4 = skyCoordinates2.getLongitude().getContentInUnits(Angle.UNIT_RAD);
        double d5 = Math.sin(d) * Math.sin(d2) + Math.cos(d) * Math.cos(d2) * Math.cos(d4 - d3);
        double d6 = Math.acos(d5);
        Angle angle = Angle.createAngle((double)d6, (String)Angle.UNIT_RAD);
        angle.convertToUnit(Angle.UNIT_DEG);
        return angle;
    }

    public NameResolvable getSource() {
        return this.source;
    }

    public NameResolvable getCalibrator() {
        return this.calibrator;
    }

    public String getCalibratorSourceName() {
        return this.calibrator.getSourceName();
    }

    public void setCalibratorSourceName(String string) {
        this.calibrator.setSourceName(string);
    }

    public SkyCoordinates getCalibratorCoordinates() {
        if (this.calibrator.getSourceCoordinates() == null) {
            this.calibrator.setSourceCoordinates(SkyCoordinates.createAbsoluteCoordinates());
        }
        return this.calibrator.getSourceCoordinates();
    }

    public void setCalibratorCoordinates(SkyCoordinates skyCoordinates) {
        this.calibrator.setSourceCoordinates(skyCoordinates);
    }

    public boolean getIsQuerySource() {
        return this.isQuerySource;
    }

    public void setIsQuerySource(boolean bl) {
        this.isQuerySource = bl;
    }

    public String getSourceName() {
        return this.source.getSourceName();
    }

    public void setSourceName(String string) {
        this.source.setSourceName(string);
    }

    public SkyCoordinates getSourceCoordinates() {
        if (this.source.getSourceCoordinates() == null) {
            this.source.setSourceCoordinates(SkyCoordinates.createAbsoluteCoordinates());
        }
        return this.source.getSourceCoordinates();
    }

    public void setSourceCoordinates(SkyCoordinates skyCoordinates) {
        this.source.setSourceCoordinates(skyCoordinates);
    }

    public Latitude getObservatoryLatitude() {
        return SiteCharacteristics.getInstance().getObsLatitude();
    }

    public Frequency getSciFrequency() {
        if (this.sciFrequency == null) {
            this.configureScienceFrequency();
        }
        return this.sciFrequency;
    }

    public void setSciFrequency(Frequency frequency) {
        this.sciFrequency = frequency;
    }

    public Frequency getCalFrequency() {
        if (this.calFrequency != null) {
            return this.calFrequency;
        }
        return this.getSciFrequency();
    }

    public void setCalFrequency(Frequency frequency) {
        this.calFrequency = frequency;
    }

    public ReceiverBand getReceiverBand() throws InvalidFrequencyException {
        ReceiverBand receiverBand = null;
        if (this.scienceGoal != null) {
            receiverBand = this.scienceGoal.getReceiverBand();
        }
        if (receiverBand == null) {
            Frequency frequency = this.getSciFrequency();
            try {
                receiverBand = ReceiverBand.getReceiverBand(frequency);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new InvalidFrequencyException(frequency.getContentInGHz());
            }
        }
        return receiverBand;
    }

    public ReceiverBand getCalibrationReceiverBand() throws InvalidFrequencyException {
        ReceiverBand receiverBand = null;
        if (this.scienceGoal != null) {
            receiverBand = this.scienceGoal.getReceiverBand();
        }
        if (receiverBand == null) {
            Frequency frequency = this.getCalFrequency();
            try {
                receiverBand = ReceiverBand.getReceiverBand(frequency);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new InvalidFrequencyException(frequency.getContentInGHz());
            }
        }
        return receiverBand;
    }

    public Frequency getSpectralResolution() {
        if (this.spectralResolution == null) {
            this.spectralResolution = Frequency.createFrequency();
        }
        return this.spectralResolution;
    }

    public void setSpectralResolution(Frequency frequency) {
        this.spectralResolution = frequency;
    }

    @Override
    public Frequency getChannelWidth() {
        if (this.channelWidth == null) {
            this.channelWidth = Frequency.createFrequency();
        }
        return this.channelWidth;
    }

    public void setChannelWidth(Frequency frequency) {
        this.channelWidth = frequency;
    }

    public Angle getDesiredLargestScale() {
        if (this.desiredLargestScale == null) {
            this.desiredLargestScale = Angle.createAngle();
        }
        return this.desiredLargestScale;
    }

    public void setDesiredLargestScale(Angle angle) {
        this.desiredLargestScale = angle;
    }

    @Override
    public Flux getCalibratorFlux() {
        if (this.calibratorFlux == null) {
            this.calibratorFlux = Flux.createFlux();
        }
        return this.calibratorFlux;
    }

    public int getWvChoice() {
        return this.wvchoice;
    }

    public void setWvChoice(int n) {
        this.wvchoice = n;
    }

    public int getWvindex() {
        ReceiverBand receiverBand = null;
        if (this.scienceGoal != null) {
            receiverBand = this.scienceGoal.getReceiverBand();
        }
        return this.wvchoice >= 0 ? this.wvchoice : WaterVaporColumns.wvindexSelector(this.getSciFrequency(), this.getSourceCoordinates().getJ2000SkyCoordinates().getLatitude(), Optional.ofNullable(receiverBand));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("========= " + this.getClass().getSimpleName() + " : Common Part ==========\n");
        stringBuilder.append("name                  = " + this.calibrator.getSourceName()).append("\n");
        stringBuilder.append("calCoordinates        = " + this.calibrator.getSourceCoordinates()).append("\n");
        stringBuilder.append("srcCoordinates        = " + this.source.getSourceCoordinates()).append("\n");
        stringBuilder.append("obs.Latitude          = " + this.getObservatoryLatitude()).append("\n");
        stringBuilder.append("sciFrequency          = " + this.getSciFrequency()).append("\n");
        stringBuilder.append("calFrequency          = " + this.getCalFrequency()).append("\n");
        stringBuilder.append("bandwidth/resolution  = " + this.getChannelWidth()).append("\n");
        stringBuilder.append("cal flux              = " + this.getCalibratorFlux()).append("\n");
        stringBuilder.append("SNR                   = " + this.getSNR()).append("\n");
        stringBuilder.append("wvindex               = " + this.getWvChoice()).append("\n");
        stringBuilder.append("correlator efficiency = " + this.getCorrelatorEfficiency()).append("\n");
        stringBuilder.append("antenna               = " + this.antenna + " x " + this.noOfAntennas + "\n");
        return stringBuilder.toString();
    }

    public Optional<Time> getPreCalculatedCalTime() {
        return this.preCalculatedCalTime;
    }

    public void setPreCalculatedCalTime(Optional<Time> optional) {
        this.preCalculatedCalTime = optional;
    }

    public CalType getSecondaryIntentCalType() {
        return this.secondaryIntentCalType;
    }

    public void setSecondaryIntentCalType(CalType calType) {
        this.secondaryIntentCalType = calType;
    }

    public CalibratorSecondaryIntentEnum getCalibratorSecondaryIntent() {
        return this.calibratorSecondaryIntent;
    }

    public void setCalibratorSecondaryIntent(CalibratorSecondaryIntentEnum calibratorSecondaryIntentEnum) {
        this.calibratorSecondaryIntent = calibratorSecondaryIntentEnum;
    }

    public Optional<Integer> getInternalCycleCount() {
        return this.internalCycleCount;
    }

    public void setInternalCycleCount(Optional<Integer> optional) {
        this.internalCycleCount = optional;
    }

    public int getNoOfAtmCalsToBePerformed() {
        return this.noOfAtmCalsToBePerformed;
    }

    public void setNoOfAtmCalsToBePerformed(int n) {
        this.noOfAtmCalsToBePerformed = n;
    }

    public boolean isIncludedInTimeEstimateAccounting() {
        return this.isIncludedInTimeEstimateAccounting;
    }

    public void setIncludedInTimeEstimateAccounting(boolean bl) {
        this.isIncludedInTimeEstimateAccounting = bl;
    }

    public int getNoOfScansPerNonRepeatingCal() {
        return this.noOfScansPerNonRepeatingCal;
    }

    public void setNoOfScansPerNonRepeatingCal(int n) {
        this.noOfScansPerNonRepeatingCal = n;
    }

    public CalType getCalType() {
        return this.calType;
    }

    public void setCalType(CalType calType) {
        this.calType = calType;
    }

    public boolean isExecutingRepeatedly() {
        return this.isExecutingRepeatedly;
    }

    public void setExecutingRepeatedly(boolean bl) {
        this.isExecutingRepeatedly = bl;
    }

    public void setCalibratorFlux(Flux flux) {
        this.calibratorFlux = flux;
    }

    @Override
    public double getSNR() {
        return this.sNR;
    }

    public void setSNR(double d) {
        this.sNR = d;
    }

    @Override
    public double getCorrelatorEfficiency() {
        return this.correlatorEfficiency;
    }

    public void setCorrelatorEfficiency(double d) {
        this.correlatorEfficiency = d;
    }

    public Antenna getAntenna() {
        return this.antenna;
    }

    public void setAntenna(Antenna antenna) {
        this.antenna = antenna;
    }

    @Override
    public int getNoOfAntennas() {
        return this.noOfAntennas;
    }

    public void setNoOfAntennas(int n) {
        this.noOfAntennas = n;
    }

    static class SourceObject
    implements NameResolvable {
        private SkyCoordinates sourceCoordinates;
        private String sourceName = "";
        private boolean isNonSiderealMotion = false;

        @Override
        public SkyCoordinates getSourceCoordinates() {
            return this.sourceCoordinates;
        }

        @Override
        public String getSourceName() {
            return this.sourceName;
        }

        public boolean isNonSiderealMotion() {
            return this.isNonSiderealMotion;
        }

        @Override
        public void setSourceCoordinates(SkyCoordinates skyCoordinates) {
            this.sourceCoordinates = skyCoordinates;
        }

        public void setSourceName(String string) {
            this.sourceName = string;
        }

        public void setNonSiderealMotion(boolean bl) {
            this.isNonSiderealMotion = bl;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof SourceObject)) {
                return false;
            }
            SourceObject sourceObject = (SourceObject)object;
            if (!sourceObject.canEqual(this)) {
                return false;
            }
            SkyCoordinates skyCoordinates = this.getSourceCoordinates();
            SkyCoordinates skyCoordinates2 = sourceObject.getSourceCoordinates();
            if (skyCoordinates == null ? skyCoordinates2 != null : !skyCoordinates.equals(skyCoordinates2)) {
                return false;
            }
            String string = this.getSourceName();
            String string2 = sourceObject.getSourceName();
            if (string == null ? string2 != null : !string.equals(string2)) {
                return false;
            }
            return this.isNonSiderealMotion() == sourceObject.isNonSiderealMotion();
        }

        protected boolean canEqual(Object object) {
            return object instanceof SourceObject;
        }

        public int hashCode() {
            int n = 1;
            SkyCoordinates skyCoordinates = this.getSourceCoordinates();
            n = n * 59 + (skyCoordinates == null ? 43 : skyCoordinates.hashCode());
            String string = this.getSourceName();
            n = n * 59 + (string == null ? 43 : string.hashCode());
            n = n * 59 + (this.isNonSiderealMotion() ? 79 : 97);
            return n;
        }

        public String toString() {
            return "CalObs.SourceObject(sourceCoordinates=" + this.getSourceCoordinates() + ", sourceName=" + this.getSourceName() + ", isNonSiderealMotion=" + this.isNonSiderealMotion() + ")";
        }
    }

    public static enum CalibratorSecondaryIntentEnum {
        UNDEFINED,
        DGC;

    }
}

