/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.problems;

import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.obsprep.problems.Problem;

public class DefaultProblem
implements Problem {
    private int severity;
    private String description;
    private String suggestion;
    private Object resource;

    private DefaultProblem(int n, String string, String string2, Object object) {
        this.severity = n;
        this.description = string == null ? "" : string;
        this.suggestion = string2 == null ? "" : string2;
        this.resource = object == null ? "" : object;
    }

    @Override
    public boolean isEqual(Problem problem) {
        if (!this.getSeverity().equals(problem.getSeverity())) {
            return false;
        }
        if (!this.getDescription().equals(problem.getDescription())) {
            return false;
        }
        return this.getSuggestion().equals(problem.getSuggestion());
    }

    public static Problem createSuccess(String string, String string2, IBusinessObject iBusinessObject) {
        return new DefaultProblem(100, string, string2, iBusinessObject);
    }

    public static Problem createInfo(String string, String string2, IBusinessObject iBusinessObject) {
        return new DefaultProblem(101, string, string2, iBusinessObject);
    }

    public static Problem createWarning(String string, String string2, IBusinessObject iBusinessObject) {
        return new DefaultProblem(102, string, string2, iBusinessObject);
    }

    public static Problem createError(String string, String string2, IBusinessObject iBusinessObject) {
        return new DefaultProblem(103, string, string2, iBusinessObject);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Object getResource() {
        return this.resource;
    }

    @Override
    public String getSeverity() {
        switch (this.severity) {
            case 103: {
                return "Error";
            }
            case 102: {
                return "Warning";
            }
            case 101: {
                return "Info";
            }
            case 100: {
                return "Success";
            }
        }
        return "<Unknown Severity>";
    }

    @Override
    public String getSuggestion() {
        return this.suggestion;
    }

    @Override
    public boolean isError() {
        return this.severity == 103;
    }

    @Override
    public boolean isWarning() {
        return this.severity == 102;
    }

    @Override
    public boolean isSuccess() {
        return this.severity == 100;
    }

    @Override
    public boolean isErrorOrWorse() {
        return this.severity >= 103;
    }

    @Override
    public boolean isWarningOrWorse() {
        return this.severity >= 102;
    }

    public String toString() {
        String string = "Problem@" + this.hashCode() + " [" + this.getSeverity() + "," + this.getDescription() + "," + this.getResource() + "," + this.getSuggestion() + "]";
        return string;
    }
}

