/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.valdef.schedblock;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.obsprep.bo.schedblock.AbstractBaseBandConfig;
import alma.obsprep.bo.schedblock.AbstractSpectralWindow;
import alma.obsprep.ot.valdef.AbstractValidator;
import alma.obsprep.ot.valdef.ProblemListModel;
import alma.obsprep.problems.DefaultProblem;
import alma.obsprep.problems.Problem;

public class SpectralSubbandSetValidator
extends AbstractValidator {
    @Override
    public void localValidate(BusinessObject businessObject, ProblemListModel problemListModel) {
        AbstractSpectralWindow abstractSpectralWindow = (AbstractSpectralWindow)businessObject;
        try {
            AbstractBaseBandConfig abstractBaseBandConfig = (AbstractBaseBandConfig)abstractSpectralWindow.getParent();
            if (abstractBaseBandConfig != null) {
                Problem problem;
                double d = abstractSpectralWindow.getCenterFrequency().getContentInDefaultUnits();
                double d2 = abstractSpectralWindow.getHalfBandwidth().getContentInDefaultUnits();
                double d3 = d - d2;
                double d4 = d + d2;
                double d5 = abstractBaseBandConfig.getCenterFrequency().getContentInDefaultUnits() + abstractBaseBandConfig.getBandwidth().getContentInDefaultUnits() / 2.0;
                if (d3 < 0.0) {
                    problem = DefaultProblem.createError("SpectralSubbandSet is positioned such that its lowest frequency is outside the range of the containing BaseBand", "Move the SpectralSubbandSet so that is falls entirely within the containing BaseBand", (IBusinessObject)businessObject);
                    problemListModel.add(problem);
                }
                if (d4 > d5) {
                    problem = DefaultProblem.createError("SpectralSubbandSet is positioned such that its highest frequency is outside the range of the containing BaseBand", "Move the SpectralSubbandSet so that is falls entirely within the containing BaseBand", (IBusinessObject)businessObject);
                    problemListModel.add(problem);
                }
                if (d4 - d3 > d5 - 0.0) {
                    problem = DefaultProblem.createError("SpectralSubbandSet has a wider bandwidth than its containing BaseBand", "Adjust the TFBMode of wither the baseband to make it wider or the spectral subband set to make it narrower", (IBusinessObject)businessObject);
                    problemListModel.add(problem);
                }
            }
        }
        catch (ClassCastException classCastException) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("internal validation error: expecting BaseBandConfig as parent");
            stringBuffer.append(" of SpectralSubbandSet got ");
            stringBuffer.append(businessObject.getClass().getName());
            stringBuffer.append('\n');
            Problem problem = DefaultProblem.createError(stringBuffer.toString(), "Contact your support agent", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
    }
}

