/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.valdef.others;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproject.ObsUnit;
import alma.obsprep.ot.valdef.AbstractValidator;
import alma.obsprep.ot.valdef.ProblemListModel;
import alma.obsprep.problems.DefaultProblem;
import alma.obsprep.util.MiscUtils;

public class TestObsUnitKnowsProjectValidator
extends AbstractValidator {
    private static final String ME = "chk06: ";
    private ObsProject obsProject;

    @Override
    protected void localValidate(BusinessObject businessObject, ProblemListModel problemListModel) {
        ObsProject obsProject;
        if (businessObject instanceof ObsProject) {
            this.obsProject = (ObsProject)businessObject;
            return;
        }
        if (!(businessObject instanceof ObsUnit)) {
            return;
        }
        try {
            obsProject = ((ObsUnit)businessObject).getObsProject();
        }
        catch (UnknownEntityException unknownEntityException) {
            problemListModel.add(DefaultProblem.createWarning("chk06: This ObsUnit references some project that's not in memory", MiscUtils.packageClassnameHash(businessObject), (IBusinessObject)businessObject));
            return;
        }
        if (obsProject == null) {
            problemListModel.add(DefaultProblem.createError("chk06: This ObsUnit references no project (null)", MiscUtils.packageClassnameHash(businessObject), (IBusinessObject)businessObject));
            return;
        }
        if (this.obsProject == null) {
            problemListModel.add(DefaultProblem.createError("chk06:  [internal validator problem] what obsproject is the expected one?", "", null));
            return;
        }
        if (obsProject != this.obsProject) {
            problemListModel.add(DefaultProblem.createError("chk06: This ObsUnit references a wrong project: @" + obsProject.hashCode(), MiscUtils.packageClassnameHash(businessObject), (IBusinessObject)businessObject));
            return;
        }
    }
}

