/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.valdef.corrconfig;

import alma.BasebandNameMod.BasebandName;
import alma.CorrConfigModeErr.wrappers.AcsJConstructorFailureEx;
import alma.Correlator.BaseBandConfig;
import alma.Correlator.CorrelatorConfiguration;
import alma.acacorrelator.ACACorrConfigValidator.ACACorrConfigValidator;
import alma.acacorrelator.ACACorrConfigValidator.ACA_XMLParser;
import alma.correlatorSrc.CorrConfigValidator.BL_XMLParser;
import alma.correlatorSrc.CorrConfigValidator.CorrConfigValidator;
import alma.correlatorSrc.CorrConfigValidator.CorrConfigValidatorBase;
import alma.correlatorSrc.CorrConfigValidator.SBConversionException;
import alma.correlatorSrc.CorrConfigValidator.XMLParserBase;
import alma.entity.xmlbinding.schedblock.SpectralSpecT;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.enumerations.ArrayRequested;
import alma.obsprep.bo.schedblock.ACACorrelatorConfiguration;
import alma.obsprep.bo.schedblock.ACASpectrometerCorrelatorConfiguration;
import alma.obsprep.bo.schedblock.AbstractBaseBandConfig;
import alma.obsprep.bo.schedblock.AbstractCorrelatorConfiguration;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.valuetypes.DataRate;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;

public class CorrelatorConfigDataRate {
    private final AbstractCorrelatorConfiguration cc;
    private XMLParserBase parser;
    private CorrConfigValidatorBase validator;
    private Map<BasebandName, CorrConfigValidatorBase.BaseBandDataRate> dataRateMap;

    public CorrelatorConfigDataRate(AbstractCorrelatorConfiguration abstractCorrelatorConfiguration) throws AcsJConstructorFailureEx {
        if (abstractCorrelatorConfiguration == null) {
            throw new RuntimeException("Corr Config must not be null.");
        }
        this.cc = abstractCorrelatorConfiguration;
        if (abstractCorrelatorConfiguration instanceof ACACorrelatorConfiguration) {
            this.parser = new ACA_XMLParser();
            this.validator = new ACACorrConfigValidator();
        } else if (abstractCorrelatorConfiguration instanceof ACASpectrometerCorrelatorConfiguration) {
            this.parser = new ACA_XMLParser();
            this.validator = new ACACorrConfigValidator();
        } else {
            this.parser = new BL_XMLParser();
            this.validator = new CorrConfigValidator();
        }
    }

    private CorrelatorConfiguration getCorrConfig() {
        SpectralSpec spectralSpec = this.cc.getSpectralSpec();
        if (spectralSpec == null) {
            return null;
        }
        SpectralSpecT spectralSpecT = spectralSpec.getCastorObject();
        try {
            CorrelatorConfiguration correlatorConfiguration = this.parser.getOneCorrelatorConfiguration(spectralSpecT);
            return correlatorConfiguration;
        }
        catch (SBConversionException sBConversionException) {
            sBConversionException.printStackTrace();
            Log.logger((Object)this).severe(sBConversionException.getMessage());
            return null;
        }
        catch (NullPointerException nullPointerException) {
            Log.logger((Object)this).warning("invalid correlator configuration");
            return null;
        }
    }

    private ArrayRequested getArrayRequested() {
        SpectralSpec spectralSpec = this.cc.getSpectralSpec();
        if (spectralSpec == null) {
            return null;
        }
        SchedBlock schedBlock = spectralSpec.getSchedBlock();
        if (schedBlock == null) {
            return null;
        }
        String string = schedBlock.getObsUnitControl().getArrayRequested();
        return ArrayRequested.getArrayRequested(string);
    }

    private BasebandName getBasebandName(@NonNull AbstractBaseBandConfig abstractBaseBandConfig) {
        if (abstractBaseBandConfig == null) {
            throw new NullPointerException("bbc is marked non-null but is null");
        }
        String string = abstractBaseBandConfig.getBaseBandName();
        Integer n = Integer.valueOf(string.substring(3));
        return BasebandName.from_int((int)n);
    }

    public void updateDataRateForConfig(@NonNull AbstractCorrelatorConfiguration abstractCorrelatorConfiguration) {
        if (abstractCorrelatorConfiguration == null) {
            throw new NullPointerException("abstractCorrelatorConfiguration is marked non-null but is null");
        }
        this.updateDataRateForConfig(false, abstractCorrelatorConfiguration);
    }

    public void updateDataRateForConfig(boolean bl, @NonNull AbstractCorrelatorConfiguration abstractCorrelatorConfiguration) {
        CorrelatorConfiguration correlatorConfiguration;
        if (abstractCorrelatorConfiguration == null) {
            throw new NullPointerException("abstractCorrelatorConfiguration is marked non-null but is null");
        }
        ArrayRequested arrayRequested = this.getArrayRequested();
        int n = 0;
        if (arrayRequested != null) {
            try {
                n = bl ? arrayRequested.getMaxAntennas() : arrayRequested.getNumAntennasForDataRates(abstractCorrelatorConfiguration);
            }
            catch (ReceiverBand.ReceiverNotFoundException receiverNotFoundException) {
                Log.logger(CorrelatorConfigDataRate.class).warning("Unable to determine the number of antennas to use for data rates");
                return;
            }
        }
        if ((correlatorConfiguration = this.getCorrConfig()) == null) {
            return;
        }
        this.dataRateMap = this.getBasebandDataRates(n, correlatorConfiguration);
    }

    private boolean isAllBasebandsContainingSPWs(@NonNull CorrelatorConfiguration correlatorConfiguration) {
        if (correlatorConfiguration == null) {
            throw new NullPointerException("corrConfig is marked non-null but is null");
        }
        for (BaseBandConfig baseBandConfig : correlatorConfiguration.baseBands) {
            if (baseBandConfig.spectralWindows.length != 0) continue;
            return false;
        }
        return true;
    }

    public void updateDataRateForConfig(@NonNull AbstractCorrelatorConfiguration abstractCorrelatorConfiguration, @NonNull ArrayRequested arrayRequested) {
        if (abstractCorrelatorConfiguration == null) {
            throw new NullPointerException("abstractCorrelatorConfiguration is marked non-null but is null");
        }
        if (arrayRequested == null) {
            throw new NullPointerException("arrayRequested is marked non-null but is null");
        }
        int n = 0;
        try {
            n = arrayRequested.getNumAntennasForDataRates(abstractCorrelatorConfiguration);
        }
        catch (ReceiverBand.ReceiverNotFoundException receiverNotFoundException) {
            Log.logger(CorrelatorConfigDataRate.class).warning("Unable to determine the number of antennas to use for data rates");
            return;
        }
        CorrelatorConfiguration correlatorConfiguration = this.getCorrConfig();
        if (correlatorConfiguration == null) {
            return;
        }
        this.dataRateMap = this.getBasebandDataRates(n, correlatorConfiguration);
    }

    private Map<BasebandName, CorrConfigValidatorBase.BaseBandDataRate> getBasebandDataRates(int n, @NonNull CorrelatorConfiguration correlatorConfiguration) {
        if (correlatorConfiguration == null) {
            throw new NullPointerException("corrConfig is marked non-null but is null");
        }
        Map<Object, Object> map = new HashMap<BasebandName, CorrConfigValidatorBase.BaseBandDataRate>();
        if (this.isAllBasebandsContainingSPWs(correlatorConfiguration)) {
            map = this.validator.calculateTotalDataRateForConfig(correlatorConfiguration, n);
        }
        assert (map != null);
        return map;
    }

    private double baseBandTotal(CorrConfigValidatorBase.BaseBandDataRate baseBandDataRate) {
        double d = 0.0;
        if (baseBandDataRate != null) {
            for (double d2 : baseBandDataRate.spectralWindow) {
                d += d2;
            }
            d += baseBandDataRate.ancillary;
        }
        return d;
    }

    private double corrConfigTotal() {
        double d = 0.0;
        if (this.dataRateMap != null) {
            for (CorrConfigValidatorBase.BaseBandDataRate baseBandDataRate : this.dataRateMap.values()) {
                d += this.baseBandTotal(baseBandDataRate);
            }
        }
        return d;
    }

    public DataRate getConfigTotalDataRate() {
        return DataRate.createDataRate((double)this.corrConfigTotal(), (String)DataRate.UNIT_MB_S);
    }

    public DataRate getBasebandTotalDataRate(@NonNull AbstractBaseBandConfig abstractBaseBandConfig) {
        if (abstractBaseBandConfig == null) {
            throw new NullPointerException("bbc is marked non-null but is null");
        }
        BasebandName basebandName = this.getBasebandName(abstractBaseBandConfig);
        CorrConfigValidatorBase.BaseBandDataRate baseBandDataRate = this.dataRateMap == null ? null : this.dataRateMap.get(basebandName);
        double d = baseBandDataRate == null ? 0.0 : this.baseBandTotal(baseBandDataRate);
        return DataRate.createDataRate((double)d, (String)DataRate.UNIT_MB_S);
    }

    public DataRate[] getSpectralWindowDataRates(@NonNull AbstractBaseBandConfig abstractBaseBandConfig) {
        if (abstractBaseBandConfig == null) {
            throw new NullPointerException("bbc is marked non-null but is null");
        }
        BasebandName basebandName = this.getBasebandName(abstractBaseBandConfig);
        CorrConfigValidatorBase.BaseBandDataRate baseBandDataRate = this.dataRateMap == null ? null : this.dataRateMap.get(basebandName);
        int n = baseBandDataRate == null ? 0 : baseBandDataRate.spectralWindow.length;
        DataRate[] dataRateArray = new DataRate[n];
        for (int i = 0; i < n; ++i) {
            dataRateArray[i] = DataRate.createDataRate((double)baseBandDataRate.spectralWindow[i], (String)DataRate.UNIT_MB_S);
        }
        return dataRateArray;
    }
}

