/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.valdef;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.ot.valdef.ProblemListEvent;
import alma.obsprep.ot.valdef.ProblemListListener;
import alma.obsprep.ot.valdef.ProblemListModel;
import alma.obsprep.problems.Problem;

public class ProblemLogger
implements ProblemListListener {
    private Log.Logger logger = Log.logger((Object)this);
    private boolean started = false;
    private ProblemListModel model;

    public ProblemLogger(ProblemListModel problemListModel) {
        this.model = problemListModel;
    }

    @Override
    public void problemListChanged(ProblemListEvent problemListEvent) {
        switch (problemListEvent.getType()) {
            case 1061: {
                if (!this.started) {
                    this.logger.fine("Starting validation");
                }
                this.started = true;
                break;
            }
            case 1062: {
                if (this.started) {
                    this.logValidationResults();
                    this.logger.fine("Validation finished");
                }
                this.started = false;
                break;
            }
        }
    }

    private void logValidationResults() {
        if (this.model.getSize() == 0) {
            this.logger.info("No validation issues found");
        } else {
            StringBuffer stringBuffer;
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < this.model.getSize(); ++i) {
                Problem problem = this.model.getProblemAt(i);
                stringBuffer = new StringBuffer();
                stringBuffer.append(problem.getDescription());
                stringBuffer.append("\n\t");
                stringBuffer.append(problem.getResource());
                stringBuffer.append("\n\t");
                stringBuffer.append(problem.getSuggestion());
                if (problem.isError()) {
                    ++n2;
                    this.logger.fine("Validation Error: " + stringBuffer.toString());
                    continue;
                }
                ++n;
                this.logger.fine("Validation Warning: " + stringBuffer.toString());
            }
            stringBuffer = new StringBuffer();
            stringBuffer.append("Validation found ");
            stringBuffer.append(n2);
            stringBuffer.append(" error");
            if (n2 != 1) {
                stringBuffer.append('s');
            }
            stringBuffer.append(" and ");
            stringBuffer.append(n);
            stringBuffer.append(" warning");
            if (n != 1) {
                stringBuffer.append('s');
            }
            this.logger.info(stringBuffer.toString());
        }
    }
}

