/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.project.transfer;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.ot.actions.ImportDrop;
import alma.obsprep.ot.gui.toplevel.ObservingToolController;
import alma.obsprep.ot.gui.toplevel.ObservingToolGui;
import alma.obsprep.ot.project.ProjectTreeNode;
import alma.obsprep.ot.project.transfer.TransferImport;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.Arrays;

public class TransferImportString
implements TransferImport {
    private Log.Logger logger = Log.logger((Object)this);

    @Override
    public boolean responsibleFor(DataFlavor[] dataFlavorArray) {
        return Arrays.asList(dataFlavorArray).contains(DataFlavor.stringFlavor);
    }

    @Override
    public boolean canImportAt(Transferable transferable, ProjectTreeNode projectTreeNode, int n) {
        return this.responsibleFor(transferable.getTransferDataFlavors());
    }

    @Override
    public boolean importAt(Transferable transferable, ProjectTreeNode projectTreeNode, int n) {
        try {
            Object object = transferable.getTransferData(DataFlavor.stringFlavor);
            if (this.logger.debug()) {
                this.logger.log(Log.DEBUG, "got: '" + object + "'");
            }
            String string = (String)object;
            ObservingToolGui observingToolGui = ObservingToolController.getOTGui();
            ImportDrop importDrop = new ImportDrop(observingToolGui, string);
            importDrop.actionPerformed(null);
            return true;
        }
        catch (Exception exception) {
            this.logger.fine("failed to import data: " + exception);
            return false;
        }
    }
}

