/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.project;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.ot.actions.ActionLog;
import alma.obsprep.ot.project.OTTree;
import alma.obsprep.ot.project.ProjectTree;
import alma.obsprep.ot.project.ProjectTreeNode;
import alma.obsprep.ot.project.transfer.TransferExport;
import alma.obsprep.ot.project.transfer.TransferExportBo;
import alma.obsprep.ot.project.transfer.TransferImport;
import alma.obsprep.ot.project.transfer.TransferImportBo;
import alma.obsprep.ot.project.transfer.TransferImportFilelist;
import alma.obsprep.ot.project.transfer.TransferImportString;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.InputEvent;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.TreePath;

public class ProjectTreeTransferHandler
extends TransferHandler {
    static final int DEBUG = 2;
    private static SimpleDateFormat dbgDateFormat = new SimpleDateFormat("HH:mm:ss.SSS");
    private TransferExport exp;
    private List<TransferImport> imps = new Vector<TransferImport>();
    private transient ProjectTree ptree;
    private Log.Logger logger;
    private boolean readonly = false;
    private static DataFlavor FancyCCP_FLAVOR = new DataFlavor("application/x-java-jvm-local-objectref; class=" + FancyCCP.class.getName(), "AuxInformation");
    private ProjectTreeNode n_known;
    private int aa_known;
    private int a_known;
    private boolean result_known;

    public static String decode(int n) {
        switch (n) {
            case 1: {
                return "COPY";
            }
            case 3: {
                return "COPY_OR_MOVE";
            }
            case 2: {
                return "MOVE";
            }
            case 0: {
                return "NONE";
            }
            case 0x40000000: {
                return "LINK";
            }
        }
        return "???(" + n + ")";
    }

    public static void dbgPrint(int n, String string, Object ... objectArray) {
        if (n > 2) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        for (Object object : objectArray) {
            Object object2;
            if (object instanceof Integer) {
                object2 = (Integer)object < 100 ? ProjectTreeTransferHandler.decode((Integer)object) : object.toString();
            } else if (object instanceof OTTree) {
                object2 = "OTTree@" + object.hashCode();
            } else if (object instanceof PTTTransferable) {
                try {
                    Object object3 = ((PTTTransferable)object).getTransferData(TransferExportBo.PTN_FLAVOR);
                    TransferExportBo.ProjectNodeTransport projectNodeTransport = (TransferExportBo.ProjectNodeTransport)object3;
                    object2 = "PTTTransferable@" + object.hashCode() + "[" + projectNodeTransport + "]";
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    object2 = "PTTTransferable@" + object.hashCode() + "[<broken>]";
                }
            } else {
                object2 = object instanceof BusinessObject ? object.getClass().getName() + "@" + object.hashCode() : String.valueOf(object);
            }
            stringBuffer.append("\n                            #" + n2++ + "=" + (String)object2);
            if (!(object instanceof Throwable)) continue;
            ((Throwable)object).printStackTrace();
        }
        System.err.println("DnD: " + dbgDateFormat.format(new Date()) + " " + string + stringBuffer.toString());
    }

    public ProjectTreeTransferHandler(ProjectTree projectTree) {
        this.ptree = projectTree;
        this.logger = Log.logger((Object)this);
        this.exp = new TransferExportBo();
        this.imps.add(new TransferImportBo());
        this.imps.add(new TransferImportString());
        this.imps.add(new TransferImportFilelist());
    }

    void setReadonly(boolean bl) {
        this.readonly = bl;
    }

    boolean isReadonly() {
        return this.readonly;
    }

    protected int getAllowedActions(ProjectTreeNode projectTreeNode) {
        int n = this.exp.allowedActions(projectTreeNode);
        if (this.readonly) {
            int n2 = 0x40000001;
            n &= n2;
        }
        return n;
    }

    @Override
    protected PTTTransferable createTransferable(JComponent jComponent) {
        if (this.logger.debug()) {
            this.logger.log(Log.DEBUG, this.logger.vformat("createTransferable called on handler " + this.hashCode(), new Object[]{jComponent}));
        }
        JTree jTree = (JTree)jComponent;
        TreePath treePath = jTree.getSelectionPath();
        ProjectTreeNode projectTreeNode = (ProjectTreeNode)treePath.getLastPathComponent();
        PTTTransferable pTTTransferable = new PTTTransferable();
        this.exp.addFlavor(pTTTransferable, projectTreeNode);
        return pTTTransferable;
    }

    protected void finishExport(Transferable transferable, int n) {
        this.exp.finishExport(transferable, n);
    }

    @Override
    public int getSourceActions(JComponent jComponent) {
        JTree jTree = (JTree)jComponent;
        TreePath treePath = jTree.getSelectionPath();
        if (treePath == null) {
            return 0;
        }
        ProjectTreeNode projectTreeNode = (ProjectTreeNode)treePath.getLastPathComponent();
        return this.getAllowedActions(projectTreeNode);
    }

    @Override
    public void exportAsDrag(JComponent jComponent, InputEvent inputEvent, int n) {
        if (this.logger.debug()) {
            this.logger.log(Log.DEBUG, this.logger.vformat("exportAsDrag called", new Object[]{jComponent, inputEvent, ProjectTreeTransferHandler.decode(n)}));
        }
        this.ptree.setDndPending(true);
        super.exportAsDrag(jComponent, inputEvent, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
        if (this.logger.debug()) {
            this.logger.log(Log.DEBUG, this.logger.vformat("exportDone called on handler " + this.hashCode(), new Object[]{jComponent, transferable, ProjectTreeTransferHandler.decode(n)}));
        }
        try {
            this.finishExport(transferable, n);
        }
        finally {
            this.ptree.setDndPending(false);
        }
    }

    protected boolean canExportToClipboard(ProjectTreeNode projectTreeNode, int n) {
        return (this.getAllowedActions(projectTreeNode) & n) == n;
    }

    public void exportToClipboard(ProjectTreeNode projectTreeNode, int n) {
        if (this.logger.debug()) {
            this.logger.log(Log.DEBUG, this.logger.vformat("export to clipboard", new Object[]{projectTreeNode, n}));
        }
        if (!this.canExportToClipboard(projectTreeNode, n)) {
            return;
        }
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        OTTree oTTree = this.ptree.getTree();
        PTTTransferable pTTTransferable = this.createTransferable(oTTree);
        FancyCCP fancyCCP = new FancyCCP();
        fancyCCP.handler = this;
        fancyCCP.node = projectTreeNode;
        fancyCCP.action = n;
        pTTTransferable.add(fancyCCP, FancyCCP_FLAVOR);
        clipboard.setContents(pTTTransferable, null);
    }

    @Override
    public void exportToClipboard(JComponent jComponent, Clipboard clipboard, int n) {
        throw new AssertionError((Object)"who called this? our cut&copy uses the companion method above");
    }

    public void exportToClipboardDone(Transferable transferable, int n) {
        this.finishExport(transferable, n);
    }

    protected boolean canImportAt(Transferable transferable, ProjectTreeNode projectTreeNode, int n) {
        if (this.readonly) {
            return false;
        }
        for (TransferImport transferImport : this.imps) {
            if (!transferImport.canImportAt(transferable, projectTreeNode, n)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean importAt(Transferable transferable, ProjectTreeNode projectTreeNode, int n) {
        try {
            this.ptree.setBusyCursor(true);
            DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
            for (TransferImport transferImport : this.imps) {
                if (!transferImport.responsibleFor(dataFlavorArray)) continue;
                if (this.logger.trace()) {
                    this.logger.log(Log.TRACE, "trying to import " + transferable + " using " + transferImport);
                }
                if (!transferImport.importAt(transferable, projectTreeNode, n)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.ptree.setBusyCursor(false);
        }
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport transferSupport) {
        ProjectTreeNode projectTreeNode;
        int n = transferSupport.getSourceDropActions();
        int n2 = transferSupport.getDropAction();
        TreePath treePath = ((JTree.DropLocation)transferSupport.getDropLocation()).getPath();
        ProjectTreeNode projectTreeNode2 = projectTreeNode = treePath == null ? null : (ProjectTreeNode)treePath.getLastPathComponent();
        if (n == this.aa_known && n2 == this.a_known && projectTreeNode == this.n_known) {
            if (this.logger.trace()) {
                this.logger.log(Log.TRACE, "filtered an abundant call to canImport");
            }
            return this.result_known;
        }
        DataFlavor[] dataFlavorArray = transferSupport.getDataFlavors();
        Transferable transferable = transferSupport.getTransferable();
        boolean bl = this.canImport0(n2, n, projectTreeNode, dataFlavorArray, transferable);
        this.aa_known = n;
        this.a_known = n2;
        this.n_known = projectTreeNode;
        this.result_known = bl;
        return bl;
    }

    private boolean canImport0(int n, int n2, ProjectTreeNode projectTreeNode, DataFlavor[] dataFlavorArray, Transferable transferable) {
        boolean bl;
        if (this.logger.debug()) {
            this.logger.log(Log.DEBUG, this.logger.vformat("can Import", new Object[]{n, n2, dataFlavorArray, projectTreeNode, transferable}));
        }
        boolean bl2 = bl = (n & n2) == n;
        if (!bl) {
            if (this.logger.finer()) {
                this.logger.finer("transfer rejected: " + ProjectTreeTransferHandler.decode(n) + " is not an allowed action");
            }
            return false;
        }
        if (projectTreeNode == null) {
            return false;
        }
        return this.canImportAt(transferable, projectTreeNode, n);
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport transferSupport) {
        int n;
        JTree.DropLocation dropLocation;
        TreePath treePath;
        ProjectTreeNode projectTreeNode;
        Transferable transferable;
        boolean bl;
        if (this.logger.debug()) {
            this.logger.log(Log.DEBUG, this.logger.vformat("importData called on handler " + this.hashCode(), new Object[]{transferSupport}));
        }
        if (bl = this.importAt(transferable = transferSupport.getTransferable(), projectTreeNode = (treePath = (dropLocation = (JTree.DropLocation)transferSupport.getDropLocation()).getPath()) == null ? null : (ProjectTreeNode)treePath.getLastPathComponent(), n = transferSupport.getDropAction())) {
            try {
                TransferExportBo.ProjectNodeTransport projectNodeTransport = (TransferExportBo.ProjectNodeTransport)transferable.getTransferData(TransferExportBo.PTN_FLAVOR);
                ProjectTreeNode projectTreeNode2 = projectNodeTransport.node;
                BusinessObject businessObject = (BusinessObject)projectTreeNode2.getUserObject();
                BusinessObject businessObject2 = (BusinessObject)projectTreeNode.getUserObject();
                ActionLog.performed("DnD", ProjectTreeTransferHandler.decode(n), businessObject, "to", businessObject2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bl;
    }

    public boolean canImportFromClipboard(ProjectTreeNode projectTreeNode) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transferable = null;
        try {
            transferable = clipboard.getContents(this);
        }
        catch (IllegalStateException illegalStateException) {
            return false;
        }
        if (transferable != null && transferable.isDataFlavorSupported(FancyCCP_FLAVOR)) {
            try {
                FancyCCP fancyCCP = (FancyCCP)transferable.getTransferData(FancyCCP_FLAVOR);
                return this.canImportAt(transferable, projectTreeNode, fancyCCP.action);
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    public void importFromClipboard(ProjectTreeNode projectTreeNode) {
        block8: {
            if (this.logger.debug()) {
                this.logger.log(Log.DEBUG, this.logger.vformat("import from clipboard", new Object[]{projectTreeNode}));
            }
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable transferable = clipboard.getContents(this);
            try {
                ProjectTreeTransferHandler projectTreeTransferHandler;
                FancyCCP fancyCCP = (FancyCCP)transferable.getTransferData(FancyCCP_FLAVOR);
                int n = fancyCCP.action;
                boolean bl = this.importAt(transferable, projectTreeNode, n);
                if (!bl) {
                    n = 0;
                }
                if ((projectTreeTransferHandler = fancyCCP.handler) != null) {
                    projectTreeTransferHandler.exportToClipboardDone(transferable, n);
                }
                if (n == 2) {
                    clipboard.setContents(new PTTTransferable(), null);
                }
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                if (this.logger.fine()) {
                    this.logger.fine("couldn't paste from clipboard to tree: unknown kind of clipboard content");
                }
            }
            catch (IOException iOException) {
                if (!this.logger.fine()) break block8;
                this.logger.log(Level.FINE, "couldn't paste from clipboard: an I/O error occurred", (Throwable)iOException);
            }
        }
    }

    static boolean isClipboarded(ProjectTreeNode projectTreeNode) {
        try {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable transferable = clipboard.getContents(null);
            if (transferable != null && transferable.isDataFlavorSupported(FancyCCP_FLAVOR)) {
                FancyCCP fancyCCP = (FancyCCP)transferable.getTransferData(FancyCCP_FLAVOR);
                return fancyCCP.node == projectTreeNode;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static class FancyCCP {
        ProjectTreeTransferHandler handler;
        ProjectTreeNode node;
        int action;

        private FancyCCP() {
        }
    }

    public static class PTTTransferable
    implements Transferable {
        private Object[] transferDatas = new Object[0];
        private DataFlavor[] dataFlavors = new DataFlavor[0];

        public PTTTransferable() {
        }

        public PTTTransferable(Object object, DataFlavor dataFlavor) {
            this.transferDatas = new Object[]{object};
            this.dataFlavors = new DataFlavor[]{dataFlavor};
        }

        public void add(Object object, DataFlavor dataFlavor) {
            Object[] objectArray = new Object[this.transferDatas.length + 1];
            System.arraycopy(this.transferDatas, 0, objectArray, 0, this.transferDatas.length);
            objectArray[this.transferDatas.length] = object;
            this.transferDatas = objectArray;
            DataFlavor[] dataFlavorArray = new DataFlavor[this.dataFlavors.length + 1];
            System.arraycopy(this.dataFlavors, 0, dataFlavorArray, 0, this.dataFlavors.length);
            dataFlavorArray[this.dataFlavors.length] = dataFlavor;
            this.dataFlavors = dataFlavorArray;
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
            for (int i = 0; i < this.dataFlavors.length; ++i) {
                if (!this.dataFlavors[i].equals(dataFlavor)) continue;
                return this.transferDatas[i];
            }
            throw new UnsupportedFlavorException(dataFlavor);
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            for (int i = 0; i < this.dataFlavors.length; ++i) {
                if (!this.dataFlavors[i].equals(dataFlavor)) continue;
                return true;
            }
            return false;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return this.dataFlavors;
        }

        public String toString() {
            String string = this.getClass().getSimpleName();
            return string + "[flavors=" + Arrays.toString(this.dataFlavors) + "]";
        }
    }
}

