/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.project;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.obsprep.bo.SubSBCollection;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.schedblock.AbstractInstrumentSpec;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.bo.schedblock.ObservingParameters;
import alma.obsprep.bo.workbooks.WorkbookPage;
import javax.swing.tree.DefaultMutableTreeNode;

public class ProjectTreeNode
extends DefaultMutableTreeNode {
    public static final int NOERROR = 0;
    public static final int HASINFO = 1;
    public static final int CONTAINSPROBLEM = 2;
    public static final int HASWARNING = 4;
    public static final int HASERROR = 8;
    private int errorStatus = 0;
    private boolean isHighlighted = false;

    public ProjectTreeNode(Object object) {
        super(object);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BusinessObject spatialBO() {
        BusinessObject businessObject = (BusinessObject)this.getUserObject();
        BusinessObject businessObject2 = null;
        if (businessObject == null) return businessObject2;
        if (businessObject.isSpatial()) {
            return businessObject.getSpatial();
        }
        if (businessObject instanceof FieldSource) return null;
        if (businessObject instanceof AbstractInstrumentSpec) return null;
        if (businessObject instanceof ObservingParameters) {
            return null;
        }
        if (businessObject instanceof SubSBCollection) {
            return null;
        }
        if (businessObject instanceof WorkbookPage) {
            if (!(businessObject.getParent() instanceof ScienceGoal)) return businessObject;
            ScienceGoal scienceGoal = (ScienceGoal)businessObject.getParent();
            if (!scienceGoal.isSpatial(businessObject.getName())) return businessObject;
            ProjectTreeNode projectTreeNode = (ProjectTreeNode)this.getParent();
            if (projectTreeNode == null) return businessObject2;
            return projectTreeNode.spatialBO();
        }
        ProjectTreeNode projectTreeNode = (ProjectTreeNode)this.getParent();
        if (projectTreeNode == null) return businessObject2;
        return projectTreeNode.spatialBO();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BusinessObject spectralBO() {
        BusinessObject businessObject = (BusinessObject)this.getUserObject();
        BusinessObject businessObject2 = null;
        if (businessObject == null) return businessObject2;
        if (businessObject.isSpectral()) {
            return businessObject.getSpectral();
        }
        if (businessObject instanceof SubSBCollection) {
            return null;
        }
        if (businessObject instanceof WorkbookPage) {
            if (!(businessObject.getParent() instanceof ScienceGoal)) return businessObject;
            ScienceGoal scienceGoal = (ScienceGoal)businessObject.getParent();
            if (!scienceGoal.isSpectral(businessObject.getName())) return businessObject;
            ProjectTreeNode projectTreeNode = (ProjectTreeNode)this.getParent();
            if (projectTreeNode == null) return businessObject2;
            return projectTreeNode.spectralBO();
        }
        ProjectTreeNode projectTreeNode = (ProjectTreeNode)this.getParent();
        if (projectTreeNode == null) return businessObject2;
        return projectTreeNode.spectralBO();
    }

    public void clearError() {
        this.errorStatus = 0;
    }

    public void clearAllErrors() {
        this.clearError();
        for (int i = 0; i < this.getChildCount(); ++i) {
            ProjectTreeNode projectTreeNode = (ProjectTreeNode)this.getChildAt(i);
            projectTreeNode.clearAllErrors();
        }
    }

    public void setErrorStatus(int n) {
        this.errorStatus |= n;
        ProjectTreeNode projectTreeNode = (ProjectTreeNode)this.getParent();
        if (projectTreeNode != null) {
            projectTreeNode.setErrorStatus(2);
        }
    }

    @Override
    public String toString() {
        String string = this.getClass().getSimpleName();
        Object object = this.getUserObject();
        String string2 = object == null ? "<empty>" : object.toString();
        String string3 = string + "[bo=" + string2 + ", hash=" + this.hashCode() + "]";
        return string3;
    }

    public int getErrorStatus() {
        return this.errorStatus;
    }

    public boolean isHighlighted() {
        return this.isHighlighted;
    }

    public void setHighlighted(boolean bl) {
        this.isHighlighted = bl;
    }
}

