/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.project;

import alma.obsprep.ot.actions.OTAction;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class ProjectTreeMouseListener
extends MouseAdapter {
    ArrayList<Action> items = null;
    private TreePath restoreLostSelectionOnMac;

    public ProjectTreeMouseListener(ArrayList<Action> arrayList) {
        this.items = arrayList;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        TreePath treePath;
        super.mousePressed(mouseEvent);
        if (!mouseEvent.isPopupTrigger()) {
            return;
        }
        JTree jTree = (JTree)mouseEvent.getComponent();
        this.restoreLostSelectionOnMac = treePath = jTree.getPathForRow(jTree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY()));
        this.popupMenu(mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        super.mouseReleased(mouseEvent);
        if (this.restoreLostSelectionOnMac != null) {
            ((JTree)mouseEvent.getSource()).getSelectionModel().setSelectionPath(this.restoreLostSelectionOnMac);
            this.restoreLostSelectionOnMac = null;
        }
        if (!mouseEvent.isPopupTrigger()) {
            return;
        }
        this.popupMenu(mouseEvent);
    }

    private void popupMenu(MouseEvent mouseEvent) {
        int n;
        int n2;
        JTree jTree = (JTree)mouseEvent.getComponent();
        int n3 = jTree.getRowForLocation(n2 = mouseEvent.getX(), n = mouseEvent.getY());
        if (n3 == -1) {
            return;
        }
        TreePath treePath = jTree.getPathForRow(n3);
        TreeSelectionModel treeSelectionModel = jTree.getSelectionModel();
        treeSelectionModel.setSelectionPath(treePath);
        JPopupMenu jPopupMenu = this.createPopup();
        if (jPopupMenu.getComponentCount() != 0) {
            jPopupMenu.show(jTree, n2, n);
        }
    }

    private JPopupMenu createPopup() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        if (this.items != null) {
            boolean bl = false;
            boolean bl2 = false;
            for (Action action : this.items) {
                boolean bl3;
                boolean bl4;
                if (action == null) {
                    if (bl2 || !bl) continue;
                    bl = false;
                    bl2 = true;
                    continue;
                }
                try {
                    OTAction oTAction = (OTAction)action;
                    bl4 = oTAction.isHidable();
                    bl3 = oTAction.isVisible();
                }
                catch (ClassCastException classCastException) {
                    bl4 = false;
                    bl3 = false;
                }
                if (!action.isEnabled() && bl4 || !bl3) continue;
                if (bl2) {
                    jPopupMenu.addSeparator();
                    bl2 = false;
                }
                jPopupMenu.add(action);
                bl = true;
            }
        }
        return jPopupMenu;
    }
}

