/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.valuetypes;

import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.ot.models.sciencegoals.AngularResolutionProviderInterface;
import alma.obsprep.ot.models.valuetypes.SensitivityFeedbackModel;
import alma.obsprep.ot.models.valuetypes.UserUnitValueUnitPairModel;
import alma.obsprep.services.etc.editor.SensitivityCalculatorEditor;
import alma.obsprep.util.TextUtils;
import alma.valuetypes.Angle;
import alma.valuetypes.UserSensitivity;
import alma.valuetypes.UserUnitValueUnitPair;

public class SensitivityFormModel
extends UserUnitValueUnitPairModel {
    SensitivityCalculatorEditor.SensitivityDisplayOption sensitivityDisplayOption = SensitivityCalculatorEditor.SensitivityDisplayOption.CURRENT;
    protected String userUnitRequested = null;
    private final SensitivityFeedbackModel feedbackFieldOneModel = new SensitivityFeedbackModel(this, this, new FieldID(this.getValueFID().toString() + ".FM"));
    private final SensitivityFeedbackModel feedbackFieldTwoModel = new SensitivityFeedbackModel(this, this, new FieldID(this.getValueFID().toString() + ".fineResolution"));

    public void setBeamsize(Angle angle) {
        if (null != this.feedbackFieldOneModel) {
            this.feedbackFieldOneModel.setBeamsize(angle);
        }
    }

    private void setupFeedbackModels() {
        this.feedbackFieldOneModel.setName("Field one");
        this.feedbackFieldTwoModel.setName("Field two");
        this.registerSubModel(this.feedbackFieldOneModel);
        this.registerSubModel(this.feedbackFieldTwoModel);
        this.feedbackFieldOneModel.setSensitivityFeedbackCalculator(this.feedbackFieldOneModel::getFieldOneFeedback);
        this.feedbackFieldTwoModel.setSensitivityFeedbackCalculator(this.feedbackFieldTwoModel::getFieldTwoFeedback);
        this.feedbackFieldTwoModel.setSensitivityProvider(this.feedbackFieldOneModel::getFeedbackValue);
    }

    public SensitivityFormModel(ValueUnitPair valueUnitPair) {
        super((ValueUnitPair<?>)valueUnitPair);
        this.setupFeedbackModels();
    }

    public SensitivityFormModel(ValueUnitPair valueUnitPair, FieldID fieldID) {
        super(valueUnitPair, fieldID);
        this.setupFeedbackModels();
    }

    public SensitivityFeedbackModel getFeedbackModel() {
        return this.feedbackFieldOneModel;
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        if (fieldID.equals(this.getUnitFID())) {
            this.userUnitRequested = (String)object;
        }
        Object object2 = super.update(editor, fieldID, object);
        this.publish();
        return object2;
    }

    @Override
    public void publish() {
        ValueUnitPair valueUnitPair = this.getVUP();
        if (valueUnitPair == null) {
            return;
        }
        if (!valueUnitPair.hasContent()) {
            valueUnitPair.setContent(0.0);
        }
        if (this.userUnitRequested == null) {
            this.userUnitRequested = valueUnitPair.defaultUnit();
        }
        switch (this.sensitivityDisplayOption) {
            case AUTOMATIC: {
                String string = valueUnitPair.getUserUnit();
                if (!valueUnitPair.getUnit().equals(string)) {
                    valueUnitPair.convertToUnit(string);
                }
                this.convertToFriendlyUnits(valueUnitPair);
                break;
            }
            case CURRENT: {
                String string = this.userUnitRequested;
                if (valueUnitPair.getUnit().equals(string)) break;
                valueUnitPair.convertToUnit(string);
                break;
            }
        }
        String string = TextUtils.format(valueUnitPair.getContent(), 0, 5);
        String string2 = valueUnitPair.getUnit();
        this.publish(this.getValueFID(), string);
        this.publish(this.getUnitFID(), string2);
        this.feedbackFieldOneModel.publish();
        this.feedbackFieldTwoModel.publish();
    }

    void convertToFriendlyUnits(ValueUnitPair<?> valueUnitPair) {
        if (valueUnitPair.defaultUnit() == UserSensitivity.UNIT_JY) {
            if (valueUnitPair.getUnit() == UserSensitivity.UNIT_JY && valueUnitPair.getContent() < 1.0) {
                valueUnitPair.convertToUnit(UserSensitivity.UNIT_MJY);
            }
            if (valueUnitPair.getUnit() == UserSensitivity.UNIT_MJY && valueUnitPair.getContent() < 1.0) {
                valueUnitPair.convertToUnit(UserSensitivity.USERUNIT_UJY);
            }
        }
    }

    public void setSensitivityDisplayOption(SensitivityCalculatorEditor.SensitivityDisplayOption sensitivityDisplayOption) {
        this.setSensitivityDisplayOption(sensitivityDisplayOption, null);
    }

    public void setSensitivityDisplayOption(SensitivityCalculatorEditor.SensitivityDisplayOption sensitivityDisplayOption, String string) {
        this.sensitivityDisplayOption = sensitivityDisplayOption;
        this.userUnitRequested = string;
    }

    @Override
    public void setDocument(Object object) {
        if (!UserUnitValueUnitPair.class.isAssignableFrom(object.getClass())) {
            throw new IllegalArgumentException(object.getClass() + " is not allowed.");
        }
        UserUnitValueUnitPair userUnitValueUnitPair = (UserUnitValueUnitPair)object;
        this.userUnitRequested = userUnitValueUnitPair.getUserUnit();
        super.setDocument(object);
    }

    public SensitivityFeedbackModel getFineResolutionFeedbackModel() {
        return this.feedbackFieldTwoModel;
    }

    public void setAngularResolutionProvider(FeedbackField feedbackField, AngularResolutionProviderInterface angularResolutionProviderInterface) {
        switch (feedbackField) {
            case FIRST: {
                this.feedbackFieldOneModel.setAngularResolutionProvider(angularResolutionProviderInterface);
                break;
            }
            case SECOND: {
                this.feedbackFieldTwoModel.setAngularResolutionProvider(angularResolutionProviderInterface);
                break;
            }
            default: {
                throw new RuntimeException("Unknown feedbackField " + feedbackField);
            }
        }
    }

    public static enum FeedbackField {
        FIRST,
        SECOND;

    }
}

