/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.sciencegoals;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.obsproject.OpticalPointingScienceGoal;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.ModelChangeSubscriber;
import alma.obsprep.ot.editors.sciencegoals.OpticalPointingTargetQueryEditor;
import alma.obsprep.ot.models.sciencegoals.OpticalPointingTargetQueryModel;
import alma.obsprep.ot.models.sciencegoals.TargetListModel;
import alma.obsprep.util.GUIUtilities;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;

public class OpticalPointingTargetModel
extends Model
implements ModelChangeSubscriber {
    TargetListModel targetListModel = new TargetListModel(null);
    OpticalPointingTargetQueryModel queryParamsModel = new OpticalPointingTargetQueryModel(null);

    public OpticalPointingTargetModel(Object object) {
        super(object);
        this.registerSubModel(this.targetListModel);
        this.registerSubModel(this.queryParamsModel);
        this.queryParamsModel.subscribe(this);
        this.setDocument(object);
    }

    public OpticalPointingScienceGoal getScienceGoal() {
        return (OpticalPointingScienceGoal)this.getDocument();
    }

    @Override
    public void publish() {
        if (this.document != null) {
            this.queryParamsModel.publish();
            this.targetListModel.publish();
        }
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        return object;
    }

    @Override
    public void setDocument(Object object) {
        this.document = object;
        if (object != null) {
            this.targetListModel.setDocument(object);
            this.queryParamsModel.setDocument((Object)this.getScienceGoal().getOpticalPointingTargetQueryParameters());
        }
        this.publish();
    }

    @Override
    public void modelChanged(Model model, FieldID fieldID, Object object) {
        if (model != this.queryParamsModel) {
            return;
        }
        if (fieldID.equals(OpticalPointingTargetQueryEditor.FILENAME_FID)) {
            File file = new File(object.toString());
            if (file.canRead()) {
                try {
                    this.targetListModel.load(file);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    Log.logger((Object)this).info("can't open file: " + fileNotFoundException);
                }
                catch (IOException iOException) {
                    Log.logger((Object)this).warning("can't open file: " + iOException);
                }
            }
        } else if (fieldID.equals(OpticalPointingTargetQueryEditor.FILTER_BUTTON_FID)) {
            this.getScienceGoal().filtering();
            this.publish();
        } else if (fieldID.equals(OpticalPointingTargetQueryEditor.LOAD_BUTTON_FID)) {
            URL[] uRLArray = new URL[12];
            uRLArray = this.getScienceGoal().getTycho2FileURL();
            try {
                this.targetListModel.loadFiltered(uRLArray);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.getTargetListModel().publish();
        } else if (fieldID.equals(OpticalPointingTargetQueryEditor.UNDO_BUTTON_FID)) {
            this.getScienceGoal().undoFiltering();
            this.publish();
        } else if (fieldID.equals(OpticalPointingTargetQueryEditor.QUERY_BUTTON_FID)) {
            GUIUtilities.info(null, "Not supported yet.");
        } else if (fieldID.equals(OpticalPointingTargetQueryEditor.SEP_BUTTON_FID)) {
            this.getScienceGoal().separationFiltering();
            this.publish();
        } else if (fieldID.equals(OpticalPointingTargetQueryEditor.RANDOM_BUTTON_FID)) {
            int n = this.getQueryParamsModel().getQueryParameters().getMaxTargets();
            this.getScienceGoal().randomFiltering(n, false);
            this.publish();
        }
    }

    public TargetListModel getTargetListModel() {
        return this.targetListModel;
    }

    public OpticalPointingTargetQueryModel getQueryParamsModel() {
        return this.queryParamsModel;
    }
}

